/*###############################################################################
# Linux Management Providers (LMP), Software Inventory provider package
# Copyright (C) 2009 Nazarov Nodir, TUIT <nazarov.nodir@gmail.com, nodir2000@yahoo.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
###############################################################################*/

#include "OpenDRIM_InstalledSoftwareIdentityAccess.h"

int SoftwareInventory_OpenDRIM_InstalledSoftwareIdentity_load(const CMPIBroker* broker, string& errorMessage) {
	_E_;
	/*
	 * for Direct Invocation
	 */
	/*
	CF_assert(SoftwareInventory_CIM_System_load(broker, errorMessage));
	CF_assert(SoftwareInventory_CIM_SoftwareIdentity_load(broker, errorMessage));
	*/
	// TODO
	_L_;
	return OK;
}

int SoftwareInventory_OpenDRIM_InstalledSoftwareIdentity_unload(string& errorMessage) {
	_E_;
	/*
	 * for Direct Invocation
	 */
	/*
	CF_assert(SoftwareInventory_CIM_System_unload(errorMessage));
	CF_assert(SoftwareInventory_CIM_SoftwareIdentity_unload(errorMessage));
	*/
	// TODO
	_L_;
	return OK;
}

int SoftwareInventory_OpenDRIM_InstalledSoftwareIdentity_isAssociated(const Instance& System, const Instance& InstalledSoftware, bool& isAssociated, string& errorMessage) {
	_E_;
	// TODO Determine if the association can be established or not
	isAssociated=true;
	_L_;
	return OK;
}

int SoftwareInventory_OpenDRIM_InstalledSoftwareIdentity_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_InstalledSoftwareIdentity>& result, const char** properties, string& errorMessage, const string& discriminant) {
	_E_;
	/*
	 * The following code has been generated for your convenience.
	 * Feel free to modify/delete.
	 */
	vector<Instance> subjects;
	// Only get the instance names
	CF_assert(SoftwareInventory_OpenDRIM_InstalledSoftwareIdentity_enumerateSystems(broker, ctx, subjects, NULL, true, errorMessage));
	// OR get the full instances IF we need the content of the instance to evaluate the association condition OR to set the reference properties
	// CF_assert(SoftwareInventory_OpenDRIM_InstalledSoftwareIdentity_enumerateSystems(broker, ctx, subjects, NULL, false, errorMessage));
	vector<Instance>::iterator c = subjects.begin();
	vector<Instance>::iterator end = subjects.end();
	for (; c != end; ++c) {
		bool leftToRight = true;
		vector<Instance> associatedInstances;
		SoftwareInventory_OpenDRIM_InstalledSoftwareIdentity_associator(broker, ctx,
			(*c).getObjectpath().getHdl(), (*c),
			System_classnames[0], InstalledSoftware_classnames[0],
			System_role.c_str(), InstalledSoftware_role.c_str(), NULL,
			associatedInstances, leftToRight, errorMessage, "an");

		string ref_discriminant = discriminant == "ein" ? "rn" : "r";
		CF_assert(SoftwareInventory_OpenDRIM_InstalledSoftwareIdentity_referenceSystemToInstalledSoftware(broker, ctx, (*c), associatedInstances, result, NULL, errorMessage, ref_discriminant));
	}
	_L_;
	return OK;
}

int SoftwareInventory_OpenDRIM_InstalledSoftwareIdentity_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_InstalledSoftwareIdentity& instance, const char** properties, string& errorMessage) {
	_E_;
	/*
	 * The following code has been generated for your convenience.
	 * Feel free to modify/delete.
	 */
	Objectpath System_objectpath;
	instance.getSystem(System_objectpath);
	Instance System_instance;
	CF_assert(SoftwareInventory_OpenDRIM_InstalledSoftwareIdentity_getSystem(broker, ctx, System_objectpath, System_instance, NULL, errorMessage));
	
	Objectpath InstalledSoftware_objectpath;
	instance.getInstalledSoftware(InstalledSoftware_objectpath);
	Instance InstalledSoftware_instance;
	CF_assert(SoftwareInventory_OpenDRIM_InstalledSoftwareIdentity_getInstalledSoftware(broker, ctx, InstalledSoftware_objectpath, InstalledSoftware_instance, NULL, errorMessage));

	bool isAssociated = false;
	CF_assert(SoftwareInventory_OpenDRIM_InstalledSoftwareIdentity_isAssociated(System_instance, InstalledSoftware_instance, isAssociated, errorMessage));
	if (!isAssociated)
	{
		if(errorMessage.empty())
			errorMessage = "No instance";
		
		return NOT_FOUND;
	}
	_L_;
	return OK;
}

int SoftwareInventory_OpenDRIM_InstalledSoftwareIdentity_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_InstalledSoftwareIdentity& newInstance, const OpenDRIM_InstalledSoftwareIdentity& oldInstance, const char** properties, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int SoftwareInventory_OpenDRIM_InstalledSoftwareIdentity_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_InstalledSoftwareIdentity& instance, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int SoftwareInventory_OpenDRIM_InstalledSoftwareIdentity_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_InstalledSoftwareIdentity& instance, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int SoftwareInventory_OpenDRIM_InstalledSoftwareIdentity_associatorSystemToInstalledSoftware(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& System_instance, const char** properties, vector<Instance>& InstalledSoftware_associatedInstances, string& errorMessage, const string& discriminant) {
	_E_;
	/*
	 * The following code has been generated for your convenience.
	 * Feel free to modify/delete.
	 */
	vector<Instance> InstalledSoftware_instances;
	if (discriminant=="a")
		CF_assert(SoftwareInventory_OpenDRIM_InstalledSoftwareIdentity_enumerateInstalledSoftwares(broker, ctx, InstalledSoftware_instances, properties, false, errorMessage));
	if (discriminant=="an") {
		// Only get the instance names
		CF_assert(SoftwareInventory_OpenDRIM_InstalledSoftwareIdentity_enumerateInstalledSoftwares(broker, ctx, InstalledSoftware_instances, properties, true, errorMessage));
		// OR get the full instances IF we need the content of the instance to evaluate the association condition OR to set the reference properties
		// CF_assert(SoftwareInventory_OpenDRIM_InstalledSoftwareIdentity_enumerateInstalledSoftwares(broker, ctx, InstalledSoftware_instances, properties, false, errorMessage));
	}

	for (size_t i=0; i<InstalledSoftware_instances.size(); i++) {
		bool isAssociated = false;
		CF_assert(SoftwareInventory_OpenDRIM_InstalledSoftwareIdentity_isAssociated(System_instance, InstalledSoftware_instances[i], isAssociated, errorMessage));
		if (isAssociated)
			InstalledSoftware_associatedInstances.push_back(InstalledSoftware_instances[i]);
	}
	_L_;
	return OK;
}

int SoftwareInventory_OpenDRIM_InstalledSoftwareIdentity_associatorInstalledSoftwareToSystem(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& InstalledSoftware_instance, const char** properties, vector<Instance>& System_associatedInstances, string& errorMessage, const string& discriminant) {
	_E_;
	/*
	 * The following code has been generated for your convenience.
	 * Feel free to modify/delete.
	 */
	vector<Instance> System_instances;
	if (discriminant=="a")
		CF_assert(SoftwareInventory_OpenDRIM_InstalledSoftwareIdentity_enumerateSystems(broker, ctx, System_instances, properties, false, errorMessage));
	if (discriminant=="an") {
		// Only get the instance names
		CF_assert(SoftwareInventory_OpenDRIM_InstalledSoftwareIdentity_enumerateSystems(broker, ctx, System_instances, properties, true, errorMessage));
		// OR get the full instances IF we need the content of the instance to evaluate the association condition OR to set the reference properties
		// CF_assert(SoftwareInventory_OpenDRIM_InstalledSoftwareIdentity_enumerateSystems(broker, ctx, System_instances, properties, false, errorMessage));
	}

	for (size_t i=0; i<System_instances.size(); i++) {
		bool isAssociated = false;
		CF_assert(SoftwareInventory_OpenDRIM_InstalledSoftwareIdentity_isAssociated(System_instances[i], InstalledSoftware_instance, isAssociated, errorMessage));
		if (isAssociated)
			System_associatedInstances.push_back(System_instances[i]);
	}
	_L_;
	return OK;
}

int SoftwareInventory_OpenDRIM_InstalledSoftwareIdentity_referenceSystemToInstalledSoftware(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& System_instance, const vector<Instance>& InstalledSoftware_instances, vector<OpenDRIM_InstalledSoftwareIdentity>& OpenDRIM_InstalledSoftwareIdentity_instances, const char** properties, string& errorMessage, const string& discriminant) {
	_E_;
	/*
	 * The following code has been generated for your convenience.
	 * Feel free to modify/delete.
	 */
	for (size_t i=0; i < InstalledSoftware_instances.size(); i++) {
		OpenDRIM_InstalledSoftwareIdentity instance;
		instance.setSystem(((Instance) System_instance).getObjectpath());
		instance.setInstalledSoftware(((Instance) InstalledSoftware_instances[i]).getObjectpath());
		
		OpenDRIM_InstalledSoftwareIdentity_instances.push_back(instance);
	}
	_L_;
	return OK;
}

int SoftwareInventory_OpenDRIM_InstalledSoftwareIdentity_referenceInstalledSoftwareToSystem(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& InstalledSoftware_instance, const vector<Instance>& System_instances, vector<OpenDRIM_InstalledSoftwareIdentity>& OpenDRIM_InstalledSoftwareIdentity_instances, const char** properties, string& errorMessage, const string& discriminant) {
	_E_;
	/*
	 * The following code has been generated for your convenience.
	 * Feel free to modify/delete.
	 */
	for (size_t i=0; i < System_instances.size(); i++) {
		OpenDRIM_InstalledSoftwareIdentity instance;
		instance.setSystem(((Instance) System_instances[i]).getObjectpath());
		instance.setInstalledSoftware(((Instance) InstalledSoftware_instance).getObjectpath());
		
		OpenDRIM_InstalledSoftwareIdentity_instances.push_back(instance);
	}
	_L_;
	return OK;
}

int SoftwareInventory_OpenDRIM_InstalledSoftwareIdentity_populate(OpenDRIM_InstalledSoftwareIdentity& instance, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return OK;
}

