//
// Copyright (c) 2021 - 2023, NVIDIA CORPORATION.  All rights reserved.
//
// NVIDIA CORPORATION and its licensors retain all intellectual property
// and proprietary rights in and to this software, related documentation
// and any modifications thereto.  Any use, reproduction, disclosure or
// distribution of this software and related documentation without an express
// license agreement from NVIDIA CORPORATION is strictly prohibited.
//

#pragma once

#include "cqi.hpp"

#include "nscq/nscq.h"

#include <memory>

namespace nscq::cqi {

struct nvswitch_nvlink_vc;

struct nvswitch_nvlink_vc : public cqi {
    using cqi_t = nvswitch_nvlink_vc;
    using id_t = uint8_t;
    using cqi::cqi;
    [[nodiscard]] virtual auto get_id() const -> id_t = 0;

    struct vc_latency_field : public session_field<nvswitch_nvlink_vc, readable<nscq_vc_latency_t>> {
        vc_latency_field(std::shared_ptr<nscq::cqi_session> &cqi_session) : session_field<nvswitch_nvlink_vc, readable<nscq_vc_latency_t>>(cqi_session) {}
    };
    virtual auto get(vc_latency_field) -> nscq_vc_latency_t = 0;

};
} // namespace nscq::cqi
