/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.touch.client;

import com.google.gwt.core.client.Duration;
import com.google.gwt.core.client.JsArray;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.dom.client.PartialSupport;
import com.google.gwt.dom.client.Touch;
import com.google.gwt.event.dom.client.TouchCancelEvent;
import com.google.gwt.event.dom.client.TouchCancelHandler;
import com.google.gwt.event.dom.client.TouchEndEvent;
import com.google.gwt.event.dom.client.TouchEndHandler;
import com.google.gwt.event.dom.client.TouchEvent;
import com.google.gwt.event.dom.client.TouchMoveEvent;
import com.google.gwt.event.dom.client.TouchMoveHandler;
import com.google.gwt.event.dom.client.TouchStartEvent;
import com.google.gwt.event.dom.client.TouchStartHandler;
import com.google.gwt.event.logical.shared.ResizeEvent;
import com.google.gwt.event.logical.shared.ResizeHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.touch.client.DefaultMomentum;
import com.google.gwt.touch.client.Momentum;
import com.google.gwt.touch.client.Point;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.HasScrolling;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@PartialSupport
public class TouchScroller {
    private static final double FRAMES_PER_SECOND = 60.0;
    private static final double MAX_TRACKING_TIME = 200.0;
    private static final double MAX_TRACKING_TIME_ON_DECK = 100.0;
    private static final double MIN_TRACKING_FOR_DRAG = 5.0;
    private static final int MS_PER_FRAME = 16;
    private static Boolean isSupported;
    private HandlerRegistration bustClickHandler;
    private boolean dragging;
    private final List<HandlerRegistration> handlerRegs = new ArrayList<HandlerRegistration>();
    private final TemporalPoint lastTouchPosition = new TemporalPoint();
    private Momentum momentum;
    private Scheduler.RepeatingCommand momentumCommand;
    private final TemporalPoint recentTouchPosition = new TemporalPoint();
    private TemporalPoint recentTouchPositionOnDeck;
    private Point startScrollPosition;
    private Point startTouchPosition;
    private boolean touching;
    private HasScrolling widget;

    public static TouchScroller createIfSupported() {
        return TouchScroller.isSupported() ? new TouchScroller() : null;
    }

    public static TouchScroller createIfSupported(HasScrolling widget) {
        TouchScroller scroller = TouchScroller.createIfSupported();
        if (scroller != null) {
            scroller.setTargetWidget(widget);
        }
        return scroller;
    }

    public static boolean isSupported() {
        if (isSupported == null) {
            isSupported = TouchEvent.isSupported() && !TouchScroller.isAndroid3();
        }
        return isSupported;
    }

    private static native boolean isAndroid3();

    protected TouchScroller() {
        this.setMomentum(new DefaultMomentum());
    }

    public Momentum getMomentum() {
        return this.momentum;
    }

    public HasScrolling getTargetWidget() {
        return this.widget;
    }

    public void setMomentum(Momentum momentum) {
        this.momentum = momentum;
        if (momentum == null) {
            this.momentumCommand = null;
        }
    }

    public void setTargetWidget(HasScrolling widget) {
        if (this.widget == widget) {
            return;
        }
        this.cancelAll();
        this.setBustNextClick(false);
        if (this.widget != null) {
            for (HandlerRegistration reg : this.handlerRegs) {
                reg.removeHandler();
            }
            this.handlerRegs.clear();
        }
        this.widget = widget;
        if (widget != null) {
            this.handlerRegs.add(widget.asWidget().addDomHandler(new TouchStartHandler(){

                public void onTouchStart(TouchStartEvent event) {
                    TouchScroller.this.onTouchStart(event);
                }
            }, TouchStartEvent.getType()));
            this.handlerRegs.add(widget.asWidget().addDomHandler(new TouchMoveHandler(){

                public void onTouchMove(TouchMoveEvent event) {
                    TouchScroller.this.onTouchMove(event);
                }
            }, TouchMoveEvent.getType()));
            this.handlerRegs.add(widget.asWidget().addDomHandler(new TouchEndHandler(){

                public void onTouchEnd(TouchEndEvent event) {
                    TouchScroller.this.onTouchEnd(event);
                }
            }, TouchEndEvent.getType()));
            this.handlerRegs.add(widget.asWidget().addDomHandler(new TouchCancelHandler(){

                public void onTouchCancel(TouchCancelEvent event) {
                    TouchScroller.this.onTouchCancel(event);
                }
            }, TouchCancelEvent.getType()));
        }
    }

    protected Touch getTouchFromEvent(TouchEvent<?> event) {
        JsArray<Touch> touches = event.getTouches();
        return touches.length() > 0 ? touches.get(0) : null;
    }

    protected void onDragEnd(TouchEvent<?> event) {
        if (this.momentum == null) {
            return;
        }
        Point endVelocity = this.calculateEndVelocity(this.recentTouchPosition, this.lastTouchPosition);
        if (endVelocity != null) {
            this.momentumCommand = new MomentumCommand(endVelocity);
            Scheduler.get().scheduleFixedDelay(this.momentumCommand, 16);
        }
    }

    protected void onDragMove(TouchEvent<?> event) {
        Point diff = this.startTouchPosition.minus(this.lastTouchPosition.getPoint());
        Point curScrollPosition = this.startScrollPosition.plus(diff);
        this.setWidgetScrollPosition(curScrollPosition);
    }

    protected void onDragStart(TouchEvent<?> event) {
    }

    protected void onTouchCancel(TouchEvent<?> event) {
        this.onTouchEnd(event);
    }

    protected void onTouchEnd(TouchEvent<?> event) {
        if (!this.touching) {
            return;
        }
        this.touching = false;
        if (this.dragging) {
            this.dragging = false;
            this.onDragEnd(event);
        }
    }

    protected void onTouchMove(TouchEvent<?> event) {
        if (!this.touching) {
            return;
        }
        Touch touch = this.getTouchFromEvent(event);
        Point touchPoint = new Point(touch.getPageX(), touch.getPageY());
        double touchTime = Duration.currentTimeMillis();
        this.lastTouchPosition.setTemporalPoint(touchPoint, touchTime);
        if (!this.dragging) {
            Point diff = touchPoint.minus(this.startTouchPosition);
            double absDiffX = Math.abs(diff.getX());
            double absDiffY = Math.abs(diff.getY());
            if (absDiffX > 5.0 || absDiffY > 5.0) {
                if (absDiffX > absDiffY) {
                    int hPosition = this.widget.getHorizontalScrollPosition();
                    int hMin = this.widget.getMinimumHorizontalScrollPosition();
                    int hMax = this.widget.getMaximumHorizontalScrollPosition();
                    if (diff.getX() < 0.0 && hMax <= hPosition) {
                        this.cancelAll();
                        return;
                    }
                    if (diff.getX() > 0.0 && hMin >= hPosition) {
                        this.cancelAll();
                        return;
                    }
                } else {
                    int vPosition = this.widget.getVerticalScrollPosition();
                    int vMin = this.widget.getMinimumVerticalScrollPosition();
                    int vMax = this.widget.getMaximumVerticalScrollPosition();
                    if (diff.getY() < 0.0 && vMax <= vPosition) {
                        this.cancelAll();
                        return;
                    }
                    if (diff.getY() > 0.0 && vMin >= vPosition) {
                        this.cancelAll();
                        return;
                    }
                }
                this.dragging = true;
                this.onDragStart(event);
            }
        }
        event.preventDefault();
        if (this.dragging) {
            this.onDragMove(event);
            double trackingTime = touchTime - this.recentTouchPosition.getTime();
            if (trackingTime > 200.0 && this.recentTouchPositionOnDeck != null) {
                this.recentTouchPosition.setTemporalPoint(this.recentTouchPositionOnDeck.getPoint(), this.recentTouchPositionOnDeck.getTime());
                this.recentTouchPositionOnDeck = null;
            } else if (trackingTime > 100.0 && this.recentTouchPositionOnDeck == null) {
                this.recentTouchPositionOnDeck = new TemporalPoint(touchPoint, touchTime);
            }
        }
    }

    protected void onTouchStart(TouchEvent<?> event) {
        if (this.touching) {
            return;
        }
        this.setBustNextClick(this.isMomentumActive());
        this.cancelAll();
        this.touching = true;
        Touch touch = this.getTouchFromEvent(event);
        this.startTouchPosition = new Point(touch.getPageX(), touch.getPageY());
        double startTouchTime = Duration.currentTimeMillis();
        this.recentTouchPosition.setTemporalPoint(this.startTouchPosition, startTouchTime);
        this.lastTouchPosition.setTemporalPoint(this.startTouchPosition, startTouchTime);
        this.recentTouchPositionOnDeck = null;
        this.startScrollPosition = this.getWidgetScrollPosition();
    }

    Point calculateEndVelocity(TemporalPoint from, TemporalPoint to) {
        double time = to.getTime() - from.getTime();
        if (time <= 0.0) {
            return null;
        }
        Point dist = from.getPoint().minus(to.getPoint());
        return new Point(dist.getX() / time, dist.getY() / time);
    }

    TemporalPoint getLastTouchPosition() {
        return this.lastTouchPosition;
    }

    TemporalPoint getRecentTouchPosition() {
        return this.recentTouchPosition;
    }

    boolean isDragging() {
        return this.dragging;
    }

    boolean isMomentumActive() {
        return this.momentumCommand != null;
    }

    boolean isTouching() {
        return this.touching;
    }

    private void cancelAll() {
        this.touching = false;
        this.dragging = false;
        this.momentumCommand = null;
    }

    private Point getWidgetScrollPosition() {
        return new Point(this.widget.getHorizontalScrollPosition(), this.widget.getVerticalScrollPosition());
    }

    private void setBustNextClick(boolean doBust) {
        if (doBust && this.bustClickHandler == null) {
            this.bustClickHandler = Event.addNativePreviewHandler(new Event.NativePreviewHandler(){

                public void onPreviewNativeEvent(Event.NativePreviewEvent event) {
                    if (1 == event.getTypeInt()) {
                        event.getNativeEvent().stopPropagation();
                        event.getNativeEvent().preventDefault();
                        TouchScroller.this.setBustNextClick(false);
                    }
                }
            });
        } else if (!doBust && this.bustClickHandler != null) {
            this.bustClickHandler.removeHandler();
            this.bustClickHandler = null;
        }
    }

    private void setWidgetScrollPosition(Point position) {
        this.widget.setHorizontalScrollPosition((int)position.getX());
        this.widget.setVerticalScrollPosition((int)position.getY());
    }

    static /* synthetic */ Point access$000(TouchScroller x0) {
        return x0.getWidgetScrollPosition();
    }

    private class MomentumCommand
    implements Scheduler.RepeatingCommand {
        private final Duration duration = new Duration();
        private final Point initialPosition = TouchScroller.access$000(TouchScroller.this);
        private int lastElapsedMillis = 0;
        private Momentum.State state;
        private HandlerRegistration windowResizeHandler;

        public MomentumCommand(Point endVelocity) {
            this.state = TouchScroller.this.momentum.createState(this.initialPosition, endVelocity);
            this.windowResizeHandler = Window.addResizeHandler(new ResizeHandler(){

                public void onResize(ResizeEvent event) {
                    MomentumCommand.this.finish();
                }
            });
        }

        public boolean execute() {
            if (this != TouchScroller.this.momentumCommand) {
                this.finish();
                return false;
            }
            int cumulativeElapsedMillis = this.duration.elapsedMillis();
            this.state.setElapsedMillis(cumulativeElapsedMillis - this.lastElapsedMillis);
            this.lastElapsedMillis = cumulativeElapsedMillis;
            this.state.setCumulativeElapsedMillis(cumulativeElapsedMillis);
            boolean notDone = TouchScroller.this.momentum.updateState(this.state);
            if (!notDone) {
                this.finish();
            }
            TouchScroller.this.setWidgetScrollPosition(this.state.getPosition());
            return notDone;
        }

        private void finish() {
            if (this.windowResizeHandler != null) {
                this.windowResizeHandler.removeHandler();
                this.windowResizeHandler = null;
            }
            if (this == TouchScroller.this.momentumCommand) {
                TouchScroller.this.momentumCommand = null;
                TouchScroller.this.setBustNextClick(false);
            }
        }
    }

    static class TemporalPoint {
        private Point point;
        private double time;

        public TemporalPoint() {
        }

        public TemporalPoint(Point point, double time) {
            this.setTemporalPoint(point, time);
        }

        public Point getPoint() {
            return this.point;
        }

        public double getTime() {
            return this.time;
        }

        public void setTemporalPoint(Point point, double time) {
            this.point = point;
            this.time = time;
        }
    }
}

