/*
 * This file is part of the webaccounts-browser-plugin.
 * Copyright (C) Canonical Ltd. 2012
 *
 * Author: Alberto Mardegan <alberto.mardegan@canonical.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef FAKE_CAPTURE_SERVICE_H
#define FAKE_CAPTURE_SERVICE_H

#include <glib.h>

G_BEGIN_DECLS

typedef struct {
    gboolean called;
    gchar *provider_name;
    gchar *username;
    gchar *password;
    GVariant *cookies;
} FakeCaptureService;

void fake_capture_service_init (FakeCaptureService *self);
void fake_capture_service_unset (FakeCaptureService *self);
void fake_capture_service_reset (FakeCaptureService *self);

G_END_DECLS

#endif
