// -*- mode: js; js-indent-level: 4; indent-tabs-mode: nil -*-
Components.utils.import("resource://unity/unity-misc-utils.js");

var EXPORTED_SYMBOLS = [ "makeAPI" ];

function checkString(str, allowUndef) {
    if (allowUndef && str == undefined) {
        return;
    }
    if (!str || typeof(str) !== 'string') {
        throw new TypeError("incorrect argument");
    }

}

function makeAPI(init, toDataURL) {
    var nope = new Function();
    var api;
    function PlaybackState() {
    }
    PlaybackState.prototype = {
        __exposedProps__: { PLAYING: 'r', PAUSED: 'r' },
        PLAYING: 0,
        PAUSED:1
    };

    function MediaPlayer() {
    }

    MediaPlayer.prototype = {
        __exposedProps__: { init: 'r', onPlayPause: 'r', onPrevious: 'r', onNext: 'r',
                            setTrack: 'r', setCanGoNext: 'r', setCanGoPrevious: 'r',
                            setCanPlay: 'r', setCanPause: 'r', setPlaybackState: 'r',
                            getPlaybackState: 'r', PlaybackState: 'r' },

        init: nope,
        onPlayPause: nope,
        onPrevious: nope,
        onNext: nope,
        setTrack: nope,
        setCanGoNext: nope,
        setCanGoPrevious: nope,
        setCanPlay: nope,
        setCanPause: nope,
        setPlaybackState: nope,
        getPlaybackState: nope,
        PlaybackState: new PlaybackState()
    };

    function MessagingIndicator() {
    }

    MessagingIndicator.prototype = {
        __exposedProps__: { addAction: 'r', showIndicator: 'r',
                            clearIndicator: 'r', clearIndicators: 'r' },

        addAction: nope,
        showIndicator: nope,
        clearIndicator: nope,
        clearIndicators: nope
    };

    function Launcher() {
    }
    Launcher.prototype = {
        __exposedProps__: { 'setCount': 'r', clearCount: 'r',
                             setProgress: 'r', clearProgress: 'r', setUrgent: 'r',
                             addAction: 'r', removeAction: 'r', removeActions: 'r' },

        setCount: nope,
        clearCount: nope,
        setProgress: nope,
        clearProgress: nope,
        setUrgent: nope,
        _addAction: nope,
        _addStaticAction: nope,
        addAction: nope,
        removeAction: nope,
        removeActions: nope
    };

    function Notification() {
    }

    Notification.prototype = {
        __exposedProps__: { 'showNotification': 'r' },
        showNotification: nope
    };

    var Api = function () {}
    Api.prototype = {
        __exposedProps__: { 'init': 'r', 'acceptData': 'r',
                            'addAction': 'r', 'clearAction': 'r',
                            'clearActions': 'r', 'MediaPlayer': 'r', 'Notification': 'r',
                            'Launcher': 'r', 'MessagingIndicator': 'r' },

        Notification: new Notification(),
        Launcher: new Launcher(),
        MessagingIndicator: new MessagingIndicator(),
        MediaPlayer: new MediaPlayer(),

        init: function(props) {
            var sx, sy, sw, sh;
            checkString(props.name, false);
            checkString(props.iconUrl, true);
            checkString(props.domain, true);
            checkString(props.login, true);
            checkString(props.mimeTypes, true);
            checkString(props.homepage, true);

            try {
                sx = props.crop.sx;
                sy= props.crop.sy;
                sw = props.crop.sw;
                sh = props.crop.sh;
            } catch (e) {}

            if (props.homepage && !/^(http|https|file):\/\//.test(props.homepage)) {
                throw new TypeError("incorrect argument");
            }
            if (props.crop) {
                toDataURL(props.iconUrl, function (aResult, uri) {
                    var tmp = {};
                    for (var i in props) {
                        if (props.hasOwnProperty(i)) {
                            tmp[i] = props[i];
                        }
                    }
                    tmp.iconUrl = uri;
                    init(tmp);
                }, sx, sy, sw, sh);
            } else {
                init(props);
            }
        },

        acceptData: nope,

        addAction: nope,
        clearAction: nope,
        clearActions: nope
    };

    api = new Api();

    return api;
}
