<template name="file-header">
    /*
        Generated by sbus code generator

        Copyright (C) 2017 Red Hat

        This program is free software; you can redistribute it and/or modify
        it under the terms of the GNU General Public License as published by
        the Free Software Foundation; either version 3 of the License, or
        (at your option) any later version.

        This program is distributed in the hope that it will be useful,
        but WITHOUT ANY WARRANTY; without even the implied warranty of
        MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
        GNU General Public License for more details.

        You should have received a copy of the GNU General Public License
        along with this program.  If not, see <http://www.gnu.org/licenses/>.
    */

    #ifndef ${file-guard}
    #define ${file-guard}

    #include <errno.h>
    #include <talloc.h>
    #include <tevent.h>

    #include "${sbus-path}/sbus_sync.h"
    #include "${header:client_properties}"
    <loop name="custom-type-header">
    #include "${custom-type-header}"
    </loop>

</template>

<template name="method-caller">
    errno_t
    sbus_call_${token}
        (<toggle name="if-use-talloc">TALLOC_CTX *mem_ctx,
         struct sbus_sync_connection *conn,
         <or>struct sbus_sync_connection *conn,
         </toggle><toggle name="if-raw-input">
         DBusMessage *raw_message<or>
         const char *busname,
         const char *object_path<loop name="in">,
         ${type} arg_${name}</loop></toggle>
         <toggle name="if-raw-output">,
         DBusMessage **_reply);
         <or><loop name="out">,
         ${type} _arg_${name}</loop>);
         </toggle>

</template>

<template name="signal-caller">
    void
    sbus_sync_emit_${token}
        (struct sbus_sync_connection *conn,
         <toggle name="if-raw-input">
         DBusMessage *raw_message);
         <or>
         const char *object_path<loop name="in">,
         ${type} arg_${name}</loop>);
         </toggle>

</template>

<template name="property-caller">
    <toggle name="get-static">
    errno_t
    sbus_get_${token}
        (struct sbus_sync_connection *conn,
         const char *busname,
         const char *object_path,
         ${output-type} _value);

    </toggle>
    <toggle name="get-talloc">
    errno_t
    sbus_get_${token}
        (TALLOC_CTX *mem_ctx,
         struct sbus_sync_connection *conn,
         const char *busname,
         const char *object_path,
         ${output-type} _value);

    </toggle>
    <toggle name="set">
    errno_t
    sbus_set_${token}
        (struct sbus_sync_connection *conn,
         const char *busname,
         const char *object_path,
         ${input-type} value);

    </toggle>
</template>

<template name="getall-caller">
    errno_t
    sbus_getall_${token}
        (TALLOC_CTX *mem_ctx,
         struct sbus_sync_connection *conn,
         const char *busname,
         const char *object_path,
         struct sbus_all_${token} **_properties);

</template>

<template name="file-footer">
    #endif /* ${file-guard} */
</template>
