/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.standard;

import org.jhotdraw.framework.DrawingEditor;
import org.jhotdraw.framework.DrawingView;
import org.jhotdraw.framework.Figure;
import org.jhotdraw.framework.FigureEnumeration;
import org.jhotdraw.standard.AbstractCommand;
import org.jhotdraw.standard.SendToBackCommand;
import org.jhotdraw.util.Undoable;

public class BringToFrontCommand
extends AbstractCommand {
    public BringToFrontCommand(String string, DrawingEditor drawingEditor) {
        super(string, drawingEditor);
    }

    public void execute() {
        super.execute();
        this.setUndoActivity(this.createUndoActivity());
        this.getUndoActivity().setAffectedFigures(this.view().selection());
        FigureEnumeration figureEnumeration = this.getUndoActivity().getAffectedFigures();
        while (figureEnumeration.hasNextFigure()) {
            this.view().drawing().bringToFront(figureEnumeration.nextFigure());
        }
        this.view().checkDamage();
    }

    public boolean isExecutableWithView() {
        return this.view().selectionCount() > 0;
    }

    protected Undoable createUndoActivity() {
        return new UndoActivity(this.view());
    }

    public static class UndoActivity
    extends SendToBackCommand.UndoActivity {
        public UndoActivity(DrawingView drawingView) {
            super(drawingView);
        }

        protected void sendToCommand(Figure figure) {
            this.getDrawingView().drawing().bringToFront(figure);
        }
    }
}

