/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.standard;

import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import org.jhotdraw.framework.DrawingEditor;
import org.jhotdraw.framework.DrawingView;
import org.jhotdraw.framework.FigureSelectionListener;
import org.jhotdraw.framework.JHotDrawRuntimeException;
import org.jhotdraw.framework.ViewChangeListener;
import org.jhotdraw.util.CollectionsFactory;
import org.jhotdraw.util.Command;
import org.jhotdraw.util.CommandListener;
import org.jhotdraw.util.Undoable;

public abstract class AbstractCommand
implements Command,
FigureSelectionListener {
    private String myName;
    private Undoable myUndoableActivity;
    private boolean myIsViewRequired;
    private EventDispatcher myEventDispatcher;
    private DrawingEditor myDrawingEditor;

    public AbstractCommand(String string, DrawingEditor drawingEditor) {
        this(string, drawingEditor, true);
    }

    public AbstractCommand(String string, DrawingEditor drawingEditor, boolean bl) {
        this.setName(string);
        this.setDrawingEditor(drawingEditor);
        this.getDrawingEditor().addViewChangeListener(this.createViewChangeListener());
        this.myIsViewRequired = bl;
        this.setEventDispatcher(this.createEventDispatcher());
    }

    protected void viewSelectionChanged(DrawingView drawingView, DrawingView drawingView2) {
        if (drawingView != null) {
            drawingView.removeFigureSelectionListener(this);
        }
        if (drawingView2 != null) {
            drawingView2.addFigureSelectionListener(this);
        }
        if (this.isViewRequired()) {
            boolean bl;
            boolean bl2 = drawingView != null && drawingView.isInteractive();
            boolean bl3 = bl = drawingView2 != null && drawingView2.isInteractive();
            if (!bl2 && bl) {
                this.getEventDispatcher().fireCommandExecutableEvent();
            } else if (bl2 && !bl) {
                this.getEventDispatcher().fireCommandNotExecutableEvent();
            }
        }
    }

    protected void viewCreated(DrawingView drawingView) {
    }

    protected void viewDestroying(DrawingView drawingView) {
    }

    public void figureSelectionChanged(DrawingView drawingView) {
    }

    public DrawingEditor getDrawingEditor() {
        return this.myDrawingEditor;
    }

    private void setDrawingEditor(DrawingEditor drawingEditor) {
        this.myDrawingEditor = drawingEditor;
    }

    public DrawingView view() {
        return this.getDrawingEditor().view();
    }

    public String name() {
        return this.myName;
    }

    public void setName(String string) {
        this.myName = string;
    }

    public void dispose() {
        if (this.view() != null) {
            this.view().removeFigureSelectionListener(this);
        }
    }

    public void execute() {
        if (this.view() == null) {
            throw new JHotDrawRuntimeException("execute should NOT be getting called when view() == null");
        }
    }

    public boolean isExecutable() {
        if (this.isViewRequired() && (this.view() == null || !this.view().isInteractive())) {
            return false;
        }
        return this.isExecutableWithView();
    }

    protected boolean isViewRequired() {
        return this.myIsViewRequired;
    }

    protected boolean isExecutableWithView() {
        return true;
    }

    public Undoable getUndoActivity() {
        return this.myUndoableActivity;
    }

    public void setUndoActivity(Undoable undoable) {
        this.myUndoableActivity = undoable;
    }

    public void addCommandListener(CommandListener commandListener) {
        this.getEventDispatcher().addCommandListener(commandListener);
    }

    public void removeCommandListener(CommandListener commandListener) {
        this.getEventDispatcher().removeCommandListener(commandListener);
    }

    private void setEventDispatcher(EventDispatcher eventDispatcher) {
        this.myEventDispatcher = eventDispatcher;
    }

    protected EventDispatcher getEventDispatcher() {
        return this.myEventDispatcher;
    }

    protected EventDispatcher createEventDispatcher() {
        return new EventDispatcher(this);
    }

    protected ViewChangeListener createViewChangeListener() {
        return new ViewChangeListener(){

            public void viewSelectionChanged(DrawingView drawingView, DrawingView drawingView2) {
                AbstractCommand.this.viewSelectionChanged(drawingView, drawingView2);
            }

            public void viewCreated(DrawingView drawingView) {
                AbstractCommand.this.viewCreated(drawingView);
            }

            public void viewDestroying(DrawingView drawingView) {
                AbstractCommand.this.viewDestroying(drawingView);
            }
        };
    }

    public static class EventDispatcher {
        private List myRegisteredListeners = CollectionsFactory.current().createList();
        private Command myObservedCommand;

        public EventDispatcher(Command command) {
            this.myObservedCommand = command;
        }

        public void fireCommandExecutedEvent() {
            Iterator iterator = this.myRegisteredListeners.iterator();
            while (iterator.hasNext()) {
                ((CommandListener)iterator.next()).commandExecuted(new EventObject(this.myObservedCommand));
            }
        }

        public void fireCommandExecutableEvent() {
            Iterator iterator = this.myRegisteredListeners.iterator();
            while (iterator.hasNext()) {
                ((CommandListener)iterator.next()).commandExecutable(new EventObject(this.myObservedCommand));
            }
        }

        public void fireCommandNotExecutableEvent() {
            Iterator iterator = this.myRegisteredListeners.iterator();
            while (iterator.hasNext()) {
                ((CommandListener)iterator.next()).commandNotExecutable(new EventObject(this.myObservedCommand));
            }
        }

        public void addCommandListener(CommandListener commandListener) {
            if (!this.myRegisteredListeners.contains(commandListener)) {
                this.myRegisteredListeners.add(commandListener);
            }
        }

        public void removeCommandListener(CommandListener commandListener) {
            if (this.myRegisteredListeners.contains(commandListener)) {
                this.myRegisteredListeners.remove(commandListener);
            }
        }
    }
}

