.\" Hey, Emacs!  This is an -*- nroff -*- source file.
.\" Update-mime and this manpage were written by Brian White and
.\" have been placed in the public domain (the only true "free").
.\"
.TH UPDATE-MIME 8 "12th Feb 2012" "Debian Project" "Update MIME Programs"
.SH NAME
update\-mime \- create or update MIME information
.SH SYNOPSIS
.B update\-mime
[no parameters]
.SH DESCRIPTION
.PP
.B update-mime
updates the
.B /etc/mailcap
file to reflect mime information changed by a Debian package during
installation or removal.

.SS OPTIONS
.BI \-\-local
Generate files in the current user's home directory instead of the
.I /etc
directory.  This allows users to create a custom ordering configuration and get
a complete
.I ~/.mailcap
file out of it.  In this local mode, the order overriding file (see below)
will be looked for in the
.I ~/.mailcap.order
file.

.SH OVERRIDING ORDER
The order of entries in the
.I /etc/mailcap
file can be altered by editing the
.I /etc/mailcap.order
file.  Please see the
.BR mailcap.order(5)
man page for more information.

.SH CREATING ENTRIES
To create entries in the mailcap file, packages need to create a file
in the
.I /usr/lib/mime/packages
directory.  In this file goes the verbatim desired mailcap entries.
In addition to the standard mailcap options (described below) is a new
.I priority
option.  Specifying this will provide for simple ranking of programs
within a given mime type.  An animation viewer, for example, may be
able to display a static picture, but probably wouldn't be the best
choice and so would give an option like "priority=2".  Priorities
range from 0 to 9, with 0 being the lowest and 9 being the highest.
If the
.I priority
option is omitted, a value of 5 is used.

The following are standard options that can be specified in the
mailcap entry.  Options are separated by semicolons (;) but must all
be on the same line.  Each line should look like:

  mime/type; viewer; option; another=val; etc; priority=5

Mime types of the form "class/*" and even "*/*" are now acceptable
(they were previously disallowed).  When using "class/*", it is
probably a good idea to add a "priority=[1-4]" option so specific
rules using the default priority will get chosen first.  If using
"*/*", though, you probably want to add a "priority=0" option to make
that rule a "last resort".
.SS Commands
.TP
.BI <program-string>
Specifies the program to run to view a file of the given content-type.
.B This option setting connot be omitted.
An implicit "view=" can be considered before it.  When writing an
entry that has no viewer, use a value of
.I false
in this space.
.TP
.BI compose=<program-string>
The "compose" command may be used to specify a program that can be
used to compose a new body or body part in the given format.  Its
intended use is to support mail composing agents that support the
composition of multiple types of mail using external composing agents.
The result of the composing program may be data that is not yet
suitable for mail transport -- that is, a Content-Transfer-Encoding
may need to be applied to the data.
.TP
.BI composetyped=<program-string>
The "composetyped" command is similar to "compose", but is to be used
when the composing program needs to specify the Content-type header
field to be applied to the composed data.  The "compose" option is
simpler, and is preferred for use with existing (non-mail-oriented)
programs for composing data in a given format.  The "composetyped"
option is necessary when the Content-type information must include
auxiliary parameters, and the composition program must then know
enough about mail formats to produce output that includes the mail
type information.
.TP
.BI edit=<program-string>
The "edit" command may be used to specify a program that can be used
to edit a body or body part in the given format.  In many cases, it
may be identical in content to the "compose" command.
.TP
.BI print=<program-string>
The "print" command may be used to specify a program that can be used to
print a message or body part in the given format.
.SS Modifiers
These options are modifiers to all the commands specified on the
command line.
.TP
.BI test=<conditional>
The "test" option may be used to test some external condition (e.g.,
the machine architecture, or the window system in use) to determine
whether or not the mailcap line applies.  It specifies a program to be
run to test some condition.  If the test fails, a subsequent mailcap
entry will be sought.  Multiple test options are not permitted --
since a test can call a program, it can already be arbitrarily
complex.

.B Note:
When testing for X by looking at the
.I DISPLAY
environment variable, please use one of:

        test=test \-z "$DISPLAY"     (no X)
  or    test=test \-n "$DISPLAY"     (have X)

Many programs recognize these strings and optimize for them.
.TP
.BI needsterminal
The "needsterminal" option, if given, indicates that the commands must
be run on an interactive terminal.  This is needed to inform window-oriented
user agents that an interactive terminal is needed.  (The decision is
not left exclusively to the command because in some circumstances it
may not be possible for such programs to tell whether or not they are
on interactive terminals.)  The needsterminal command applies to the
view, compose and edit commands, if they exist.  Note that this is NOT
a test -- it is a requirement for the environment in which the program
will be executed, and will typically cause the creation of a terminal
window when not executed on either a real terminal or a terminal
window.
.TP
.BI copiousoutput
The "copiousoutput" option, if given, indicates that the output from the
view-command will be an extended stream of output and is to be
interpreted as advice to the UA (User Agent mail-reading program) that
the output should be either paged or made scrollable.  Note that it is
probably a mistake if needsterminal and copiousoutput are both
specified.
.SS Content-Type Info
These options provide additional information about the given
content-type.
.TP
.BI description=<string>
The "description" option simply provides a textual description that
describes the type of data, to be used optionally by mail readers that
wish to describe the data before offering to display it.
.TP
.BI textualnewlines
The "textualnewlines" option, if given, indicates that this type
of data is line-oriented and that, if encoded in a binary format, all
newlines should be converted to canonical form (CRLF) before encoding,
and will be in that form after decoding.  In general, this is needed
only if there is line-oriented data of some type other than text/* or
non-line-oriented data that is a subtype of text.
.TP
.BI x11-bitmap=<pathname>
The "x11-bitmap" option names a file, in X11 bitmap (xbm) format,
which points to an appropriate icon to be used to visually denote the
presence of this kind of data.
.TP
.BI nametemplate=<string>
The "nametemplate" option gives a file name format, in which %s will be
replaced by a short unique string to give the name of the temporary
file to be passed to the viewing command.  This is only expected to be
relevant in environments where filename extensions are meaningful,
e.g., one could specify that a GIF file being passed to a gif viewer
should have a name ending in ".gif" by using "nametemplate=%s.gif".
.SH DEPENDENCIES
Packages that wish to provide MIME access to themselves should
.B not
depend on, recommend, or suggest
.B mime-support,
as the the file they create in
.I /usr/lib/mime/packages
will cause
.B update\-mime
to be automatically run via a Dpkg trigger.

.SH DESKTOP ENTRIES
In addition to the abovementioned mechanism
.B update\-mime
also parses desktop entries in /usr/share/applications/ to generate
mailcap entries. These entries are given a lower priority than those
in /usr/lib/mime/packages.

.SH "SEE ALSO"
.BR mailcap.order "(5), "deb-triggers "(1), RFC-2046, RFC-1524
.SH AUTHOR
.B update\-mime
was written by Brian White <bcwhite@pobox.com>
.SH COPYRIGHT
.B update\-mime
is in the public domain (the only true "free").
