; RUN: llc -filetype=obj %s -o %t.obj
; RUN: llvm-pdbutil dump -types %t.obj | FileCheck %s

; Manually remove the "static" flag from the LLVM IR generated by compiling the
; following C++ source:
; struct Foo  {
;   static void st_meth(int x, int y);
; } f;

; "this type" below should be <no type>.
; CHECK: LF_MFUNCTION
; CHECK-NEXT: return type = 0x0003 (void), # args = 2, param list = {{.*}}
; CHECK-NEXT: class type = {{.*}}, this type = <no type>, this adjust = 0
; CHECK-NEXT: calling conv = cdecl, options = None

; ModuleID = 't.cpp'
source_filename = "t.cpp"
target datalayout = "e-m:w-i64:64-f80:128-n8:16:32:64-S128"
target triple = "x86_64-pc-windows-msvc19.14.26433"

%struct.Foo = type { i8 }

@"?f@@3UFoo@@A" = dso_local global %struct.Foo zeroinitializer, align 1, !dbg !0

!llvm.dbg.cu = !{!2}
!llvm.module.flags = !{!12, !13, !14, !15}
!llvm.ident = !{!16}

!0 = !DIGlobalVariableExpression(var: !1, expr: !DIExpression())
!1 = distinct !DIGlobalVariable(name: "f", linkageName: "?f@@3UFoo@@A", scope: !2, file: !3, line: 3, type: !6, isLocal: false, isDefinition: true)
!2 = distinct !DICompileUnit(language: DW_LANG_C_plus_plus, file: !3, producer: "clang version 8.0.0 ", isOptimized: false, runtimeVersion: 0, emissionKind: FullDebug, enums: !4, globals: !5, nameTableKind: None)
!3 = !DIFile(filename: "t.cpp", directory: "C:\5Csrc\5Cllvm-project\5Cbuild", checksumkind: CSK_MD5, checksum: "ac580c6cde5f3f394632dcaad04873a4")
!4 = !{}
!5 = !{!0}
!6 = distinct !DICompositeType(tag: DW_TAG_structure_type, name: "Foo", file: !3, line: 1, size: 8, flags: DIFlagTypePassByValue, elements: !7, identifier: ".?AUFoo@@")
!7 = !{!8}
!8 = !DISubprogram(name: "st_meth", linkageName: "?st_meth@Foo@@SAXHH@Z", scope: !6, file: !3, line: 2, type: !9, scopeLine: 2, flags: DIFlagPrototyped, spFlags: 0)
!9 = !DISubroutineType(types: !10)
!10 = !{null, !11, !11}
!11 = !DIBasicType(name: "int", size: 32, encoding: DW_ATE_signed)
!12 = !{i32 2, !"CodeView", i32 1}
!13 = !{i32 2, !"Debug Info Version", i32 3}
!14 = !{i32 1, !"wchar_size", i32 2}
!15 = !{i32 7, !"PIC Level", i32 2}
!16 = !{!"clang version 8.0.0 "}
