/* SPDX-License-Identifier: GPL-2.0-only */

#ifndef __SOC_MEDIATEK_MT8173_MMSYS_H
#define __SOC_MEDIATEK_MT8173_MMSYS_H

#define MT8173_DISP_REG_CONFIG_DISP_OVL0_MOUT_EN	0x040
#define MT8173_DISP_REG_CONFIG_DISP_OVL1_MOUT_EN	0x044
#define MT8173_DISP_REG_CONFIG_DISP_OD_MOUT_EN		0x048
#define MT8173_DISP_REG_CONFIG_DISP_GAMMA_MOUT_EN	0x04c
#define MT8173_DISP_REG_CONFIG_DISP_UFOE_MOUT_EN	0x050
#define MT8173_DISP_REG_CONFIG_DISP_COLOR0_SEL_IN	0x084
#define MT8173_DISP_REG_CONFIG_DISP_COLOR1_SEL_IN	0x088
#define MT8173_DISP_REG_CONFIG_DISP_AAL_SEL_IN		0x08c
#define MT8173_DISP_REG_CONFIG_DISP_UFOE_SEL_IN		0x0a0
#define MT8173_DISP_REG_CONFIG_DSI0_SEL_IN		0x0a4
#define MT8173_DISP_REG_CONFIG_DPI_SEL_IN		0x0ac
#define MT8173_DISP_REG_CONFIG_DISP_RDMA0_SOUT_SEL_IN	0x0b0
#define MT8173_DISP_REG_CONFIG_DISP_RDMA1_SOUT_EN	0x0c8
#define MT8173_DISP_REG_CONFIG_DISP_COLOR0_SOUT_SEL_IN	0x0bc

#define MT8173_AAL_SEL_IN_MERGE				BIT(0)
#define MT8173_COLOR0_SEL_IN_OVL0			BIT(0)
#define MT8173_COLOR0_SOUT_MERGE			BIT(0)
#define MT8173_DPI0_SEL_IN_MASK				GENMASK(1, 0)
#define MT8173_DPI0_SEL_IN_RDMA1			BIT(0)
#define MT8173_DSI0_SEL_IN_UFOE				BIT(0)
#define MT8173_GAMMA_MOUT_EN_RDMA1			BIT(0)
#define MT8173_OD0_MOUT_EN_RDMA0			BIT(0)
#define MT8173_OVL0_MOUT_EN_COLOR0			BIT(0)
#define MT8173_OVL1_MOUT_EN_COLOR1			BIT(0)
#define MT8173_UFOE_MOUT_EN_DSI0			BIT(0)
#define MT8173_UFOE_SEL_IN_RDMA0			BIT(0)
#define MT8173_RDMA0_SOUT_COLOR0			BIT(0)

static const struct mtk_mmsys_routes mt8173_mmsys_routing_table[] = {
	MMSYS_ROUTE(OVL0, COLOR0,
		    MT8173_DISP_REG_CONFIG_DISP_OVL0_MOUT_EN, MT8173_OVL0_MOUT_EN_COLOR0,
		    MT8173_OVL0_MOUT_EN_COLOR0),
	MMSYS_ROUTE(OD0, RDMA0,
		    MT8173_DISP_REG_CONFIG_DISP_OD_MOUT_EN, MT8173_OD0_MOUT_EN_RDMA0,
		    MT8173_OD0_MOUT_EN_RDMA0),
	MMSYS_ROUTE(UFOE, DSI0,
		    MT8173_DISP_REG_CONFIG_DISP_UFOE_MOUT_EN, MT8173_UFOE_MOUT_EN_DSI0,
		    MT8173_UFOE_MOUT_EN_DSI0),
	MMSYS_ROUTE(COLOR0, AAL0,
		    MT8173_DISP_REG_CONFIG_DISP_COLOR0_SOUT_SEL_IN, MT8173_COLOR0_SOUT_MERGE,
		    0 /* SOUT to AAL */),
	MMSYS_ROUTE(RDMA0, UFOE,
		    MT8173_DISP_REG_CONFIG_DISP_RDMA0_SOUT_SEL_IN, MT8173_RDMA0_SOUT_COLOR0,
		    0 /* SOUT to UFOE */),
	MMSYS_ROUTE(OVL0, COLOR0,
		    MT8173_DISP_REG_CONFIG_DISP_COLOR0_SEL_IN, MT8173_COLOR0_SEL_IN_OVL0,
		    MT8173_COLOR0_SEL_IN_OVL0),
	MMSYS_ROUTE(AAL0, COLOR0,
		    MT8173_DISP_REG_CONFIG_DISP_AAL_SEL_IN, MT8173_AAL_SEL_IN_MERGE,
		    0 /* SEL_IN from COLOR0 */),
	MMSYS_ROUTE(RDMA0, UFOE,
		    MT8173_DISP_REG_CONFIG_DISP_UFOE_SEL_IN, MT8173_UFOE_SEL_IN_RDMA0,
		    0 /* SEL_IN from RDMA0 */),
	MMSYS_ROUTE(UFOE, DSI0,
		    MT8173_DISP_REG_CONFIG_DSI0_SEL_IN, MT8173_DSI0_SEL_IN_UFOE,
		    0 /* SEL_IN from UFOE */),
	MMSYS_ROUTE(OVL1, COLOR1,
		    MT8173_DISP_REG_CONFIG_DISP_OVL1_MOUT_EN, MT8173_OVL1_MOUT_EN_COLOR1,
		    MT8173_OVL1_MOUT_EN_COLOR1),
	MMSYS_ROUTE(GAMMA, RDMA1,
		    MT8173_DISP_REG_CONFIG_DISP_GAMMA_MOUT_EN, MT8173_GAMMA_MOUT_EN_RDMA1,
		    MT8173_GAMMA_MOUT_EN_RDMA1),
	MMSYS_ROUTE(RDMA1, DPI0,
		    MT8173_DISP_REG_CONFIG_DISP_RDMA1_SOUT_EN, RDMA1_SOUT_MASK,
		    RDMA1_SOUT_DPI0),
	MMSYS_ROUTE(OVL1, COLOR1,
		    MT8173_DISP_REG_CONFIG_DISP_COLOR1_SEL_IN, COLOR1_SEL_IN_OVL1,
		    COLOR1_SEL_IN_OVL1),
	MMSYS_ROUTE(RDMA1, DPI0,
		    MT8173_DISP_REG_CONFIG_DPI_SEL_IN, MT8173_DPI0_SEL_IN_MASK,
		    MT8173_DPI0_SEL_IN_RDMA1),
};

#endif /* __SOC_MEDIATEK_MT8173_MMSYS_H */
