// { dg-do run { target c++11 } }
// { dg-options "-D__STDCPP_WANT_MATH_SPEC_FUNCS__" }
//
// Copyright (C) 2016 Free Software Foundation, Inc.
//
// This file is part of the GNU ISO C++ Library.  This library is free
// software; you can redistribute it and/or modify it under the
// terms of the GNU General Public License as published by the
// Free Software Foundation; either version 3, or (at your option)
// any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License along
// with this library; see the file COPYING3.  If not see
// <http://www.gnu.org/licenses/>.

//  sph_legendre
//  Compare against values generated by the GNU Scientific Library.
//  The GSL can be found on the web: http://www.gnu.org/software/gsl/
#include <limits>
#include <cmath>
#if defined(__TEST_DEBUG)
#  include <iostream>
#  define VERIFY(A) \
  if (!(A)) \
    { \
      std::cout << "line " << __LINE__ \
	<< "  max_abs_frac = " << max_abs_frac \
	<< std::endl; \
    }
#else
#  include <testsuite_hooks.h>
#endif
#include <specfun_testcase.h>


// Test data for l=0, m=0.
// max(|f - f_GSL|): 0.0000000000000000
// max(|f - f_GSL| / |f_GSL|): 0.0000000000000000
const testcase_sph_legendre<double>
data001[21] =
{
  { 0.28209479177387814, 0, 0, 
	  0.0000000000000000 },
  { 0.28209479177387814, 0, 0, 
	  0.15707963267948966 },
  { 0.28209479177387814, 0, 0, 
	  0.31415926535897931 },
  { 0.28209479177387814, 0, 0, 
	  0.47123889803846897 },
  { 0.28209479177387814, 0, 0, 
	  0.62831853071795862 },
  { 0.28209479177387814, 0, 0, 
	  0.78539816339744828 },
  { 0.28209479177387814, 0, 0, 
	  0.94247779607693793 },
  { 0.28209479177387814, 0, 0, 
	  1.0995574287564276 },
  { 0.28209479177387814, 0, 0, 
	  1.2566370614359172 },
  { 0.28209479177387814, 0, 0, 
	  1.4137166941154069 },
  { 0.28209479177387814, 0, 0, 
	  1.5707963267948966 },
  { 0.28209479177387814, 0, 0, 
	  1.7278759594743860 },
  { 0.28209479177387814, 0, 0, 
	  1.8849555921538759 },
  { 0.28209479177387814, 0, 0, 
	  2.0420352248333655 },
  { 0.28209479177387814, 0, 0, 
	  2.1991148575128552 },
  { 0.28209479177387814, 0, 0, 
	  2.3561944901923448 },
  { 0.28209479177387814, 0, 0, 
	  2.5132741228718345 },
  { 0.28209479177387814, 0, 0, 
	  2.6703537555513241 },
  { 0.28209479177387814, 0, 0, 
	  2.8274333882308138 },
  { 0.28209479177387814, 0, 0, 
	  2.9845130209103035 },
  { 0.28209479177387814, 0, 0, 
	  3.1415926535897931 },
};
const double toler001 = 2.5000000000000020e-13;

// Test data for l=1, m=0.
// max(|f - f_GSL|): 0.0000000000000000
// max(|f - f_GSL| / |f_GSL|): 0.0000000000000000
const testcase_sph_legendre<double>
data002[21] =
{
  { 0.48860251190291992, 1, 0, 
	  0.0000000000000000 },
  { 0.48258700419201100, 1, 0, 
	  0.15707963267948966 },
  { 0.46468860282345231, 1, 0, 
	  0.31415926535897931 },
  { 0.43534802584032634, 1, 0, 
	  0.47123889803846897 },
  { 0.39528773562374975, 1, 0, 
	  0.62831853071795862 },
  { 0.34549414947133550, 1, 0, 
	  0.78539816339744828 },
  { 0.28719335072959390, 1, 0, 
	  0.94247779607693793 },
  { 0.22182089855280449, 1, 0, 
	  1.0995574287564276 },
  { 0.15098647967228981, 1, 0, 
	  1.2566370614359172 },
  { 0.076434272566846345, 1, 0, 
	  1.4137166941154069 },
  { 2.9918275112863369e-17, 1, 0, 
	  1.5707963267948966 },
  { -0.076434272566846179, 1, 0, 
	  1.7278759594743860 },
  { -0.15098647967228976, 1, 0, 
	  1.8849555921538759 },
  { -0.22182089855280443, 1, 0, 
	  2.0420352248333655 },
  { -0.28719335072959384, 1, 0, 
	  2.1991148575128552 },
  { -0.34549414947133544, 1, 0, 
	  2.3561944901923448 },
  { -0.39528773562374969, 1, 0, 
	  2.5132741228718345 },
  { -0.43534802584032628, 1, 0, 
	  2.6703537555513241 },
  { -0.46468860282345231, 1, 0, 
	  2.8274333882308138 },
  { -0.48258700419201095, 1, 0, 
	  2.9845130209103035 },
  { -0.48860251190291992, 1, 0, 
	  3.1415926535897931 },
};
const double toler002 = 2.5000000000000020e-13;

// Test data for l=1, m=1.
// max(|f - f_GSL|): 2.2204460492503131e-16
// max(|f - f_GSL| / |f_GSL|): 7.7031500691196945e-16
const testcase_sph_legendre<double>
data003[21] =
{
  { 0.0000000000000000, 1, 1, 
	  0.0000000000000000 },
  { -0.054047192447077917, 1, 1, 
	  0.15707963267948966 },
  { -0.10676356364376104, 1, 1, 
	  0.31415926535897931 },
  { -0.15685106157558129, 1, 1, 
	  0.47123889803846897 },
  { -0.20307636581258243, 1, 1, 
	  0.62831853071795862 },
  { -0.24430125595146007, 1, 1, 
	  0.78539816339744828 },
  { -0.27951063837942880, 1, 1, 
	  0.94247779607693793 },
  { -0.30783754124787122, 1, 1, 
	  1.0995574287564276 },
  { -0.32858446219656556, 1, 1, 
	  1.2566370614359172 },
  { -0.34124054317667202, 1, 1, 
	  1.4137166941154069 },
  { -0.34549414947133567, 1, 1, 
	  1.5707963267948966 },
  { -0.34124054317667202, 1, 1, 
	  1.7278759594743860 },
  { -0.32858446219656556, 1, 1, 
	  1.8849555921538759 },
  { -0.30783754124787127, 1, 1, 
	  2.0420352248333655 },
  { -0.27951063837942880, 1, 1, 
	  2.1991148575128552 },
  { -0.24430125595146013, 1, 1, 
	  2.3561944901923448 },
  { -0.20307636581258248, 1, 1, 
	  2.5132741228718345 },
  { -0.15685106157558140, 1, 1, 
	  2.6703537555513241 },
  { -0.10676356364376104, 1, 1, 
	  2.8274333882308138 },
  { -0.054047192447078167, 1, 1, 
	  2.9845130209103035 },
  { 0.0000000000000000, 1, 1, 
	  3.1415926535897931 },
};
const double toler003 = 2.5000000000000020e-13;

// Test data for l=2, m=0.
// max(|f - f_GSL|): 5.5511151231257827e-17
// max(|f - f_GSL| / |f_GSL|): 3.0159263334953002e-15
const testcase_sph_legendre<double>
data004[21] =
{
  { 0.63078313050504009, 2, 0, 
	  0.0000000000000000 },
  { 0.60762858760316607, 2, 0, 
	  0.15707963267948966 },
  { 0.54043148688396569, 2, 0, 
	  0.31415926535897931 },
  { 0.43576954875556589, 2, 0, 
	  0.47123889803846897 },
  { 0.30388781294457579, 2, 0, 
	  0.62831853071795862 },
  { 0.15769578262626011, 2, 0, 
	  0.78539816339744828 },
  { 0.011503752307944235, 2, 0, 
	  0.94247779607693793 },
  { -0.12037798350304570, 2, 0, 
	  1.0995574287564276 },
  { -0.22503992163144576, 2, 0, 
	  1.2566370614359172 },
  { -0.29223702235064597, 2, 0, 
	  1.4137166941154069 },
  { -0.31539156525252005, 2, 0, 
	  1.5707963267948966 },
  { -0.29223702235064608, 2, 0, 
	  1.7278759594743860 },
  { -0.22503992163144584, 2, 0, 
	  1.8849555921538759 },
  { -0.12037798350304584, 2, 0, 
	  2.0420352248333655 },
  { 0.011503752307944164, 2, 0, 
	  2.1991148575128552 },
  { 0.15769578262625994, 2, 0, 
	  2.3561944901923448 },
  { 0.30388781294457567, 2, 0, 
	  2.5132741228718345 },
  { 0.43576954875556562, 2, 0, 
	  2.6703537555513241 },
  { 0.54043148688396569, 2, 0, 
	  2.8274333882308138 },
  { 0.60762858760316585, 2, 0, 
	  2.9845130209103035 },
  { 0.63078313050504009, 2, 0, 
	  3.1415926535897931 },
};
const double toler004 = 2.5000000000000020e-13;

// Test data for l=2, m=1.
// max(|f - f_GSL|): 2.2204460492503131e-16
// max(|f - f_GSL| / |f_GSL|): 8.1384221730905279e-16
const testcase_sph_legendre<double>
data005[21] =
{
  { 0.0000000000000000, 2, 1, 
	  0.0000000000000000 },
  { -0.11936529291378727, 2, 1, 
	  0.15707963267948966 },
  { -0.22704627929027449, 2, 1, 
	  0.31415926535897931 },
  { -0.31250239392538215, 2, 1, 
	  0.47123889803846897 },
  { -0.36736859691086526, 2, 1, 
	  0.62831853071795862 },
  { -0.38627420202318979, 2, 1, 
	  0.78539816339744828 },
  { -0.36736859691086526, 2, 1, 
	  0.94247779607693793 },
  { -0.31250239392538226, 2, 1, 
	  1.0995574287564276 },
  { -0.22704627929027438, 2, 1, 
	  1.2566370614359172 },
  { -0.11936529291378740, 2, 1, 
	  1.4137166941154069 },
  { -4.7304946510089748e-17, 2, 1, 
	  1.5707963267948966 },
  { 0.11936529291378714, 2, 1, 
	  1.7278759594743860 },
  { 0.22704627929027429, 2, 1, 
	  1.8849555921538759 },
  { 0.31250239392538220, 2, 1, 
	  2.0420352248333655 },
  { 0.36736859691086521, 2, 1, 
	  2.1991148575128552 },
  { 0.38627420202318979, 2, 1, 
	  2.3561944901923448 },
  { 0.36736859691086526, 2, 1, 
	  2.5132741228718345 },
  { 0.31250239392538232, 2, 1, 
	  2.6703537555513241 },
  { 0.22704627929027449, 2, 1, 
	  2.8274333882308138 },
  { 0.11936529291378781, 2, 1, 
	  2.9845130209103035 },
  { 0.0000000000000000, 2, 1, 
	  3.1415926535897931 },
};
const double toler005 = 2.5000000000000020e-13;

// Test data for l=2, m=2.
// max(|f - f_GSL|): 1.6653345369377348e-16
// max(|f - f_GSL| / |f_GSL|): 6.2393366429561032e-16
const testcase_sph_legendre<double>
data006[21] =
{
  { 0.0000000000000000, 2, 2, 
	  0.0000000000000000 },
  { 0.0094528025561622549, 2, 2, 
	  0.15707963267948966 },
  { 0.036885904048903795, 2, 2, 
	  0.31415926535897931 },
  { 0.079613961366457681, 2, 2, 
	  0.47123889803846897 },
  { 0.13345445455470123, 2, 2, 
	  0.62831853071795862 },
  { 0.19313710101159484, 2, 2, 
	  0.78539816339744828 },
  { 0.25281974746848851, 2, 2, 
	  0.94247779607693793 },
  { 0.30666024065673209, 2, 2, 
	  1.0995574287564276 },
  { 0.34938829797428600, 2, 2, 
	  1.2566370614359172 },
  { 0.37682139946702747, 2, 2, 
	  1.4137166941154069 },
  { 0.38627420202318979, 2, 2, 
	  1.5707963267948966 },
  { 0.37682139946702753, 2, 2, 
	  1.7278759594743860 },
  { 0.34938829797428606, 2, 2, 
	  1.8849555921538759 },
  { 0.30666024065673209, 2, 2, 
	  2.0420352248333655 },
  { 0.25281974746848856, 2, 2, 
	  2.1991148575128552 },
  { 0.19313710101159492, 2, 2, 
	  2.3561944901923448 },
  { 0.13345445455470126, 2, 2, 
	  2.5132741228718345 },
  { 0.079613961366457764, 2, 2, 
	  2.6703537555513241 },
  { 0.036885904048903795, 2, 2, 
	  2.8274333882308138 },
  { 0.0094528025561623433, 2, 2, 
	  2.9845130209103035 },
  { 0.0000000000000000, 2, 2, 
	  3.1415926535897931 },
};
const double toler006 = 2.5000000000000020e-13;

// Test data for l=5, m=0.
// max(|f - f_GSL|): 1.0547118733938987e-15
// max(|f - f_GSL| / |f_GSL|): 2.9385557676213648e-15
const testcase_sph_legendre<double>
data007[21] =
{
  { 0.93560257962738880, 5, 0, 
	  0.0000000000000000 },
  { 0.77014422942079963, 5, 0, 
	  0.15707963267948966 },
  { 0.35892185032365165, 5, 0, 
	  0.31415926535897931 },
  { -0.090214932090594294, 5, 0, 
	  0.47123889803846897 },
  { -0.36214460396518883, 5, 0, 
	  0.62831853071795862 },
  { -0.35145955579226906, 5, 0, 
	  0.78539816339744828 },
  { -0.11441703594725168, 5, 0, 
	  0.94247779607693793 },
  { 0.17248966720808107, 5, 0, 
	  1.0995574287564276 },
  { 0.32128384287200523, 5, 0, 
	  1.2566370614359172 },
  { 0.24377632246714948, 5, 0, 
	  1.4137166941154069 },
  { 1.0741712853887702e-16, 5, 0, 
	  1.5707963267948966 },
  { -0.24377632246714911, 5, 0, 
	  1.7278759594743860 },
  { -0.32128384287200534, 5, 0, 
	  1.8849555921538759 },
  { -0.17248966720808132, 5, 0, 
	  2.0420352248333655 },
  { 0.11441703594725151, 5, 0, 
	  2.1991148575128552 },
  { 0.35145955579226895, 5, 0, 
	  2.3561944901923448 },
  { 0.36214460396518905, 5, 0, 
	  2.5132741228718345 },
  { 0.090214932090594752, 5, 0, 
	  2.6703537555513241 },
  { -0.35892185032365165, 5, 0, 
	  2.8274333882308138 },
  { -0.77014422942079852, 5, 0, 
	  2.9845130209103035 },
  { -0.93560257962738880, 5, 0, 
	  3.1415926535897931 },
};
const double toler007 = 2.5000000000000020e-13;

// Test data for l=5, m=1.
// max(|f - f_GSL|): 4.4408920985006262e-16
// max(|f - f_GSL| / |f_GSL|): 1.4161260272615034e-15
const testcase_sph_legendre<double>
data008[21] =
{
  { 0.0000000000000000, 5, 1, 
	  0.0000000000000000 },
  { -0.36712373713318258, 5, 1, 
	  0.15707963267948966 },
  { -0.54610329010534753, 5, 1, 
	  0.31415926535897931 },
  { -0.45381991493631763, 5, 1, 
	  0.47123889803846897 },
  { -0.15679720635769961, 5, 1, 
	  0.62831853071795862 },
  { 0.16985499419838601, 5, 1, 
	  0.78539816339744828 },
  { 0.34468004499725180, 5, 1, 
	  0.94247779607693793 },
  { 0.28349471119605985, 5, 1, 
	  1.0995574287564276 },
  { 0.044286619339675815, 5, 1, 
	  1.2566370614359172 },
  { -0.21193784177193470, 5, 1, 
	  1.4137166941154069 },
  { -0.32028164857621527, 5, 1, 
	  1.5707963267948966 },
  { -0.21193784177193514, 5, 1, 
	  1.7278759594743860 },
  { 0.044286619339675592, 5, 1, 
	  1.8849555921538759 },
  { 0.28349471119605968, 5, 1, 
	  2.0420352248333655 },
  { 0.34468004499725174, 5, 1, 
	  2.1991148575128552 },
  { 0.16985499419838640, 5, 1, 
	  2.3561944901923448 },
  { -0.15679720635769906, 5, 1, 
	  2.5132741228718345 },
  { -0.45381991493631768, 5, 1, 
	  2.6703537555513241 },
  { -0.54610329010534753, 5, 1, 
	  2.8274333882308138 },
  { -0.36712373713318402, 5, 1, 
	  2.9845130209103035 },
  { 0.0000000000000000, 5, 1, 
	  3.1415926535897931 },
};
const double toler008 = 2.5000000000000020e-13;

// Test data for l=5, m=2.
// max(|f - f_GSL|): 1.6653345369377348e-16
// max(|f - f_GSL| / |f_GSL|): 3.0636916515712721e-15
const testcase_sph_legendre<double>
data009[21] =
{
  { 0.0000000000000000, 5, 2, 
	  0.0000000000000000 },
  { 0.078919441745546146, 5, 2, 
	  0.15707963267948966 },
  { 0.26373799140437987, 5, 2, 
	  0.31415926535897931 },
  { 0.43002359842080096, 5, 2, 
	  0.47123889803846897 },
  { 0.45642486439050983, 5, 2, 
	  0.62831853071795862 },
  { 0.29959604906083293, 5, 2, 
	  0.78539816339744828 },
  { 0.023781239849532215, 5, 2, 
	  0.94247779607693793 },
  { -0.23313989334673826, 5, 2, 
	  1.0995574287564276 },
  { -0.33799912776303714, 5, 2, 
	  1.2566370614359172 },
  { -0.23964508489529743, 5, 2, 
	  1.4137166941154069 },
  { -1.0377480524338170e-16, 5, 2, 
	  1.5707963267948966 },
  { 0.23964508489529704, 5, 2, 
	  1.7278759594743860 },
  { 0.33799912776303714, 5, 2, 
	  1.8849555921538759 },
  { 0.23313989334673843, 5, 2, 
	  2.0420352248333655 },
  { -0.023781239849531916, 5, 2, 
	  2.1991148575128552 },
  { -0.29959604906083276, 5, 2, 
	  2.3561944901923448 },
  { -0.45642486439050983, 5, 2, 
	  2.5132741228718345 },
  { -0.43002359842080118, 5, 2, 
	  2.6703537555513241 },
  { -0.26373799140437987, 5, 2, 
	  2.8274333882308138 },
  { -0.078919441745546867, 5, 2, 
	  2.9845130209103035 },
  { 0.0000000000000000, 5, 2, 
	  3.1415926535897931 },
};
const double toler009 = 2.5000000000000020e-13;

// Test data for l=5, m=5.
// max(|f - f_GSL|): 1.1102230246251565e-16
// max(|f - f_GSL| / |f_GSL|): 4.2617219728402347e-16
const testcase_sph_legendre<double>
data010[21] =
{
  { 0.0000000000000000, 5, 5, 
	  0.0000000000000000 },
  { -4.3481439097909148e-05, 5, 5, 
	  0.15707963267948966 },
  { -0.0013078367086431812, 5, 5, 
	  0.31415926535897931 },
  { -0.0089510818191922761, 5, 5, 
	  0.47123889803846897 },
  { -0.032563803777573896, 5, 5, 
	  0.62831853071795862 },
  { -0.082047757105021241, 5, 5, 
	  0.78539816339744828 },
  { -0.16085328164143814, 5, 5, 
	  0.94247779607693793 },
  { -0.26064303436645381, 5, 5, 
	  1.0995574287564276 },
  { -0.36113811790820571, 5, 5, 
	  1.2566370614359172 },
  { -0.43625592459446139, 5, 5, 
	  1.4137166941154069 },
  { -0.46413220344085809, 5, 5, 
	  1.5707963267948966 },
  { -0.43625592459446155, 5, 5, 
	  1.7278759594743860 },
  { -0.36113811790820577, 5, 5, 
	  1.8849555921538759 },
  { -0.26064303436645386, 5, 5, 
	  2.0420352248333655 },
  { -0.16085328164143822, 5, 5, 
	  2.1991148575128552 },
  { -0.082047757105021310, 5, 5, 
	  2.3561944901923448 },
  { -0.032563803777573910, 5, 5, 
	  2.5132741228718345 },
  { -0.0089510818191923004, 5, 5, 
	  2.6703537555513241 },
  { -0.0013078367086431812, 5, 5, 
	  2.8274333882308138 },
  { -4.3481439097910151e-05, 5, 5, 
	  2.9845130209103035 },
  { 0.0000000000000000, 5, 5, 
	  3.1415926535897931 },
};
const double toler010 = 2.5000000000000020e-13;

// Test data for l=10, m=0.
// max(|f - f_GSL|): 9.9920072216264089e-16
// max(|f - f_GSL| / |f_GSL|): 2.2266594990531305e-15
const testcase_sph_legendre<double>
data011[21] =
{
  { 1.2927207364566027, 10, 0, 
	  0.0000000000000000 },
  { 0.55288895150522555, 10, 0, 
	  0.15707963267948966 },
  { -0.44874428379711545, 10, 0, 
	  0.31415926535897931 },
  { -0.25532095827149687, 10, 0, 
	  0.47123889803846897 },
  { 0.36625249688013961, 10, 0, 
	  0.62831853071795862 },
  { 0.14880806329084206, 10, 0, 
	  0.78539816339744828 },
  { -0.33533356797848757, 10, 0, 
	  0.94247779607693793 },
  { -0.080639967662335665, 10, 0, 
	  1.0995574287564276 },
  { 0.32197986450174521, 10, 0, 
	  1.2566370614359172 },
  { 0.025713542103667848, 10, 0, 
	  1.4137166941154069 },
  { -0.31813049373736707, 10, 0, 
	  1.5707963267948966 },
  { 0.025713542103666699, 10, 0, 
	  1.7278759594743860 },
  { 0.32197986450174543, 10, 0, 
	  1.8849555921538759 },
  { -0.080639967662335096, 10, 0, 
	  2.0420352248333655 },
  { -0.33533356797848757, 10, 0, 
	  2.1991148575128552 },
  { 0.14880806329084156, 10, 0, 
	  2.3561944901923448 },
  { 0.36625249688013994, 10, 0, 
	  2.5132741228718345 },
  { -0.25532095827149576, 10, 0, 
	  2.6703537555513241 },
  { -0.44874428379711545, 10, 0, 
	  2.8274333882308138 },
  { 0.55288895150522011, 10, 0, 
	  2.9845130209103035 },
  { 1.2927207364566027, 10, 0, 
	  3.1415926535897931 },
};
const double toler011 = 2.5000000000000020e-13;

// Test data for l=10, m=1.
// max(|f - f_GSL|): 1.4432899320127035e-15
// max(|f - f_GSL| / |f_GSL|): 4.9708436073954521e-15
const testcase_sph_legendre<double>
data012[21] =
{
  { 0.0000000000000000, 10, 1, 
	  0.0000000000000000 },
  { -0.74373723919063894, 10, 1, 
	  0.15707963267948966 },
  { -0.29035110456209601, 10, 1, 
	  0.31415926535897931 },
  { 0.42219282075271530, 10, 1, 
	  0.47123889803846897 },
  { 0.17109256898931269, 10, 1, 
	  0.62831853071795862 },
  { -0.35583574648544281, 10, 1, 
	  0.78539816339744828 },
  { -0.10089212303543979, 10, 1, 
	  0.94247779607693793 },
  { 0.32997652649321085, 10, 1, 
	  1.0995574287564276 },
  { 0.047416376890032939, 10, 1, 
	  1.2566370614359172 },
  { -0.31999356750295660, 10, 1, 
	  1.4137166941154069 },
  { -2.0430664782290766e-16, 10, 1, 
	  1.5707963267948966 },
  { 0.31999356750295660, 10, 1, 
	  1.7278759594743860 },
  { -0.047416376890032544, 10, 1, 
	  1.8849555921538759 },
  { -0.32997652649321091, 10, 1, 
	  2.0420352248333655 },
  { 0.10089212303543935, 10, 1, 
	  2.1991148575128552 },
  { 0.35583574648544292, 10, 1, 
	  2.3561944901923448 },
  { -0.17109256898931161, 10, 1, 
	  2.5132741228718345 },
  { -0.42219282075271569, 10, 1, 
	  2.6703537555513241 },
  { 0.29035110456209601, 10, 1, 
	  2.8274333882308138 },
  { 0.74373723919064050, 10, 1, 
	  2.9845130209103035 },
  { 0.0000000000000000, 10, 1, 
	  3.1415926535897931 },
};
const double toler012 = 2.5000000000000020e-13;

// Test data for l=10, m=2.
// max(|f - f_GSL|): 3.3306690738754696e-16
// max(|f - f_GSL| / |f_GSL|): 3.3968188217108871e-15
const testcase_sph_legendre<double>
data013[21] =
{
  { 0.0000000000000000, 10, 2, 
	  0.0000000000000000 },
  { 0.34571695599980246, 10, 2, 
	  0.15707963267948966 },
  { 0.62485535978198059, 10, 2, 
	  0.31415926535897931 },
  { 0.098210039644716252, 10, 2, 
	  0.47123889803846897 },
  { -0.41494799233049684, 10, 2, 
	  0.62831853071795862 },
  { -0.081698973831472732, 10, 2, 
	  0.78539816339744828 },
  { 0.35253132222271277, 10, 2, 
	  0.94247779607693793 },
  { 0.049026298555980979, 10, 2, 
	  1.0995574287564276 },
  { -0.32791246874130792, 10, 2, 
	  1.2566370614359172 },
  { -0.016196782433946885, 10, 2, 
	  1.4137166941154069 },
  { 0.32106263400438328, 10, 2, 
	  1.5707963267948966 },
  { -0.016196782433945761, 10, 2, 
	  1.7278759594743860 },
  { -0.32791246874130803, 10, 2, 
	  1.8849555921538759 },
  { 0.049026298555980424, 10, 2, 
	  2.0420352248333655 },
  { 0.35253132222271266, 10, 2, 
	  2.1991148575128552 },
  { -0.081698973831472121, 10, 2, 
	  2.3561944901923448 },
  { -0.41494799233049695, 10, 2, 
	  2.5132741228718345 },
  { 0.098210039644715197, 10, 2, 
	  2.6703537555513241 },
  { 0.62485535978198059, 10, 2, 
	  2.8274333882308138 },
  { 0.34571695599980545, 10, 2, 
	  2.9845130209103035 },
  { 0.0000000000000000, 10, 2, 
	  3.1415926535897931 },
};
const double toler013 = 2.5000000000000020e-13;

// Test data for l=10, m=5.
// max(|f - f_GSL|): 3.6082248300317588e-16
// max(|f - f_GSL| / |f_GSL|): 1.6350423942234514e-15
const testcase_sph_legendre<double>
data014[21] =
{
  { 0.0000000000000000, 10, 5, 
	  0.0000000000000000 },
  { -0.0030300124052750196, 10, 5, 
	  0.15707963267948966 },
  { -0.070348585248056802, 10, 5, 
	  0.31415926535897931 },
  { -0.30055029290703639, 10, 5, 
	  0.47123889803846897 },
  { -0.49987818144009155, 10, 5, 
	  0.62831853071795862 },
  { -0.28108771757150108, 10, 5, 
	  0.78539816339744828 },
  { 0.22068081187249292, 10, 5, 
	  0.94247779607693793 },
  { 0.33689502212592121, 10, 5, 
	  1.0995574287564276 },
  { -0.086095515520764110, 10, 5, 
	  1.2566370614359172 },
  { -0.33935827318511558, 10, 5, 
	  1.4137166941154069 },
  { -1.9213014340664578e-16, 10, 5, 
	  1.5707963267948966 },
  { 0.33935827318511552, 10, 5, 
	  1.7278759594743860 },
  { 0.086095515520764512, 10, 5, 
	  1.8849555921538759 },
  { -0.33689502212592087, 10, 5, 
	  2.0420352248333655 },
  { -0.22068081187249344, 10, 5, 
	  2.1991148575128552 },
  { 0.28108771757150064, 10, 5, 
	  2.3561944901923448 },
  { 0.49987818144009138, 10, 5, 
	  2.5132741228718345 },
  { 0.30055029290703672, 10, 5, 
	  2.6703537555513241 },
  { 0.070348585248056802, 10, 5, 
	  2.8274333882308138 },
  { 0.0030300124052750873, 10, 5, 
	  2.9845130209103035 },
  { 0.0000000000000000, 10, 5, 
	  3.1415926535897931 },
};
const double toler014 = 2.5000000000000020e-13;

// Test data for l=10, m=10.
// max(|f - f_GSL|): 9.9920072216264089e-16
// max(|f - f_GSL| / |f_GSL|): 1.9163828344752537e-15
const testcase_sph_legendre<double>
data015[21] =
{
  { 0.0000000000000000, 10, 10, 
	  0.0000000000000000 },
  { 4.7624282733343473e-09, 10, 10, 
	  0.15707963267948966 },
  { 4.3085156534549772e-06, 10, 10, 
	  0.31415926535897931 },
  { 0.00020182347649472387, 10, 10, 
	  0.47123889803846897 },
  { 0.0026711045506511684, 10, 10, 
	  0.62831853071795862 },
  { 0.016957196623256909, 10, 10, 
	  0.78539816339744828 },
  { 0.065174916004990341, 10, 10, 
	  0.94247779607693793 },
  { 0.17112476903017845, 10, 10, 
	  1.0995574287564276 },
  { 0.32852414199733554, 10, 10, 
	  1.2566370614359172 },
  { 0.47940582314838287, 10, 10, 
	  1.4137166941154069 },
  { 0.54263029194422152, 10, 10, 
	  1.5707963267948966 },
  { 0.47940582314838309, 10, 10, 
	  1.7278759594743860 },
  { 0.32852414199733571, 10, 10, 
	  1.8849555921538759 },
  { 0.17112476903017856, 10, 10, 
	  2.0420352248333655 },
  { 0.065174916004990410, 10, 10, 
	  2.1991148575128552 },
  { 0.016957196623256943, 10, 10, 
	  2.3561944901923448 },
  { 0.0026711045506511706, 10, 10, 
	  2.5132741228718345 },
  { 0.00020182347649472493, 10, 10, 
	  2.6703537555513241 },
  { 4.3085156534549772e-06, 10, 10, 
	  2.8274333882308138 },
  { 4.7624282733345673e-09, 10, 10, 
	  2.9845130209103035 },
  { 0.0000000000000000, 10, 10, 
	  3.1415926535897931 },
};
const double toler015 = 2.5000000000000020e-13;

// Test data for l=20, m=0.
// max(|f - f_GSL|): 1.2212453270876722e-15
// max(|f - f_GSL| / |f_GSL|): 2.1900476331757668e-15
const testcase_sph_legendre<double>
data016[21] =
{
  { 1.8062879984608917, 20, 0, 
	  0.0000000000000000 },
  { -0.58906549291415933, 20, 0, 
	  0.15707963267948966 },
  { 0.45624611402342408, 20, 0, 
	  0.31415926535897931 },
  { -0.39955402700466724, 20, 0, 
	  0.47123889803846897 },
  { 0.36818552901640772, 20, 0, 
	  0.62831853071795862 },
  { -0.34873131330857743, 20, 0, 
	  0.78539816339744828 },
  { 0.33600882829186507, 20, 0, 
	  0.94247779607693793 },
  { -0.32759286308122931, 20, 0, 
	  1.0995574287564276 },
  { 0.32222458068091325, 20, 0, 
	  1.2566370614359172 },
  { -0.31922731037135965, 20, 0, 
	  1.4137166941154069 },
  { 0.31826262039531755, 20, 0, 
	  1.5707963267948966 },
  { -0.31922731037135987, 20, 0, 
	  1.7278759594743860 },
  { 0.32222458068091342, 20, 0, 
	  1.8849555921538759 },
  { -0.32759286308122942, 20, 0, 
	  2.0420352248333655 },
  { 0.33600882829186518, 20, 0, 
	  2.1991148575128552 },
  { -0.34873131330857782, 20, 0, 
	  2.3561944901923448 },
  { 0.36818552901640805, 20, 0, 
	  2.5132741228718345 },
  { -0.39955402700466824, 20, 0, 
	  2.6703537555513241 },
  { 0.45624611402342408, 20, 0, 
	  2.8274333882308138 },
  { -0.58906549291416732, 20, 0, 
	  2.9845130209103035 },
  { 1.8062879984608917, 20, 0, 
	  3.1415926535897931 },
};
const double toler016 = 2.5000000000000020e-13;

// Test data for l=20, m=1.
// max(|f - f_GSL|): 2.8310687127941492e-15
// max(|f - f_GSL| / |f_GSL|): 9.0837292708194213e-15
const testcase_sph_legendre<double>
data017[21] =
{
  { 0.0000000000000000, 20, 1, 
	  0.0000000000000000 },
  { -0.45905213045060256, 20, 1, 
	  0.15707963267948966 },
  { 0.31166370423309253, 20, 1, 
	  0.31415926535897931 },
  { -0.23278757741246778, 20, 1, 
	  0.47123889803846897 },
  { 0.17937240823504172, 20, 1, 
	  0.62831853071795862 },
  { -0.13857299972299839, 20, 1, 
	  0.78539816339744828 },
  { 0.10495324841927722, 20, 1, 
	  0.94247779607693793 },
  { -0.075707774352163665, 20, 1, 
	  1.0995574287564276 },
  { 0.049168697683476224, 20, 1, 
	  1.2566370614359172 },
  { -0.024216050551253303, 20, 1, 
	  1.4137166941154069 },
  { 3.9938443510694349e-16, 20, 1, 
	  1.5707963267948966 },
  { 0.024216050551250919, 20, 1, 
	  1.7278759594743860 },
  { -0.049168697683475482, 20, 1, 
	  1.8849555921538759 },
  { 0.075707774352163068, 20, 1, 
	  2.0420352248333655 },
  { -0.10495324841927638, 20, 1, 
	  2.1991148575128552 },
  { 0.13857299972299741, 20, 1, 
	  2.3561944901923448 },
  { -0.17937240823503983, 20, 1, 
	  2.5132741228718345 },
  { 0.23278757741246703, 20, 1, 
	  2.6703537555513241 },
  { -0.31166370423309253, 20, 1, 
	  2.8274333882308138 },
  { 0.45905213045059046, 20, 1, 
	  2.9845130209103035 },
  { 0.0000000000000000, 20, 1, 
	  3.1415926535897931 },
};
const double toler017 = 5.0000000000000039e-13;

// Test data for l=20, m=2.
// max(|f - f_GSL|): 2.3314683517128287e-15
// max(|f - f_GSL| / |f_GSL|): 2.6675898738403374e-15
const testcase_sph_legendre<double>
data018[21] =
{
  { 0.0000000000000000, 20, 2, 
	  0.0000000000000000 },
  { 0.87399805141574394, 20, 2, 
	  0.15707963267948966 },
  { -0.55116854080895061, 20, 2, 
	  0.31415926535897931 },
  { 0.44520137308557572, 20, 2, 
	  0.47123889803846897 },
  { -0.39321637877908228, 20, 2, 
	  0.62831853071795862 },
  { 0.36312025711350937, 20, 2, 
	  0.78539816339744828 },
  { -0.34427103004873116, 20, 2, 
	  0.94247779607693793 },
  { 0.33214917638387642, 20, 2, 
	  1.0995574287564276 },
  { -0.32455734448839091, 20, 2, 
	  1.2566370614359172 },
  { 0.32036529628513238, 20, 2, 
	  1.4137166941154069 },
  { -0.31902310563819986, 20, 2, 
	  1.5707963267948966 },
  { 0.32036529628513266, 20, 2, 
	  1.7278759594743860 },
  { -0.32455734448839102, 20, 2, 
	  1.8849555921538759 },
  { 0.33214917638387659, 20, 2, 
	  2.0420352248333655 },
  { -0.34427103004873105, 20, 2, 
	  2.1991148575128552 },
  { 0.36312025711350981, 20, 2, 
	  2.3561944901923448 },
  { -0.39321637877908278, 20, 2, 
	  2.5132741228718345 },
  { 0.44520137308557650, 20, 2, 
	  2.6703537555513241 },
  { -0.55116854080895061, 20, 2, 
	  2.8274333882308138 },
  { 0.87399805141574527, 20, 2, 
	  2.9845130209103035 },
  { 0.0000000000000000, 20, 2, 
	  3.1415926535897931 },
};
const double toler018 = 2.5000000000000020e-13;

// Test data for l=20, m=5.
// max(|f - f_GSL|): 3.5388358909926865e-16
// max(|f - f_GSL| / |f_GSL|): 1.2458491381272207e-14
const testcase_sph_legendre<double>
data019[21] =
{
  { 0.0000000000000000, 20, 5, 
	  0.0000000000000000 },
  { -0.10024848623504863, 20, 5, 
	  0.15707963267948966 },
  { -0.68115361075940484, 20, 5, 
	  0.31415926535897931 },
  { 0.31774532551156298, 20, 5, 
	  0.47123889803846897 },
  { -0.16011868165390544, 20, 5, 
	  0.62831853071795862 },
  { 0.085844143304115578, 20, 5, 
	  0.78539816339744828 },
  { -0.047467540840864568, 20, 5, 
	  0.94247779607693793 },
  { 0.026283575189471796, 20, 5, 
	  1.0995574287564276 },
  { -0.013891104052597688, 20, 5, 
	  1.2566370614359172 },
  { 0.0059873308239496957, 20, 5, 
	  1.4137166941154069 },
  { 3.9355286582083095e-16, 20, 5, 
	  1.5707963267948966 },
  { -0.0059873308239519014, 20, 5, 
	  1.7278759594743860 },
  { 0.013891104052598547, 20, 5, 
	  1.8849555921538759 },
  { -0.026283575189472864, 20, 5, 
	  2.0420352248333655 },
  { 0.047467540840865928, 20, 5, 
	  2.1991148575128552 },
  { -0.085844143304117007, 20, 5, 
	  2.3561944901923448 },
  { 0.16011868165390658, 20, 5, 
	  2.5132741228718345 },
  { -0.31774532551156381, 20, 5, 
	  2.6703537555513241 },
  { 0.68115361075940484, 20, 5, 
	  2.8274333882308138 },
  { 0.10024848623505046, 20, 5, 
	  2.9845130209103035 },
  { 0.0000000000000000, 20, 5, 
	  3.1415926535897931 },
};
const double toler019 = 1.0000000000000008e-12;

// Test data for l=20, m=10.
// max(|f - f_GSL|): 1.6653345369377348e-15
// max(|f - f_GSL| / |f_GSL|): 2.0744116940226714e-14
const testcase_sph_legendre<double>
data020[21] =
{
  { 0.0000000000000000, 20, 10, 
	  0.0000000000000000 },
  { 3.0595797603706485e-05, 20, 10, 
	  0.15707963267948966 },
  { 0.015924453916397002, 20, 10, 
	  0.31415926535897931 },
  { 0.26588079118745744, 20, 10, 
	  0.47123889803846897 },
  { 0.54045081420686869, 20, 10, 
	  0.62831853071795862 },
  { -0.28215279394285531, 20, 10, 
	  0.78539816339744828 },
  { 0.0085297337582245884, 20, 10, 
	  0.94247779607693793 },
  { 0.16930127953533738, 20, 10, 
	  1.0995574287564276 },
  { -0.27215134048018325, 20, 10, 
	  1.2566370614359172 },
  { 0.32456597088029526, 20, 10, 
	  1.4137166941154069 },
  { -0.34057893241353715, 20, 10, 
	  1.5707963267948966 },
  { 0.32456597088029449, 20, 10, 
	  1.7278759594743860 },
  { -0.27215134048018291, 20, 10, 
	  1.8849555921538759 },
  { 0.16930127953533675, 20, 10, 
	  2.0420352248333655 },
  { 0.0085297337582257438, 20, 10, 
	  2.1991148575128552 },
  { -0.28215279394285619, 20, 10, 
	  2.3561944901923448 },
  { 0.54045081420686736, 20, 10, 
	  2.5132741228718345 },
  { 0.26588079118745828, 20, 10, 
	  2.6703537555513241 },
  { 0.015924453916397002, 20, 10, 
	  2.8274333882308138 },
  { 3.0595797603707888e-05, 20, 10, 
	  2.9845130209103035 },
  { 0.0000000000000000, 20, 10, 
	  3.1415926535897931 },
};
const double toler020 = 2.5000000000000015e-12;

// Test data for l=20, m=20.
// max(|f - f_GSL|): 3.3306690738754696e-16
// max(|f - f_GSL| / |f_GSL|): 8.6795105199201385e-16
const testcase_sph_legendre<double>
data021[21] =
{
  { 0.0000000000000000, 20, 20, 
	  0.0000000000000000 },
  { 4.9264471419246231e-17, 20, 20, 
	  0.15707963267948966 },
  { 4.0321091681531780e-11, 20, 20, 
	  0.31415926535897931 },
  { 8.8474944184471664e-08, 20, 20, 
	  0.47123889803846897 },
  { 1.5497395129387764e-05, 20, 20, 
	  0.62831853071795862 },
  { 0.00062457564282984495, 20, 20, 
	  0.78539816339744828 },
  { 0.0092265192458967568, 20, 20, 
	  0.94247779607693793 },
  { 0.063606673236323297, 20, 20, 
	  1.0995574287564276 },
  { 0.23442909509776316, 20, 20, 
	  1.2566370614359172 },
  { 0.49921030481087009, 20, 20, 
	  1.4137166941154069 },
  { 0.63956545825776223, 20, 20, 
	  1.5707963267948966 },
  { 0.49921030481087064, 20, 20, 
	  1.7278759594743860 },
  { 0.23442909509776336, 20, 20, 
	  1.8849555921538759 },
  { 0.063606673236323380, 20, 20, 
	  2.0420352248333655 },
  { 0.0092265192458967742, 20, 20, 
	  2.1991148575128552 },
  { 0.00062457564282984766, 20, 20, 
	  2.3561944901923448 },
  { 1.5497395129387791e-05, 20, 20, 
	  2.5132741228718345 },
  { 8.8474944184472617e-08, 20, 20, 
	  2.6703537555513241 },
  { 4.0321091681531780e-11, 20, 20, 
	  2.8274333882308138 },
  { 4.9264471419250786e-17, 20, 20, 
	  2.9845130209103035 },
  { 0.0000000000000000, 20, 20, 
	  3.1415926535897931 },
};
const double toler021 = 2.5000000000000020e-13;

// Test data for l=50, m=0.
// max(|f - f_GSL|): 4.8849813083506888e-15
// max(|f - f_GSL| / |f_GSL|): 9.2046020313085697e-15
const testcase_sph_legendre<double>
data022[21] =
{
  { 2.8350175706934717, 50, 0, 
	  0.0000000000000000 },
  { 0.53157537495174900, 50, 0, 
	  0.15707963267948966 },
  { -0.46056183476301255, 50, 0, 
	  0.31415926535897931 },
  { -0.24876032079677909, 50, 0, 
	  0.47123889803846897 },
  { 0.36926172901532522, 50, 0, 
	  0.62831853071795862 },
  { 0.14571730283563575, 50, 0, 
	  0.78539816339744828 },
  { -0.33636199170850806, 50, 0, 
	  0.94247779607693793 },
  { -0.079132716267091507, 50, 0, 
	  1.0995574287564276 },
  { 0.32232921941301451, 50, 0, 
	  1.2566370614359172 },
  { 0.025253991969481544, 50, 0, 
	  1.4137166941154069 },
  { -0.31830208724152359, 50, 0, 
	  1.5707963267948966 },
  { 0.025253991969476332, 50, 0, 
	  1.7278759594743860 },
  { 0.32232921941301479, 50, 0, 
	  1.8849555921538759 },
  { -0.079132716267088510, 50, 0, 
	  2.0420352248333655 },
  { -0.33636199170850883, 50, 0, 
	  2.1991148575128552 },
  { 0.14571730283563347, 50, 0, 
	  2.3561944901923448 },
  { 0.36926172901532667, 50, 0, 
	  2.5132741228718345 },
  { -0.24876032079677354, 50, 0, 
	  2.6703537555513241 },
  { -0.46056183476301255, 50, 0, 
	  2.8274333882308138 },
  { 0.53157537495172758, 50, 0, 
	  2.9845130209103035 },
  { 2.8350175706934717, 50, 0, 
	  3.1415926535897931 },
};
const double toler022 = 5.0000000000000039e-13;

// Test data for l=50, m=1.
// max(|f - f_GSL|): 4.2743586448068527e-15
// max(|f - f_GSL| / |f_GSL|): 1.3104848798660735e-14
const testcase_sph_legendre<double>
data023[21] =
{
  { 0.0000000000000000, 50, 1, 
	  0.0000000000000000 },
  { -0.63751752155226260, 50, 1, 
	  0.15707963267948966 },
  { -0.32616619317604606, 50, 1, 
	  0.31415926535897931 },
  { 0.40649930826162850, 50, 1, 
	  0.47123889803846897 },
  { 0.18473991408344057, 50, 1, 
	  0.62831853071795862 },
  { -0.35083930302013117, 50, 1, 
	  0.78539816339744828 },
  { -0.10755382110947125, 50, 1, 
	  0.94247779607693793 },
  { 0.32822568316499900, 50, 1, 
	  1.0995574287564276 },
  { 0.050286056609797389, 50, 1, 
	  1.2566370614359172 },
  { -0.31935368562159644, 50, 1, 
	  1.4137166941154069 },
  { -9.8421602686195941e-16, 50, 1, 
	  1.5707963267948966 },
  { 0.31935368562159716, 50, 1, 
	  1.7278759594743860 },
  { -0.050286056609795446, 50, 1, 
	  1.8849555921538759 },
  { -0.32822568316499912, 50, 1, 
	  2.0420352248333655 },
  { 0.10755382110946902, 50, 1, 
	  2.1991148575128552 },
  { 0.35083930302013205, 50, 1, 
	  2.3561944901923448 },
  { -0.18473991408343635, 50, 1, 
	  2.5132741228718345 },
  { -0.40649930826163011, 50, 1, 
	  2.6703537555513241 },
  { 0.32616619317604606, 50, 1, 
	  2.8274333882308138 },
  { 0.63751752155228247, 50, 1, 
	  2.9845130209103035 },
  { 0.0000000000000000, 50, 1, 
	  3.1415926535897931 },
};
const double toler023 = 1.0000000000000008e-12;

// Test data for l=50, m=2.
// max(|f - f_GSL|): 7.5495165674510645e-15
// max(|f - f_GSL| / |f_GSL|): 2.0277903864891892e-14
const testcase_sph_legendre<double>
data024[21] =
{
  { 0.0000000000000000, 50, 2, 
	  0.0000000000000000 },
  { -0.37230261163838724, 50, 2, 
	  0.15707963267948966 },
  { 0.50051599680316194, 50, 2, 
	  0.31415926535897931 },
  { 0.21724795180329495, 50, 2, 
	  0.47123889803846897 },
  { -0.37948127307610924, 50, 2, 
	  0.62831853071795862 },
  { -0.13187372121003396, 50, 2, 
	  0.78539816339744828 },
  { 0.33959009162400228, 50, 2, 
	  0.94247779607693793 },
  { 0.072537503112489563, 50, 2, 
	  1.0995574287564276 },
  { -0.32310306941855266, 50, 2, 
	  1.2566370614359172 },
  { -0.023259822816436588, 50, 2, 
	  1.4137166941154069 },
  { 0.31842698506357275, 50, 2, 
	  1.5707963267948966 },
  { -0.023259822816431196, 50, 2, 
	  1.7278759594743860 },
  { -0.32310306941855316, 50, 2, 
	  1.8849555921538759 },
  { 0.072537503112487453, 50, 2, 
	  2.0420352248333655 },
  { 0.33959009162400267, 50, 2, 
	  2.1991148575128552 },
  { -0.13187372121003124, 50, 2, 
	  2.3561944901923448 },
  { -0.37948127307611107, 50, 2, 
	  2.5132741228718345 },
  { 0.21724795180329090, 50, 2, 
	  2.6703537555513241 },
  { 0.50051599680316194, 50, 2, 
	  2.8274333882308138 },
  { -0.37230261163837081, 50, 2, 
	  2.9845130209103035 },
  { 0.0000000000000000, 50, 2, 
	  3.1415926535897931 },
};
const double toler024 = 2.5000000000000015e-12;

// Test data for l=50, m=5.
// max(|f - f_GSL|): 4.3021142204224816e-16
// max(|f - f_GSL| / |f_GSL|): 8.9548506383410822e-15
const testcase_sph_legendre<double>
data025[21] =
{
  { 0.0000000000000000, 50, 5, 
	  0.0000000000000000 },
  { -0.57750385903193124, 50, 5, 
	  0.15707963267948966 },
  { 0.077360497065588632, 50, 5, 
	  0.31415926535897931 },
  { 0.47707267400540226, 50, 5, 
	  0.47123889803846897 },
  { 0.055370615126630517, 50, 5, 
	  0.62831853071795862 },
  { -0.37629451847202833, 50, 5, 
	  0.78539816339744828 },
  { -0.048042277801960784, 50, 5, 
	  0.94247779607693793 },
  { 0.33619379362228718, 50, 5, 
	  1.0995574287564276 },
  { 0.025265227185718764, 50, 5, 
	  1.2566370614359172 },
  { -0.32083679430964535, 50, 5, 
	  1.4137166941154069 },
  { -9.8189201019751884e-16, 50, 5, 
	  1.5707963267948966 },
  { 0.32083679430964579, 50, 5, 
	  1.7278759594743860 },
  { -0.025265227185716790, 50, 5, 
	  1.8849555921538759 },
  { -0.33619379362228752, 50, 5, 
	  2.0420352248333655 },
  { 0.048042277801958064, 50, 5, 
	  2.1991148575128552 },
  { 0.37629451847202872, 50, 5, 
	  2.3561944901923448 },
  { -0.055370615126626811, 50, 5, 
	  2.5132741228718345 },
  { -0.47707267400540176, 50, 5, 
	  2.6703537555513241 },
  { -0.077360497065588632, 50, 5, 
	  2.8274333882308138 },
  { 0.57750385903191603, 50, 5, 
	  2.9845130209103035 },
  { 0.0000000000000000, 50, 5, 
	  3.1415926535897931 },
};
const double toler025 = 5.0000000000000039e-13;

// Test data for l=50, m=10.
// max(|f - f_GSL|): 1.3322676295501878e-15
// max(|f - f_GSL| / |f_GSL|): 6.0812430149180488e-15
const testcase_sph_legendre<double>
data026[21] =
{
  { 0.0000000000000000, 50, 10, 
	  0.0000000000000000 },
  { 0.15606941844800776, 50, 10, 
	  0.15707963267948966 },
  { -0.53748868836814501, 50, 10, 
	  0.31415926535897931 },
  { -0.49304919025183969, 50, 10, 
	  0.47123889803846897 },
  { -0.26267582750428364, 50, 10, 
	  0.62831853071795862 },
  { 0.22058983666314153, 50, 10, 
	  0.78539816339744828 },
  { 0.32936725160671754, 50, 10, 
	  0.94247779607693793 },
  { -0.092053311559447959, 50, 10, 
	  1.0995574287564276 },
  { -0.32542913495935522, 50, 10, 
	  1.2566370614359172 },
  { 0.025673223789103351, 50, 10, 
	  1.4137166941154069 },
  { 0.32150019350255743, 50, 10, 
	  1.5707963267948966 },
  { 0.025673223789108836, 50, 10, 
	  1.7278759594743860 },
  { -0.32542913495935510, 50, 10, 
	  1.8849555921538759 },
  { -0.092053311559449819, 50, 10, 
	  2.0420352248333655 },
  { 0.32936725160671687, 50, 10, 
	  2.1991148575128552 },
  { 0.22058983666314380, 50, 10, 
	  2.3561944901923448 },
  { -0.26267582750427920, 50, 10, 
	  2.5132741228718345 },
  { -0.49304919025184135, 50, 10, 
	  2.6703537555513241 },
  { -0.53748868836814501, 50, 10, 
	  2.8274333882308138 },
  { 0.15606941844801256, 50, 10, 
	  2.9845130209103035 },
  { 0.0000000000000000, 50, 10, 
	  3.1415926535897931 },
};
const double toler026 = 5.0000000000000039e-13;

// Test data for l=50, m=20.
// max(|f - f_GSL|): 4.4408920985006262e-16
// max(|f - f_GSL| / |f_GSL|): 6.0930911637998029e-15
const testcase_sph_legendre<double>
data027[21] =
{
  { 0.0000000000000000, 50, 20, 
	  0.0000000000000000 },
  { 3.0409598712833246e-07, 50, 20, 
	  0.15707963267948966 },
  { 0.030940518122882274, 50, 20, 
	  0.31415926535897931 },
  { 0.64134588721659802, 50, 20, 
	  0.47123889803846897 },
  { 0.29895244392136405, 50, 20, 
	  0.62831853071795862 },
  { 0.25309324781873871, 50, 20, 
	  0.78539816339744828 },
  { 0.34368634714931717, 50, 20, 
	  0.94247779607693793 },
  { 0.33996764360663945, 50, 20, 
	  1.0995574287564276 },
  { 0.12866267745104024, 50, 20, 
	  1.2566370614359172 },
  { -0.18201114398922874, 50, 20, 
	  1.4137166941154069 },
  { -0.33216683431510857, 50, 20, 
	  1.5707963267948966 },
  { -0.18201114398923302, 50, 20, 
	  1.7278759594743860 },
  { 0.12866267745103857, 50, 20, 
	  1.8849555921538759 },
  { 0.33996764360663895, 50, 20, 
	  2.0420352248333655 },
  { 0.34368634714931812, 50, 20, 
	  2.1991148575128552 },
  { 0.25309324781874126, 50, 20, 
	  2.3561944901923448 },
  { 0.29895244392136594, 50, 20, 
	  2.5132741228718345 },
  { 0.64134588721659869, 50, 20, 
	  2.6703537555513241 },
  { 0.030940518122882274, 50, 20, 
	  2.8274333882308138 },
  { 3.0409598712835887e-07, 50, 20, 
	  2.9845130209103035 },
  { 0.0000000000000000, 50, 20, 
	  3.1415926535897931 },
};
const double toler027 = 5.0000000000000039e-13;

// Test data for l=50, m=50.
// max(|f - f_GSL|): 1.2323475573339238e-14
// max(|f - f_GSL| / |f_GSL|): 1.6099735616249234e-14
const testcase_sph_legendre<double>
data028[21] =
{
  { 0.0000000000000000, 50, 50, 
	  0.0000000000000000 },
  { 4.1649039898151844e-41, 50, 50, 
	  0.15707963267948966 },
  { 2.5240684647724192e-26, 50, 50, 
	  0.31415926535897931 },
  { 5.6927376423967334e-18, 50, 50, 
	  0.47123889803846897 },
  { 2.3116239814797057e-12, 50, 50, 
	  0.62831853071795862 },
  { 2.3835981241325056e-08, 50, 50, 
	  0.78539816339744828 },
  { 1.9992410287270356e-05, 50, 50, 
	  0.94247779607693793 },
  { 0.0024947505670829834, 50, 50, 
	  1.0995574287564276 },
  { 0.065057774647971231, 50, 50, 
	  1.2566370614359172 },
  { 0.43050607056732243, 50, 50, 
	  1.4137166941154069 },
  { 0.79980281171531975, 50, 50, 
	  1.5707963267948966 },
  { 0.43050607056732360, 50, 50, 
	  1.7278759594743860 },
  { 0.065057774647971398, 50, 50, 
	  1.8849555921538759 },
  { 0.0024947505670829899, 50, 50, 
	  2.0420352248333655 },
  { 1.9992410287270427e-05, 50, 50, 
	  2.1991148575128552 },
  { 2.3835981241325311e-08, 50, 50, 
	  2.3561944901923448 },
  { 2.3116239814797222e-12, 50, 50, 
	  2.5132741228718345 },
  { 5.6927376423968952e-18, 50, 50, 
	  2.6703537555513241 },
  { 2.5240684647724192e-26, 50, 50, 
	  2.8274333882308138 },
  { 4.1649039898161316e-41, 50, 50, 
	  2.9845130209103035 },
  { 0.0000000000000000, 50, 50, 
	  3.1415926535897931 },
};
const double toler028 = 1.0000000000000008e-12;

// Test data for l=100, m=0.
// max(|f - f_GSL|): 7.5495165674510645e-15
// max(|f - f_GSL| / |f_GSL|): 1.2423065089723510e-14
const testcase_sph_legendre<double>
data029[21] =
{
  { 3.9993839251484076, 100, 0, 
	  0.0000000000000000 },
  { -0.60770160285935426, 100, 0, 
	  0.15707963267948966 },
  { 0.46193027883955923, 100, 0, 
	  0.31415926535897931 },
  { -0.40218718869815234, 100, 0, 
	  0.47123889803846897 },
  { 0.36960201406910725, 100, 0, 
	  0.62831853071795862 },
  { -0.34953726547378389, 100, 0, 
	  0.78539816339744828 },
  { 0.33646959352497829, 100, 0, 
	  0.94247779607693793 },
  { -0.32784733067663224, 100, 0, 
	  1.0995574287564276 },
  { 0.32235624474047969, 100, 0, 
	  1.2566370614359172 },
  { -0.31929330706601350, 100, 0, 
	  1.4137166941154069 },
  { 0.31830791662110325, 100, 0, 
	  1.5707963267948966 },
  { -0.31929330706601405, 100, 0, 
	  1.7278759594743860 },
  { 0.32235624474048036, 100, 0, 
	  1.8849555921538759 },
  { -0.32784733067663357, 100, 0, 
	  2.0420352248333655 },
  { 0.33646959352498013, 100, 0, 
	  2.1991148575128552 },
  { -0.34953726547378589, 100, 0, 
	  2.3561944901923448 },
  { 0.36960201406911097, 100, 0, 
	  2.5132741228718345 },
  { -0.40218718869815723, 100, 0, 
	  2.6703537555513241 },
  { 0.46193027883955923, 100, 0, 
	  2.8274333882308138 },
  { -0.60770160285939456, 100, 0, 
	  2.9845130209103035 },
  { 3.9993839251484076, 100, 0, 
	  3.1415926535897931 },
};
const double toler029 = 1.0000000000000008e-12;

// Test data for l=100, m=1.
// max(|f - f_GSL|): 4.1078251911130792e-15
// max(|f - f_GSL| / |f_GSL|): 1.5162419336330716e-14
const testcase_sph_legendre<double>
data030[21] =
{
  { 0.0000000000000000, 100, 1, 
	  0.0000000000000000 },
  { -0.50851949013719866, 100, 1, 
	  0.15707963267948966 },
  { 0.33129641402221749, 100, 1, 
	  0.31415926535897931 },
  { -0.24390405750942512, 100, 1, 
	  0.47123889803846897 },
  { 0.18659755088414104, 100, 1, 
	  0.62831853071795862 },
  { -0.14355908970517178, 100, 1, 
	  0.78539816339744828 },
  { 0.10844906813251107, 100, 1, 
	  0.94247779607693793 },
  { -0.078100088690857675, 100, 1, 
	  1.0995574287564276 },
  { 0.050670002998302717, 100, 1, 
	  1.2566370614359172 },
  { -0.024941251747138900, 100, 1, 
	  1.4137166941154069 },
  { 1.9587949830851623e-15, 100, 1, 
	  1.5707963267948966 },
  { 0.024941251747127875, 100, 1, 
	  1.7278759594743860 },
  { -0.050670002998298824, 100, 1, 
	  1.8849555921538759 },
  { 0.078100088690853664, 100, 1, 
	  2.0420352248333655 },
  { -0.10844906813250622, 100, 1, 
	  2.1991148575128552 },
  { 0.14355908970516626, 100, 1, 
	  2.3561944901923448 },
  { -0.18659755088413388, 100, 1, 
	  2.5132741228718345 },
  { 0.24390405750941679, 100, 1, 
	  2.6703537555513241 },
  { -0.33129641402221749, 100, 1, 
	  2.8274333882308138 },
  { 0.50851949013714159, 100, 1, 
	  2.9845130209103035 },
  { 0.0000000000000000, 100, 1, 
	  3.1415926535897931 },
};
const double toler030 = 1.0000000000000008e-12;

// Test data for l=100, m=2.
// max(|f - f_GSL|): 2.7755575615628914e-15
// max(|f - f_GSL| / |f_GSL|): 5.7552022268705475e-15
const testcase_sph_legendre<double>
data031[21] =
{
  { 0.0000000000000000, 100, 2, 
	  0.0000000000000000 },
  { 0.67166274297193962, 100, 2, 
	  0.15707963267948966 },
  { -0.48226933687995360, 100, 2, 
	  0.31415926535897931 },
  { 0.41175421895715525, 100, 2, 
	  0.47123889803846897 },
  { -0.37475021787822438, 100, 2, 
	  0.62831853071795862 },
  { 0.35242909383605225, 100, 2, 
	  0.78539816339744828 },
  { -0.33807110409160063, 100, 2, 
	  0.94247779607693793 },
  { 0.32867180390710077, 100, 2, 
	  1.0995574287564276 },
  { -0.32271583790278502, 100, 2, 
	  1.2566370614359172 },
  { 0.31940354677687444, 100, 2, 
	  1.4137166941154069 },
  { -0.31833943693772526, 100, 2, 
	  1.5707963267948966 },
  { 0.31940354677687555, 100, 2, 
	  1.7278759594743860 },
  { -0.32271583790278552, 100, 2, 
	  1.8849555921538759 },
  { 0.32867180390710193, 100, 2, 
	  2.0420352248333655 },
  { -0.33807110409160157, 100, 2, 
	  2.1991148575128552 },
  { 0.35242909383605503, 100, 2, 
	  2.3561944901923448 },
  { -0.37475021787822776, 100, 2, 
	  2.5132741228718345 },
  { 0.41175421895716052, 100, 2, 
	  2.6703537555513241 },
  { -0.48226933687995360, 100, 2, 
	  2.8274333882308138 },
  { 0.67166274297196660, 100, 2, 
	  2.9845130209103035 },
  { 0.0000000000000000, 100, 2, 
	  3.1415926535897931 },
};
const double toler031 = 5.0000000000000039e-13;

// Test data for l=100, m=5.
// max(|f - f_GSL|): 5.9674487573602164e-16
// max(|f - f_GSL| / |f_GSL|): 8.4413588189215985e-15
const testcase_sph_legendre<double>
data032[21] =
{
  { 0.0000000000000000, 100, 5, 
	  0.0000000000000000 },
  { 0.062564361105902272, 100, 5, 
	  0.15707963267948966 },
  { 0.14179554455879767, 100, 5, 
	  0.31415926535897931 },
  { -0.14356866942905960, 100, 5, 
	  0.47123889803846897 },
  { 0.12355483388448550, 100, 5, 
	  0.62831853071795862 },
  { -0.10090029999681642, 100, 5, 
	  0.78539816339744828 },
  { 0.078905134460230675, 100, 5, 
	  0.94247779607693793 },
  { -0.058040182398185071, 100, 5, 
	  1.0995574287564276 },
  { 0.038142759389482424, 100, 5, 
	  1.2566370614359172 },
  { -0.018906264170660478, 100, 5, 
	  1.4137166941154069 },
  { 1.9576303042914544e-15, 100, 5, 
	  1.5707963267948966 },
  { 0.018906264170649455, 100, 5, 
	  1.7278759594743860 },
  { -0.038142759389478365, 100, 5, 
	  1.8849555921538759 },
  { 0.058040182398180429, 100, 5, 
	  2.0420352248333655 },
  { -0.078905134460225707, 100, 5, 
	  2.1991148575128552 },
  { 0.10090029999681013, 100, 5, 
	  2.3561944901923448 },
  { -0.12355483388447824, 100, 5, 
	  2.5132741228718345 },
  { 0.14356866942904906, 100, 5, 
	  2.6703537555513241 },
  { -0.14179554455879767, 100, 5, 
	  2.8274333882308138 },
  { -0.062564361105954577, 100, 5, 
	  2.9845130209103035 },
  { 0.0000000000000000, 100, 5, 
	  3.1415926535897931 },
};
const double toler032 = 5.0000000000000039e-13;

// Test data for l=100, m=10.
// max(|f - f_GSL|): 1.7763568394002505e-15
// max(|f - f_GSL| / |f_GSL|): 4.0853922061744651e-15
const testcase_sph_legendre<double>
data033[21] =
{
  { 0.0000000000000000, 100, 10, 
	  0.0000000000000000 },
  { -0.75366545187996004, 100, 10, 
	  0.15707963267948966 },
  { -0.35914570017276798, 100, 10, 
	  0.31415926535897931 },
  { 0.43480692911578295, 100, 10, 
	  0.47123889803846897 },
  { -0.40862111080315755, 100, 10, 
	  0.62831853071795862 },
  { 0.37832688692909411, 100, 10, 
	  0.78539816339744828 },
  { -0.35484056194773445, 100, 10, 
	  0.94247779607693793 },
  { 0.33821981171196341, 100, 10, 
	  1.0995574287564276 },
  { -0.32729120767830594, 100, 10, 
	  1.2566370614359172 },
  { 0.32110336937091438, 100, 10, 
	  1.4137166941154069 },
  { -0.31910064020036194, 100, 10, 
	  1.5707963267948966 },
  { 0.32110336937091460, 100, 10, 
	  1.7278759594743860 },
  { -0.32729120767830605, 100, 10, 
	  1.8849555921538759 },
  { 0.33821981171196341, 100, 10, 
	  2.0420352248333655 },
  { -0.35484056194773461, 100, 10, 
	  2.1991148575128552 },
  { 0.37832688692909372, 100, 10, 
	  2.3561944901923448 },
  { -0.40862111080315500, 100, 10, 
	  2.5132741228718345 },
  { 0.43480692911577751, 100, 10, 
	  2.6703537555513241 },
  { -0.35914570017276798, 100, 10, 
	  2.8274333882308138 },
  { -0.75366545187997991, 100, 10, 
	  2.9845130209103035 },
  { 0.0000000000000000, 100, 10, 
	  3.1415926535897931 },
};
const double toler033 = 2.5000000000000020e-13;

// Test data for l=100, m=20.
// max(|f - f_GSL|): 9.7144514654701197e-16
// max(|f - f_GSL| / |f_GSL|): 2.8802569343392205e-14
const testcase_sph_legendre<double>
data034[21] =
{
  { 0.0000000000000000, 100, 20, 
	  0.0000000000000000 },
  { 0.053569660841553700, 100, 20, 
	  0.15707963267948966 },
  { 0.57154926874732348, 100, 20, 
	  0.31415926535897931 },
  { 0.47536909969585633, 100, 20, 
	  0.47123889803846897 },
  { -0.28882554564109075, 100, 20, 
	  0.62831853071795862 },
  { 0.020116179014043743, 100, 20, 
	  0.78539816339744828 },
  { 0.14752195931706563, 100, 20, 
	  0.94247779607693793 },
  { -0.24069428588868366, 100, 20, 
	  1.0995574287564276 },
  { 0.29031796025014306, 100, 20, 
	  1.2566370614359172 },
  { -0.31437256851143458, 100, 20, 
	  1.4137166941154069 },
  { 0.32153954851141792, 100, 20, 
	  1.5707963267948966 },
  { -0.31437256851143169, 100, 20, 
	  1.7278759594743860 },
  { 0.29031796025014139, 100, 20, 
	  1.8849555921538759 },
  { -0.24069428588868083, 100, 20, 
	  2.0420352248333655 },
  { 0.14752195931706186, 100, 20, 
	  2.1991148575128552 },
  { 0.020116179014049562, 100, 20, 
	  2.3561944901923448 },
  { -0.28882554564109575, 100, 20, 
	  2.5132741228718345 },
  { 0.47536909969585545, 100, 20, 
	  2.6703537555513241 },
  { 0.57154926874732348, 100, 20, 
	  2.8274333882308138 },
  { 0.053569660841557079, 100, 20, 
	  2.9845130209103035 },
  { 0.0000000000000000, 100, 20, 
	  3.1415926535897931 },
};
const double toler034 = 2.5000000000000015e-12;

// Test data for l=100, m=50.
// max(|f - f_GSL|): 8.3266726846886741e-15
// max(|f - f_GSL| / |f_GSL|): 1.8981734972089879e-14
const testcase_sph_legendre<double>
data035[21] =
{
  { 0.0000000000000000, 100, 50, 
	  0.0000000000000000 },
  { 3.3047910392590615e-21, 100, 50, 
	  0.15707963267948966 },
  { 1.0592655372554981e-07, 100, 50, 
	  0.31415926535897931 },
  { 0.080418744223952773, 100, 50, 
	  0.47123889803846897 },
  { -0.56450600580393095, 100, 50, 
	  0.62831853071795862 },
  { 0.33338739844742110, 100, 50, 
	  0.78539816339744828 },
  { 0.39741714816514706, 100, 50, 
	  0.94247779607693793 },
  { 0.35223993750972243, 100, 50, 
	  1.0995574287564276 },
  { 0.17885891940721577, 100, 50, 
	  1.2566370614359172 },
  { -0.15341660126461967, 100, 50, 
	  1.4137166941154069 },
  { -0.34175924303503102, 100, 50, 
	  1.5707963267948966 },
  { -0.15341660126462869, 100, 50, 
	  1.7278759594743860 },
  { 0.17885891940721302, 100, 50, 
	  1.8849555921538759 },
  { 0.35223993750972105, 100, 50, 
	  2.0420352248333655 },
  { 0.39741714816514595, 100, 50, 
	  2.1991148575128552 },
  { 0.33338739844741666, 100, 50, 
	  2.3561944901923448 },
  { -0.56450600580392973, 100, 50, 
	  2.5132741228718345 },
  { 0.080418744223953911, 100, 50, 
	  2.6703537555513241 },
  { 1.0592655372554981e-07, 100, 50, 
	  2.8274333882308138 },
  { 3.3047910392597822e-21, 100, 50, 
	  2.9845130209103035 },
  { 0.0000000000000000, 100, 50, 
	  3.1415926535897931 },
};
const double toler035 = 1.0000000000000008e-12;

// Test data for l=100, m=100.
// max(|f - f_GSL|): 2.3314683517128287e-14
// max(|f - f_GSL| / |f_GSL|): 2.6593512237122742e-14
const testcase_sph_legendre<double>
data036[21] =
{
  { 0.0000000000000000, 100, 100, 
	  0.0000000000000000 },
  { 2.5744136608862186e-81, 100, 100, 
	  0.15707963267948966 },
  { 9.4551974868956498e-52, 100, 100, 
	  0.31415926535897931 },
  { 4.8096190703397596e-35, 100, 100, 
	  0.47123889803846897 },
  { 7.9305393636342891e-24, 100, 100, 
	  0.62831853071795862 },
  { 8.4320740610944858e-16, 100, 100, 
	  0.78539816339744828 },
  { 5.9319660146027522e-10, 100, 100, 
	  0.94247779607693793 },
  { 9.2368225946797243e-06, 100, 100, 
	  1.0995574287564276 },
  { 0.0062815489742044095, 100, 100, 
	  1.2566370614359172 },
  { 0.27505966018176986, 100, 100, 
	  1.4137166941154069 },
  { 0.94936713998764621, 100, 100, 
	  1.5707963267948966 },
  { 0.27505966018177130, 100, 100, 
	  1.7278759594743860 },
  { 0.0062815489742044433, 100, 100, 
	  1.8849555921538759 },
  { 9.2368225946797734e-06, 100, 100, 
	  2.0420352248333655 },
  { 5.9319660146027946e-10, 100, 100, 
	  2.1991148575128552 },
  { 8.4320740610946652e-16, 100, 100, 
	  2.3561944901923448 },
  { 7.9305393636344023e-24, 100, 100, 
	  2.5132741228718345 },
  { 4.8096190703400333e-35, 100, 100, 
	  2.6703537555513241 },
  { 9.4551974868956498e-52, 100, 100, 
	  2.8274333882308138 },
  { 2.5744136608873895e-81, 100, 100, 
	  2.9845130209103035 },
  { 0.0000000000000000, 100, 100, 
	  3.1415926535897931 },
};
const double toler036 = 2.5000000000000015e-12;

template<typename Tp, unsigned int Num>
  void
  test(const testcase_sph_legendre<Tp> (&data)[Num], Tp toler)
  {
    bool test __attribute__((unused)) = true;
    const Tp eps = std::numeric_limits<Tp>::epsilon();
    Tp max_abs_diff = -Tp(1);
    Tp max_abs_frac = -Tp(1);
    unsigned int num_datum = Num;
    for (unsigned int i = 0; i < num_datum; ++i)
  	 {
	const Tp f = std::sph_legendre(data[i].l, data[i].m,
		     data[i].theta);
	const Tp f0 = data[i].f0;
	const Tp diff = f - f0;
	if (std::abs(diff) > max_abs_diff)
	  max_abs_diff = std::abs(diff);
	if (std::abs(f0) > Tp(10) * eps
	 && std::abs(f) > Tp(10) * eps)
	  {
	    const Tp frac = diff / f0;
	    if (std::abs(frac) > max_abs_frac)
	      max_abs_frac = std::abs(frac);
	  }
      }
    VERIFY(max_abs_frac < toler);
  }

int
main()
{
  test(data001, toler001);
  test(data002, toler002);
  test(data003, toler003);
  test(data004, toler004);
  test(data005, toler005);
  test(data006, toler006);
  test(data007, toler007);
  test(data008, toler008);
  test(data009, toler009);
  test(data010, toler010);
  test(data011, toler011);
  test(data012, toler012);
  test(data013, toler013);
  test(data014, toler014);
  test(data015, toler015);
  test(data016, toler016);
  test(data017, toler017);
  test(data018, toler018);
  test(data019, toler019);
  test(data020, toler020);
  test(data021, toler021);
  test(data022, toler022);
  test(data023, toler023);
  test(data024, toler024);
  test(data025, toler025);
  test(data026, toler026);
  test(data027, toler027);
  test(data028, toler028);
  test(data029, toler029);
  test(data030, toler030);
  test(data031, toler031);
  test(data032, toler032);
  test(data033, toler033);
  test(data034, toler034);
  test(data035, toler035);
  test(data036, toler036);
  return 0;
}
