.\" dpkg manual page - deb-control(5)
.\"
.\" Copyright © 1995 Raul Miller, Ian Jackson, Ian Murdock
.\" Copyright © 1999 Ben Collins <bcollins@debian.org>
.\" Copyright © 2000 Wichert Akkerman <wakkerma@debian.org>
.\" Copyright © 2007-2011, 2013-2015 Guillem Jover <guillem@debian.org>
.\" Copyright © 2008-2012 Raphaël Hertzog <hertzog@debian.org>
.\"
.\" This is free software; you can redistribute it and/or modify
.\" it under the terms of the GNU General Public License as published by
.\" the Free Software Foundation; either version 2 of the License, or
.\" (at your option) any later version.
.\"
.\" This is distributed in the hope that it will be useful,
.\" but WITHOUT ANY WARRANTY; without even the implied warranty of
.\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\" GNU General Public License for more details.
.\"
.\" You should have received a copy of the GNU General Public License
.\" along with this program.  If not, see <https://www.gnu.org/licenses/>.
.
.TH deb\-control 5 "%RELEASE_DATE%" "%VERSION%" "dpkg suite"
.nh
.SH NAME
deb\-control \- Debian binary packages' master control file format
.
.SH SYNOPSIS
control
.
.SH DESCRIPTION
Each Debian binary package contains the master \fIcontrol\fP file, which
contains a number of fields.
Each field begins with a tag, such as
.B Package
or
.B Version
(case insensitive), followed by a colon, and the body of the field.
Fields are delimited only by field tags. In other words, field text
may be multiple lines in length, but the installation tools will
generally join lines when processing the body of the field (except
in the case of the
.B Description
field, see below).
.
.SH FIELDS
.TP
.BR Package: " \fIpackage-name\fP (required)"
The value of this field determines the package name, and is used to
generate file names by most installation tools.
.TP
.BR Package\-Type: " \fBdeb\fP|\fBudeb\fP|\fItype\fP"
This field defines the type of the package.
\fBudeb\fP is for size-constrained packages used by the debian installer.
\fBdeb\fP is the default value, it is assumed if the field is absent.
More types might be added in the future.
.TP
.BR Version: " \fIversion-string\fP (required)"
Typically, this is the original package's version number in whatever form
the program's author uses. It may also include a Debian revision number
(for non-native packages). The exact format and sorting algorithm
are described in
.BR deb\-version (7).
.TP
.BR Maintainer: " \fIfullname-email\fP (recommended)"
Should be in the format “Joe Bloggs <jbloggs@foo.com>”, and is typically
the person who created the package, as opposed to the author of the
software that was packaged.
.TP
.BR Description: " \fIshort-description\fP (recommended)"
.TQ
.BI " " "long-description"
.br
The format for the package description is a short brief summary on the
first line (after the \fBDescription\fP field). The following lines should be
used as a longer, more detailed description. Each line of the long description
must be preceded by a space, and blank lines in the long description must
contain a single ‘\fB.\fP’ following the preceding space.
.TP
.BI Section: " section"
This is a general field that gives the package a category based on the
software that it installs.
Some common sections are \fButils\fP, \fBnet\fP, \fBmail\fP, \fBtext\fP,
\fBx11\fP, etc.
.TP
.BI Priority: " priority"
Sets the importance of this package in relation to the system as a whole.
Common priorities are \fBrequired\fP, \fBstandard\fP, \fBoptional\fP,
\fBextra\fP, etc.
.LP
The
.B Section
and
.B Priority
fields usually have a defined set of accepted values based on the specific
distribution policy.
.
.TP
.BR Installed\-Size: " size"
The approximate total size of the package's installed files, in KiB units.
.
.TP
.BR Essential: " \fByes\fP|\fBno\fP"
This field is usually only needed when the answer is \fByes\fP. It denotes
a package that is required for proper operation of the system. Dpkg
or any other installation tool will not allow an
.B Essential
package to be removed (at least not without using one of the force options).
.TP
.BR Build\-Essential: " \fByes\fP|\fBno\fP"
This field is usually only needed when the answer is \fByes\fP, and is
commonly injected by the archive software.
It denotes a package that is required when building other packages.
.TP
.BR Architecture: " \fIarch\fP|\fBall\fP (recommended)"
The architecture specifies which type of hardware this package was compiled
for.
Common architectures are \fBamd64\fP, \fBarmel\fP, \fBi386\fP, \fBpowerpc\fP,
etc.
Note that the
.B all
value is meant for packages that are architecture independent.
Some examples of this are shell and Perl scripts, and documentation.
.TP
.BI Origin: " name"
The name of the distribution this package is originating from.
.TP
.BI Bugs: " url"
The \fIurl\fP of the bug tracking system for this package. The current
used format is \fIbts-type\fP\fB://\fP\fIbts-address\fP, like
\fBdebbugs://bugs.debian.org\fP.
.TP
.BI Homepage: " url"
The upstream project home page \fIurl\fP.
.TP
.BI Tag: " tag-list"
List of tags describing the qualities of the package. The description and
list of supported tags can be found in the \fBdebtags\fP package.
.TP
.BR Multi\-Arch: " \fBno\fP|\fBsame\fP|\fBforeign\fP|\fBallowed\fP"
This field is used to indicate how this package should behave on a multi-arch
installations.
.RS
.TP
.B no
This value is the default when the field is omitted, in which case
adding the field with an explicit \fBno\fP value is generally not needed.
.TP
.B same
This package is co-installable with itself, but it must not be used to
satisfy the dependency of any package of a different architecture from
itself.
.TP
.B foreign
This package is not co-installable with itself, but should be allowed to
satisfy a non-arch-qualified dependency of a package of a different arch
from itself (if a dependency has an explicit arch-qualifier then the
value \fBforeign\fP is ignored).
.TP
.B allowed
This allows reverse-dependencies to indicate in their \fBDepends\fP
field that they accept this package from a foreign architecture by
qualifying the package name with \fB:any\fP, but has no effect otherwise.
.RE
.TP
.BR Source: " \fIsource-name\fP [\fB(\fP\fIsource-version\fP\fB)\fP]"
The name of the source package that this binary package came from, if it is
different than the name of the package itself.
If the source version differs from the binary version, then the
\fIsource-name\fP will be followed by a \fIsource-version\fP in parenthesis.
This can happen for example on a binary-only non-maintainer upload, or when
setting a different binary version via «\fBdpkg\-gencontrol \-v\fP».
.TP
.BI Subarchitecture: " value"
.TQ
.BI Kernel\-Version: " value"
.TQ
.BI Installer\-Menu\-Item: " value"
These fields are used by the debian\-installer and are usually not needed.
See /usr/share/doc/debian\-installer/devel/modules.txt from the
.B debian\-installer
package for more details about them.

.TP
.BI Depends: " package-list"
List of packages that are required for this package to provide a
non-trivial amount of functionality. The package maintenance software
will not allow a package to be installed if the packages listed in its
.B Depends
field aren't installed (at least not without using the force options).
In an installation, the postinst scripts of packages listed in \fBDepends\fP
fields are run before those of the packages which depend on them. On the
opposite, in a removal, the prerm script of a package is run before
those of the packages listed in its \fBDepends\fP field.
.TP
.BI Pre\-Depends: " package-list"
List of packages that must be installed
.B and
configured before this one can be installed. This is usually used in the
case where this package requires another package for running its preinst
script.
.TP
.BI Recommends: " package-list"
Lists packages that would be found together with this one in all but
unusual installations. The package maintenance software will warn the
user if they install a package without those listed in its
.B Recommends
field.
.TP
.BI Suggests: " package-list"
Lists packages that are related to this one and can perhaps enhance
its usefulness, but without which installing this package is perfectly
reasonable.
.LP
The syntax of
.BR Depends ,
.BR Pre\-Depends ,
.B Recommends
and
.B Suggests
fields is a list of groups of alternative packages. Each group is a list
of packages separated by vertical bar (or “pipe”) symbols,
‘\fB|\fP’.
The groups are separated by commas.
Commas are to be read as “AND”, and pipes as “OR”, with pipes
binding more tightly.
Each package name is optionally followed by an architecture qualifier
appended after a colon ‘\fB:\fP’, optionally followed by a version
number specification in parentheses.
.LP
An architecture qualifier name can be a real Debian architecture name
(since dpkg 1.16.5) or \fBany\fP (since dpkg 1.16.2).
If omitted, the default is the current binary package architecture.
A real Debian architecture name will match exactly that architecture for
that package name, \fBany\fP will match any architecture for that package
name if the package has been marked as \fBMulti\-Arch: allowed\fP.
.LP
A version number may start with a ‘\fB>>\fP’, in which case any later
version will match, and may specify or omit the Debian packaging revision
(separated by a hyphen).
Accepted version relationships are ‘\fB>>\fP’ for greater than,
‘\fB<<\fP’ for less than, ‘\fB>=\fP’ for greater than or
equal to, ‘\fB<=\fP’ for less than or equal to, and ‘\fB=\fP’
for equal to.
.TP
.BI Breaks: " package-list"
Lists packages that this one breaks, for example by exposing bugs
when the named packages rely on this one. The package maintenance
software will not allow broken packages to be configured; generally
the resolution is to upgrade the packages named in a
.B Breaks
field.
.TP
.BI Conflicts: " package-list"
Lists packages that conflict with this one, for example by containing
files with the same names. The package maintenance software will not
allow conflicting packages to be installed at the same time. Two
conflicting packages should each include a
.B Conflicts
line mentioning the other.
.TP
.BI Replaces: " package-list"
List of packages files from which this one replaces. This is used for
allowing this package to overwrite the files of another package and
is usually used with the
.B Conflicts
field to force removal of the other package, if this one also has the
same files as the conflicted package.
.LP
The syntax of
.BR Breaks ,
.B Conflicts
and
.B Replaces
is a list of package names, separated by commas (and optional whitespace).
In the
.B Breaks
and
.B Conflicts
fields, the comma should be read as “OR”.
An optional architecture qualifier can also be appended to the package name
with the same syntax as above, but the default is \fBany\fP instead of the
binary package architecture.
An optional version can also be given with the same syntax as above for the
.BR Breaks ,
.B Conflicts
and
.B Replaces
fields.
.
.TP
.BI Enhances: " package-list"
This is a list of packages that this one enhances.
It is similar to \fBSuggests\fP but in the opposite direction.
.TP
.BI Provides: " package-list"
This is a list of virtual packages that this one provides.
Usually this is used in the case of several packages all providing the
same service.
For example, sendmail and exim can serve as a mail server, so they
provide a common package (“mail\-transport\-agent”) on which
other packages can depend.
This will allow sendmail or exim to serve as a valid option to satisfy
the dependency.
This prevents the packages that depend on a mail server from having to
know the package names for all of them, and using ‘\fB|\fP’ to
separate the list.
.LP
The syntax of
.B Provides
is a list of package names, separated by commas (and optional whitespace).
An optional architecture qualifier can also be appended to the package
name with the same syntax as above.
If omitted, the default is the current binary package architecture.
An optional exact (equal to) version can also be given with the same
syntax as above (honored since dpkg 1.17.11).
.
.TP
.BI Built\-Using: " package-list"
This field lists extra source packages that were used during the build of this
binary package.  This is an indication to the archive maintenance software that
these extra source packages must be kept whilst this binary package is
maintained.
This field must be a list of source package names with strict ‘\fB=\fP’
version relationships.  Note that the archive maintenance software is likely to
refuse to accept an upload which declares a
.B Built\-Using
relationship which cannot be satisfied within the archive.
.
.TP
.BI Built\-For\-Profiles: " profile-list (obsolete)"
This field used to specify a whitespace separated list of build profiles that
this binary packages was built with (since dpkg 1.17.2 until 1.18.18).
The information previously found in this field can now be found in the
\fB.buildinfo\fP file, which supersedes it.
.
.TP
.BI Auto\-Built\-Package: " reason-list"
This field specifies a whitespace separated list of reasons why this package
was auto-generated.
Binary packages marked with this field will not appear in the
\fIdebian/control\fP master source control file.
The only currently used reason is \fBdebug\-symbols\fP.
.
.SH EXAMPLE
.\" .RS
.nf
# Comment
Package: grep
Essential: yes
Priority: required
Section: base
Maintainer: Wichert Akkerman <wakkerma@debian.org>
Architecture: sparc
Version: 2.4\-1
Pre\-Depends: libc6 (>= 2.0.105)
Provides: rgrep
Conflicts: rgrep
Description: GNU grep, egrep and fgrep.
 The GNU family of grep utilities may be the "fastest grep in the west".
 GNU grep is based on a fast lazy-state deterministic matcher (about
 twice as fast as stock Unix egrep) hybridized with a Boyer-Moore-Gosper
 search for a fixed string that eliminates impossible text from being
 considered by the full regexp matcher without necessarily having to
 look at every character. The result is typically many times faster
 than Unix grep or egrep. (Regular expressions containing backreferencing
 will run more slowly, however).
.fi
.\" .RE
.
.SH SEE ALSO
.BR deb (5),
.BR deb\-version (7),
.BR debtags (1),
.BR dpkg (1),
.BR dpkg\-deb (1).
