/*
 * Decompiled with CFR 0.152.
 */
package org.purejava;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.freedesktop.dbus.connections.impl.DBusConnection;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.handlers.Messaging;
import org.freedesktop.dbus.interfaces.DBus;
import org.freedesktop.dbus.messages.DBusSignal;
import org.freedesktop.dbus.types.Variant;
import org.kde.KWallet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KDEWallet
extends Messaging
implements KWallet,
AutoCloseable {
    private Logger log = LoggerFactory.getLogger(KDEWallet.class);
    private DBusConnection connection;
    public static final List<Class<? extends DBusSignal>> signals = Arrays.asList(KWallet.applicationDisconnected.class, KWallet.folderUpdated.class, KWallet.folderListUpdated.class, KWallet.allWalletsClosed.class, KWallet.walletClosedId.class, KWallet.walletClosed.class, KWallet.walletDeleted.class, KWallet.walletAsyncOpened.class, KWallet.walletOpened.class, KWallet.walletCreated.class, KWallet.walletListDirty.class);

    public KDEWallet(DBusConnection connection) {
        super(connection, signals, "org.kde.kwalletd5", "/modules/kwalletd5", "org.kde.KWallet");
        this.connection = connection;
    }

    @Override
    public boolean isEnabled() {
        try {
            DBus bus = (DBus)this.connection.getRemoteObject("org.freedesktop.DBus", "/org/freedesktop/DBus", DBus.class);
            if (Arrays.asList(bus.ListActivatableNames()).contains("org.kde.kwalletd5")) {
                this.log.debug("Kwallet daemon is available.");
                return true;
            }
            return false;
        }
        catch (DBusException e) {
            this.log.error(e.toString(), e.getCause());
            return false;
        }
    }

    @Override
    public int open(String wallet, long wId, String appid) {
        Object[] response = this.send("open", "sxs", wallet, wId, appid);
        return null == response ? -1 : (Integer)response[0];
    }

    @Override
    public int openPath(String path, long wId, String appid) {
        Object[] response = this.send("openPath", "sxs", path, wId, appid);
        return null == response ? 0 : (Integer)response[0];
    }

    @Override
    public int openAsync(String wallet, long wId, String appid, boolean handleSession) {
        Object[] response = this.send("openAsync", "sxsb", wallet, wId, appid, handleSession);
        return (Integer)response[0];
    }

    @Override
    public int openPathAsync(String path, long wId, String appid, boolean handleSession) {
        Object[] response = this.send("openPathAsync", "sxsb", path, wId, appid, handleSession);
        return (Integer)response[0];
    }

    @Override
    public int close(String wallet, boolean force) {
        Object[] response = this.send("close", "sb", wallet, force);
        return (Integer)response[0];
    }

    @Override
    public int close(int handle, boolean force, String appid) {
        Object[] response = this.send("close", "ibs", handle, force, appid);
        return (Integer)response[0];
    }

    @Override
    public void sync(int handle, String appid) {
        this.send("sync", "is", handle, appid);
    }

    @Override
    public int deleteWallet(String wallet) {
        Object[] response = this.send("deleteWallet", "s", wallet);
        return (Integer)response[0];
    }

    @Override
    public boolean isOpen(String wallet) {
        Object[] response = this.send("isOpen", "s", wallet);
        return (Boolean)response[0];
    }

    @Override
    public boolean isOpen(int handle) {
        Object[] response = this.send("isOpen", "i", handle);
        return (Boolean)response[0];
    }

    @Override
    public List<String> users(String wallet) {
        Object[] response = this.send("users", "s", wallet);
        return (List)response[0];
    }

    @Override
    public void changePassword(String wallet, long wId, String appid) {
        this.send("changePassword", "sxs", wallet, wId, appid);
    }

    @Override
    public List<String> wallets() {
        Object[] response = this.send("wallets");
        return (List)response[0];
    }

    @Override
    public List<String> folderList(int handle, String appid) {
        Object[] response = this.send("folderList", "is", handle, appid);
        return (List)response[0];
    }

    @Override
    public boolean hasFolder(int handle, String folder, String appid) {
        Object[] response = this.send("hasFolder", "iss", handle, folder, appid);
        return (Boolean)response[0];
    }

    @Override
    public boolean createFolder(int handle, String folder, String appid) {
        Object[] response = this.send("createFolder", "iss", handle, folder, appid);
        return (Boolean)response[0];
    }

    @Override
    public boolean removeFolder(int handle, String folder, String appid) {
        Object[] response = this.send("removeFolder", "iss", handle, folder, appid);
        return (Boolean)response[0];
    }

    @Override
    public List<String> entryList(int handle, String folder, String appid) {
        Object[] response = this.send("entryList", "iss", handle, folder, appid);
        return (List)response[0];
    }

    @Override
    public byte[] readEntry(int handle, String folder, String key, String appid) {
        Object[] response = this.send("readEntry", "isss", handle, folder, key, appid);
        return (byte[])response[0];
    }

    @Override
    public byte[] readMap(int handle, String folder, String key, String appid) {
        Object[] response = this.send("readMap", "isss", handle, folder, key, appid);
        return (byte[])response[0];
    }

    @Override
    public String readPassword(int handle, String folder, String key, String appid) {
        Object[] response = this.send("readPassword", "isss", handle, folder, key, appid);
        return (String)response[0];
    }

    @Override
    public Map<String, byte[]> entriesList(int handle, String folder, String appid) {
        Object[] response = this.send("entriesList", "iss", handle, folder, appid);
        Map map = (Map)response[0];
        return map.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> (byte[])((Variant)e.getValue()).getValue()));
    }

    @Override
    public Map<String, byte[]> mapList(int handle, String folder, String appid) {
        Object[] response = this.send("mapList", "iss", handle, folder, appid);
        Map map = (Map)response[0];
        return map.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> (byte[])((Variant)e.getValue()).getValue()));
    }

    @Override
    public Map<String, String> passwordList(int handle, String folder, String appid) {
        Object[] response = this.send("passwordList", "iss", handle, folder, appid);
        Map map = (Map)response[0];
        return map.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> (String)((Variant)e.getValue()).getValue()));
    }

    @Override
    public int renameEntry(int handle, String folder, String oldName, String newName, String appid) {
        Object[] response = this.send("renameEntry", "issss", handle, folder, oldName, newName, appid);
        return (Integer)response[0];
    }

    @Override
    public int writeEntry(int handle, String folder, String key, byte[] value, int entryType, String appid) {
        Object[] response = this.send("writeEntry", "issayis", handle, folder, key, value, entryType, appid);
        return (Integer)response[0];
    }

    @Override
    public int writeEntry(int handle, String folder, String key, byte[] value, String appid) {
        Object[] response = this.send("writeEntry", "issays", handle, folder, key, value, appid);
        return (Integer)response[0];
    }

    @Override
    public int writeMap(int handle, String folder, String key, byte[] value, String appid) {
        Object[] response = this.send("writeMap", "issays", handle, folder, key, value, appid);
        return (Integer)response[0];
    }

    @Override
    public int writePassword(int handle, String folder, String key, String value, String appid) {
        Object[] response = this.send("writePassword", "issss", handle, folder, key, value, appid);
        return (Integer)response[0];
    }

    @Override
    public boolean hasEntry(int handle, String folder, String key, String appid) {
        Object[] response = this.send("hasEntry", "isss", handle, folder, key, appid);
        return (Boolean)response[0];
    }

    @Override
    public int entryType(int handle, String folder, String key, String appid) {
        Object[] response = this.send("entryType", "isss", handle, folder, key, appid);
        return (Integer)response[0];
    }

    @Override
    public int removeEntry(int handle, String folder, String key, String appid) {
        Object[] response = this.send("removeEntry", "isss", handle, folder, key, appid);
        return (Integer)response[0];
    }

    @Override
    public boolean disconnectApplication(String wallet, String application) {
        Object[] response = this.send("disconnectApplication", "ss", wallet, application);
        return (Boolean)response[0];
    }

    @Override
    public void reconfigure() {
        this.send("reconfigure");
    }

    @Override
    public boolean folderDoesNotExist(String wallet, String folder) {
        Object[] response = this.send("folderDoesNotExist", "ss", wallet, folder);
        return (Boolean)response[0];
    }

    @Override
    public boolean keyDoesNotExist(String wallet, String folder, String key) {
        Object[] response = this.send("keyDoesNotExist", "sss", wallet, folder, key);
        return (Boolean)response[0];
    }

    @Override
    public void closeAllWallets() {
        this.send("closeAllWallets");
    }

    @Override
    public String networkWallet() {
        Object[] response = this.send("networkWallet");
        return (String)response[0];
    }

    @Override
    public String localWallet() {
        Object[] response = this.send("localWallet");
        return (String)response[0];
    }

    @Override
    public void pamOpen(String wallet, byte[] passwordHash, int sessionTimeout) {
        this.send("pamOpen", "sayi", wallet, passwordHash, sessionTimeout);
    }

    public boolean isRemote() {
        return false;
    }

    @Override
    public String getObjectPath() {
        return super.getObjectPath();
    }

    @Override
    public void close() {
        try {
            if (this.connection != null) {
                this.connection.disconnect();
            }
        }
        catch (Exception e) {
            this.log.error(e.toString(), e.getCause());
        }
    }
}

