/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptolib.v2;

import java.nio.ByteBuffer;
import java.security.SecureRandom;
import java.util.Arrays;
import javax.crypto.AEADBadTagException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.GCMParameterSpec;
import org.cryptomator.cryptolib.api.AuthenticationFailedException;
import org.cryptomator.cryptolib.api.FileHeader;
import org.cryptomator.cryptolib.api.FileHeaderCryptor;
import org.cryptomator.cryptolib.api.Masterkey;
import org.cryptomator.cryptolib.common.CipherSupplier;
import org.cryptomator.cryptolib.common.DestroyableSecretKey;
import org.cryptomator.cryptolib.v2.FileHeaderImpl;

class FileHeaderCryptorImpl
implements FileHeaderCryptor {
    private final Masterkey masterkey;
    private final SecureRandom random;

    FileHeaderCryptorImpl(Masterkey masterkey, SecureRandom random) {
        this.masterkey = masterkey;
        this.random = random;
    }

    @Override
    public FileHeader create() {
        byte[] nonce = new byte[12];
        this.random.nextBytes(nonce);
        byte[] contentKey = new byte[32];
        this.random.nextBytes(contentKey);
        FileHeaderImpl.Payload payload = new FileHeaderImpl.Payload(-1L, contentKey);
        return new FileHeaderImpl(nonce, payload);
    }

    @Override
    public int headerSize() {
        return 68;
    }

    @Override
    public ByteBuffer encryptHeader(FileHeader header) {
        FileHeaderImpl headerImpl = FileHeaderImpl.cast(header);
        ByteBuffer payloadCleartextBuf = headerImpl.getPayload().encode();
        try {
            DestroyableSecretKey ek = this.masterkey.getEncKey();
            try {
                ByteBuffer result = ByteBuffer.allocate(68);
                result.put(headerImpl.getNonce());
                Cipher cipher = CipherSupplier.AES_GCM.forEncryption(ek, new GCMParameterSpec(128, headerImpl.getNonce()));
                int encrypted = cipher.doFinal(payloadCleartextBuf, result);
                assert (encrypted == 56);
                result.flip();
                ByteBuffer byteBuffer = result;
                if (ek != null) {
                    ek.close();
                }
                return byteBuffer;
            }
            catch (Throwable throwable) {
                try {
                    if (ek != null) {
                        try {
                            ek.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ShortBufferException e) {
                    throw new IllegalStateException("Result buffer too small for encrypted header payload.", e);
                }
                catch (BadPaddingException | IllegalBlockSizeException e) {
                    throw new IllegalStateException("Unexpected exception during GCM encryption.", e);
                }
            }
        }
        finally {
            Arrays.fill(payloadCleartextBuf.array(), (byte)0);
        }
    }

    @Override
    public FileHeader decryptHeader(ByteBuffer ciphertextHeaderBuf) throws AuthenticationFailedException {
        if (ciphertextHeaderBuf.remaining() < 68) {
            throw new IllegalArgumentException("Malformed ciphertext header");
        }
        ByteBuffer buf = ciphertextHeaderBuf.asReadOnlyBuffer();
        byte[] nonce = new byte[12];
        buf.position(0);
        buf.get(nonce);
        byte[] ciphertextAndTag = new byte[56];
        buf.position(12);
        buf.get(ciphertextAndTag);
        ByteBuffer payloadCleartextBuf = ByteBuffer.allocate(56);
        try {
            DestroyableSecretKey ek = this.masterkey.getEncKey();
            try {
                Cipher cipher = CipherSupplier.AES_GCM.forDecryption(ek, new GCMParameterSpec(128, nonce));
                int decrypted = cipher.doFinal(ByteBuffer.wrap(ciphertextAndTag), payloadCleartextBuf);
                assert (decrypted == 40);
                payloadCleartextBuf.flip();
                FileHeaderImpl.Payload payload = FileHeaderImpl.Payload.decode(payloadCleartextBuf);
                FileHeaderImpl fileHeaderImpl = new FileHeaderImpl(nonce, payload);
                if (ek != null) {
                    ek.close();
                }
                return fileHeaderImpl;
            }
            catch (Throwable throwable) {
                try {
                    if (ek != null) {
                        try {
                            ek.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (AEADBadTagException e) {
                    throw new AuthenticationFailedException("Header tag mismatch.", e);
                }
                catch (ShortBufferException e) {
                    throw new IllegalStateException("Result buffer too small for decrypted header payload.", e);
                }
                catch (BadPaddingException | IllegalBlockSizeException e) {
                    throw new IllegalStateException("Unexpected exception during GCM decryption.", e);
                }
            }
        }
        finally {
            Arrays.fill(payloadCleartextBuf.array(), (byte)0);
        }
    }
}

