/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.frontend.fuse.locks;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.function.Function;
import org.cryptomator.frontend.fuse.locks.AlreadyLockedException;
import org.cryptomator.frontend.fuse.locks.PathLock;
import org.cryptomator.frontend.fuse.locks.PathLockImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PathWLockImpl
extends PathLockImpl {
    private static final Logger LOG = LoggerFactory.getLogger(PathWLockImpl.class);

    private PathWLockImpl(List<String> pathComponents, Optional<PathLock> parent, ReadWriteLock lock, Function<List<String>, ReadWriteLock> dataLockSupplier) {
        super(pathComponents, parent, lock, dataLockSupplier);
    }

    public static PathLockImpl create(List<String> pathComponents, Optional<PathLock> parent, ReadWriteLock lock, Function<List<String>, ReadWriteLock> dataLockSupplier) {
        lock.writeLock().lock();
        LOG.trace("Acquired write path lock for '{}'", pathComponents);
        return new PathWLockImpl(pathComponents, parent, lock, dataLockSupplier);
    }

    public static PathLockImpl attempt(List<String> pathComponents, Optional<PathLock> parent, ReadWriteLock lock, Function<List<String>, ReadWriteLock> dataLockSupplier) throws AlreadyLockedException {
        if (!lock.writeLock().tryLock()) {
            throw new AlreadyLockedException();
        }
        LOG.trace("Acquired write path lock for '{}'", pathComponents);
        return new PathWLockImpl(pathComponents, parent, lock, dataLockSupplier);
    }

    @Override
    public void close() {
        LOG.trace("Released write path lock for '{}'", (Object)this.pathComponents);
        this.lock.writeLock().unlock();
        super.close();
    }
}

