/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.frontend.fuse;

import java.nio.file.Path;
import org.cryptomator.frontend.fuse.DaggerFuseNioAdapterComponent;
import org.cryptomator.frontend.fuse.FileNameTranscoder;
import org.cryptomator.frontend.fuse.FuseNioAdapter;
import org.cryptomator.frontend.fuse.FuseNioAdapterComponent;

public class AdapterFactory {
    public static final int DEFAULT_MAX_FILENAMELENGTH = 254;

    private AdapterFactory() {
    }

    public static FuseNioAdapter createReadOnlyAdapter(Path root) {
        return AdapterFactory.createReadOnlyAdapter(root, 254, FileNameTranscoder.transcoder());
    }

    public static FuseNioAdapter createReadOnlyAdapter(Path root, int maxFileNameLength, FileNameTranscoder fileNameTranscoder) {
        FuseNioAdapterComponent comp = DaggerFuseNioAdapterComponent.builder().root(root).maxFileNameLength(maxFileNameLength).fileNameTranscoder(fileNameTranscoder).build();
        return comp.readOnlyAdapter();
    }

    public static FuseNioAdapter createReadWriteAdapter(Path root) {
        return AdapterFactory.createReadWriteAdapter(root, 254);
    }

    public static FuseNioAdapter createReadWriteAdapter(Path root, int maxFileNameLength) {
        return AdapterFactory.createReadWriteAdapter(root, maxFileNameLength, FileNameTranscoder.transcoder());
    }

    public static FuseNioAdapter createReadWriteAdapter(Path root, int maxFileNameLength, FileNameTranscoder fileNameTranscoder) {
        FuseNioAdapterComponent comp = DaggerFuseNioAdapterComponent.builder().root(root).maxFileNameLength(maxFileNameLength).fileNameTranscoder(fileNameTranscoder).build();
        return comp.readWriteAdapter();
    }
}

