/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.ui.recoverykey;

import dagger.Lazy;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.StringProperty;
import javafx.concurrent.Task;
import javafx.fxml.FXML;
import javafx.scene.Scene;
import javafx.stage.Stage;
import javax.inject.Inject;
import org.cryptomator.common.vaults.Vault;
import org.cryptomator.ui.common.ErrorComponent;
import org.cryptomator.ui.common.FxController;
import org.cryptomator.ui.common.FxmlFile;
import org.cryptomator.ui.common.FxmlScene;
import org.cryptomator.ui.common.NewPasswordController;
import org.cryptomator.ui.recoverykey.RecoveryKeyFactory;
import org.cryptomator.ui.recoverykey.RecoveryKeyScoped;
import org.cryptomator.ui.recoverykey.RecoveryKeyWindow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RecoveryKeyScoped
public class RecoveryKeyResetPasswordController
implements FxController {
    private static final Logger LOG = LoggerFactory.getLogger(RecoveryKeyResetPasswordController.class);
    private final Stage window;
    private final Vault vault;
    private final RecoveryKeyFactory recoveryKeyFactory;
    private final ExecutorService executor;
    private final StringProperty recoveryKey;
    private final Lazy<Scene> recoverScene;
    private final ErrorComponent.Builder errorComponent;
    public NewPasswordController newPasswordController;

    @Inject
    public RecoveryKeyResetPasswordController(@RecoveryKeyWindow Stage window, @RecoveryKeyWindow Vault vault, RecoveryKeyFactory recoveryKeyFactory, ExecutorService executor, @RecoveryKeyWindow StringProperty recoveryKey, @FxmlScene(value=FxmlFile.RECOVERYKEY_RECOVER) Lazy<Scene> recoverScene, ErrorComponent.Builder errorComponent) {
        this.window = window;
        this.vault = vault;
        this.recoveryKeyFactory = recoveryKeyFactory;
        this.executor = executor;
        this.recoveryKey = recoveryKey;
        this.recoverScene = recoverScene;
        this.errorComponent = errorComponent;
    }

    @FXML
    public void back() {
        this.window.setScene((Scene)this.recoverScene.get());
    }

    @FXML
    public void done() {
        ResetPasswordTask task = new ResetPasswordTask();
        task.setOnScheduled(event -> LOG.debug("Using recovery key to reset password for {}.", (Object)this.vault.getDisplayablePath()));
        task.setOnSucceeded(event -> {
            LOG.info("Used recovery key to reset password for {}.", (Object)this.vault.getDisplayablePath());
            this.window.close();
        });
        task.setOnFailed(event -> {
            LOG.error("Resetting password failed.", task.getException());
            this.errorComponent.cause(task.getException()).window(this.window).returnToScene((Scene)this.recoverScene.get()).build().showErrorScene();
        });
        this.executor.submit((Runnable)((Object)task));
    }

    public ReadOnlyBooleanProperty validPasswordProperty() {
        return this.newPasswordController.goodPasswordProperty();
    }

    public boolean isValidPassword() {
        return this.newPasswordController.isGoodPassword();
    }

    private class ResetPasswordTask
    extends Task<Void> {
        private ResetPasswordTask() {
            this.setOnFailed(event -> LOG.error("Failed to reset password", this.getException()));
        }

        protected Void call() throws IOException, IllegalArgumentException {
            RecoveryKeyResetPasswordController.this.recoveryKeyFactory.resetPasswordWithRecoveryKey(RecoveryKeyResetPasswordController.this.vault.getPath(), (String)RecoveryKeyResetPasswordController.this.recoveryKey.get(), RecoveryKeyResetPasswordController.this.newPasswordController.passwordField.getCharacters());
            return null;
        }
    }
}

