/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.ui.preferences;

import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableStringValue;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.Button;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.TextField;
import javafx.util.StringConverter;
import javax.inject.Inject;
import org.apache.commons.lang3.SystemUtils;
import org.cryptomator.common.settings.Settings;
import org.cryptomator.common.settings.VolumeImpl;
import org.cryptomator.common.settings.WebDavUrlScheme;
import org.cryptomator.common.vaults.Volume;
import org.cryptomator.ui.common.FxController;
import org.cryptomator.ui.preferences.PreferencesScoped;

@PreferencesScoped
public class VolumePreferencesController
implements FxController {
    private final Settings settings;
    private final BooleanBinding showWebDavSettings;
    private final BooleanBinding showWebDavScheme;
    public ChoiceBox<VolumeImpl> volumeTypeChoiceBox;
    public TextField webDavPortField;
    public Button changeWebDavPortButton;
    public ChoiceBox<WebDavUrlScheme> webDavUrlSchemeChoiceBox;

    @Inject
    VolumePreferencesController(Settings settings) {
        this.settings = settings;
        this.showWebDavSettings = Bindings.equal(settings.preferredVolumeImpl(), (Object)((Object)VolumeImpl.WEBDAV));
        this.showWebDavScheme = this.showWebDavSettings.and((ObservableBooleanValue)new SimpleBooleanProperty(SystemUtils.IS_OS_LINUX));
    }

    public void initialize() {
        this.volumeTypeChoiceBox.getItems().addAll((Object[])Volume.getCurrentSupportedAdapters());
        if (!this.volumeTypeChoiceBox.getItems().contains(this.settings.preferredVolumeImpl().get())) {
            this.settings.preferredVolumeImpl().set((Object)VolumeImpl.WEBDAV);
        }
        this.volumeTypeChoiceBox.valueProperty().bindBidirectional(this.settings.preferredVolumeImpl());
        this.volumeTypeChoiceBox.setConverter((StringConverter)new VolumeImplConverter());
        this.webDavPortField.setText(String.valueOf(this.settings.port().get()));
        this.changeWebDavPortButton.visibleProperty().bind((ObservableValue)this.settings.port().asString().isNotEqualTo((ObservableStringValue)this.webDavPortField.textProperty()));
        this.changeWebDavPortButton.disableProperty().bind((ObservableValue)Bindings.createBooleanBinding(this::validateWebDavPort, (Observable[])new Observable[]{this.webDavPortField.textProperty()}).not());
        this.webDavUrlSchemeChoiceBox.getItems().addAll((Object[])WebDavUrlScheme.values());
        this.webDavUrlSchemeChoiceBox.valueProperty().bindBidirectional(this.settings.preferredGvfsScheme());
        this.webDavUrlSchemeChoiceBox.setConverter((StringConverter)new WebDavUrlSchemeConverter());
    }

    private boolean validateWebDavPort() {
        try {
            int port = Integer.parseInt(this.webDavPortField.getText());
            return port == 0 || port >= 1024 && port <= 65535;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public void doChangeWebDavPort() {
        this.settings.port().set(Integer.parseInt(this.webDavPortField.getText()));
    }

    public BooleanBinding showWebDavSettingsProperty() {
        return this.showWebDavSettings;
    }

    public Boolean getShowWebDavSettings() {
        return this.showWebDavSettings.get();
    }

    public BooleanBinding showWebDavSchemeProperty() {
        return this.showWebDavScheme;
    }

    public Boolean getShowWebDavScheme() {
        return this.showWebDavScheme.get();
    }

    private static class VolumeImplConverter
    extends StringConverter<VolumeImpl> {
        private VolumeImplConverter() {
        }

        public String toString(VolumeImpl impl) {
            return impl.getDisplayName();
        }

        public VolumeImpl fromString(String string) {
            throw new UnsupportedOperationException();
        }
    }

    private static class WebDavUrlSchemeConverter
    extends StringConverter<WebDavUrlScheme> {
        private WebDavUrlSchemeConverter() {
        }

        public String toString(WebDavUrlScheme scheme) {
            return scheme.getDisplayName();
        }

        public WebDavUrlScheme fromString(String string) {
            throw new UnsupportedOperationException();
        }
    }
}

