/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.ui.preferences;

import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.ObjectProperty;
import javafx.fxml.FXML;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.stage.Stage;
import javafx.stage.WindowEvent;
import javax.inject.Inject;
import org.cryptomator.ui.common.FxController;
import org.cryptomator.ui.fxapp.UpdateChecker;
import org.cryptomator.ui.preferences.PreferencesScoped;
import org.cryptomator.ui.preferences.PreferencesWindow;
import org.cryptomator.ui.preferences.SelectedPreferencesTab;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PreferencesScoped
public class PreferencesController
implements FxController {
    private static final Logger LOG = LoggerFactory.getLogger(PreferencesController.class);
    private final Stage window;
    private final ObjectProperty<SelectedPreferencesTab> selectedTabProperty;
    private final BooleanBinding updateAvailable;
    public TabPane tabPane;
    public Tab generalTab;
    public Tab volumeTab;
    public Tab updatesTab;
    public Tab contributeTab;
    public Tab aboutTab;

    @Inject
    public PreferencesController(@PreferencesWindow Stage window, ObjectProperty<SelectedPreferencesTab> selectedTabProperty, UpdateChecker updateChecker) {
        this.window = window;
        this.selectedTabProperty = selectedTabProperty;
        this.updateAvailable = updateChecker.latestVersionProperty().isNotNull();
    }

    @FXML
    public void initialize() {
        this.window.setOnShowing(this::windowWillAppear);
        this.selectedTabProperty.addListener(observable -> this.selectChosenTab());
        this.tabPane.getSelectionModel().selectedItemProperty().addListener(observable -> this.selectedTabChanged());
    }

    private void selectChosenTab() {
        Tab toBeSelected = this.getTabToSelect((SelectedPreferencesTab)((Object)this.selectedTabProperty.get()));
        this.tabPane.getSelectionModel().select((Object)toBeSelected);
    }

    private Tab getTabToSelect(SelectedPreferencesTab selectedTab) {
        return switch (selectedTab) {
            default -> throw new IncompatibleClassChangeError();
            case SelectedPreferencesTab.UPDATES -> this.updatesTab;
            case SelectedPreferencesTab.VOLUME -> this.volumeTab;
            case SelectedPreferencesTab.CONTRIBUTE -> this.contributeTab;
            case SelectedPreferencesTab.GENERAL -> this.generalTab;
            case SelectedPreferencesTab.ABOUT -> this.aboutTab;
            case SelectedPreferencesTab.ANY -> this.updateAvailable.get() ? this.updatesTab : this.generalTab;
        };
    }

    private void selectedTabChanged() {
        Tab selectedTab = (Tab)this.tabPane.getSelectionModel().getSelectedItem();
        try {
            SelectedPreferencesTab selectedPreferencesTab = SelectedPreferencesTab.valueOf(selectedTab.getId());
            this.selectedTabProperty.set((Object)selectedPreferencesTab);
        }
        catch (IllegalArgumentException e) {
            LOG.error("Unknown preferences tab id: {}", (Object)selectedTab.getId());
        }
    }

    private void windowWillAppear(WindowEvent windowEvent) {
        this.selectChosenTab();
    }
}

