/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.ui.mainwindow;

import java.io.File;
import java.util.ResourceBundle;
import javafx.beans.property.ObjectProperty;
import javafx.fxml.FXML;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import javax.inject.Inject;
import org.cryptomator.common.vaults.Vault;
import org.cryptomator.common.vaults.VaultListManager;
import org.cryptomator.ui.common.FxController;
import org.cryptomator.ui.mainwindow.MainWindow;
import org.cryptomator.ui.mainwindow.MainWindowScoped;
import org.cryptomator.ui.removevault.RemoveVaultComponent;

@MainWindowScoped
public class VaultDetailMissingVaultController
implements FxController {
    private final ObjectProperty<Vault> vault;
    private final RemoveVaultComponent.Builder removeVault;
    private final ResourceBundle resourceBundle;
    private final Stage window;

    @Inject
    public VaultDetailMissingVaultController(ObjectProperty<Vault> vault, RemoveVaultComponent.Builder removeVault, ResourceBundle resourceBundle, @MainWindow Stage window) {
        this.vault = vault;
        this.removeVault = removeVault;
        this.resourceBundle = resourceBundle;
        this.window = window;
    }

    @FXML
    public void recheck() {
        VaultListManager.redetermineVaultState((Vault)this.vault.get());
    }

    @FXML
    void didClickRemoveVault() {
        this.removeVault.vault((Vault)this.vault.get()).build().showRemoveVault();
    }

    @FXML
    void changeLocation() {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle(this.resourceBundle.getString("addvaultwizard.existing.filePickerTitle"));
        fileChooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("Cryptomator Masterkey", new String[]{"*.cryptomator"}));
        File masterkeyFile = fileChooser.showOpenDialog((Window)this.window);
        if (masterkeyFile != null) {
            ((Vault)this.vault.get()).getVaultSettings().path().setValue((Object)masterkeyFile.toPath().toAbsolutePath().getParent());
            this.recheck();
        }
    }
}

