/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.ui.health;

import com.tobiasdiez.easybind.EasyBind;
import com.tobiasdiez.easybind.Subscription;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import javafx.animation.Animation;
import javafx.animation.SequentialTransition;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.Binding;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableObjectValue;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Tooltip;
import javafx.util.Duration;
import javax.inject.Inject;
import org.cryptomator.cryptofs.health.api.DiagnosticResult;
import org.cryptomator.ui.common.Animations;
import org.cryptomator.ui.common.AutoAnimator;
import org.cryptomator.ui.common.FxController;
import org.cryptomator.ui.controls.FontAwesome5Icon;
import org.cryptomator.ui.controls.FontAwesome5IconView;
import org.cryptomator.ui.health.Result;
import org.cryptomator.ui.health.ResultFixApplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResultListCellController
implements FxController {
    private static final FontAwesome5Icon INFO_ICON = FontAwesome5Icon.INFO_CIRCLE;
    private static final FontAwesome5Icon GOOD_ICON = FontAwesome5Icon.CHECK;
    private static final FontAwesome5Icon WARN_ICON = FontAwesome5Icon.EXCLAMATION_TRIANGLE;
    private static final FontAwesome5Icon CRIT_ICON = FontAwesome5Icon.TIMES;
    private final Logger LOG = LoggerFactory.getLogger(ResultListCellController.class);
    private final ObjectProperty<Result> result = new SimpleObjectProperty(null);
    private final ObservableObjectValue<DiagnosticResult.Severity> severity = EasyBind.wrapNullable(this.result).map(r -> r.diagnosis().getSeverity()).asOrdinary();
    private final Binding<String> description = EasyBind.wrapNullable(this.result).map(Result::getDescription).orElse((Object)"");
    private final ResultFixApplier fixApplier;
    private final ObservableObjectValue<Result.FixState> fixState;
    private final ObjectBinding<FontAwesome5Icon> severityGlyph;
    private final ObjectBinding<FontAwesome5Icon> fixGlyph;
    private final BooleanBinding fixable;
    private final BooleanBinding fixing;
    private final BooleanBinding fixed;
    private final BooleanBinding fixFailed;
    private final BooleanBinding fixRunningOrDone;
    private final List<Subscription> subscriptions;
    private final Tooltip fixSuccess;
    private final Tooltip fixFail;
    private AutoAnimator fixRunningRotator;
    public FontAwesome5IconView severityView;
    public FontAwesome5IconView fixView;

    @Inject
    public ResultListCellController(ResultFixApplier fixApplier, ResourceBundle resourceBundle) {
        this.fixApplier = fixApplier;
        this.fixState = EasyBind.wrapNullable(this.result).mapObservable(Result::fixState).asOrdinary();
        this.severityGlyph = Bindings.createObjectBinding(this::getSeverityGlyph, (Observable[])new Observable[]{this.result});
        this.fixGlyph = Bindings.createObjectBinding(this::getFixGlyph, (Observable[])new Observable[]{this.fixState});
        this.fixable = Bindings.createBooleanBinding(this::isFixable, (Observable[])new Observable[]{this.fixState});
        this.fixing = Bindings.createBooleanBinding(this::isFixing, (Observable[])new Observable[]{this.fixState});
        this.fixed = Bindings.createBooleanBinding(this::isFixed, (Observable[])new Observable[]{this.fixState});
        this.fixFailed = Bindings.createBooleanBinding(this::isFixFailed, (Observable[])new Observable[]{this.fixState});
        this.fixRunningOrDone = this.fixing.or((ObservableBooleanValue)this.fixed).or((ObservableBooleanValue)this.fixFailed);
        this.subscriptions = new ArrayList<Subscription>();
        this.fixSuccess = new Tooltip(resourceBundle.getString("health.fix.successTip"));
        this.fixFail = new Tooltip(resourceBundle.getString("health.fix.failTip"));
        this.fixSuccess.setShowDelay(Duration.millis((double)100.0));
        this.fixFail.setShowDelay(Duration.millis((double)100.0));
    }

    @FXML
    public void initialize() {
        this.subscriptions.addAll(List.of(EasyBind.includeWhen((Collection)this.severityView.getStyleClass(), (Object)"glyph-icon-muted", (ObservableValue)Bindings.equal(this.severity, (Object)DiagnosticResult.Severity.INFO)), EasyBind.includeWhen((Collection)this.severityView.getStyleClass(), (Object)"glyph-icon-primary", (ObservableValue)Bindings.equal(this.severity, (Object)DiagnosticResult.Severity.GOOD)), EasyBind.includeWhen((Collection)this.severityView.getStyleClass(), (Object)"glyph-icon-orange", (ObservableValue)Bindings.equal(this.severity, (Object)DiagnosticResult.Severity.WARN)), EasyBind.includeWhen((Collection)this.severityView.getStyleClass(), (Object)"glyph-icon-red", (ObservableValue)Bindings.equal(this.severity, (Object)DiagnosticResult.Severity.CRITICAL))));
        SequentialTransition animation = Animations.createDiscrete360Rotation((Node)this.fixView);
        this.fixRunningRotator = AutoAnimator.animate((Animation)animation).onCondition((ObservableValue<Boolean>)Bindings.equal(this.fixState, (Object)((Object)Result.FixState.FIXING))).afterStop(() -> this.fixView.setRotate(0.0)).build();
    }

    @FXML
    public void fix() {
        Result r = (Result)this.result.get();
        if (r != null) {
            this.fixApplier.fix(r).whenCompleteAsync(this::fixFinished, Platform::runLater);
        }
    }

    private void fixFinished(Void unused, Throwable exception) {
        if (exception != null) {
            this.LOG.error("Failed to apply fix", exception);
            Tooltip.install((Node)this.fixView, (Tooltip)this.fixFail);
        } else {
            Tooltip.install((Node)this.fixView, (Tooltip)this.fixSuccess);
        }
    }

    public Result getResult() {
        return (Result)this.result.get();
    }

    public void setResult(Result result) {
        this.result.set((Object)result);
    }

    public ObjectProperty<Result> resultProperty() {
        return this.result;
    }

    public Binding<String> descriptionProperty() {
        return this.description;
    }

    public String getDescription() {
        return (String)this.description.getValue();
    }

    public ObjectBinding<FontAwesome5Icon> severityGlyphProperty() {
        return this.severityGlyph;
    }

    public FontAwesome5Icon getSeverityGlyph() {
        Result r = (Result)this.result.get();
        if (r == null) {
            return null;
        }
        return switch (r.diagnosis().getSeverity()) {
            default -> throw new IncompatibleClassChangeError();
            case DiagnosticResult.Severity.INFO -> INFO_ICON;
            case DiagnosticResult.Severity.GOOD -> GOOD_ICON;
            case DiagnosticResult.Severity.WARN -> WARN_ICON;
            case DiagnosticResult.Severity.CRITICAL -> CRIT_ICON;
        };
    }

    public ObjectBinding<FontAwesome5Icon> fixGlyphProperty() {
        return this.fixGlyph;
    }

    public FontAwesome5Icon getFixGlyph() {
        if (this.fixState.getValue() == null) {
            return null;
        }
        return switch ((Result.FixState)((Object)this.fixState.getValue())) {
            default -> throw new IncompatibleClassChangeError();
            case Result.FixState.NOT_FIXABLE, Result.FixState.FIXABLE -> null;
            case Result.FixState.FIXING -> FontAwesome5Icon.SPINNER;
            case Result.FixState.FIXED -> FontAwesome5Icon.CHECK;
            case Result.FixState.FIX_FAILED -> FontAwesome5Icon.TIMES;
        };
    }

    public BooleanBinding fixableProperty() {
        return this.fixable;
    }

    public boolean isFixable() {
        return Result.FixState.FIXABLE.equals(this.fixState.get());
    }

    public BooleanBinding fixingProperty() {
        return this.fixing;
    }

    public boolean isFixing() {
        return Result.FixState.FIXING.equals(this.fixState.get());
    }

    public BooleanBinding fixedProperty() {
        return this.fixed;
    }

    public boolean isFixed() {
        return Result.FixState.FIXED.equals(this.fixState.get());
    }

    public BooleanBinding fixFailedProperty() {
        return this.fixFailed;
    }

    public Boolean isFixFailed() {
        return Result.FixState.FIX_FAILED.equals(this.fixState.get());
    }

    public BooleanBinding fixRunningOrDoneProperty() {
        return this.fixRunningOrDone;
    }

    public boolean isFixRunningOrDone() {
        return this.fixRunningOrDone.get();
    }
}

