/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.ui.common;

import dagger.BindsInstance;
import dagger.Subcomponent;
import javafx.application.Platform;
import javafx.scene.Scene;
import javafx.stage.Stage;
import org.cryptomator.common.Nullable;
import org.cryptomator.ui.common.ErrorModule;
import org.cryptomator.ui.common.FxmlFile;
import org.cryptomator.ui.common.FxmlScene;

@Subcomponent(modules={ErrorModule.class})
public interface ErrorComponent {
    public Stage window();

    @FxmlScene(value=FxmlFile.ERROR)
    public Scene scene();

    default public void showErrorScene() {
        if (Platform.isFxApplicationThread()) {
            this.show();
        } else {
            Platform.runLater(this::show);
        }
    }

    private void show() {
        Stage stage = this.window();
        stage.setScene(this.scene());
        stage.show();
    }

    @Subcomponent.Builder
    public static interface Builder {
        @BindsInstance
        public Builder cause(Throwable var1);

        @BindsInstance
        public Builder window(Stage var1);

        @BindsInstance
        public Builder returnToScene(@Nullable Scene var1);

        public ErrorComponent build();
    }
}

