/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.ui.addvaultwizard;

import dagger.Lazy;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ResourceBundle;
import javafx.beans.property.ObjectProperty;
import javafx.fxml.FXML;
import javafx.scene.Scene;
import javafx.scene.image.Image;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import javax.inject.Inject;
import org.apache.commons.lang3.SystemUtils;
import org.cryptomator.common.vaults.Vault;
import org.cryptomator.common.vaults.VaultListManager;
import org.cryptomator.ui.addvaultwizard.AddVaultWizardScoped;
import org.cryptomator.ui.addvaultwizard.AddVaultWizardWindow;
import org.cryptomator.ui.common.ErrorComponent;
import org.cryptomator.ui.common.FxController;
import org.cryptomator.ui.common.FxmlFile;
import org.cryptomator.ui.common.FxmlScene;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AddVaultWizardScoped
public class ChooseExistingVaultController
implements FxController {
    private static final Logger LOG = LoggerFactory.getLogger(ChooseExistingVaultController.class);
    private final Stage window;
    private final Lazy<Scene> welcomeScene;
    private final Lazy<Scene> successScene;
    private final ErrorComponent.Builder errorComponent;
    private final ObjectProperty<Path> vaultPath;
    private final ObjectProperty<Vault> vault;
    private final VaultListManager vaultListManager;
    private final ResourceBundle resourceBundle;
    private Image screenshot;

    @Inject
    ChooseExistingVaultController(@AddVaultWizardWindow Stage window, @FxmlScene(value=FxmlFile.ADDVAULT_WELCOME) Lazy<Scene> welcomeScene, @FxmlScene(value=FxmlFile.ADDVAULT_SUCCESS) Lazy<Scene> successScene, ErrorComponent.Builder errorComponent, ObjectProperty<Path> vaultPath, @AddVaultWizardWindow ObjectProperty<Vault> vault, VaultListManager vaultListManager, ResourceBundle resourceBundle) {
        this.window = window;
        this.welcomeScene = welcomeScene;
        this.successScene = successScene;
        this.errorComponent = errorComponent;
        this.vaultPath = vaultPath;
        this.vault = vault;
        this.vaultListManager = vaultListManager;
        this.resourceBundle = resourceBundle;
    }

    @FXML
    public void initialize() {
        this.screenshot = SystemUtils.IS_OS_MAC ? new Image(this.getClass().getResource("/img/select-masterkey-mac.png").toString()) : new Image(this.getClass().getResource("/img/select-masterkey-win.png").toString());
    }

    @FXML
    public void back() {
        this.window.setScene((Scene)this.welcomeScene.get());
    }

    @FXML
    public void chooseFileAndNext() {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle(this.resourceBundle.getString("addvaultwizard.existing.filePickerTitle"));
        fileChooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("Cryptomator Vault", new String[]{"*.cryptomator"}));
        File masterkeyFile = fileChooser.showOpenDialog((Window)this.window);
        if (masterkeyFile != null) {
            this.vaultPath.setValue((Object)masterkeyFile.toPath().toAbsolutePath().getParent());
            try {
                Vault newVault = this.vaultListManager.add((Path)this.vaultPath.get());
                this.vault.set((Object)newVault);
                this.window.setScene((Scene)this.successScene.get());
            }
            catch (IOException e) {
                LOG.error("Failed to open existing vault.", (Throwable)e);
                this.errorComponent.cause(e).window(this.window).returnToScene(this.window.getScene()).build().showErrorScene();
            }
        }
    }

    public Image getScreenshot() {
        return this.screenshot;
    }
}

