/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.common.mountpoint;

import java.io.IOException;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NotDirectoryException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import javax.inject.Inject;
import org.apache.commons.lang3.SystemUtils;
import org.cryptomator.common.Environment;
import org.cryptomator.common.mountpoint.InvalidMountPointException;
import org.cryptomator.common.mountpoint.MountPointChooser;
import org.cryptomator.common.settings.VaultSettings;
import org.cryptomator.common.settings.VolumeImpl;
import org.cryptomator.common.vaults.Volume;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CustomMountPointChooser
implements MountPointChooser {
    private static final Logger LOG = LoggerFactory.getLogger(CustomMountPointChooser.class);
    private final VaultSettings vaultSettings;
    private final Environment environment;

    @Inject
    public CustomMountPointChooser(VaultSettings vaultSettings, Environment environment) {
        this.vaultSettings = vaultSettings;
        this.environment = environment;
    }

    @Override
    public boolean isApplicable(Volume caller) {
        return caller.getImplementationType() != VolumeImpl.FUSE || !SystemUtils.IS_OS_WINDOWS || this.environment.useExperimentalFuse();
    }

    @Override
    public Optional<Path> chooseMountPoint(Volume caller) {
        return this.vaultSettings.getCustomMountPath().map(x$0 -> Paths.get(x$0, new String[0]));
    }

    @Override
    public boolean prepare(Volume caller, Path mountPoint) throws InvalidMountPointException {
        switch (caller.getMountPointRequirement()) {
            case PARENT_NO_MOUNT_POINT: {
                this.prepareParentNoMountPoint(mountPoint);
                break;
            }
            case EMPTY_MOUNT_POINT: {
                this.prepareEmptyMountPoint(mountPoint);
                break;
            }
            case NONE: {
                throw new InvalidMountPointException(new IllegalStateException("Illegal MountPointRequirement"));
            }
            default: {
                throw new InvalidMountPointException(new IllegalStateException("Not implemented"));
            }
        }
        LOG.debug("Successfully checked custom mount point: {}", (Object)mountPoint);
        return false;
    }

    private void prepareParentNoMountPoint(Path mountPoint) throws InvalidMountPointException {
        Path parent = mountPoint.getParent();
        if (!Files.isDirectory(parent, new LinkOption[0])) {
            throw new InvalidMountPointException(new NotDirectoryException(parent.toString()));
        }
        if (!Files.notExists(mountPoint, LinkOption.NOFOLLOW_LINKS)) {
            throw new InvalidMountPointException(new FileAlreadyExistsException(mountPoint.toString()));
        }
    }

    private void prepareEmptyMountPoint(Path mountPoint) throws InvalidMountPointException {
        if (!Files.isDirectory(mountPoint, new LinkOption[0])) {
            throw new InvalidMountPointException(new NotDirectoryException(mountPoint.toString()));
        }
        try (DirectoryStream<Path> ds = Files.newDirectoryStream(mountPoint);){
            if (ds.iterator().hasNext()) {
                throw new InvalidMountPointException(new DirectoryNotEmptyException(mountPoint.toString()));
            }
        }
        catch (IOException exception) {
            throw new InvalidMountPointException("IOException while checking folder content", exception);
        }
    }
}

