/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.util.ImageUtil;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.media.jai.ColormapOpImage;
import javax.media.jai.ImageLayout;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFormatTag;

final class RescaleOpImage
extends ColormapOpImage {
    protected double[] constants;
    protected double[] offsets;
    private byte[][] byteTable = null;
    static final int numProc = Runtime.getRuntime().availableProcessors();

    private synchronized void initByteTable() {
        if (this.byteTable != null) {
            return;
        }
        int nbands = this.constants.length;
        this.byteTable = new byte[nbands][256];
        for (int band = 0; band < nbands; ++band) {
            byte[] t = this.byteTable[band];
            double c = this.constants[band];
            double o = this.offsets[band];
            for (int i = 0; i < 256; ++i) {
                t[i] = ImageUtil.clampRoundByte((double)i * c + o);
            }
        }
    }

    public RescaleOpImage(RenderedImage source, Map config, ImageLayout layout, double[] constants, double[] offsets) {
        super(source, layout, config, true);
        int i;
        int numBands = this.getSampleModel().getNumBands();
        if (constants.length < numBands) {
            this.constants = new double[numBands];
            for (i = 0; i < numBands; ++i) {
                this.constants[i] = constants[0];
            }
        } else {
            this.constants = constants;
        }
        if (offsets.length < numBands) {
            this.offsets = new double[numBands];
            for (i = 0; i < numBands; ++i) {
                this.offsets[i] = offsets[0];
            }
        } else {
            this.offsets = offsets;
        }
        this.permitInPlaceOperation();
        this.initializeColormapOperation();
    }

    @Override
    protected void transformColormap(byte[][] colormap) {
        for (int b = 0; b < 3; ++b) {
            byte[] map = colormap[b];
            int mapSize = map.length;
            float c = (float)(b < this.constants.length ? this.constants[b] : this.constants[0]);
            float o = (float)(b < this.constants.length ? this.offsets[b] : this.offsets[0]);
            for (int i = 0; i < mapSize; ++i) {
                map[i] = ImageUtil.clampRoundByte((float)(map[i] & 0xFF) * c + o);
            }
        }
    }

    @Override
    protected void computeRect(Raster[] sources, WritableRaster dest, Rectangle destRect) {
        RasterFormatTag[] formatTags = this.getFormatTags();
        Rectangle srcRect = this.mapDestRect(destRect, 0);
        RasterAccessor dst = new RasterAccessor(dest, destRect, formatTags[1], this.getColorModel());
        RasterAccessor src = new RasterAccessor(sources[0], srcRect, formatTags[0], this.getSourceImage(0).getColorModel());
        switch (dst.getDataType()) {
            case 0: {
                this.computeRectByte(src, dst);
                break;
            }
            case 1: {
                this.computeRectUShort(src, dst);
                break;
            }
            case 2: {
                this.computeRectShort(src, dst);
                break;
            }
            case 3: {
                this.computeRectInt(src, dst);
                break;
            }
            case 4: {
                this.computeRectFloat(src, dst);
                break;
            }
            case 5: {
                this.computeRectDouble(src, dst);
            }
        }
        if (dst.needsClamping()) {
            dst.clampDataArrays();
        }
        dst.copyDataToRaster();
    }

    private void computeRectByte(RasterAccessor src, RasterAccessor dst) {
        final int dstWidth = dst.getWidth();
        int dstHeight = dst.getHeight();
        int dstBands = dst.getNumBands();
        final int dstLineStride = dst.getScanlineStride();
        final int dstPixelStride = dst.getPixelStride();
        int[] dstBandOffsets = dst.getBandOffsets();
        byte[][] dstData = dst.getByteDataArrays();
        final int srcLineStride = src.getScanlineStride();
        final int srcPixelStride = src.getPixelStride();
        int[] srcBandOffsets = src.getBandOffsets();
        byte[][] srcData = src.getByteDataArrays();
        this.initByteTable();
        ExecutorService threadPool = Executors.newFixedThreadPool(numProc);
        LinkedList<1> processes = new LinkedList<1>();
        for (int band = 0; band < dstBands; ++band) {
            final byte[] s = srcData[band];
            final byte[] d = dstData[band];
            final int dstLineOffset = dstBandOffsets[band];
            final int srcLineOffset = srcBandOffsets[band];
            final byte[] clamp = this.byteTable[band];
            int h = 0;
            while (h < dstHeight) {
                final int hh = h++;
                processes.add(new Callable<Void>(){

                    @Override
                    public Void call() {
                        int dstPixelOffset = dstLineOffset + hh * dstLineStride;
                        int srcPixelOffset = srcLineOffset + hh * srcLineStride;
                        for (int w = 0; w < dstWidth; ++w) {
                            d[dstPixelOffset] = clamp[s[srcPixelOffset] & 0xFF];
                            dstPixelOffset += dstPixelStride;
                            srcPixelOffset += srcPixelStride;
                        }
                        return null;
                    }
                });
            }
        }
        try {
            threadPool.invokeAll(processes);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        finally {
            threadPool.shutdown();
        }
    }

    private void computeRectUShort(RasterAccessor src, RasterAccessor dst) {
        final int dstWidth = dst.getWidth();
        int dstHeight = dst.getHeight();
        int dstBands = dst.getNumBands();
        final int dstLineStride = dst.getScanlineStride();
        final int dstPixelStride = dst.getPixelStride();
        int[] dstBandOffsets = dst.getBandOffsets();
        short[][] dstData = dst.getShortDataArrays();
        final int srcLineStride = src.getScanlineStride();
        final int srcPixelStride = src.getPixelStride();
        int[] srcBandOffsets = src.getBandOffsets();
        short[][] srcData = src.getShortDataArrays();
        ExecutorService threadPool = Executors.newFixedThreadPool(numProc);
        LinkedList<2> processes = new LinkedList<2>();
        for (int band = 0; band < dstBands; ++band) {
            final float c = (float)this.constants[band];
            final float o = (float)this.offsets[band];
            final short[] s = srcData[band];
            final short[] d = dstData[band];
            final int dstLineOffset = dstBandOffsets[band];
            final int srcLineOffset = srcBandOffsets[band];
            int h = 0;
            while (h < dstHeight) {
                final int hh = h++;
                processes.add(new Callable<Void>(){

                    @Override
                    public Void call() {
                        int dstPixelOffset = dstLineOffset + hh * dstLineStride;
                        int srcPixelOffset = srcLineOffset + hh * srcLineStride;
                        for (int w = 0; w < dstWidth; ++w) {
                            d[dstPixelOffset] = ImageUtil.clampRoundUShort((float)(s[srcPixelOffset] & 0xFFFF) * c + o);
                            dstPixelOffset += dstPixelStride;
                            srcPixelOffset += srcPixelStride;
                        }
                        return null;
                    }
                });
            }
        }
        try {
            threadPool.invokeAll(processes);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        finally {
            threadPool.shutdown();
        }
    }

    private void computeRectShort(RasterAccessor src, RasterAccessor dst) {
        final int dstWidth = dst.getWidth();
        int dstHeight = dst.getHeight();
        int dstBands = dst.getNumBands();
        final int dstLineStride = dst.getScanlineStride();
        final int dstPixelStride = dst.getPixelStride();
        int[] dstBandOffsets = dst.getBandOffsets();
        short[][] dstData = dst.getShortDataArrays();
        final int srcLineStride = src.getScanlineStride();
        final int srcPixelStride = src.getPixelStride();
        int[] srcBandOffsets = src.getBandOffsets();
        short[][] srcData = src.getShortDataArrays();
        ExecutorService threadPool = Executors.newFixedThreadPool(numProc);
        LinkedList<3> processes = new LinkedList<3>();
        for (int band = 0; band < dstBands; ++band) {
            final float c = (float)this.constants[band];
            final float o = (float)this.offsets[band];
            final short[] s = srcData[band];
            final short[] d = dstData[band];
            final int dstLineOffset = dstBandOffsets[band];
            final int srcLineOffset = srcBandOffsets[band];
            int h = 0;
            while (h < dstHeight) {
                final int hh = h++;
                processes.add(new Callable<Void>(){

                    @Override
                    public Void call() {
                        int dstPixelOffset = dstLineOffset + hh * dstLineStride;
                        int srcPixelOffset = srcLineOffset + hh * srcLineStride;
                        for (int w = 0; w < dstWidth; ++w) {
                            d[dstPixelOffset] = ImageUtil.clampRoundShort((float)s[srcPixelOffset] * c + o);
                            dstPixelOffset += dstPixelStride;
                            srcPixelOffset += srcPixelStride;
                        }
                        return null;
                    }
                });
            }
        }
        try {
            threadPool.invokeAll(processes);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        finally {
            threadPool.shutdown();
        }
    }

    private void computeRectInt(RasterAccessor src, RasterAccessor dst) {
        final int dstWidth = dst.getWidth();
        int dstHeight = dst.getHeight();
        int dstBands = dst.getNumBands();
        final int dstLineStride = dst.getScanlineStride();
        final int dstPixelStride = dst.getPixelStride();
        int[] dstBandOffsets = dst.getBandOffsets();
        int[][] dstData = dst.getIntDataArrays();
        final int srcLineStride = src.getScanlineStride();
        final int srcPixelStride = src.getPixelStride();
        int[] srcBandOffsets = src.getBandOffsets();
        int[][] srcData = src.getIntDataArrays();
        ExecutorService threadPool = Executors.newFixedThreadPool(numProc);
        LinkedList<4> processes = new LinkedList<4>();
        for (int b = 0; b < dstBands; ++b) {
            final double c = this.constants[b];
            final double o = this.offsets[b];
            final int[] s = srcData[b];
            final int[] d = dstData[b];
            final int dstLineOffset = dstBandOffsets[b];
            final int srcLineOffset = srcBandOffsets[b];
            int h = 0;
            while (h < dstHeight) {
                final int hh = h++;
                processes.add(new Callable<Void>(){

                    @Override
                    public Void call() {
                        int dstPixelOffset = dstLineOffset + hh * dstLineStride;
                        int srcPixelOffset = srcLineOffset + hh * srcLineStride;
                        for (int w = 0; w < dstWidth; ++w) {
                            d[dstPixelOffset] = ImageUtil.clampRoundInt((double)s[srcPixelOffset] * c + o);
                            dstPixelOffset += dstPixelStride;
                            srcPixelOffset += srcPixelStride;
                        }
                        return null;
                    }
                });
            }
        }
        try {
            threadPool.invokeAll(processes);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        finally {
            threadPool.shutdown();
        }
    }

    private void computeRectFloat(RasterAccessor src, RasterAccessor dst) {
        final int dstWidth = dst.getWidth();
        int dstHeight = dst.getHeight();
        int dstBands = dst.getNumBands();
        final int dstLineStride = dst.getScanlineStride();
        final int dstPixelStride = dst.getPixelStride();
        int[] dstBandOffsets = dst.getBandOffsets();
        float[][] dstData = dst.getFloatDataArrays();
        final int srcLineStride = src.getScanlineStride();
        final int srcPixelStride = src.getPixelStride();
        int[] srcBandOffsets = src.getBandOffsets();
        float[][] srcData = src.getFloatDataArrays();
        ExecutorService threadPool = Executors.newFixedThreadPool(numProc);
        LinkedList<5> processes = new LinkedList<5>();
        for (int band = 0; band < dstBands; ++band) {
            final double c = this.constants[band];
            final double o = this.offsets[band];
            final float[] s = srcData[band];
            final float[] d = dstData[band];
            final int dstLineOffset = dstBandOffsets[band];
            final int srcLineOffset = srcBandOffsets[band];
            int h = 0;
            while (h < dstHeight) {
                final int hh = h++;
                processes.add(new Callable<Void>(){

                    @Override
                    public Void call() {
                        int dstPixelOffset = dstLineOffset + hh * dstLineStride;
                        int srcPixelOffset = srcLineOffset + hh * srcLineStride;
                        for (int w = 0; w < dstWidth; ++w) {
                            d[dstPixelOffset] = ImageUtil.clampFloat((double)s[srcPixelOffset] * c + o);
                            dstPixelOffset += dstPixelStride;
                            srcPixelOffset += srcPixelStride;
                        }
                        return null;
                    }
                });
            }
        }
        try {
            threadPool.invokeAll(processes);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        finally {
            threadPool.shutdown();
        }
    }

    private void computeRectDouble(RasterAccessor src, RasterAccessor dst) {
        final int dstWidth = dst.getWidth();
        int dstHeight = dst.getHeight();
        int dstBands = dst.getNumBands();
        final int dstLineStride = dst.getScanlineStride();
        final int dstPixelStride = dst.getPixelStride();
        int[] dstBandOffsets = dst.getBandOffsets();
        double[][] dstData = dst.getDoubleDataArrays();
        final int srcLineStride = src.getScanlineStride();
        final int srcPixelStride = src.getPixelStride();
        int[] srcBandOffsets = src.getBandOffsets();
        double[][] srcData = src.getDoubleDataArrays();
        ExecutorService threadPool = Executors.newFixedThreadPool(numProc);
        LinkedList<6> processes = new LinkedList<6>();
        for (int band = 0; band < dstBands; ++band) {
            final double c = this.constants[band];
            final double o = this.offsets[band];
            final double[] s = srcData[band];
            final double[] d = dstData[band];
            final int dstLineOffset = dstBandOffsets[band];
            final int srcLineOffset = srcBandOffsets[band];
            int h = 0;
            while (h < dstHeight) {
                final int hh = h++;
                processes.add(new Callable<Void>(){

                    @Override
                    public Void call() {
                        int dstPixelOffset = dstLineOffset + hh * dstLineStride;
                        int srcPixelOffset = srcLineOffset + hh * srcLineStride;
                        for (int w = 0; w < dstWidth; ++w) {
                            d[dstPixelOffset] = s[srcPixelOffset] * c + o;
                            dstPixelOffset += dstPixelStride;
                            srcPixelOffset += srcPixelStride;
                        }
                        return null;
                    }
                });
            }
        }
        try {
            threadPool.invokeAll(processes);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        finally {
            threadPool.shutdown();
        }
    }
}

