/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.color;

import java.awt.Color;
import org.jvnet.substance.color.BaseColorScheme;
import org.jvnet.substance.color.ColorScheme;
import org.jvnet.substance.utils.SubstanceCoreUtilities;

public class MixColorScheme
extends BaseColorScheme {
    private Color mainUltraLightColor;
    private Color mainExtraLightColor;
    private Color mainLightColor;
    private Color mainMidColor;
    private Color mainDarkColor;
    private Color mainUltraDarkColor;
    private Color foregroundColor;
    private ColorScheme[] origSchemes;

    public MixColorScheme(ColorScheme ... origSchemes) {
        if (origSchemes == null || origSchemes.length < 2) {
            throw new IllegalArgumentException("At least two schemes needed for a mix scheme");
        }
        this.origSchemes = origSchemes;
        this.foregroundColor = this.origSchemes[0].getForegroundColor();
        this.mainUltraDarkColor = this.origSchemes[0].getUltraDarkColor();
        this.mainDarkColor = this.origSchemes[0].getDarkColor();
        this.mainMidColor = this.origSchemes[0].getMidColor();
        this.mainLightColor = this.origSchemes[0].getLightColor();
        this.mainExtraLightColor = this.origSchemes[0].getExtraLightColor();
        this.mainUltraLightColor = this.origSchemes[0].getUltraLightColor();
        StringBuffer idBuf = new StringBuffer();
        idBuf.append("Mixed ");
        String delim = "";
        for (ColorScheme origScheme : origSchemes) {
            idBuf.append(delim);
            idBuf.append(SubstanceCoreUtilities.getSchemeId(origScheme));
            delim = " & ";
        }
        this.id = idBuf.toString();
    }

    public Color getForegroundColor() {
        return this.foregroundColor;
    }

    public Color getUltraLightColor() {
        return this.mainUltraLightColor;
    }

    public Color getExtraLightColor() {
        return this.mainExtraLightColor;
    }

    public Color getLightColor() {
        return this.mainLightColor;
    }

    public Color getMidColor() {
        return this.mainMidColor;
    }

    public Color getDarkColor() {
        return this.mainDarkColor;
    }

    public Color getUltraDarkColor() {
        return this.mainUltraDarkColor;
    }

    public ColorScheme[] getOrigSchemes() {
        return this.origSchemes;
    }
}

