/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Area;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.HashSet;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.ScrollPaneLayout;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicScrollPaneUI;
import org.jvnet.lafwidget.layout.TransitionBorder;
import org.jvnet.lafwidget.layout.TransitionLayout;
import org.jvnet.substance.SubstanceFillBackgroundDelegate;
import org.jvnet.substance.SubstanceScrollBarUI;
import org.jvnet.substance.scroll.SubstanceScrollPaneBorder;
import org.jvnet.substance.utils.SubstanceCoreUtilities;

public class SubstanceScrollPaneUI
extends BasicScrollPaneUI {
    protected PropertyChangeListener substancePropertyChangeListener;
    protected static SubstanceFillBackgroundDelegate bgDelegate = new SubstanceFillBackgroundDelegate();

    public static ComponentUI createUI(JComponent c) {
        return new SubstanceScrollPaneUI();
    }

    protected void installDefaults(JScrollPane scrollpane) {
        super.installDefaults(scrollpane);
        if (SubstanceCoreUtilities.toBleedWatermark(this.scrollpane)) {
            this.scrollpane.setOpaque(false);
            this.scrollpane.getViewport().setOpaque(false);
        }
        scrollpane.setLayout(new AdjustedLayout((ScrollPaneLayout)scrollpane.getLayout()));
    }

    protected void uninstallDefaults(JScrollPane c) {
        LayoutManager lm = this.scrollpane.getLayout();
        if (lm instanceof AdjustedLayout) {
            c.setLayout(((AdjustedLayout)lm).delegate);
        }
        super.uninstallDefaults(c);
    }

    protected void installListeners(final JScrollPane c) {
        super.installListeners(c);
        this.substancePropertyChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                ScrollPaneLayout currLayout;
                if ("substancelaf.scrollPaneButtonsPolicy".equals(evt.getPropertyName())) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            c.getHorizontalScrollBar().doLayout();
                            c.getVerticalScrollBar().doLayout();
                        }
                    });
                }
                if ("substancelaf.watermark.tobleed".equals(evt.getPropertyName())) {
                    boolean toBleed = SubstanceCoreUtilities.toBleedWatermark(c);
                    c.setOpaque(!toBleed);
                    c.getViewport().setOpaque(!toBleed);
                    Component view = c.getViewport().getView();
                    if (view instanceof JComponent) {
                        ((JComponent)view).setOpaque(!toBleed);
                    }
                }
                if ("layoutManager".equals(evt.getPropertyName()) && ((Boolean)evt.getNewValue()).booleanValue() && !((currLayout = (ScrollPaneLayout)c.getLayout()) instanceof AdjustedLayout)) {
                    c.setLayout(new AdjustedLayout((ScrollPaneLayout)c.getLayout()));
                }
            }
        };
        c.addPropertyChangeListener(this.substancePropertyChangeListener);
    }

    protected void uninstallListeners(JComponent c) {
        c.removePropertyChangeListener(this.substancePropertyChangeListener);
        this.substancePropertyChangeListener = null;
        super.uninstallListeners(c);
    }

    protected MouseWheelListener createMouseWheelListener() {
        return new MouseWheelHandler();
    }

    public void update(Graphics g, JComponent c) {
        LayoutManager origLm;
        JScrollPane jsp;
        if (TransitionLayout.isOpaque(c)) {
            bgDelegate.update(g, c);
        }
        if (SubstanceCoreUtilities.hasOverlayProperty(jsp = (JScrollPane)c)) {
            JViewport viewport = jsp.getViewport();
            int dx = -viewport.getX() + viewport.getViewRect().x;
            int dy = viewport.getY() - viewport.getViewRect().y;
            Graphics2D graphics = (Graphics2D)g.create();
            Area clip = new Area();
            if (jsp.getVerticalScrollBar() != null && jsp.getVerticalScrollBar().isVisible()) {
                clip.add(new Area(jsp.getVerticalScrollBar().getBounds()));
            }
            if (jsp.getHorizontalScrollBar() != null && jsp.getHorizontalScrollBar().isVisible()) {
                clip.add(new Area(jsp.getHorizontalScrollBar().getBounds()));
            }
            graphics.setClip(clip);
            graphics.translate(-dx, dy);
            JComponent view = (JComponent)viewport.getView();
            HashMap<Component, Boolean> dbSnapshot = new HashMap<Component, Boolean>();
            SubstanceCoreUtilities.makeNonDoubleBuffered(view, dbSnapshot);
            view.paint(graphics);
            SubstanceCoreUtilities.restoreDoubleBuffered(view, dbSnapshot);
            graphics.translate(dx, -dy);
            graphics.dispose();
        }
        LayoutManager lm = jsp.getLayout();
        ScrollPaneLayout scrollLm = null;
        if (lm instanceof ScrollPaneLayout) {
            scrollLm = (ScrollPaneLayout)lm;
        } else if (lm instanceof TransitionLayout && (origLm = ((TransitionLayout)lm).getDelegate()) instanceof ScrollPaneLayout) {
            scrollLm = (ScrollPaneLayout)origLm;
        }
        if (scrollLm != null) {
            HashSet<Component> corners = new HashSet<Component>();
            if (scrollLm.getCorner("LOWER_LEFT_CORNER") != null) {
                corners.add(scrollLm.getCorner("LOWER_LEFT_CORNER"));
            }
            if (scrollLm.getCorner("LOWER_RIGHT_CORNER") != null) {
                corners.add(scrollLm.getCorner("LOWER_RIGHT_CORNER"));
            }
            if (scrollLm.getCorner("UPPER_LEFT_CORNER") != null) {
                corners.add(scrollLm.getCorner("UPPER_LEFT_CORNER"));
            }
            if (scrollLm.getCorner("UPPER_RIGHT_CORNER") != null) {
                corners.add(scrollLm.getCorner("UPPER_RIGHT_CORNER"));
            }
            if (TransitionLayout.isOpaque(c)) {
                for (Component corner : corners) {
                    bgDelegate.update(g, c, corner.getBounds());
                }
            }
        }
        super.paint(g, c);
    }

    protected static class AdjustedLayout
    extends ScrollPaneLayout
    implements UIResource {
        protected ScrollPaneLayout delegate;

        public AdjustedLayout(ScrollPaneLayout delegate) {
            this.delegate = delegate;
        }

        public void addLayoutComponent(String s, Component c) {
            this.delegate.addLayoutComponent(s, c);
        }

        public boolean equals(Object obj) {
            return this.delegate.equals(obj);
        }

        public JViewport getColumnHeader() {
            return this.delegate.getColumnHeader();
        }

        public Component getCorner(String key) {
            return this.delegate.getCorner(key);
        }

        public JScrollBar getHorizontalScrollBar() {
            return this.delegate.getHorizontalScrollBar();
        }

        public int getHorizontalScrollBarPolicy() {
            return this.delegate.getHorizontalScrollBarPolicy();
        }

        public JViewport getRowHeader() {
            return this.delegate.getRowHeader();
        }

        public JScrollBar getVerticalScrollBar() {
            return this.delegate.getVerticalScrollBar();
        }

        public int getVerticalScrollBarPolicy() {
            return this.delegate.getVerticalScrollBarPolicy();
        }

        public JViewport getViewport() {
            return this.delegate.getViewport();
        }

        public Rectangle getViewportBorderBounds(JScrollPane scrollpane) {
            return this.delegate.getViewportBorderBounds(scrollpane);
        }

        public int hashCode() {
            return this.delegate.hashCode();
        }

        public Dimension minimumLayoutSize(Container parent) {
            return this.delegate.minimumLayoutSize(parent);
        }

        public Dimension preferredLayoutSize(Container parent) {
            return this.delegate.preferredLayoutSize(parent);
        }

        public void removeLayoutComponent(Component c) {
            this.delegate.removeLayoutComponent(c);
        }

        public void setHorizontalScrollBarPolicy(int x) {
            this.delegate.setHorizontalScrollBarPolicy(x);
        }

        public void setVerticalScrollBarPolicy(int x) {
            this.delegate.setVerticalScrollBarPolicy(x);
        }

        public void syncWithScrollPane(JScrollPane sp) {
            this.delegate.syncWithScrollPane(sp);
        }

        public String toString() {
            return this.delegate.toString();
        }

        public void layoutContainer(Container parent) {
            this.delegate.layoutContainer(parent);
            JScrollPane scrollPane = (JScrollPane)parent;
            Border border = scrollPane.getBorder();
            boolean toAdjust = border instanceof SubstanceScrollPaneBorder;
            if (border instanceof TransitionBorder) {
                toAdjust = ((TransitionBorder)border).getDelegate() instanceof SubstanceScrollPaneBorder;
            }
            if (toAdjust) {
                Rectangle hBounds;
                Rectangle vBounds;
                JScrollBar vertical = scrollPane.getVerticalScrollBar();
                JScrollBar horizontal = scrollPane.getHorizontalScrollBar();
                int dx = 0;
                int dy = 0;
                int dw = 0;
                int dh = 0;
                if (scrollPane.getComponentOrientation().isLeftToRight()) {
                    if (vertical.isVisible()) {
                        vBounds = vertical.getBounds();
                        ++dw;
                        vertical.setBounds(vBounds.x + 1, vBounds.y - 1, vBounds.width, vBounds.height + 2);
                    }
                    if (horizontal.isVisible()) {
                        ++dh;
                        hBounds = horizontal.getBounds();
                        horizontal.setBounds(hBounds.x - 1, hBounds.y + 1, hBounds.width + 2, hBounds.height);
                    }
                    if (this.delegate.getCorner("LOWER_RIGHT_CORNER") != null) {
                        Rectangle lrBounds = this.delegate.getCorner("LOWER_RIGHT_CORNER").getBounds();
                        this.delegate.getCorner("LOWER_RIGHT_CORNER").setBounds(lrBounds.x + 1, lrBounds.y + 1, lrBounds.width, lrBounds.height);
                    }
                } else {
                    if (vertical.isVisible()) {
                        --dx;
                        ++dw;
                        vBounds = vertical.getBounds();
                        vertical.setBounds(vBounds.x - 1, vBounds.y - 1, vBounds.width, vBounds.height + 2);
                    }
                    if (horizontal.isVisible()) {
                        ++dh;
                        hBounds = horizontal.getBounds();
                        horizontal.setBounds(hBounds.x - 1, hBounds.y + 1, hBounds.width + 2, hBounds.height);
                    }
                    if (this.delegate.getCorner("LOWER_LEFT_CORNER") != null) {
                        Rectangle llBounds = this.delegate.getCorner("LOWER_LEFT_CORNER").getBounds();
                        this.delegate.getCorner("LOWER_LEFT_CORNER").setBounds(llBounds.x - 1, llBounds.y - 1, llBounds.width, llBounds.height);
                    }
                }
                if (this.delegate.getViewport() != null) {
                    Rectangle vpBounds = this.delegate.getViewport().getBounds();
                    this.delegate.getViewport().setBounds(new Rectangle(vpBounds.x + dx, vpBounds.y + dy, vpBounds.width + dw, vpBounds.height + dh));
                }
            }
        }
    }

    protected class MouseWheelHandler
    implements MouseWheelListener {
        protected MouseWheelHandler() {
        }

        public void mouseWheelMoved(MouseWheelEvent e) {
            if (SubstanceScrollPaneUI.this.scrollpane.isWheelScrollingEnabled() && e.getScrollAmount() != 0) {
                JScrollBar toScroll = SubstanceScrollPaneUI.this.scrollpane.getVerticalScrollBar();
                int direction = 0;
                if (!(toScroll != null && toScroll.isVisible() && e.getModifiers() != 8 || (toScroll = SubstanceScrollPaneUI.this.scrollpane.getHorizontalScrollBar()) != null && toScroll.isVisible())) {
                    return;
                }
                direction = e.getWheelRotation() < 0 ? -1 : 1;
                SubstanceScrollBarUI ui = (SubstanceScrollBarUI)toScroll.getUI();
                if (e.getScrollType() == 0) {
                    ui.scrollByUnits(direction, 2 * e.getScrollAmount());
                } else if (e.getScrollType() == 1) {
                    ui.scrollByBlock(direction);
                }
            }
        }
    }
}

