﻿/***************************************************************
 * Name:      dxutils.h
 * Author:    David Vachulka (arch_dvx@users.sourceforge.net)
 * Copyright: 2020
 * License:   GPL3
 **************************************************************/

#ifndef DXUTILS_H
#define DXUTILS_H

#ifndef WX_PRECOMP
    #include <wx/wx.h>
#endif
#include <ctime>

class dxutils
{
public:
    dxutils();
    static wxString formatDateTime(const wxDateTime &date, const wxString &formatDate, const wxString &formatTime, int layout);
    static wxString formatDate(const wxDateTime &date, const wxString &formatDate, bool replaceBrackets=false);
    static wxString formatTime(const wxDateTime &date, const wxString &formatTime, bool replaceBrackets=false);
    static wxDateTime easternSunday(int year);
    static wxDateTime::wxDateTime_t lastdayofmonth(wxDateTime::Month month, int year);
    static wxDateTime::wxDateTime_t weeksofmonth(const wxDateTime &date);
    static wxString fontToString(const wxFont &font);
    static wxFont fontFromString(const wxString &fontstr);
    static struct tm dateTimeToTm(const wxDateTime &date);
    static size_t numberOfChars(const wxString &text, char value);
    static int recurrenceSelectionToType(int selection);
    static int recurrenceTypeToSelection(int type);
    static wxArrayString reminders();
    static wxArrayString recurrences();
    static long textToInt(const wxString &text);
    static wxString fromStdString(const std::string &str);
    static wxString availableVersion();
    static int versionToInt(const wxString &version);
};

#endif // DXUTILS_H
