/*
 * Decompiled with CFR 0.152.
 */
package gj.layout.tree;

import gj.awt.geom.Geometry;
import gj.awt.geom.Path;
import gj.layout.tree.Contour;
import gj.layout.tree.Orientation;
import gj.model.Node;
import gj.util.ArcIterator;
import gj.util.ModelHelper;
import java.awt.geom.Point2D;
import java.util.List;

public class Branch {
    private Node root;
    private Contour contour;

    Branch(Node root, Node parent, Contour contour) {
        this.root = root;
        this.contour = contour;
        Point2D delta = Geometry.getNegative(root.getPosition());
        ArcIterator it = new ArcIterator(root);
        while (it.next()) {
            if (it.dest == parent) continue;
            Path path = it.arc.getPath();
            if (path != null) {
                path.translate(delta);
            }
            if (!it.isFirst || it.isLoop) continue;
            ModelHelper.move(it.dest, delta);
        }
    }

    public int getLongitude(Orientation o) {
        return o.getLongitude(this.root.getPosition());
    }

    public int getLatitude() {
        return this.contour.north;
    }

    public static int getMinLongitude(Branch[] bs) {
        int result = Integer.MAX_VALUE;
        for (Branch b : bs) {
            result = Math.min(b.contour.west, result);
        }
        return result;
    }

    public static int getMaxLongitude(Branch[] bs) {
        int result = Integer.MIN_VALUE;
        for (Branch b : bs) {
            result = Math.max(b.contour.east, result);
        }
        return result;
    }

    public static int getLongitude(Branch[] bs, double fraction, Orientation o) {
        double min = bs[0].getLongitude(o);
        double max = bs[bs.length - 1].getLongitude(o);
        return (int)(min + (max - min) * Math.min(1.0, Math.max(0.0, fraction)));
    }

    Contour finalize(int dlat, int dlon, Orientation o) {
        this.finalizeRecursively(this.root, null, o.getPoint(dlat, dlon));
        this.contour.translate(dlat, dlon);
        return this.contour;
    }

    private void finalizeRecursively(Node node, Node parent, Point2D delta) {
        ModelHelper.move(node, delta);
        ArcIterator it = new ArcIterator(node);
        while (it.next()) {
            if (it.dest == parent) continue;
            Path path = it.arc.getPath();
            if (path != null) {
                path.translate(node.getPosition());
            }
            if (it.isLoop || !it.isFirst) continue;
            this.finalizeRecursively(it.dest, node, node.getPosition());
        }
    }

    void moveBy(int dlat, int dlon, Orientation o) {
        this.contour.translate(dlat, dlon);
        ModelHelper.move(this.root, o.getPoint(dlat, dlon));
    }

    void moveTo(int lat, int lon, Orientation o) {
        Point2D pos = this.root.getPosition();
        this.moveBy(lat - o.getLatitude(pos), lon - o.getLongitude(pos), o);
    }

    void insertEastOf(List others, Orientation o) {
        if (!others.isEmpty()) {
            this.moveBy(((Branch)others.get((int)0)).contour.north - this.contour.north, 0, o);
            this.moveBy(0, -Branch.calcMinimumDistance(others, this), o);
        }
        others.add(this);
    }

    private static int calcMinimumDistance(List branches, Branch other) {
        int[] ds = Branch.calcMinimumDistances(branches, other);
        int result = Integer.MAX_VALUE;
        for (int d = 0; d < ds.length; ++d) {
            result = Math.min(ds[d], result);
        }
        return result;
    }

    private static int[] calcMinimumDistances(List<Branch> branches, Branch other) {
        int[] result = new int[branches.size()];
        for (int r = 0; r < result.length; ++r) {
            result[r] = Integer.MAX_VALUE;
        }
        Contour.Iterator east = other.contour.getIterator(0);
        block1: for (int r = result.length - 1; r >= 0; --r) {
            Contour.Iterator west = branches.get((int)r).contour.getIterator(1);
            while (true) {
                if (west.south <= east.north) {
                    if (west.next()) continue;
                    continue block1;
                }
                while (east.south <= west.north) {
                    if (east.next()) continue;
                    break block1;
                }
                result[r] = Math.min(result[r], east.longitude - west.longitude);
                if (west.south < east.south) {
                    if (!west.next()) continue block1;
                    continue;
                }
                if (!east.next()) break;
            }
            break;
        }
        return result;
    }

    static Contour[] getCountoursForMerge(Contour parent, Branch[] children) {
        Contour[] result = new Contour[children.length + 2];
        int i = 0;
        result[i++] = parent;
        for (Branch child : children) {
            result[i++] = child.contour;
        }
        result[i++] = parent;
        return result;
    }
}

