/*
 * Decompiled with CFR 0.152.
 */
package ancestris.reports.phonetics;

import ancestris.reports.phonetics.Phonetics;

public class Nysiis
implements Phonetics {
    boolean debug = false;
    StringBuffer word = null;

    @Override
    public String encode(String originalWord) {
        if (originalWord == null || originalWord.length() == 0) {
            return null;
        }
        this.word = new StringBuffer(originalWord.toUpperCase());
        if (this.word.length() == 0) {
            return null;
        }
        while (this.word.toString().endsWith("S") || this.word.toString().endsWith("Z")) {
            this.word.deleteCharAt(this.word.length() - 1);
        }
        int current = 0;
        while (current < this.word.length()) {
            if (!Character.isLetter(this.word.charAt(current))) {
                this.word.deleteCharAt(current);
                continue;
            }
            ++current;
        }
        if (this.word.length() == 0) {
            return null;
        }
        this.replaceFront("MAC", "MC");
        this.replaceFront("PF", "F");
        this.replaceEnd("IX", "IC");
        this.replaceEnd("EX", "EC");
        this.replaceEnd("YE", "Y");
        this.replaceEnd("EE", "Y");
        this.replaceEnd("IE", "Y");
        this.replaceEnd("DT", "D");
        this.replaceEnd("RT", "D");
        this.replaceEnd("RD", "D");
        this.replaceEnd("NT", "N");
        this.replaceEnd("ND", "N");
        this.replaceAll("EV", "EF", 1);
        char first = this.word.charAt(0);
        this.replaceAll("E", "A");
        this.replaceAll("I", "A");
        this.replaceAll("O", "A");
        this.replaceAll("U", "A");
        this.replaceAll("AW", "A");
        this.replaceAll("GHT", "GT");
        this.replaceAll("DG", "G");
        this.replaceAll("PH", "F");
        this.replaceAll("AH", "A", 1);
        this.replaceAll("HA", "A", 1);
        this.replaceAll("KN", "N");
        this.replaceAll("K", "C");
        this.replaceAll("M", "N", 1);
        this.replaceAll("Q", "G", 1);
        this.replaceAll("SH", "S");
        this.replaceAll("SCH", "S");
        this.replaceAll("YW", "Y");
        this.replaceAll("Y", "A", 1, this.word.length() - 2);
        this.replaceAll("WR", "R");
        this.replaceAll("Z", "S", 1);
        this.replaceEnd("AY", "Y");
        while (this.word.toString().endsWith("A")) {
            this.word.deleteCharAt(this.word.length() - 1);
        }
        if (this.word.length() == 0) {
            return null;
        }
        this.reduceDuplicates();
        if ('A' == first || 'E' == first || 'I' == first || 'O' == first || 'U' == first) {
            this.word.deleteCharAt(0);
            this.word.insert(0, first);
        }
        return this.word.toString();
    }

    private void reduceDuplicates() {
        StringBuffer newWord = new StringBuffer();
        if (0 == this.word.length()) {
            return;
        }
        char lastChar = this.word.charAt(0);
        newWord.append(lastChar);
        for (int i = 1; i < this.word.length(); ++i) {
            if (lastChar != this.word.charAt(i)) {
                newWord.append(this.word.charAt(i));
            }
            lastChar = this.word.charAt(i);
        }
        this.log("reduceDuplicates: " + this.word);
        this.word = newWord;
    }

    private void replaceAll(String find, String repl) {
        this.replaceAll(find, repl, 0, -1);
    }

    private void replaceAll(String find, String repl, int startPos) {
        this.replaceAll(find, repl, startPos, -1);
    }

    private void replaceAll(String find, String repl, int startPos, int endPos) {
        int pos = this.word.toString().indexOf(find, startPos);
        if (-1 == endPos) {
            endPos = this.word.length() - 1;
        }
        while (-1 != pos) {
            if (-1 != endPos && pos > endPos) {
                this.log("stopping pos > endPos: " + pos + ":" + endPos);
                break;
            }
            this.word.delete(pos, pos + find.length());
            this.word.insert(pos, repl);
            pos = this.word.toString().indexOf(find);
            this.log("replaceAll[" + find + "," + repl + "]: " + this.word);
        }
    }

    private void replaceFront(String find, String repl) {
        if (this.word.toString().startsWith(find)) {
            this.word.delete(0, find.length());
            this.word.insert(0, repl);
            this.log("replaceFront[" + find + "]: " + this.word);
        }
    }

    private void replaceEnd(String find, String repl) {
        if (this.word.toString().endsWith(find)) {
            this.word.delete(this.word.length() - find.length(), this.word.length());
            this.word.append(repl);
            this.log("replaceEnd[" + find + "]: " + this.word);
        }
    }

    private void log(String msg) {
        if (!this.debug) {
            return;
        }
        System.out.println(msg);
        System.out.flush();
    }

    public String toString() {
        return "Nysiis";
    }
}

