/*
 * Decompiled with CFR 0.152.
 */
package ancestris.reports.narrative;

import ancestris.core.TextOptions;
import ancestris.reports.narrative.NarrativeContentOptions;
import ancestris.reports.narrative.NarrativeParameterOptions;
import ancestris.reports.narrative.Utterance;
import genj.fo.Document;
import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomOptions;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.gedcom.PropertyDate;
import genj.gedcom.PropertyEvent;
import genj.gedcom.PropertyFile;
import genj.gedcom.PropertyPlace;
import genj.gedcom.PropertySource;
import genj.gedcom.PropertyXRef;
import genj.gedcom.Source;
import genj.gedcom.TagPath;
import genj.gedcom.time.Delta;
import genj.gedcom.time.PointInTime;
import genj.io.InputSource;
import genj.renderer.MediaRenderer;
import genj.report.Report;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;

public class ReportNarrative
extends Report {
    public static final int DETAIL_NO_SHOW = 0;
    public static final int DETAIL_NAME = 1;
    public static final int DETAIL_BRIEF = 2;
    public static final int DETAIL_DATES = 3;
    public static final int DETAIL_BRIEF_WITH_DATES = 2;
    public static final int DETAIL_FULL = 5;
    public static final int DETAIL_EVERYTHING = 6;
    private static final int ORIENTATION_LANDSCAPE = 1;
    private final String[] fonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
    private static final int[] fontSizes = new int[]{4, 8, 10, 12, 16, 18, 20};
    public String titre;
    public int reportOrientation = 1;
    public String[] reportOrientations = new String[]{this.translate("OrientationPO"), this.translate("OrientationLA")};
    public String author;
    public String coverImage;
    public int reportFont = 0;
    public String[] reportFonts = this.fonts;
    public int reportFontSize = 4;
    public String[] reportFontSizes = new String[]{this.translate("FontSizeXXS"), this.translate("FontSizeXS"), this.translate("FontSizeS"), this.translate("FontSizeM"), this.translate("FontSizeL"), this.translate("FontSizeXL"), this.translate("FontSizeXXL")};
    public String htmlStylesheet = null;
    public boolean noAds = false;
    public boolean printDate = true;
    public NarrativeContentOptions contentOptions = new NarrativeContentOptions();
    public NarrativeParameterOptions parameterOptions = new NarrativeParameterOptions();
    private String nameIndexTitle;
    private String placeIndexTitle;
    private String sourceIndexTitle;
    private String occupationIndexTitle;
    private final Set<Source> bibliography = new HashSet<Source>();

    public Object startTest(Gedcom gedcom, String startingIndiTag) {
        Indi indi = (Indi)gedcom.getEntity("INDI", startingIndiTag);
        return this.start(indi);
    }

    public Entity getStartingEntity(String msg, Gedcom gedcom, String tag) {
        return this.getEntityFromUser(msg, gedcom, tag);
    }

    public Document start(Indi indi) {
        List<Indi> nextGen;
        this.println("indi = " + indi.getName());
        this.bibliography.clear();
        this.nameIndexTitle = this.contentOptions.withNameIndex ? this.translate("index.names") : null;
        this.placeIndexTitle = this.contentOptions.withPlaceIndex ? this.translate("index.places") : null;
        this.sourceIndexTitle = this.parameterOptions.withBibliography ? this.translate("bibliography") : null;
        this.occupationIndexTitle = this.contentOptions.withoccupationIndex ? this.translate("index.occupation") : null;
        String title = this.formatTitle(indi);
        Document doc = new Document(title, this.fonts[this.reportFont], fontSizes[this.reportFontSize], 0, 6, this.reportOrientation, this.printDate, TextOptions.getInstance().getOutputLocale());
        int imageSpace = this.reportOrientation == 1 ? 5 : 15;
        int authorSpace = this.coverImage != null && !"".equals(this.coverImage) ? 5 : 5 + imageSpace;
        authorSpace = this.reportOrientation == 1 && this.coverImage != null && !"".equals(this.coverImage) ? 1 : authorSpace;
        int titleMargin = this.coverImage != null && !"".equals(this.coverImage) ? 10 : 25;
        doc.startSection(title, "", 1, this.contentOptions.withToc, true, this.contentOptions.withToc ? "text-align=center, margin-top=" + titleMargin + "%" : "text-align=center");
        doc.nextParagraph("white-space-treatment=preserve, font-size=xx-large, font-weight=bold, space-before=0.5cm, keep-with-next.within-page=always, text-align=center, space-after=" + authorSpace + "em");
        if (this.author != null && !"".equals(this.author)) {
            Utterance u = Utterance.forTemplate(this.getResources(), this.translate("phrase.SOUR.AUTH"), new String[]{this.author});
            doc.addText(u.toString());
        } else {
            doc.addText(" ");
        }
        if (this.coverImage != null && !"".equals(this.coverImage)) {
            int addSpace = this.reportOrientation == 1 ? 1 : 10;
            doc.nextParagraph("display-align=center, text-align=center, space-after=" + addSpace + "em");
            try {
                URL myUrl = new URL(this.coverImage);
                Optional is = InputSource.get((URL)myUrl);
                if (is.isPresent()) {
                    doc.addImage((InputSource)is.get(), "height=10cm, width=10cm, display-align=center, text-align=center", this.reportOrientation != 1);
                } else {
                    doc.addImage(new File(this.coverImage), "height=10cm, width=10cm, display-align=center, text-align=center", this.reportOrientation != 1);
                }
            }
            catch (MalformedURLException e) {
                doc.addImage(new File(this.coverImage), "height=10cm, width=10cm, display-align=center, text-align=center", this.reportOrientation != 1);
            }
        }
        doc.nextParagraph();
        if (!this.noAds) {
            Utterance ad = this.getUtterance("doc.ad.1");
            PropertyDate dateFormatter = new PropertyDate();
            dateFormatter.setValue(PropertyDate.DATE, PointInTime.getPointInTime((long)System.currentTimeMillis()), null, "");
            ad.set("DATE", dateFormatter.getDisplayValue());
            doc.addText(ad.toString());
            doc.addText(" ");
            doc.addExternalLink("Ancestris", "https://www.ancestris.org");
            ad = this.getUtterance("doc.ad.2");
            ad.set("DATE", new Date().toString());
            doc.addText(ad.toString());
        }
        HashSet<Indi> printed = new HashSet<Indi>();
        List<Indi> gen = new ArrayList<Indi>();
        gen.add(indi);
        int generationNumber = 1;
        do {
            nextGen = this.printGenerations(doc, generationNumber, gen, printed);
        } while ((gen = nextGen).size() > 0 && ++generationNumber <= this.contentOptions.maxGenerations);
        if (this.contentOptions.withNameIndex) {
            this.println(this.translate("log.printingNameIndex"));
        }
        if (this.contentOptions.withPlaceIndex) {
            this.println(this.translate("log.printingPlaceIndex"));
        }
        if (this.contentOptions.withoccupationIndex) {
            this.println(this.translate("log.printingOccupationIndex"));
        }
        if (this.parameterOptions.withBibliography) {
            this.println(this.translate("log.printingBibliography"));
            this.writeBibliography(doc);
        }
        if (this.contentOptions.withToc) {
            this.println(this.translate("log.printingToc"));
            doc.addTOC(this.coverImage != null && !"".equals(this.coverImage) ? 5 : 4);
        }
        this.println(this.translate("log.finished"));
        return doc;
    }

    private String formatTitle(Indi indi) {
        if (this.titre != null && !"".equals(this.titre.trim())) {
            String value = this.titre.replaceAll("\\$i", indi.getId());
            value = value.replaceAll("\\$s", indi.getSosaString());
            value = value.replaceAll("\\$n", indi.getName());
            value = value.replaceAll("\\$f", indi.getFirstName());
            value = value.replaceAll("\\$l", indi.getLastName());
            Property pTitle = indi.getProperty("TITL");
            String titleStr = "";
            if (pTitle != null) {
                titleStr = pTitle.getDisplayValue();
            }
            value = value.replaceAll("\\$t", titleStr);
            value = value.replaceAll("\\s+", " ");
            return value;
        }
        return this.getUtterance(this.contentOptions.ancestors ? "doc.ancestors.title" : "doc.descendants.title", new String[]{new IndiWriter(indi, null).getName(indi)}).toString();
    }

    private Utterance getUtterance(String key) {
        return this.getUtterance(key, new String[0]);
    }

    private Utterance getUtterance(String key, String[] params) {
        String template1 = this.translate(key);
        if (template1 == null) {
            template1 = key;
        }
        return Utterance.forTemplate(this.getResources(), template1, params);
    }

    private List<Indi> printGenerations(Document doc, int n, List<Indi> gen, Set<Indi> printed) {
        Utterance generations = this.getUtterance("individuals.in.generation", new String[]{Integer.toString(gen.size()), Integer.toString(n)});
        this.println(generations.toString());
        ArrayList<Indi> nextGen = new ArrayList<Indi>();
        Utterance docTitle = this.getUtterance("section.title", new String[]{Integer.toString(n)});
        if (n == 1 && !this.contentOptions.withToc) {
            doc.startSection(docTitle.toString(), 2);
        } else {
            doc.startSection(docTitle.toString(), "", 2, this.contentOptions.pageBreakBetweenSection, true, "");
        }
        for (Indi indi : gen) {
            IndiWriter writer = new IndiWriter(indi, doc);
            String sectionTitle = indi.getName();
            Property title = indi.getProperty("TITL");
            if (title != null) {
                sectionTitle = sectionTitle + " ; " + title.getValue();
            }
            if (printed.contains(indi)) {
                doc.startSection(sectionTitle, "", 3, false, false, "");
                Utterance linkTitle = this.getUtterance("phrase.already.seen");
                doc.addLink(linkTitle.toString(), indi.getLinkAnchor());
            } else {
                doc.startSection(sectionTitle, indi.getLinkAnchor(), 3, false, false, "");
                if (this.contentOptions.withNameIndex) {
                    doc.addIndexTerm(this.nameIndexTitle, indi.getLastName(), indi.getFirstName());
                }
                boolean showKids = true;
                writer.writeEntry(showKids, this.contentOptions.withOtherDetails ? 6 : 5, true, false, this.contentOptions.showImages);
            }
            this.addNextGeneration(nextGen, indi);
            printed.add(indi);
        }
        return nextGen;
    }

    private void addNextGeneration(List<Indi> indis, Indi indi) {
        if (this.contentOptions.ancestors) {
            Indi parent = indi.getBiologicalFather();
            if (parent != null) {
                indis.add(parent);
            }
            if ((parent = indi.getBiologicalMother()) != null) {
                indis.add(parent);
            }
        } else {
            indis.addAll(Arrays.asList(indi.getChildren()));
        }
    }

    private void writeBibliography(Document doc) {
        if (this.bibliography.isEmpty()) {
            return;
        }
        doc.startSection(this.sourceIndexTitle, "", 1, this.contentOptions.pageBreakBetweenSection, true, "");
        ArrayList<Source> sortedBiblio = new ArrayList<Source>(this.bibliography.size());
        sortedBiblio.addAll(this.bibliography);
        Collections.sort(sortedBiblio);
        for (Source source : sortedBiblio) {
            Property data;
            doc.startSection(source.getId(), source.getLinkAnchor(), 5, false, false, "");
            doc.nextParagraph("font-size=smaller");
            Utterance u = Utterance.forTemplate(this.getResources(), this.translate("phrase.SOUR.TITL"), new String[]{source.getPropertyDisplayValue("TITL")});
            doc.addText(u.toString());
            if (!"".equals(source.getPropertyDisplayValue("AUTH"))) {
                doc.addText(" ");
                u = Utterance.forTemplate(this.getResources(), this.translate("phrase.SOUR.AUTH"), new String[]{source.getPropertyDisplayValue("AUTH")});
                doc.addText(u.toString(), "font-style=italic");
            }
            if (source.getProperty("DATA") != null && (data = source.getProperty("DATA")).getProperty("EVEN") != null) {
                Property event = data.getProperty("EVEN");
                doc.nextParagraph("font-size=smaller");
                u = Utterance.forTemplate(this.getResources(), this.translate("phrase.SOUR.EVEN"), new String[]{event.getDisplayValue()});
                doc.addText(u.toString());
                if (event.getProperty("DATE") != null) {
                    u = Utterance.forTemplate(this.getResources(), this.translate("phrase.SOUR.DATE"), new String[]{this.getDatePhrase(event.getProperty("DATE"))});
                    doc.addText(u.toString());
                }
            }
            if (source.getProperty("REPO") != null) {
                Property repoRef = source.getProperty("REPO");
                if (repoRef instanceof PropertyXRef) {
                    Entity repo = ((PropertyXRef)repoRef).getTargetEntity();
                    u = Utterance.forTemplate(this.getResources(), this.translate("phrase.SOUR.REPO"), new String[]{repo.getPropertyDisplayValue("NAME")});
                    doc.nextParagraph("font-size=smaller");
                    doc.addText(u.toString());
                }
                if (repoRef.getProperty("CALN") != null) {
                    Property caln = repoRef.getProperty("CALN");
                    doc.nextParagraph("font-size=smaller");
                    u = Utterance.forTemplate(this.getResources(), this.translate("phrase.SOUR.CALN"), new String[]{caln.getDisplayValue()});
                    doc.addText(u.toString());
                    if (caln.getProperty("MEDI") != null) {
                        u = Utterance.forTemplate(this.getResources(), this.translate("phrase.SOUR.MEDI"), new String[]{caln.getPropertyDisplayValue("MEDI")});
                        doc.addText(" (" + u.toString() + ")");
                    }
                }
            }
            if (!this.parameterOptions.withSourceText || "".equals(source.getPropertyDisplayValue("TEXT"))) continue;
            doc.nextParagraph("font-size=smaller");
            u = Utterance.forTemplate(this.getResources(), this.translate("phrase.SOUR.TEXT"), new String[]{source.getPropertyDisplayValue("TEXT")});
            doc.addText(u.toString());
        }
    }

    private String getDatePhrase(Property prop) {
        PropertyDate.Format dateFormat;
        String date = "";
        PropertyDate propDate = null;
        if (prop instanceof PropertyEvent) {
            propDate = ((PropertyEvent)prop).getDate(true);
            date = this.getDateString(prop.getProperty("DATE"));
        } else if (prop instanceof PropertyDate) {
            propDate = (PropertyDate)prop;
            date = this.getDateString((Property)propDate);
        }
        if (date.length() > 0 && (dateFormat = propDate.getFormat()).equals(PropertyDate.DATE)) {
            if (propDate.getStart().getDay() == Integer.MAX_VALUE) {
                Utterance phrase = propDate.getStart().getMonth() == Integer.MAX_VALUE ? Utterance.forProperty(this.getResources(), "phrase.date.year", new String[]{date}) : Utterance.forProperty(this.getResources(), "phrase.date.month", new String[]{date});
                date = phrase.toString();
            } else {
                Utterance phrase = Utterance.forProperty(this.getResources(), "phrase.date.day", new String[]{date});
                date = phrase.toString();
            }
        }
        return " " + date;
    }

    private String getDateString(Property prop) {
        if (prop == null || !prop.isValid()) {
            return "";
        }
        PropertyDate date = (PropertyDate)prop;
        return date.getReportValue(null, GedcomOptions.GedcomDateFormat.LONG);
    }

    public class IndiWriter {
        private Indi indi;
        private Document doc;
        private final Set<String> INDIVIDUAL_ATTRIBUTES = new HashSet<String>(Arrays.asList("CAST", "DSCR", "EDUC", "IDNO", "NATI", "NCHI", "NMR", "PROP", "RELI", "SSN"));

        public IndiWriter(Indi indi, Document doc) {
            this.indi = indi;
            this.doc = doc;
        }

        public String getIdAndReference(Indi i) {
            boolean doShowSosa;
            StringBuilder name = new StringBuilder();
            boolean doShowRefn = ReportNarrative.this.parameterOptions.showRefns && i.getProperties("REFN").length > 0;
            boolean bl = doShowSosa = ReportNarrative.this.parameterOptions.showSosa && (i.getProperties(Indi.TAG_SOSA).length > 0 || i.getProperties(Indi.TAG_DABOVILLE).length > 0 || i.getProperties(Indi.TAG_SOSADABOVILLE).length > 0);
            if (ReportNarrative.this.parameterOptions.showIds || doShowRefn || doShowSosa) {
                name.append(" (");
                if (ReportNarrative.this.parameterOptions.showIds) {
                    name.append(i.getId());
                    if (doShowRefn || doShowSosa) {
                        name.append("; ");
                    }
                }
                if (doShowRefn) {
                    Property[] refns = i.getProperties("REFN");
                    for (int j = 0; j < refns.length; ++j) {
                        Property refn = refns[j];
                        if (j > 0) {
                            name.append(", ");
                        }
                        name.append(refn.getValue());
                    }
                    if (doShowSosa) {
                        name.append("; ");
                    }
                }
                if (doShowSosa) {
                    int j;
                    Property[] sosas = i.getProperties(Indi.TAG_SOSA);
                    Property[] dabovilles = i.getProperties(Indi.TAG_DABOVILLE);
                    Property[] sosaDabs = i.getProperties(Indi.TAG_SOSADABOVILLE);
                    for (j = 0; j < sosas.length; ++j) {
                        Property sosa = sosas[j];
                        if (j > 0) {
                            name.append(", ");
                        }
                        name.append(sosa.getValue());
                    }
                    if (sosas.length > 0 && (dabovilles.length > 0 || sosaDabs.length > 0)) {
                        name.append("; ");
                    }
                    for (j = 0; j < dabovilles.length; ++j) {
                        Property daboville = dabovilles[j];
                        if (j > 0) {
                            name.append(", ");
                        }
                        name.append(daboville.getValue());
                    }
                    if ((sosas.length > 0 || dabovilles.length > 0) && sosaDabs.length > 0) {
                        name.append("; ");
                    }
                    for (j = 0; j < sosaDabs.length; ++j) {
                        Property sosaDab = sosaDabs[j];
                        if (j > 0) {
                            name.append(", ");
                        }
                        name.append(sosaDab.getValue());
                    }
                }
                name.append(")");
            }
            return name.toString();
        }

        public String getName(Indi i) {
            if (i == null) {
                return ReportNarrative.this.translate("phrase.spouses_name_unknown");
            }
            StringBuffer name = new StringBuffer(i.getFirstName());
            this.appendName(name, i.getLastName());
            this.appendName(name, i.getNameSuffix());
            return name.toString();
        }

        private void appendName(StringBuffer name, String element) {
            if (element != null && element.length() > 0) {
                name.append(' ');
                name.append(element);
            }
        }

        public void writeEntry(boolean withChildren, int defaultDetailLevel, boolean withParents, boolean linkToIndi, boolean showImages) {
            Property[] occupations = this.indi.getProperties(new TagPath("INDI:OCCU"));
            Property lastOccupation = occupations.length > 0 ? occupations[occupations.length - 1] : null;
            Property[] residences = this.indi.getProperties(new TagPath("INDI:RESI"));
            Property lastResidence = residences.length > 0 ? residences[residences.length - 1] : null;
            LinkedHashSet<Property> usedProperties = new LinkedHashSet<Property>();
            int detailLevel = defaultDetailLevel;
            try {
                Indi[] children;
                String idString;
                if (ReportNarrative.this.contentOptions.withNameIndex) {
                    this.doc.addIndexTerm(ReportNarrative.this.nameIndexTitle, this.indi.getLastName(), this.indi.getFirstName());
                }
                if (detailLevel >= 5 && (idString = this.getIdAndReference(this.indi)) != null && !"".equals(idString.trim())) {
                    this.doc.nextParagraph("font-style=italic");
                    this.doc.addText(idString);
                    this.doc.nextParagraph("text-align=justify");
                }
                if (showImages && detailLevel >= 5) {
                    this.insertImages();
                }
                if (linkToIndi) {
                    this.doc.addLink(this.getName(this.indi), this.indi.getLinkAnchor());
                } else {
                    this.doc.addText(this.getName(this.indi));
                }
                if (detailLevel >= 3) {
                    String placeB;
                    PropertyDate birthDate;
                    Indi father = this.indi.getBiologicalFather();
                    Indi mother = this.indi.getBiologicalMother();
                    if (withParents && (father != null || mother != null)) {
                        this.doc.addText(", ");
                        this.addGenderSpecificUtterance("childof.parent", this.indi, "");
                        if (father != null) {
                            this.doc.addLink(this.getName(father), father.getLinkAnchor());
                            if (mother != null) {
                                this.doc.addText(" ");
                                this.doc.addText(ReportNarrative.this.translate("phrase.childof.and"));
                                this.doc.addLink(this.getName(mother), mother.getLinkAnchor());
                            }
                        } else {
                            this.doc.addLink(this.getName(mother), mother.getLinkAnchor());
                        }
                    } else if (!withParents && this.indi.getProperty("ADOP") != null) {
                        this.doc.addText(", ");
                        this.addGenderSpecificUtterance("ADOP", this.indi, "");
                    }
                    if ((birthDate = this.indi.getBirthDate()) != null) {
                        usedProperties.add(this.indi.getProperty("BIRT"));
                        this.doc.addText(", ");
                        this.addGenderSpecificUtterance("born", this.indi, ReportNarrative.this.getDatePhrase((Property)birthDate));
                    }
                    if ((placeB = this.getPlaceString(this.indi.getProperty("BIRT"), null)).length() > 0) {
                        usedProperties.add(this.indi.getProperty("BIRT"));
                        this.doc.addText(" " + placeB);
                    }
                    if (detailLevel >= 5) {
                        this.addFootNote(this.indi.getProperty("BIRT"));
                    }
                    Fam[] fams = this.indi.getFamiliesWhereSpouse(!ReportNarrative.this.parameterOptions.keepWeddingGedcomOrder);
                    for (int i = 0; i < fams.length; ++i) {
                        Fam fam = fams[i];
                        PropertyDate marriage = fam.getMarriageDate();
                        boolean isMarriage = fam.getProperty(Fam.PATH_FAMMARR) != null;
                        Property engagement = fam.getProperty(new TagPath("FAM:ENGA"));
                        boolean isEnga = engagement != null && detailLevel >= 5;
                        Property contract = fam.getProperty(new TagPath("FAM:MARC"));
                        boolean isContract = contract != null && detailLevel >= 5;
                        this.doc.addText(", ");
                        if (isEnga) {
                            String placeE;
                            usedProperties.add(engagement);
                            this.addGenderSpecificUtterance("engaged", this.indi, "");
                            if (fam.getProperty(new TagPath("FAM:ENGA:DATE")) != null) {
                                this.doc.addText(ReportNarrative.this.getDatePhrase(fam.getProperty(new TagPath("FAM:ENGA:DATE"))));
                            }
                            if (fam.getProperty(new TagPath("FAM:ENGA:PLAC")) != null && (placeE = this.getPlaceString(engagement, null)).length() > 0) {
                                this.doc.addText(" " + placeE);
                            }
                            this.addFootNote(engagement);
                        }
                        if (isContract) {
                            String placeC;
                            if (isEnga) {
                                this.doc.addText(", ");
                            }
                            usedProperties.add(contract);
                            this.addGenderSpecificUtterance("contracted", this.indi, "");
                            if (fam.getProperty(new TagPath("FAM:MARC:DATE")) != null) {
                                this.doc.addText(ReportNarrative.this.getDatePhrase(fam.getProperty(new TagPath("FAM:MARC:DATE"))));
                            }
                            if (fam.getProperty(new TagPath("FAM:MARC:PLAC")) != null && (placeC = this.getPlaceString(contract, null)).length() > 0) {
                                this.doc.addText(" " + placeC);
                            }
                            this.addFootNote(contract);
                        }
                        if ((isEnga || isContract) && isMarriage) {
                            this.doc.addText(" ");
                            this.addGenderSpecificUtterance("then", this.indi, "");
                        }
                        if (marriage != null) {
                            usedProperties.add(fam.getProperty(Fam.PATH_FAMMARR));
                            this.addGenderSpecificUtterance("married", this.indi, "");
                        } else if (isMarriage) {
                            this.addGenderSpecificUtterance("married", this.indi, "");
                        } else if (!isEnga && !isContract) {
                            this.addGenderSpecificUtterance("relation", this.indi, "");
                        }
                        if (isMarriage && detailLevel >= 5) {
                            this.addFootNote(fam.getProperty("NOTE"));
                        }
                        if (fams.length > 1) {
                            this.doc.addText(" ");
                            if (marriage != null && !ReportNarrative.this.parameterOptions.useAbbrevations) {
                                switch (i) {
                                    case 0: {
                                        this.addUtterance("phrase.married.1");
                                        break;
                                    }
                                    case 1: {
                                        this.addUtterance("phrase.married.2");
                                        break;
                                    }
                                    case 2: {
                                        this.addUtterance("phrase.married.3");
                                        break;
                                    }
                                    case 3: {
                                        this.addUtterance("phrase.married.4");
                                        break;
                                    }
                                    default: {
                                        this.doc.addText("(" + (i + 1) + ")");
                                        break;
                                    }
                                }
                            } else {
                                this.doc.addText("(" + (i + 1) + ")");
                            }
                        }
                        if (marriage != null) {
                            this.doc.addText(ReportNarrative.this.getDatePhrase((Property)marriage));
                            String placeM = this.getPlaceString(fam.getProperty(Fam.PATH_FAMMARR), null);
                            if (placeM.length() > 0) {
                                this.doc.addText(" " + placeM);
                            }
                        }
                        if (ReportNarrative.this.parameterOptions.showAges) {
                            Property age = null;
                            if (isMarriage) {
                                age = this.indi.getSex() == 1 ? fam.getProperty(new TagPath("FAM:MARR:HUSB:AGE")) : fam.getProperty(new TagPath("FAM:MARR:WIFE:AGE"));
                            } else if (isContract) {
                                age = this.indi.getSex() == 1 ? fam.getProperty(new TagPath("FAM:MARC:HUSB:AGE")) : fam.getProperty(new TagPath("FAM:MARC:WIFE:AGE"));
                            } else if (isEnga) {
                                Property property = age = this.indi.getSex() == 1 ? fam.getProperty(new TagPath("FAM:ENGA:HUSB:AGE")) : fam.getProperty(new TagPath("FAM:ENGA:WIFE:AGE"));
                            }
                            if (age != null) {
                                this.doc.addText(" " + Utterance.forProperty(ReportNarrative.this.getResources(), "phrase.at_age", new String[]{age.getReportValue()}).toString());
                            }
                        }
                        Indi spouse = fam.getOtherSpouse(this.indi);
                        this.doc.addText(" ");
                        this.addUtterance("prep.married_to");
                        this.doc.addText(" ");
                        if (spouse == null) {
                            this.addUtterance("phrase.spouses_name_unknown");
                        } else {
                            this.doc.addLink(this.getName(spouse), spouse.getLinkAnchor());
                        }
                        if (isMarriage && detailLevel >= 5) {
                            this.addFootNote(fam.getProperty(Fam.PATH_FAMMARR));
                        }
                        if (fam.getProperty(Fam.PATH_FAMDIV) == null) continue;
                        usedProperties.add(fam.getProperty(Fam.PATH_FAMDIV));
                        this.doc.addText(", ");
                        this.addGenderSpecificUtterance("divorce", this.indi, "");
                        Property divorceDate = fam.getProperty(Fam.PATH_FAMDIVDATE);
                        if (divorceDate != null) {
                            Property divAge;
                            this.doc.addText(ReportNarrative.this.getDatePhrase(divorceDate));
                            Property property = divAge = this.indi.getSex() == 1 ? fam.getProperty(new TagPath("FAM:DIV:HUSB:AGE")) : fam.getProperty(new TagPath("FAM:DIV:WIFE:AGE"));
                            if (ReportNarrative.this.parameterOptions.showAges && divAge != null) {
                                this.doc.addText(" " + Utterance.forProperty(ReportNarrative.this.getResources(), "phrase.at_age", new String[]{divAge.getReportValue()}).toString());
                            }
                        }
                        if (detailLevel < 5) continue;
                        this.addFootNote(fam.getProperty(Fam.PATH_FAMDIV));
                    }
                    Property death = this.indi.getProperty("DEAT");
                    PropertyDate deathDate = this.indi.getDeathDate();
                    if (death != null) {
                        usedProperties.add(death);
                        this.doc.addText(", ");
                        if (deathDate != null) {
                            this.addGenderSpecificUtterance("died", this.indi, ReportNarrative.this.getDatePhrase((Property)deathDate));
                            String placeD = this.getPlaceString(death, null);
                            if (placeD.length() > 0) {
                                this.doc.addText(" " + placeD);
                            }
                            if (ReportNarrative.this.parameterOptions.showAges && this.indi.getProperty(new TagPath("INDI:DEAT:AGE")) != null) {
                                this.doc.addText(" " + Utterance.forProperty(ReportNarrative.this.getResources(), "phrase.at_age", new String[]{this.indi.getProperty(new TagPath("INDI:DEAT:AGE")).getReportValue()}).toString());
                            }
                        } else {
                            this.addGenderSpecificUtterance("died", this.indi, ReportNarrative.this.translate("phrase.details.unknown"));
                        }
                        if (detailLevel >= 5) {
                            this.addFootNote(death);
                        }
                    }
                    this.doc.addText(".");
                    HashSet<String> tagsProcessed = new HashSet<String>(Arrays.asList("REFN", "CHAN", "SEX", "BIRT", "DEAT", "FAMC", "FAMS", "NAME", "OBJE", "_SOSADABOVILLE", "_SOSA", "_DABOVILLE", "ASSO", "XREF"));
                    if (detailLevel >= 5) {
                        this.doc.nextParagraph("linefeed-treatment=preserve, white-space-treatment=preserve, line-height=50%");
                        this.doc.addText(" ");
                        Property[] props = this.indi.getProperties();
                        for (Property prop : this.indi.getProperties()) {
                            String val;
                            Utterance u;
                            if (tagsProcessed.contains(prop.getTag())) continue;
                            this.doc.nextParagraph();
                            if (prop instanceof PropertyEvent || this.INDIVIDUAL_ATTRIBUTES.contains(prop.getTag()) || prop.getTag().equals("ADDR") || prop.getTag().equals("EVEN")) {
                                usedProperties.add(prop);
                                this.printEventUtterance(prop);
                                continue;
                            }
                            if ("OCCU".equals(prop.getTag())) {
                                Delta age;
                                if (prop.getValue().length() <= 0) continue;
                                usedProperties.add(prop);
                                if (ReportNarrative.this.contentOptions.withoccupationIndex) {
                                    this.doc.addIndexTerm(ReportNarrative.this.occupationIndexTitle, prop.getReportValue());
                                }
                                this.doc.addText(" ");
                                this.doc.nextParagraph();
                                boolean past = true;
                                if (this.indi.getDeathDate() == null && (age = this.indi.getAge(PointInTime.getPointInTime((long)System.currentTimeMillis()))) != null && age.getYears() < ReportNarrative.this.parameterOptions.retireAge && prop.equals(lastOccupation)) {
                                    past = false;
                                }
                                u = Utterance.forProperty(ReportNarrative.this.getResources(), "sentence.OCCU" + (past ? "" : ".present"), new String[]{ReportNarrative.this.parameterOptions.putLowerCase ? prop.getReportValue().toLowerCase() : prop.getReportValue()});
                                u.setSubject(this.indi);
                                this.completeEventUtterance(u, prop);
                                this.doc.addText(u.toString());
                                this.addFootNote(prop);
                                continue;
                            }
                            if ("RESI".equals(prop.getTag())) {
                                usedProperties.add(prop);
                                boolean present = "".equals(this.indi.getDeathAsString()) && prop.equals(lastResidence);
                                u = Utterance.forProperty(ReportNarrative.this.getResources(), "sentence.RESI" + (present ? ".present" : ""), new String[]{ReportNarrative.this.parameterOptions.putLowerCase ? prop.getReportValue().toLowerCase() : prop.getReportValue()});
                                u.setSubject(this.indi);
                                this.completeEventUtterance(u, prop);
                                this.doc.addText(u.toString());
                                this.addFootNote(prop);
                                continue;
                            }
                            if ("NOTE".equals(prop.getTag())) {
                                if (!ReportNarrative.this.contentOptions.withNotes) continue;
                                this.doc.nextParagraph(" linefeed-treatment=preserve, white-space-treatment=preserve, line-height=50%");
                                this.doc.addText(" ");
                                this.doc.nextParagraph("font-style=italic, font-weight=bold, space-after=0.1cm");
                                this.addUtterance("phrase.note.header");
                                this.doc.nextParagraph("font-style=italic, text-align=justify, linefeed-treatment=preserve");
                                if (prop instanceof PropertyXRef) {
                                    Entity ref = ((PropertyXRef)prop).getTargetEntity();
                                    this.addUtterance("phrase.note", ref.getValue());
                                    Property source = ref.getProperty("SOUR");
                                    if (source != null && ReportNarrative.this.contentOptions.withSources) {
                                        this.writeSource((Source)((PropertySource)source).getTargetEntity(), "", source.getPropertyValue("PAGE"));
                                    }
                                } else {
                                    this.addUtterance("phrase.note", prop.getValue());
                                }
                                this.doc.nextParagraph();
                                continue;
                            }
                            if ("SOUR".equals(prop.getTag()) && prop instanceof PropertySource) {
                                if (!ReportNarrative.this.contentOptions.withSources) continue;
                                this.writeSource((Source)((PropertySource)prop).getTargetEntity(), "", prop.getPropertyValue("PAGE"));
                                continue;
                            }
                            if ("SOUR".equals(prop.getTag())) {
                                if (!ReportNarrative.this.contentOptions.withSources) continue;
                                this.addUtterance("phrase.source", prop.getValue());
                                continue;
                            }
                            if (prop.getTag().startsWith("_")) {
                                if (!ReportNarrative.this.contentOptions.withUserTags || detailLevel < 6) continue;
                                this.addUtterance("phrase.property", prop.getValue());
                                continue;
                            }
                            if (!ReportNarrative.this.contentOptions.withOtherDetails || (val = prop.getValue()).isEmpty()) continue;
                            usedProperties.add(prop);
                            val = prop.getPropertyName() + ": " + val;
                            this.addUtterance("", val);
                        }
                    } else if (detailLevel <= 2) {
                        // empty if block
                    }
                }
                if (withChildren && ReportNarrative.this.contentOptions.withChildrenList && ((children = this.indi.getChildren()).length > 0 || ReportNarrative.this.parameterOptions.alwaysChildren)) {
                    this.doc.nextParagraph("linefeed-treatment=preserve, white-space-treatment=preserve, line-height=50%");
                    this.doc.addText(" ");
                    this.doc.nextParagraph("font-weight=bold, space-before=0.2cm, space-after=0.2cm");
                    Fam[] families = this.indi.getFamiliesWhereSpouse(!ReportNarrative.this.parameterOptions.keepWeddingGedcomOrder);
                    if (families.length > 1) {
                        this.doc.startList("font-weight=bold, text-align=justify, keep-with-next.within-page=always");
                    }
                    for (int i = 0; i < families.length; ++i) {
                        Fam family = families[i];
                        children = family.getChildren();
                        if (families.length > 1) {
                            this.doc.nextListItem("genj:label=" + (i + 1) + ".");
                        }
                        String str = Utterance.forProperty(ReportNarrative.this.getResources(), "phrase.children.of.parents", new String[]{this.getName(family.getHusband()), this.getName(family.getWife())}, new Entity[]{family.getHusband(), family.getWife()}).toString();
                        this.doc.addText(str.substring(0, 1).toUpperCase() + str.substring(1));
                        if (children.length > 0) {
                            this.doc.startList("font-weight=normal, space-before=0.2cm, space-after=0.2cm, text-align=justify, keep-with-next.within-page=always");
                            for (int j = 0; j < children.length; ++j) {
                                this.doc.nextListItem("genj:label=" + (j + 1) + ".");
                                Indi child = children[j];
                                IndiWriter w = new IndiWriter(child, this.doc);
                                w.writeEntry(false, 3, false, true, false);
                            }
                            this.doc.endList();
                            continue;
                        }
                        this.doc.startList("font-weight=normal, space-before=0.2cm, space-after=0.2cm, keep-with-next.within-page=always");
                        this.doc.nextListItem("genj:label= ");
                        this.doc.addText(Utterance.forProperty(ReportNarrative.this.getResources(), "phrase.no.child").toString());
                        this.doc.endList();
                    }
                    if (families.length > 1) {
                        this.doc.endList();
                    }
                }
                if (ReportNarrative.this.contentOptions.withSources && detailLevel >= 5) {
                    this.writeSources(usedProperties);
                }
            }
            catch (Exception e) {
                LOG.log(Level.INFO, "Error during narrative report.", e);
                this.addUtterance("sentence.error");
                ReportNarrative.this.println(Utterance.forProperty(ReportNarrative.this.getResources(), "sentence.error.log", new String[]{this.indi.getId()}).toString());
            }
        }

        private void addGenderSpecificUtterance(String key, Indi indi, String param1) {
            String abbrevKey = "abbrev." + key;
            if (ReportNarrative.this.parameterOptions.useAbbrevations && Utterance.isTranslatable(abbrevKey, ReportNarrative.this.getResources())) {
                this.addUtterance(indi, abbrevKey, param1);
            } else {
                this.addUtterance(indi, this.genderSpecificKey("phrase." + key, indi.getSex()), param1);
            }
        }

        private void addUtterance(String key) {
            this.doc.addText(Utterance.forProperty(ReportNarrative.this.getResources(), key).toString());
        }

        private void addUtterance(String key, String value1) {
            if (!value1.isEmpty()) {
                if (key.isEmpty()) {
                    this.doc.addText(value1);
                } else {
                    this.doc.addText(Utterance.forProperty(ReportNarrative.this.getResources(), key, new String[]{value1}).toString());
                }
            }
        }

        private void addUtterance(Indi indi, String key, String value1) {
            Utterance u = Utterance.forProperty(ReportNarrative.this.getResources(), key, new String[]{value1});
            u.setSubject(indi);
            this.doc.addText(u.toString());
        }

        private void insertImages() {
            Property[] props;
            for (Property prop : props = this.indi.getProperties(new TagPath("INDI:OBJE"))) {
                PropertyFile file = null;
                if (prop instanceof PropertyXRef) {
                    PropertyXRef pxref = (PropertyXRef)prop;
                    Entity e = pxref.getTargetEntity();
                    if (e.getProperty("FILE") != null) {
                        file = (PropertyFile)e.getProperty("FILE");
                    }
                } else if (prop.getProperty("FILE") != null) {
                    file = (PropertyFile)prop.getProperty("FILE");
                }
                if (file == null) continue;
                InputSource inputSource = MediaRenderer.getSource(file);
                this.doc.addImage(inputSource, "", false);
                this.doc.addText(" ");
            }
            this.doc.nextParagraph("text-align=justify");
        }

        private void writeSource(Source prop, String sourceTag, String page) {
            String date;
            String[] tags;
            if (ReportNarrative.this.sourceIndexTitle != null) {
                String key = prop.getProperty("REFN") != null ? prop.getProperty("REFN").getValue() : prop.getId();
                this.doc.addLink("[" + key + "]", prop.getLinkAnchor());
            }
            Utterance u = this.getSentenceForTag("phrase.SOUR");
            for (String tag : tags = new String[]{"REFN", "TYPE", "TITL", "AUTH", "EDIT", "INTV", "INFT", "OWNR"}) {
                this.addOptionalParam(u, prop, tag);
            }
            if (!"".equals(page)) {
                u.set("OPTIONAL_PAGE", ", " + Utterance.forProperty(ReportNarrative.this.getResources(), "abbrev.page") + " " + page);
            }
            if ((date = ReportNarrative.this.getDatePhrase((Property)prop)).length() > 1) {
                u.set("OPTIONAL_DATE", date);
            }
            u.set("ending.OPTIONAL_TAG", sourceTag);
            if (ReportNarrative.this.parameterOptions.withSourceText) {
                this.addOptionalParam(u, prop, "TEXT");
            }
            if (!"".equals(u.toString())) {
                this.doc.nextParagraph("font-style=italic, font-size=smaller");
                this.doc.addText(" " + u.toString() + "");
            }
        }

        private void writeSourceReference(PropertySource source, String tag) {
            Entity theSource = source.getTargetEntity();
            ReportNarrative.this.bibliography.add((Source)theSource);
            String key = theSource.getProperty("REFN") != null ? theSource.getProperty("REFN").getValue() : theSource.getId();
            String page = source.getPropertyValue("PAGE");
            if (!"".equals(page)) {
                Utterance u = ReportNarrative.this.getUtterance(ReportNarrative.this.parameterOptions.useAbbrevations ? "abbrev.page" : "phrase.SOUR.PAGE");
                page = ", " + u.toString() + " " + page;
            }
            this.doc.nextParagraph("font-style=italic, font-size=smaller");
            this.doc.addText("[" + tag + " : ");
            this.doc.addLink(key, theSource.getLinkAnchor());
            this.doc.addText(page + "]");
        }

        private void writeSources(Set<Property> usedProperties) {
            Property[] sources;
            boolean isSources = false;
            Iterator<Property> iterator = usedProperties.iterator();
            if (iterator.hasNext()) {
                Property prop = iterator.next();
                sources = prop.getProperties("SOUR");
                boolean bl = isSources = sources.length > 0;
            }
            if (isSources) {
                this.doc.nextParagraph("linefeed-treatment=preserve, white-space-treatment=preserve, line-height=50%");
                this.doc.addText(" ");
                this.doc.nextParagraph("font-style=italic, font-weight=bold, space-after=0.1cm");
                this.addUtterance("phrase.source.header");
                for (Property prop : usedProperties) {
                    Property[] propertyArray = sources = prop.getProperties("SOUR");
                    int n = propertyArray.length;
                    for (int i = 0; i < n; ++i) {
                        Property source;
                        Property currentSource = source = propertyArray[i];
                        if (source instanceof PropertySource) {
                            currentSource = ((PropertySource)source).getTargetEntity();
                            if (ReportNarrative.this.parameterOptions.withBibliography) {
                                this.writeSourceReference((PropertySource)source, Gedcom.getReportName((String)prop.getTag()));
                                continue;
                            }
                            this.writeSource((Source)currentSource, Gedcom.getReportName((String)prop.getTag()), source.getPropertyValue("PAGE"));
                            continue;
                        }
                        if (source == null || !ReportNarrative.this.parameterOptions.withSourceText) continue;
                        this.doc.nextParagraph("font-style=italic, font-size=smaller");
                        this.doc.addText("[" + Gedcom.getReportName((String)prop.getTag()) + " : ");
                        this.doc.addText(source.getValue());
                        this.doc.addText("]");
                    }
                }
            }
        }

        private void addOptionalParam(Utterance u, Source prop, String tag) {
            if (prop.getProperty(tag) != null) {
                String value;
                String phraseKey = "phrase." + prop.getTag() + "." + tag;
                if (ReportNarrative.this.translate(phraseKey) != null) {
                    Utterance phrase = Utterance.forTemplate(ReportNarrative.this.getResources(), ReportNarrative.this.translate(phraseKey), new String[]{prop.getProperty(tag).getValue()});
                    value = phrase.toString();
                } else {
                    value = prop.getProperty(tag).getValue();
                }
                if (tag.equals("TYPE")) {
                    value = "(" + value + ")";
                } else if (tag.equals("TITL")) {
                    value = "\"" + value + "\"";
                }
                u.set("OPTIONAL_" + tag, value);
            }
        }

        private boolean propertyDefined(String key) {
            return !ReportNarrative.this.translate(key).equals(key);
        }

        private String genderSpecificKey(String key, int gender) {
            String suffix;
            String string = gender == 1 ? ".male" : (suffix = gender == 2 ? ".female" : ".genderUnknown");
            if (this.propertyDefined(key + suffix)) {
                return key + suffix;
            }
            return key;
        }

        private void printEventUtterance(Property prop) {
            Utterance s = this.getSentenceForTag(prop.getTag(), new String[]{prop.getValue()});
            s.setSubject(this.indi);
            this.completeEventUtterance(s, prop);
            this.doc.addText(" " + s.toString());
            this.addFootNote(prop);
        }

        private void addFootNote(Property prop) {
            if (ReportNarrative.this.contentOptions.withNotes && ReportNarrative.this.parameterOptions.withAllNotes && prop != null && prop.getProperty("NOTE") != null) {
                Property note = prop.getProperty("NOTE");
                if (note instanceof PropertyXRef) {
                    Entity ref = ((PropertyXRef)note).getTargetEntity();
                    this.doc.addFootnote(ref.getValue(), ReportNarrative.this.parameterOptions.putCallbackItalic);
                } else {
                    this.doc.addFootnote(note.getValue(), ReportNarrative.this.parameterOptions.putCallbackItalic);
                }
            }
        }

        private void completeEventUtterance(Utterance s, Property prop) {
            String place = this.getPlaceString(prop, null);
            if (place.length() > 0) {
                s.set("OPTIONAL_PP_PLACE", place);
            }
            if (prop.getProperty("AGNC") != null) {
                Utterance agency = Utterance.forProperty(ReportNarrative.this.getResources(), "phrase." + prop.getTag() + ".AGENCY", new String[]{prop.getProperty("AGNC").getValue()});
                s.set("OPTIONAL_AGENCY", agency.toString());
            }
            String date = "";
            if (prop.getProperty("DATE") != null) {
                date = ReportNarrative.this.getDatePhrase(prop.getProperty("DATE"));
            }
            if (date.length() > 0) {
                s.set("OPTIONAL_PP_DATE", date);
            }
            if (prop.getProperty("TYPE") != null) {
                s.set("OPTIONAL_TYPE", prop.getProperty("TYPE").getDisplayValue());
            }
            if (ReportNarrative.this.parameterOptions.showAges && prop.getProperty("AGE") != null) {
                s.set("OPTIONAL_PP_AGE", Utterance.forProperty(ReportNarrative.this.getResources(), "phrase.at_age", new String[]{prop.getProperty("AGE").getReportValue()}).toString());
            }
        }

        private Utterance getSentenceForTag(String tag) {
            return this.getSentenceForTag(tag, new String[0]);
        }

        private Utterance getSentenceForTag(String tag, String[] params) {
            String template1 = ReportNarrative.this.translate("sentence." + tag);
            if (template1 == null) {
                template1 = "{SUBJECT} " + tag + "{OPTIONAL_AGENCY}{OPTIONAL_PP_PLACE}{OPTIONAL_PP_DATE}.";
            }
            Utterance u = Utterance.forTemplate(ReportNarrative.this.getResources(), template1, params);
            u.setSubject(this.indi);
            return u;
        }

        private String getPlaceString(Property prop, String preposition) {
            PropertyPlace place;
            if (prop == null) {
                return "";
            }
            StringBuilder result = new StringBuilder();
            Property addr = prop.getProperty("ADDR");
            if (addr != null) {
                this.appendToPlace(result, addr);
                this.appendToPlace(result, addr.getProperty("ADR1"));
                this.appendToPlace(result, addr.getProperty("ADR2"));
                this.appendToPlace(result, addr.getProperty("CITY"));
                this.appendToPlace(result, addr.getProperty("STAE"));
                this.appendToPlace(result, addr.getProperty("CTRY"));
            } else if (prop.getProperty("PLAC") != null) {
                place = (PropertyPlace)prop.getProperty("PLAC");
                String placeFormatted = place.format(ReportNarrative.this.parameterOptions.placeFormat);
                placeFormatted = !"".equals(placeFormatted) ? placeFormatted.replaceAll("\\(\\)", " ").trim() : "";
                result.append(placeFormatted);
            }
            if (result.length() == 0) {
                return "";
            }
            if (ReportNarrative.this.placeIndexTitle != null) {
                if (prop.getProperty("PLAC") != null) {
                    place = (PropertyPlace)prop.getProperty("PLAC");
                    this.doc.addIndexTerm(ReportNarrative.this.placeIndexTitle, place.format(ReportNarrative.this.parameterOptions.placeIndexFormat));
                } else {
                    this.doc.addIndexTerm(ReportNarrative.this.placeIndexTitle, result.toString());
                }
            }
            if (preposition == null) {
                String key = "prep.in_city";
                if (Character.isDigit(result.charAt(0))) {
                    key = "prep.at_street_address";
                }
                preposition = ReportNarrative.this.translate(key);
            }
            return " " + preposition + " " + result;
        }

        private void appendToPlace(StringBuilder result, Property prop) {
            if (prop != null && !prop.getValue().isEmpty()) {
                if (result.length() > 0) {
                    result.append(", ");
                }
                result.append(prop.getValue());
            }
        }
    }
}

