/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans;

import java.text.MessageFormat;
import java.util.Collections;
import java.util.Set;
import org.netbeans.Module;
import org.openide.util.NbBundle;

final class IllegalModuleException
extends IllegalArgumentException {
    private final Reason reason;
    private final Set<Module> bogus;

    IllegalModuleException(Reason reason, Module bogus) {
        this(reason, Collections.singleton(bogus));
    }

    IllegalModuleException(Reason reason, Set<Module> bogus) {
        this.reason = reason;
        this.bogus = bogus;
    }

    @Override
    public String getMessage() {
        return MessageFormat.format(this.reason.msg, this.bogus);
    }

    @Override
    public String getLocalizedMessage() {
        if (this.reason.l10n != null) {
            StringBuilder sb = new StringBuilder();
            for (Module m : this.bogus) {
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append(m.getDisplayName());
            }
            return NbBundle.getMessage(Reason.class, (String)this.reason.l10n, (Object)sb.toString());
        }
        return this.getMessage();
    }

    static enum Reason {
        DELETE_FIXED_MODULE("fixed module: {0}"),
        DELETE_ENABLED_MODULE("enabled module: {0}"),
        RELOAD_FIXED_MODULE("reload fixed module: {0}"),
        RELOAD_ENABLED_MODULE("reload enabled module: {0}"),
        ENABLE_MISSING("Not all requested modules can be enabled: {0}", "MSG_ENABLE_MISSING"),
        ENABLE_TESTING("Would also need to enable: {0}"),
        DISABLE_TOO("Would also need to disable: {0}"),
        SIMULATE_ENABLE_AUTOLOAD("Cannot simulate enabling an autoload: {0}", "MSG_ENABLE_MISSING"),
        SIMULATE_ENABLE_EAGER("Cannot simulate enabling an eager module: {0}", "MSG_ENABLE_MISSING"),
        SIMULATE_ENABLE_ALREADY("Already enabled: {0}"),
        SIMULATE_ENABLE_INVALID("Not managed by me: {0}"),
        SIMULATE_DISABLE_AUTOLOAD("Cannot disable autoload: {0}"),
        SIMULATE_DISABLE_EAGER("Cannot disable eager module: {0}"),
        SIMULATE_DISABLE_FIXED("Cannot disable fixed module: {0}"),
        SIMULATE_DISABLE_ALREADY("Already disabled: {0}");

        final String msg;
        final String l10n;

        private Reason(String msg) {
            this(msg, null);
        }

        private Reason(String msg, String l10n) {
            this.msg = msg;
            this.l10n = l10n;
        }
    }
}

