/*
 * Decompiled with CFR 0.152.
 */
package genj.timeline;

import genj.gedcom.Gedcom;
import genj.gedcom.PropertyDate;
import genj.timeline.Model;
import genj.timeline.TimelineView;
import genj.util.swing.ImageIcon;
import genj.util.swing.UnitGraphics;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class ContentRenderer {
    protected Point2D.Double dotSize = new Point2D.Double();
    protected GeneralPath fromMark;
    protected GeneralPath toMark;
    protected GeneralPath eventMark;
    boolean paintTags = false;
    boolean paintDates = true;
    boolean paintGrid = false;
    List<Model.Event> selectionEvent = new LinkedList<Model.Event>();
    List<Model.EventSerie> selectionEventSerie = new LinkedList<Model.EventSerie>();
    Color cBackground = null;
    Color cText = null;
    Color cTag = null;
    Color cDate = null;
    Color cTimespanM = null;
    Color cTimespanF = null;
    Color cTimespanU = null;
    Color cGrid = null;
    Color cSelected = null;
    Color cSelectedBg = null;

    public void render(UnitGraphics graphics, Model model, int mode) {
        this.init(graphics);
        this.renderBackground(graphics, model);
        this.renderGrid(graphics, model);
        this.renderLayers(graphics, model, mode);
    }

    protected void renderBackground(UnitGraphics g, Model model) {
        if (this.cBackground == null) {
            return;
        }
        g.setColor(this.cBackground);
        Rectangle2D.Double r = new Rectangle2D.Double(model.min, 0.0, model.max - model.min, model.getMaxLayersNumber());
        g.draw((Shape)r, 0.0, 0.0, true);
    }

    private void renderGrid(UnitGraphics g, Model model) {
        if (!this.paintGrid) {
            return;
        }
        g.setColor(this.cGrid);
        Rectangle2D r = g.getClip();
        double from = Math.floor(r.getMinX());
        double to = Math.ceil(r.getMaxX());
        double step = this.getYearStep(g, model);
        for (double year = Math.ceil(from / step) * step; year < to; year += step) {
            g.draw(year, 0.0, year, (double)model.getMaxLayersNumber());
        }
    }

    private void renderLayers(UnitGraphics g, Model model, int mode) {
        List<List<Object>> eventLayers;
        List<List<Object>> list = eventLayers = mode == TimelineView.INDI_MODE ? model.indiLayers : model.eventLayers;
        if (eventLayers == null) {
            return;
        }
        Rectangle2D clip = g.getClip();
        for (int l = 0; l < eventLayers.size(); ++l) {
            if ((double)l < Math.floor(clip.getMinY()) || (double)l > Math.ceil(clip.getMaxY())) continue;
            List<Object> layer = eventLayers.get(l);
            if (mode == TimelineView.INDI_MODE) {
                this.renderEventSeries(g, model, layer, l);
                continue;
            }
            this.renderEvents(g, model, layer, l);
        }
    }

    private void renderEvents(UnitGraphics g, Model model, List layer, int level) {
        Rectangle2D clip = g.getClip();
        Iterator events = layer.iterator();
        Model.Event event = (Model.Event)events.next();
        while (true) {
            Model.Event next;
            Model.Event event2 = next = events.hasNext() ? (Model.Event)events.next() : null;
            if ((next == null || next.from > clip.getMinX()) && event.from < clip.getMaxX()) {
                this.renderEvent(g, model, event, next, level);
            }
            if (next == null) break;
            event = next;
        }
    }

    private void renderEventSeries(UnitGraphics g, Model model, List layer, int level) {
        Rectangle2D clip = g.getClip();
        Iterator eventSeries = layer.iterator();
        Model.EventSerie eventSerie = (Model.EventSerie)eventSeries.next();
        while (true) {
            Model.EventSerie next;
            Model.EventSerie eventSerie2 = next = eventSeries.hasNext() ? (Model.EventSerie)eventSeries.next() : null;
            if ((next == null || next.from > clip.getMinX()) && eventSerie.from < clip.getMaxX()) {
                this.renderEventSerie(g, model, eventSerie, next, level);
            }
            if (next == null) break;
            eventSerie = next;
        }
    }

    private void renderEvent(UnitGraphics g, Model model, Model.Event event, Model.Event next, int level) {
        boolean em = this.selectionEvent.contains(event);
        FontMetrics fm = g.getFontMetrics();
        int sex = event.getSex();
        g.setColor(sex == 1 ? this.cTimespanM : (sex == 2 ? this.cTimespanF : this.cTimespanU));
        PropertyDate.Format format = event.pd.getFormat();
        if (format == PropertyDate.AFTER || format == PropertyDate.FROM) {
            g.draw((Shape)this.fromMark, event.from, (double)(level + 1), true);
        } else if (format == PropertyDate.BEFORE || format == PropertyDate.TO) {
            g.draw((Shape)this.toMark, event.from, (double)(level + 1), true);
        } else {
            g.draw((Shape)this.fromMark, event.from, (double)(level + 1), true);
            g.draw(event.from, (double)(level + 1) - this.dotSize.y, event.to, (double)(level + 1) - this.dotSize.y);
            g.draw((Shape)this.toMark, event.to, (double)(level + 1), true);
        }
        int dx = 0;
        double left = event.from - 1.0;
        String tag = Gedcom.getName((String)event.pe.getTag());
        String txt = event.content;
        String date = " (" + event.pd.getDisplayValue() + ')';
        int width = fm.stringWidth(tag + txt + date) + 3 * fm.charWidth(' ');
        double right = left + (double)width;
        if (next != null) {
            right = Math.min(right, next.from);
        }
        if (!this.paintTags) {
            ImageIcon img = event.pe.getImage(false);
            g.pushClip(left, (double)level, right, (double)(level + 2));
            g.draw(img, event.from, (double)level + 0.5, 0.0, 0.5);
            g.popClip();
            dx += img.getIconWidth() + 2;
        }
        if (this.paintTags) {
            g.setColor(this.cTag);
            g.pushClip(left, (double)level, right, (double)(level + 2));
            g.draw(tag, event.from, (double)level + 0.5, 0.0, 0.5, dx, 0);
            g.popClip();
            dx += fm.stringWidth(tag) + fm.charWidth(' ');
        }
        g.pushClip(left, (double)level, right, (double)(level + 2));
        g.draw(txt, event.from, (double)level + 0.5, 0.0, 0.5, dx, 0, em ? this.cSelected : this.cText, em ? this.cSelectedBg : null);
        g.popClip();
        dx += fm.stringWidth(txt) + fm.charWidth(' ');
        if (this.paintDates) {
            g.setColor(this.cDate);
            g.pushClip(left, (double)level, right, (double)(level + 2));
            g.draw(date, event.from, (double)level + 0.5, 0.0, 0.5, dx, 0);
            g.popClip();
        }
    }

    private void renderEventSerie(UnitGraphics g, Model model, Model.EventSerie eventSerie, Model.EventSerie next, int level) {
        if (eventSerie.indi == null) {
            return;
        }
        boolean em = this.selectionEventSerie.contains(eventSerie);
        FontMetrics fm = g.getFontMetrics();
        BasicStroke dotted = new BasicStroke(1.0f, 1, 1, 0.0f, new float[]{2.0f}, 0.0f);
        int sex = eventSerie.getSex();
        g.setColor(sex == 1 ? this.cTimespanM : (sex == 2 ? this.cTimespanF : this.cTimespanU));
        g.draw((Shape)this.fromMark, eventSerie.from, (double)(level + 1), true);
        g.draw(eventSerie.getFrom(), (double)(level + 1) - this.dotSize.y, eventSerie.getFirstEvent().from, (double)(level + 1) - this.dotSize.y, (Stroke)dotted);
        g.draw(eventSerie.getFirstEvent().from, (double)(level + 1) - this.dotSize.y, eventSerie.getLastEvent().to, (double)(level + 1) - this.dotSize.y);
        g.draw(eventSerie.getLastEvent().to, (double)(level + 1) - this.dotSize.y, eventSerie.to, (double)(level + 1) - this.dotSize.y, (Stroke)dotted);
        g.draw((Shape)this.toMark, eventSerie.getTo(), (double)(level + 1), true);
        for (double d : eventSerie.getDates()) {
            if (d == eventSerie.from || d == eventSerie.to) continue;
            g.draw((Shape)this.eventMark, d, (double)(level + 1), true);
        }
        int dx = 6;
        String tag = Gedcom.getName((String)eventSerie.getTag());
        String txt = eventSerie.content;
        String date = " (" + eventSerie.getDisplayDates() + ')';
        int width = fm.stringWidth(tag + txt + date) + 3 * fm.charWidth(' ');
        double left = eventSerie.from - 1.0;
        double right = left + (double)width;
        if (next != null) {
            right = Math.min(right, next.from);
        }
        if (!this.paintTags) {
            ImageIcon img = eventSerie.getImage();
            g.pushClip(left, (double)level, right, (double)(level + 2));
            g.draw(img, eventSerie.from, (double)level + 0.5, 0.0, 0.5, dx, 0);
            g.popClip();
            dx += img.getIconWidth() + 2;
        }
        if (this.paintTags) {
            g.setColor(this.cTag);
            g.pushClip(left, (double)level, right, (double)(level + 2));
            g.draw(tag, eventSerie.from, (double)level + 0.5, 0.0, 0.5, dx, 0);
            g.popClip();
            dx += fm.stringWidth(tag) + fm.charWidth(' ');
        }
        g.pushClip(left, (double)level, right, (double)(level + 2));
        g.draw(txt, eventSerie.from, (double)level + 0.5, 0.0, 0.5, dx, 0, em ? this.cSelected : this.cText, em ? this.cSelectedBg : null);
        g.popClip();
        dx += fm.stringWidth(txt) + fm.charWidth(' ');
        if (this.paintDates) {
            g.setColor(this.cDate);
            g.pushClip(left, (double)level, right, (double)(level + 2));
            g.draw(date, eventSerie.from, (double)level + 0.5, 0.0, 0.5, dx, 0);
            g.popClip();
        }
    }

    double getYearStep(UnitGraphics graphics, Model model) {
        FontMetrics fm = graphics.getFontMetrics();
        double width = (double)fm.stringWidth(" 0000 ") * this.dotSize.x;
        double step = Math.ceil(width);
        if (step == 1.0) {
            return step;
        }
        if (step <= 5.0) {
            return 5.0;
        }
        if (step <= 50.0) {
            return 10.0 * Math.ceil(step / 10.0);
        }
        return 100.0 * Math.ceil(step / 100.0);
    }

    protected void init(UnitGraphics graphics) {
        this.dotSize.setLocation(1.0 / graphics.getUnit().getX(), 1.0 / graphics.getUnit().getY());
        this.fromMark = new GeneralPath();
        this.fromMark.moveTo((float)(4.0 * this.dotSize.x), (float)(-1.0 * this.dotSize.y));
        this.fromMark.lineTo((float)(-1.0 * this.dotSize.x), (float)(-6.0 * this.dotSize.y));
        this.fromMark.lineTo((float)(-1.0 * this.dotSize.x), (float)(4.0 * this.dotSize.y));
        this.fromMark.closePath();
        this.toMark = new GeneralPath();
        this.toMark.moveTo((float)(-4.0 * this.dotSize.x), (float)(-1.0 * this.dotSize.y));
        this.toMark.lineTo((float)(1.0 * this.dotSize.x), (float)(-6.0 * this.dotSize.y));
        this.toMark.lineTo((float)(1.0 * this.dotSize.x), (float)(4.0 * this.dotSize.y));
        this.toMark.closePath();
        this.eventMark = new GeneralPath();
        this.eventMark.moveTo((float)(-5.0 * this.dotSize.x), (float)(-1.0 * this.dotSize.y));
        this.eventMark.lineTo((float)(-1.0 * this.dotSize.x), (float)(-5.0 * this.dotSize.y));
        this.eventMark.lineTo((float)(3.0 * this.dotSize.x), (float)(-1.0 * this.dotSize.y));
        this.eventMark.lineTo((float)(-1.0 * this.dotSize.x), (float)(3.0 * this.dotSize.y));
        this.eventMark.closePath();
    }
}

