/*
 * Decompiled with CFR 0.152.
 */
package genj.view;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.awt.image.BandedSampleModel;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;

public class BigBufferedImage
extends BufferedImage {
    private static final int MAX_PIXELS_IN_MEMORY = 50000000;

    public static BigBufferedImage create(File tempDir, int width, int height, int imageType) throws IOException {
        FileDataBuffer buffer = new FileDataBuffer(tempDir, width * height, 4);
        ComponentColorModel colorModel = null;
        BandedSampleModel sampleModel = null;
        switch (imageType) {
            case 1: {
                colorModel = new ComponentColorModel(ColorSpace.getInstance(1000), new int[]{8, 8, 8, 0}, false, false, 3, 0);
                sampleModel = new BandedSampleModel(0, width, height, 3);
                break;
            }
            case 2: {
                colorModel = new ComponentColorModel(ColorSpace.getInstance(1000), new int[]{8, 8, 8, 8}, true, false, 3, 0);
                sampleModel = new BandedSampleModel(0, width, height, 4);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported image type: " + imageType);
            }
        }
        SimpleRaster raster = new SimpleRaster(sampleModel, buffer, new Point(0, 0));
        BigBufferedImage image = new BigBufferedImage(colorModel, raster, colorModel.isAlphaPremultiplied(), null);
        return image;
    }

    public static BigBufferedImage create(File inputFile, File tempDir, int imageType) throws IOException {
        ImageInputStream stream = ImageIO.createImageInputStream(inputFile);
        Iterator<ImageReader> readers = ImageIO.getImageReaders(stream);
        if (readers.hasNext()) {
            try {
                ImageReader reader = readers.next();
                reader.setInput(stream, true, true);
                int width = reader.getWidth(reader.getMinIndex());
                int height = reader.getHeight(reader.getMinIndex());
                BigBufferedImage image = BigBufferedImage.create(tempDir, width, height, imageType);
                int cores = Math.max(1, Runtime.getRuntime().availableProcessors() / 2);
                int block = Math.min(50000000 / cores / width, (int)Math.ceil((double)height / (double)cores));
                ExecutorService generalExecutor = Executors.newFixedThreadPool(cores);
                ArrayList<ImagePartLoader> partLoaders = new ArrayList<ImagePartLoader>();
                for (int y = 0; y < height; y += block) {
                    partLoaders.add(new ImagePartLoader(y, width, Math.min(block, height - y), inputFile, image));
                }
                generalExecutor.invokeAll(partLoaders);
                generalExecutor.shutdown();
                return image;
            }
            catch (InterruptedException ex) {
                Logger.getLogger(BigBufferedImage.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return null;
    }

    private BigBufferedImage(ColorModel cm, WritableRaster raster, boolean isRasterPremultiplied, Hashtable<?, ?> properties) {
        super(cm, raster, isRasterPremultiplied, properties);
    }

    public Rectangle getRectangle() {
        return new Rectangle(0, 0, this.getWidth(), this.getHeight());
    }

    private static class FileDataBuffer
    extends DataBuffer {
        private final String id = "buffer-" + System.currentTimeMillis() + "-" + (int)(Math.random() * 1000.0);
        private File dir;
        private String path;
        private MappedByteBuffer[] buffer;

        public FileDataBuffer(File dir, int size) throws FileNotFoundException, IOException {
            super(0, size);
            this.dir = dir;
            this.init();
        }

        public FileDataBuffer(File dir, int size, int numBanks) throws FileNotFoundException, IOException {
            super(0, size, numBanks);
            this.dir = dir;
            this.init();
        }

        private void init() throws FileNotFoundException, IOException {
            if (this.dir == null) {
                this.dir = new File(".");
            }
            if (!this.dir.exists()) {
                throw new RuntimeException("FileDataBuffer constructor parameter dir does not exist: " + this.dir);
            }
            if (!this.dir.isDirectory()) {
                throw new RuntimeException("FileDataBuffer constructor parameter dir is not a directory: " + this.dir);
            }
            this.path = this.dir.getPath() + "/" + this.id;
            File subDir = new File(this.path);
            subDir.mkdir();
            subDir.deleteOnExit();
            this.buffer = new MappedByteBuffer[this.banks];
            for (int i = 0; i < this.banks; ++i) {
                File file = new File(this.path + "/bank" + i + ".dat");
                file.deleteOnExit();
                this.buffer[i] = new RandomAccessFile(file, "rw").getChannel().map(FileChannel.MapMode.READ_WRITE, 0L, this.getSize());
            }
        }

        @Override
        public int getElem(int bank, int i) {
            return this.buffer[bank].get(i) & 0xFF;
        }

        @Override
        public void setElem(int bank, int i, int val) {
            this.buffer[bank].put(i, (byte)val);
        }
    }

    private static class SimpleRaster
    extends WritableRaster {
        public SimpleRaster(SampleModel sampleModel, DataBuffer dataBuffer, Point origin) {
            super(sampleModel, dataBuffer, origin);
        }
    }

    private static class ImagePartLoader
    implements Callable<ImagePartLoader> {
        private final int y;
        private final BigBufferedImage image;
        private final Rectangle region;
        private final File file;

        public ImagePartLoader(int y, int width, int height, File file, BigBufferedImage image) {
            this.y = y;
            this.image = image;
            this.file = file;
            this.region = new Rectangle(0, y, width, height);
        }

        @Override
        public ImagePartLoader call() throws Exception {
            Thread.currentThread().setPriority(3);
            ImageInputStream stream = ImageIO.createImageInputStream(this.file);
            Iterator<ImageReader> readers = ImageIO.getImageReaders(stream);
            if (readers.hasNext()) {
                ImageReader reader = readers.next();
                reader.setInput(stream, true, true);
                ImageReadParam param = reader.getDefaultReadParam();
                param.setSourceRegion(this.region);
                BufferedImage part = reader.read(0, param);
                WritableRaster source = part.getRaster();
                WritableRaster target = this.image.getRaster();
                target.setRect(0, this.y, source);
            }
            return this;
        }
    }
}

