/*
 * Decompiled with CFR 0.152.
 */
package ancestris.util;

import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.gedcom.PropertyForeignXRef;
import genj.gedcom.PropertyName;
import genj.gedcom.PropertyXRef;
import genj.gedcom.TagPath;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GedcomUtilities {
    private static final Logger LOG = Logger.getLogger(GedcomUtilities.class.getName(), null);
    private static Map<String, Set<String>> allows = new HashMap<String, Set<String>>();

    public static <T> List<T> searchProperties(Gedcom gedcom, Class<T> type, String entityTag) {
        LOG.log(Level.FINER, "Searching for property {0}", type.getClass());
        Collection<Entity> entities = entityTag == null || entityTag.isEmpty() ? gedcom.getEntities() : gedcom.getEntities(entityTag);
        ArrayList<T> foundProperties = new ArrayList<T>();
        for (Entity entity : entities) {
            foundProperties.addAll(GedcomUtilities.searchPropertiesRecursively(entity, type));
        }
        LOG.log(Level.FINER, "found  {0}", foundProperties.size());
        return foundProperties;
    }

    private static <T> List<T> searchPropertiesRecursively(Property parent, Class<T> type) {
        ArrayList<Property> foundProperties = new ArrayList<Property>();
        for (Property child : parent.getProperties()) {
            if (type.isAssignableFrom(child.getClass())) {
                foundProperties.add(child);
            }
            foundProperties.addAll(GedcomUtilities.searchPropertiesRecursively(child, type));
        }
        return foundProperties;
    }

    public static int deleteTags(Gedcom gedcom, String tagToRemove, String entityTag, boolean emptyTagOnly) {
        LOG.log(Level.FINER, "deleting_tag {0}", tagToRemove);
        if (tagToRemove.trim().isEmpty()) {
            return 0;
        }
        int iCounter = 0;
        Collection<Entity> entities = entityTag == null || entityTag.isEmpty() ? gedcom.getEntities() : gedcom.getEntities(entityTag);
        for (Entity entity : entities) {
            List<Property> propsToDelete = entity.getAllProperties(tagToRemove);
            for (Property prop : propsToDelete) {
                Property parent;
                boolean isEmpty;
                boolean bl = isEmpty = prop.getValue().length() == 0 && prop.getNoOfProperties() == 0;
                if (emptyTagOnly && !isEmpty || (parent = prop.getParent()) == null) continue;
                String propText = parent.getTag() + " " + tagToRemove + " '" + prop.toString() + "'";
                parent.delProperty(prop);
                ++iCounter;
                LOG.log(Level.FINER, "deleting_tag {0} {1} {2}", new Object[]{entity.getTag(), entity.toString(), propText});
            }
        }
        LOG.log(Level.FINER, "DeletedNb {0}", iCounter);
        return iCounter;
    }

    public static void MergeEntities(Entity dest, Entity src) {
        GedcomUtilities.MergeEntities(dest, src, false);
    }

    public static void MergeEntities(Entity dest, Entity src, boolean addOnly) {
        GedcomUtilities.MergeEntities(dest, src, Arrays.asList(src.getProperties()), addOnly);
    }

    public static void MergeEntities(Entity dest, Entity src, List<Property> allProperties) {
        GedcomUtilities.MergeEntities(dest, src, allProperties, false);
    }

    private static void MergeEntities(Entity dest, Entity src, List<Property> allProperties, boolean addOnly) {
        LOG.log(Level.FINER, "Merging {0} with {1}", new Object[]{src.getId(), dest.getId()});
        ArrayList<Property> properties = new ArrayList<Property>();
        boolean found = false;
        for (Property prop : allProperties) {
            if (prop == null) continue;
            found = false;
            for (Property parent : GedcomUtilities.getAncestors(prop)) {
                if (!allProperties.contains(parent)) continue;
                found = true;
                break;
            }
            if (found) continue;
            properties.add(prop);
        }
        for (Property prop : properties) {
            TagPath tagPath = prop.getParent().getPath();
            String[] pathArray = tagPath.toArray();
            pathArray[0] = dest.getTag();
            TagPath destTagPath = new TagPath(pathArray, null);
            Property propDest = dest.getProperty(destTagPath);
            if (propDest == null) {
                dest.setValue(tagPath, "");
                propDest = dest.getProperty(tagPath);
            }
            try {
                GedcomUtilities.movePropertyRecursively(prop, propDest, addOnly);
            }
            catch (GedcomException ex) {
                LOG.log(Level.SEVERE, "Unexpected Gedcom exception {0}", ex);
            }
        }
        dest.getGedcom().deleteEntity(src);
    }

    private static List<Property> getAncestors(Property prop) {
        ArrayList<Property> ancestors = new ArrayList<Property>();
        for (Property parent = prop.getParent(); parent != null; parent = parent.getParent()) {
            ancestors.add(parent);
        }
        return ancestors;
    }

    public static void movePropertyRecursively(Property propertySrc, Property parentPropertyDest) throws GedcomException {
        GedcomUtilities.movePropertyRecursively(propertySrc, parentPropertyDest, false);
    }

    private static void movePropertyRecursively(Property propertySrc, Property parentPropertyDest, boolean addOnly) throws GedcomException {
        boolean isSameValue;
        Property propertyDest = parentPropertyDest.getProperty(propertySrc.getTag());
        boolean tagAlreadyExists = propertyDest != null;
        boolean isSingleton = propertySrc.getMetaProperty().isSingleton();
        int n = tagAlreadyExists ? parentPropertyDest.getPropertyPosition(propertyDest) + 1 : parentPropertyDest.getNoOfProperties();
        boolean bl = isSameValue = tagAlreadyExists && propertyDest.getValue().equals(propertySrc.getValue());
        if (propertySrc instanceof PropertyForeignXRef) {
            PropertyForeignXRef pfxref = (PropertyForeignXRef)propertySrc;
            PropertyXRef pxref = pfxref.getTarget();
            pxref.unlink();
            pxref.setValue(parentPropertyDest.getEntity().getId());
            pxref.link();
            return;
        }
        if (!tagAlreadyExists || addOnly && !isSingleton && !isSameValue) {
            propertyDest = propertySrc instanceof PropertyName ? parentPropertyDest.addProperty(propertySrc.getTag(), "", n) : parentPropertyDest.addProperty(propertySrc.getTag(), propertySrc.getValue(), n);
            if (propertyDest instanceof PropertyXRef) {
                try {
                    ((PropertyXRef)propertyDest).link();
                }
                catch (Exception e) {
                    LOG.log(Level.FINE, "", e);
                    parentPropertyDest.delProperty(propertyDest);
                }
            }
        } else if (!addOnly && !isSameValue) {
            if (propertyDest instanceof PropertyXRef) {
                try {
                    ((PropertyXRef)propertyDest).unlink();
                }
                catch (Exception e) {
                    LOG.log(Level.INFO, "", e);
                }
            }
            if (!(propertySrc instanceof PropertyName)) {
                propertyDest.setValue(propertySrc.getValue());
            }
            if (propertyDest instanceof PropertyXRef) {
                try {
                    ((PropertyXRef)propertyDest).link();
                }
                catch (Exception e) {
                    LOG.log(Level.INFO, "", e);
                }
            }
        }
        for (Property children : propertySrc.getProperties()) {
            GedcomUtilities.movePropertyRecursively(children, propertyDest, addOnly);
        }
        if (propertySrc instanceof PropertyXRef) {
            PropertyXRef pxref = (PropertyXRef)propertySrc;
            Entity ent = pxref.getTargetEntity();
            ent.delProperty(pxref.getTarget());
            propertySrc = null;
        } else {
            propertySrc.getParent().delProperty(propertySrc);
        }
    }

    public static Entity copyEntity(Entity sourceEntity, Gedcom targetGedcom, boolean richCopy) {
        Entity newEntity = null;
        try {
            newEntity = targetGedcom.createEntity(sourceEntity.getTag());
        }
        catch (GedcomException ex) {
            LOG.log(Level.INFO, "", ex);
        }
        if (newEntity == null) {
            return newEntity;
        }
        GedcomUtilities.copyPropertiesRecursively(sourceEntity, newEntity, richCopy);
        return newEntity;
    }

    public static void copyPropertiesRecursively(Property srcProperty, Property destProperty, boolean richCopy) {
        if (srcProperty == null || destProperty == null) {
            return;
        }
        for (int i = 0; i < srcProperty.getNoOfProperties(); ++i) {
            Property addedProperty;
            Property child = srcProperty.getProperty(i);
            if (child.getTag().equals("CHAN") || child instanceof PropertyForeignXRef) continue;
            if (child instanceof PropertyXRef) {
                String tag;
                Entity entityToCopy;
                Set<String> allowed;
                if (!richCopy || (allowed = allows.get(srcProperty.getEntity().getTag())) == null || (entityToCopy = ((PropertyXRef)child).getTargetEntity()) == null || !allowed.contains(tag = entityToCopy.getTag())) continue;
                Entity ent = GedcomUtilities.copyEntity(entityToCopy, destProperty.getGedcom(), richCopy);
                try {
                    Property addedProperty2 = destProperty.addProperty(child.getTag(), child.getValue(), i);
                    ((PropertyXRef)addedProperty2).setValue(ent.getId());
                    ((PropertyXRef)addedProperty2).link();
                    GedcomUtilities.copyPropertiesRecursively(child, addedProperty2, richCopy);
                }
                catch (GedcomException ex) {
                    LOG.log(Level.INFO, "", ex);
                }
                continue;
            }
            if (child instanceof PropertyName) {
                try {
                    addedProperty = destProperty.addProperty(child.getTag(), "", i);
                    GedcomUtilities.copyPropertiesRecursively(child, addedProperty, richCopy);
                }
                catch (GedcomException ex) {
                    LOG.log(Level.INFO, "", ex);
                }
                continue;
            }
            try {
                addedProperty = destProperty.addProperty(child.getTag(), child.getValue(), i);
                GedcomUtilities.copyPropertiesRecursively(child, addedProperty, richCopy);
                continue;
            }
            catch (GedcomException ex) {
                LOG.log(Level.INFO, "", ex);
            }
        }
    }

    public static Entity attach(Entity importedEntity, Property targetProperty) {
        Gedcom gedcom = targetProperty.getGedcom();
        Entity attachedEntity = importedEntity;
        if (gedcom.compareTo(importedEntity.getGedcom()) != 0) {
            attachedEntity = GedcomUtilities.copyEntity(importedEntity, gedcom, true);
        }
        try {
            Property xref = targetProperty.addProperty(attachedEntity.getTag(), '@' + attachedEntity.getId() + '@', targetProperty.getNoOfProperties());
            if (xref != null && xref instanceof PropertyXRef) {
                ((PropertyXRef)xref).link();
            }
        }
        catch (GedcomException ex) {
            LOG.log(Level.INFO, "", ex);
        }
        return targetProperty.getEntity();
    }

    public static Entity createParent(boolean isHusband, Indi indi, Fam fam, Gedcom gedcom) {
        Fam targetEntity = fam;
        Indi targetIndi = indi;
        if (fam.getGedcom().compareTo(gedcom) != 0) {
            targetEntity = (Fam)GedcomUtilities.copyEntity(fam, gedcom, true);
        }
        if (indi.getGedcom().compareTo(gedcom) != 0) {
            targetIndi = (Indi)GedcomUtilities.copyEntity(indi, gedcom, true);
        }
        PropertyXRef xref = null;
        try {
            xref = isHusband ? targetEntity.setHusband(targetIndi) : targetEntity.setWife(targetIndi);
        }
        catch (GedcomException ex) {
            LOG.log(Level.INFO, "", ex);
        }
        return xref != null ? xref.getEntity() : null;
    }

    public static Entity createChild(Indi child, Fam fam, Gedcom gedcom) {
        Fam targetEntity = fam;
        Indi targetIndi = child;
        if (fam.getGedcom().compareTo(gedcom) != 0) {
            targetEntity = (Fam)GedcomUtilities.copyEntity(fam, gedcom, true);
        }
        if (child.getGedcom().compareTo(gedcom) != 0) {
            targetIndi = (Indi)GedcomUtilities.copyEntity(child, gedcom, true);
        }
        PropertyXRef xref = null;
        try {
            xref = targetEntity.addChild(targetIndi);
        }
        catch (GedcomException ex) {
            LOG.log(Level.INFO, "", ex);
        }
        return xref != null ? xref.getEntity() : null;
    }

    public static Fam createFamily(Gedcom gedcom, Indi husb, Indi wife, Indi child) {
        Fam fam = null;
        try {
            fam = (Fam)gedcom.createEntity("FAM");
        }
        catch (GedcomException ex) {
            LOG.log(Level.INFO, "", ex);
            return null;
        }
        if (husb != null) {
            try {
                fam.setHusband(husb);
            }
            catch (GedcomException ex) {
                LOG.log(Level.INFO, "", ex);
            }
        }
        if (wife != null) {
            try {
                fam.setWife(husb);
            }
            catch (GedcomException ex) {
                LOG.log(Level.INFO, "", ex);
            }
        }
        if (child != null) {
            try {
                fam.addChild(child);
            }
            catch (GedcomException ex) {
                LOG.log(Level.INFO, "", ex);
            }
        }
        return fam;
    }

    static {
        allows.put("FAM", new HashSet<String>(Arrays.asList("INDI", "SOUR", "OBJE", "NOTE")));
        allows.put("INDI", new HashSet<String>(Arrays.asList("SOUR", "OBJE", "NOTE")));
        allows.put("SOUR", new HashSet<String>(Arrays.asList("OBJE", "NOTE", "REPO")));
        allows.put("OBJE", new HashSet<String>(Arrays.asList("NOTE")));
    }
}

