/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.print.action;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.JComponent;
import org.netbeans.modules.print.provider.ComponentProvider;
import org.netbeans.modules.print.provider.EditorProvider;
import org.netbeans.modules.print.provider.TextProvider;
import org.netbeans.modules.print.ui.Preview;
import org.netbeans.modules.print.util.Config;
import org.netbeans.modules.print.util.UI;
import org.netbeans.spi.print.PrintProvider;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.PrintCookie;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.windows.TopComponent;

public final class PrintAction
extends UI.IconAction {
    private boolean myEnabled;
    private PrintProvider[] myProviders;

    public PrintAction() {
        this("MNU_Print_Action", "TLT_Print_Action", null, false, null);
    }

    public PrintAction(PrintProvider[] providers) {
        this(null, "ACT_Print_Action", "print", true, providers);
    }

    public PrintAction(JComponent component) {
        this((PrintProvider[])null);
        this.myProviders = this.getComponentProviders(component);
    }

    private PrintAction(String name, String toolTip, String icon, boolean enabled, PrintProvider[] providers) {
        super(UI.i18n(PrintAction.class, name), UI.i18n(PrintAction.class, toolTip), UI.icon(Config.class, icon));
        this.setEnabled(enabled);
        this.myEnabled = enabled;
        this.myProviders = providers;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (this.myProviders == null) {
            this.myProviders = this.getPrintProviders();
        }
        if (this.myProviders != null) {
            Preview.getDefault().print(this.myProviders, true);
            if (!this.myEnabled) {
                this.myProviders = null;
            }
        } else {
            PrintCookie cookie = this.getPrintCookie();
            if (cookie != null) {
                cookie.print();
            }
        }
    }

    private PrintProvider[] getPrintProviders() {
        TopComponent top = UI.getActiveTopComponent();
        PrintProvider[] providers = this.getComponentProviders((JComponent)top);
        if (providers != null) {
            return providers;
        }
        providers = this.getLookupProviders(top);
        if (providers != null) {
            return providers;
        }
        return this.getCookieProviders(UI.getSelectedNodes());
    }

    private PrintProvider[] getLookupProviders(TopComponent top) {
        if (top == null) {
            return null;
        }
        return this.getProviders((PrintProvider)top.getLookup().lookup(PrintProvider.class));
    }

    private PrintProvider[] getComponentProviders(JComponent top) {
        if (top == null) {
            return null;
        }
        ArrayList<JComponent> printable = new ArrayList<JComponent>();
        this.findPrintable(top, printable);
        if (printable.size() == 0) {
            return null;
        }
        return this.getProviders(new ComponentProvider(printable, this.getName(printable, top), this.getDate(top)));
    }

    private PrintProvider[] getCookieProviders(Node[] nodes) {
        if (nodes == null) {
            return null;
        }
        ArrayList<PrintProvider> providers = new ArrayList<PrintProvider>();
        for (Node node : nodes) {
            PrintProvider provider = this.getCookieProvider(node);
            if (provider == null) continue;
            providers.add(provider);
        }
        if (providers.size() == 0) {
            return null;
        }
        return providers.toArray(new PrintProvider[providers.size()]);
    }

    private PrintProvider getCookieProvider(Node node) {
        String text = this.getText((InputStream)node.getLookup().lookup(InputStream.class));
        if (text != null) {
            return new TextProvider(text);
        }
        EditorCookie editor = (EditorCookie)node.getLookup().lookup(EditorCookie.class);
        if (editor == null) {
            return null;
        }
        if (editor.getDocument() == null) {
            return null;
        }
        return new EditorProvider(editor, this.getDate(UI.getDataObject(node)));
    }

    private void findPrintable(Container container, List<JComponent> printable) {
        Component[] children;
        if (container.isShowing() && this.isPrintable(container)) {
            printable.add((JComponent)container);
        }
        for (Component child : children = container.getComponents()) {
            if (!(child instanceof Container)) continue;
            this.findPrintable((Container)child, printable);
        }
    }

    private PrintProvider[] getProviders(PrintProvider provider) {
        if (provider == null) {
            return null;
        }
        return new PrintProvider[]{provider};
    }

    private boolean isPrintable(Container container) {
        return container instanceof JComponent && ((JComponent)container).getClientProperty("print.printable") == Boolean.TRUE;
    }

    private String getName(List<JComponent> printable, JComponent top) {
        for (JComponent component : printable) {
            Object object = component.getClientProperty("print.name");
            if (!(object instanceof String)) continue;
            return (String)object;
        }
        return this.getName(this.getData(top));
    }

    private String getName(DataObject data) {
        if (data == null) {
            return null;
        }
        return data.getName();
    }

    private Date getDate(JComponent top) {
        return this.getDate(this.getData(top));
    }

    private Date getDate(DataObject data) {
        if (data == null) {
            return null;
        }
        return data.getPrimaryFile().lastModified();
    }

    private DataObject getData(JComponent top) {
        if (!(top instanceof TopComponent)) {
            return null;
        }
        return (DataObject)((TopComponent)top).getLookup().lookup(DataObject.class);
    }

    private String getText(InputStream input) {
        if (input == null) {
            return null;
        }
        try {
            input.reset();
            int length = input.available();
            byte[] bytes = new byte[length];
            input.read(bytes);
            input.close();
            return new String(bytes);
        }
        catch (IOException e) {
            return null;
        }
    }

    private PrintCookie getPrintCookie() {
        Node node = UI.getSelectedNode();
        if (node == null) {
            return null;
        }
        return (PrintCookie)node.getCookie(PrintCookie.class);
    }

    @Override
    public boolean isEnabled() {
        if (this.myEnabled) {
            return true;
        }
        return this.getPrintProviders() != null || this.getPrintCookie() != null;
    }
}

