/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.editors.genealogyeditor.panels;

import ancestris.modules.editors.genealogyeditor.AriesTopComponent;
import ancestris.modules.editors.genealogyeditor.editors.FamilyEditor;
import ancestris.modules.editors.genealogyeditor.editors.IndividualEditor;
import ancestris.modules.editors.genealogyeditor.models.FamiliesTreeTableModel;
import ancestris.modules.editors.genealogyeditor.models.FamilyReferencesTreeTableModel;
import ancestris.modules.editors.genealogyeditor.panels.FamiliesTablePanel;
import ancestris.util.swing.DialogManager;
import genj.gedcom.Context;
import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.gedcom.PropertyXRef;
import genj.gedcom.UnitOfWork;
import genj.util.Registry;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jdesktop.swingx.JXTreeTable;
import org.jdesktop.swingx.decorator.ColorHighlighter;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.decorator.HighlightPredicate;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.decorator.IconHighlighter;
import org.jdesktop.swingx.treetable.TreeTableModel;
import org.openide.DialogDescriptor;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class FamiliesTreeTablePanel
extends JPanel {
    public static int LIST_FAM = 0;
    public static int EDIT_FAMC = 1;
    public static int EDIT_FAMS = 2;
    private static final Logger logger = Logger.getLogger(FamiliesTreeTablePanel.class.getName(), null);
    private int mFamilyEditingType = EDIT_FAMC;
    private Registry mRegistry = Registry.get(FamiliesTreeTablePanel.class);
    private Property mRoot;
    private Fam mCreateFamily = null;
    private String mTableId = FamiliesTreeTablePanel.class.getName();
    private JButton addFamilyButton;
    private JButton deleteFamilyButton;
    private JButton editButton;
    private JScrollPane familiesScrollPane;
    private JXTreeTable familiesTreeTable;
    private JToolBar familyNamesToolBar;
    private JButton linkToFamilyButton;

    public FamiliesTreeTablePanel() {
        this(EDIT_FAMC);
    }

    public FamiliesTreeTablePanel(int familyEditingType) {
        this.mFamilyEditingType = familyEditingType;
        this.initComponents();
        for (int index = 0; index < this.familiesTreeTable.getColumnModel().getColumnCount(); ++index) {
            int columnSize = this.mRegistry.get(this.mTableId + ".column" + index + ".size", 100);
            this.familiesTreeTable.getColumnModel().getColumn(index).setPreferredWidth(columnSize);
            logger.log(Level.FINE, "setID: table id {0} column index {1} size {2}", new Object[]{this.mTableId, index, columnSize});
        }
        HighlightPredicate MyHighlightPredicate = new HighlightPredicate(){

            public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
                int rowIndex = adapter.row;
                TreePath path = FamiliesTreeTablePanel.this.familiesTreeTable.getPathForRow(rowIndex);
                Object lastPathComponent = path.getLastPathComponent();
                if (lastPathComponent instanceof DefaultMutableTreeNode) {
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
                    if (node.getUserObject() instanceof PropertyXRef) {
                        Entity entity = ((PropertyXRef)node.getUserObject()).getTargetEntity();
                        return entity.equals(FamiliesTreeTablePanel.this.mRoot);
                    }
                    return false;
                }
                return false;
            }
        };
        HighlightPredicate FamilyIconpredicate = new HighlightPredicate(){

            public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
                int rowIndex = adapter.row;
                TreePath path = FamiliesTreeTablePanel.this.familiesTreeTable.getPathForRow(rowIndex);
                Object lastPathComponent = path.getLastPathComponent();
                if (lastPathComponent instanceof DefaultMutableTreeNode) {
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
                    if (node.getUserObject() instanceof PropertyXRef) {
                        Entity entity = ((PropertyXRef)node.getUserObject()).getTargetEntity();
                        return entity instanceof Fam;
                    }
                    return false;
                }
                return false;
            }
        };
        this.familiesTreeTable.addHighlighter((Highlighter)new ColorHighlighter(MyHighlightPredicate, this.familiesTreeTable.getBackground(), Color.blue));
        this.familiesTreeTable.addHighlighter((Highlighter)new IconHighlighter(FamilyIconpredicate, (Icon)new ImageIcon("ancestris/modules/editors/genealogyeditor/resources/indi_add.png")));
    }

    private void initComponents() {
        this.familiesScrollPane = new JScrollPane();
        this.familiesTreeTable = new JXTreeTable((TreeTableModel)new FamiliesTreeTableModel(this.mFamilyEditingType));
        this.familyNamesToolBar = new JToolBar();
        this.addFamilyButton = new JButton();
        this.linkToFamilyButton = new JButton();
        this.editButton = new JButton();
        this.deleteFamilyButton = new JButton();
        this.familiesTreeTable.setEditable(false);
        this.familiesTreeTable.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                FamiliesTreeTablePanel.this.familiesTreeTableMouseClicked(evt);
            }
        });
        this.familiesScrollPane.setViewportView((Component)this.familiesTreeTable);
        this.familyNamesToolBar.setFloatable(false);
        this.familyNamesToolBar.setRollover(true);
        this.addFamilyButton.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/editors/genealogyeditor/resources/edit_add.png")));
        this.addFamilyButton.setToolTipText(NbBundle.getMessage(FamiliesTreeTablePanel.class, (String)"FamiliesTreeTablePanel.addFamilyButton.toolTipText"));
        this.addFamilyButton.setFocusable(false);
        this.addFamilyButton.setHorizontalTextPosition(0);
        this.addFamilyButton.setVerticalTextPosition(3);
        this.addFamilyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FamiliesTreeTablePanel.this.addFamilyButtonActionPerformed(evt);
            }
        });
        this.familyNamesToolBar.add(this.addFamilyButton);
        this.linkToFamilyButton.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/editors/genealogyeditor/resources/link_add.png")));
        this.linkToFamilyButton.setToolTipText(NbBundle.getMessage(FamiliesTreeTablePanel.class, (String)"FamiliesTreeTablePanel.linkToFamilyButton.toolTipText"));
        this.linkToFamilyButton.setFocusable(false);
        this.linkToFamilyButton.setHorizontalTextPosition(4);
        this.linkToFamilyButton.setVerticalTextPosition(3);
        this.linkToFamilyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FamiliesTreeTablePanel.this.linkToFamilyButtonActionPerformed(evt);
            }
        });
        this.familyNamesToolBar.add(this.linkToFamilyButton);
        this.editButton.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/editors/genealogyeditor/resources/edit.png")));
        this.editButton.setToolTipText(NbBundle.getMessage(FamiliesTreeTablePanel.class, (String)"FamiliesTreeTablePanel.editButton.toolTipText"));
        this.editButton.setFocusable(false);
        this.editButton.setHorizontalTextPosition(0);
        this.editButton.setVerticalTextPosition(3);
        this.editButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FamiliesTreeTablePanel.this.editButtonActionPerformed(evt);
            }
        });
        this.familyNamesToolBar.add(this.editButton);
        this.deleteFamilyButton.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/editors/genealogyeditor/resources/edit_delete.png")));
        this.deleteFamilyButton.setToolTipText(NbBundle.getMessage(FamiliesTreeTablePanel.class, (String)"FamiliesTreeTablePanel.deleteFamilyButton.toolTipText"));
        this.deleteFamilyButton.setFocusable(false);
        this.deleteFamilyButton.setHorizontalTextPosition(0);
        this.deleteFamilyButton.setVerticalTextPosition(3);
        this.deleteFamilyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FamiliesTreeTablePanel.this.deleteFamilyButtonActionPerformed(evt);
            }
        });
        this.familyNamesToolBar.add(this.deleteFamilyButton);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.familiesScrollPane, -1, 539, Short.MAX_VALUE).addComponent(this.familyNamesToolBar, -1, 539, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.familyNamesToolBar, -2, 25, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.familiesScrollPane, -1, 154, Short.MAX_VALUE)));
    }

    private void addFamilyButtonActionPerformed(ActionEvent evt) {
        Gedcom gedcom = this.mRoot.getGedcom();
        int undoNb = gedcom.getUndoNb();
        try {
            gedcom.doUnitOfWork(new UnitOfWork(){

                public void perform(Gedcom gedcom) throws GedcomException {
                    FamiliesTreeTablePanel.this.mCreateFamily = (Fam)gedcom.createEntity("FAM");
                }
            });
            FamilyEditor familyEditor = new FamilyEditor();
            familyEditor.setContext(new Context((Entity)this.mCreateFamily));
            AriesTopComponent atc = AriesTopComponent.findEditorWindow(gedcom);
            atc.getOpenEditors().add(familyEditor);
            if (familyEditor.showPanel()) {
                ((FamiliesTreeTableModel)this.familiesTreeTable.getTreeTableModel()).add(this.mCreateFamily);
                gedcom.doUnitOfWork(new UnitOfWork(){

                    public void perform(Gedcom gedcom) throws GedcomException {
                        if (FamiliesTreeTablePanel.this.mFamilyEditingType == EDIT_FAMC) {
                            FamiliesTreeTablePanel.this.mCreateFamily.addChild((Indi)FamiliesTreeTablePanel.this.mRoot);
                        } else if (FamiliesTreeTablePanel.this.mFamilyEditingType == EDIT_FAMS) {
                            if (((Indi)FamiliesTreeTablePanel.this.mRoot).getSex() == 1) {
                                FamiliesTreeTablePanel.this.mCreateFamily.setHusband((Indi)FamiliesTreeTablePanel.this.mRoot);
                            } else {
                                FamiliesTreeTablePanel.this.mCreateFamily.setWife((Indi)FamiliesTreeTablePanel.this.mRoot);
                            }
                        }
                    }
                });
            } else {
                while (gedcom.getUndoNb() > undoNb && gedcom.canUndo()) {
                    gedcom.undoUnitOfWork(false);
                }
            }
            atc.getOpenEditors().remove((Object)familyEditor);
        }
        catch (GedcomException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void linkToFamilyButtonActionPerformed(ActionEvent evt) {
        Fam selectedFamily;
        FamiliesTablePanel familiesTablePanel = new FamiliesTablePanel(LIST_FAM);
        familiesTablePanel.set(this.mRoot, new ArrayList<Fam>(this.mRoot.getGedcom().getFamilies()));
        DialogManager.ADialog familiesTableDialog = new DialogManager.ADialog(NbBundle.getMessage(FamiliesTablePanel.class, (String)"familiesTableDialog.linkto.title"), (JComponent)familiesTablePanel);
        familiesTableDialog.setDialogId(FamiliesTablePanel.class.getName());
        if (familiesTableDialog.show() == DialogDescriptor.OK_OPTION && (selectedFamily = familiesTablePanel.getSelectedFamily()) != null) {
            try {
                ((FamiliesTreeTableModel)this.familiesTreeTable.getTreeTableModel()).add(selectedFamily);
                this.mRoot.getGedcom().doUnitOfWork(new UnitOfWork(){

                    public void perform(Gedcom gedcom) throws GedcomException {
                        if (FamiliesTreeTablePanel.this.mFamilyEditingType == EDIT_FAMC) {
                            selectedFamily.addChild((Indi)FamiliesTreeTablePanel.this.mRoot);
                        } else if (FamiliesTreeTablePanel.this.mFamilyEditingType == EDIT_FAMS) {
                            if (((Indi)FamiliesTreeTablePanel.this.mRoot).getSex() == 1) {
                                selectedFamily.setHusband((Indi)FamiliesTreeTablePanel.this.mRoot);
                            } else {
                                selectedFamily.setWife((Indi)FamiliesTreeTablePanel.this.mRoot);
                            }
                        }
                    }
                });
            }
            catch (GedcomException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        familiesTablePanel.saveFilterSettings();
    }

    private void editButtonActionPerformed(ActionEvent evt) {
        TreePath path;
        Object node;
        int rowIndex = this.familiesTreeTable.convertRowIndexToModel(this.familiesTreeTable.getSelectedRow());
        Gedcom gedcom = this.mRoot.getGedcom();
        if (rowIndex != -1 && (node = (path = this.familiesTreeTable.getPathForRow(rowIndex)).getLastPathComponent()) instanceof DefaultMutableTreeNode) {
            Indi child;
            DefaultMutableTreeNode dataNode = (DefaultMutableTreeNode)node;
            Entity entity = (Entity)dataNode.getUserObject();
            if (entity instanceof Fam) {
                Fam family = (Fam)entity;
                FamilyEditor familyEditor = new FamilyEditor();
                familyEditor.setContext(new Context((Entity)family));
                AriesTopComponent atc = AriesTopComponent.findEditorWindow(gedcom);
                atc.getOpenEditors().add(familyEditor);
                familyEditor.showPanel();
                atc.getOpenEditors().remove((Object)familyEditor);
            } else if (entity instanceof Indi && !(child = (Indi)entity).equals(this.mRoot)) {
                IndividualEditor individualEditor = new IndividualEditor();
                individualEditor.setContext(new Context((Entity)child));
                AriesTopComponent atc = AriesTopComponent.findEditorWindow(gedcom);
                atc.getOpenEditors().add(individualEditor);
                individualEditor.showPanel();
                atc.getOpenEditors().remove((Object)individualEditor);
            }
        }
    }

    private void deleteFamilyButtonActionPerformed(ActionEvent evt) {
        TreePath path;
        Object node;
        int rowIndex = this.familiesTreeTable.convertRowIndexToModel(this.familiesTreeTable.getSelectedRow());
        Gedcom gedcom = this.mRoot.getGedcom();
        if (rowIndex != -1 && (node = (path = this.familiesTreeTable.getPathForRow(rowIndex)).getLastPathComponent()) instanceof DefaultMutableTreeNode) {
            final DefaultMutableTreeNode dataNode = (DefaultMutableTreeNode)node;
            if (dataNode.getUserObject() instanceof Fam) {
                final Fam family = (Fam)dataNode.getUserObject();
                DialogManager createYesNo = DialogManager.createYesNo((String)NbBundle.getMessage(FamiliesTreeTablePanel.class, (String)"FamiliesTreeTablePanel.deleteFamilyConfirmation.title", (Object)family), (String)NbBundle.getMessage(FamiliesTreeTablePanel.class, (String)"FamiliesTreeTablePanel.deleteFamilyConfirmation.text", (Object)family, (Object)this.mRoot));
                if (createYesNo.show() == DialogManager.YES_OPTION) {
                    try {
                        gedcom.doUnitOfWork(new UnitOfWork(){

                            public void perform(Gedcom gedcom) throws GedcomException {
                                FamiliesTreeTablePanel.this.mRoot.delProperty((Property)family);
                            }
                        });
                        ((FamiliesTreeTableModel)this.familiesTreeTable.getTreeTableModel()).remove(dataNode);
                    }
                    catch (GedcomException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            } else if (dataNode.getUserObject() instanceof PropertyXRef && ((PropertyXRef)dataNode.getUserObject()).getTargetEntity() instanceof Indi) {
                Indi indi = (Indi)((PropertyXRef)dataNode.getUserObject()).getTargetEntity();
                TreeNode parent = dataNode.getParent();
                if (parent instanceof DefaultMutableTreeNode && ((DefaultMutableTreeNode)parent).getUserObject() instanceof Fam) {
                    final Fam family = (Fam)((DefaultMutableTreeNode)parent).getUserObject();
                    DialogManager createYesNo = DialogManager.createYesNo((String)NbBundle.getMessage(FamiliesTreeTablePanel.class, (String)"FamiliesReferenceTreeTablePanel.deleteChildConfirmation.title", (Object)indi), (String)NbBundle.getMessage(FamiliesTreeTablePanel.class, (String)"FamiliesReferenceTreeTablePanel.deleteChildConfirmation.text", (Object)indi, (Object)family));
                    if (createYesNo.show() == DialogManager.YES_OPTION) {
                        try {
                            gedcom.doUnitOfWork(new UnitOfWork(){

                                public void perform(Gedcom gedcom) throws GedcomException {
                                    family.delProperty((Property)((PropertyXRef)dataNode.getUserObject()));
                                }
                            });
                            ((FamilyReferencesTreeTableModel)this.familiesTreeTable.getTreeTableModel()).remove(dataNode);
                        }
                        catch (GedcomException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    }
                }
            }
        }
    }

    private void familiesTreeTableMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() >= 2) {
            TreePath path;
            Object node;
            int rowIndex = this.familiesTreeTable.convertRowIndexToModel(this.familiesTreeTable.getSelectedRow());
            Gedcom gedcom = this.mRoot.getGedcom();
            if (rowIndex != -1 && (node = (path = this.familiesTreeTable.getPathForRow(rowIndex)).getLastPathComponent()) instanceof DefaultMutableTreeNode) {
                Indi child;
                DefaultMutableTreeNode dataNode = (DefaultMutableTreeNode)node;
                Entity entity = (Entity)dataNode.getUserObject();
                if (entity instanceof Fam) {
                    Fam family = (Fam)entity;
                    FamilyEditor familyEditor = new FamilyEditor();
                    familyEditor.setContext(new Context((Entity)family));
                    AriesTopComponent atc = AriesTopComponent.findEditorWindow(gedcom);
                    atc.getOpenEditors().add(familyEditor);
                    familyEditor.showPanel();
                    atc.getOpenEditors().remove((Object)familyEditor);
                } else if (entity instanceof Indi && !(child = (Indi)entity).equals(this.mRoot)) {
                    IndividualEditor individualEditor = new IndividualEditor();
                    individualEditor.setContext(new Context((Entity)child));
                    AriesTopComponent atc = AriesTopComponent.findEditorWindow(gedcom);
                    atc.getOpenEditors().add(individualEditor);
                    individualEditor.showPanel();
                    atc.getOpenEditors().remove((Object)individualEditor);
                }
            }
        }
    }

    public void setFamiliesList(Property root, List<Fam> familiesList) {
        this.mRoot = root;
        ((FamiliesTreeTableModel)this.familiesTreeTable.getTreeTableModel()).clear();
        ((FamiliesTreeTableModel)this.familiesTreeTable.getTreeTableModel()).addAll(familiesList);
        this.familiesTreeTable.expandAll();
        this.familiesTreeTable.getColumnModel().addColumnModelListener(new FamiliesTreeTableTableColumnModelListener());
    }

    private class FamiliesTreeTableTableColumnModelListener
    implements TableColumnModelListener {
        private final Logger logger = Logger.getLogger(FamiliesTreeTableTableColumnModelListener.class.getName(), null);

        private FamiliesTreeTableTableColumnModelListener() {
        }

        @Override
        public void columnAdded(TableColumnModelEvent tcme) {
            this.logger.log(Level.FINE, "columnAdded: {0}", tcme.getFromIndex());
        }

        @Override
        public void columnRemoved(TableColumnModelEvent tcme) {
            this.logger.log(Level.FINE, "columnRemoved: {0}", tcme.getFromIndex());
        }

        @Override
        public void columnMoved(TableColumnModelEvent tcme) {
            this.logger.log(Level.FINE, "columnMoved: {0}", tcme.getFromIndex());
        }

        @Override
        public void columnMarginChanged(ChangeEvent ce) {
            this.logger.log(Level.FINE, "columnMarginChanged: {0}", ce.toString());
            for (int index = 0; index < FamiliesTreeTablePanel.this.familiesTreeTable.getColumnCount(); ++index) {
                int preferredWidth = FamiliesTreeTablePanel.this.familiesTreeTable.getColumn(index).getPreferredWidth();
                this.logger.log(Level.FINE, "columnMarginChanged: table id {0} column index {1} size {2}", new Object[]{FamiliesTreeTablePanel.this.mTableId, index, preferredWidth});
                FamiliesTreeTablePanel.this.mRegistry.put(FamiliesTreeTablePanel.this.mTableId + ".column" + index + ".size", preferredWidth);
            }
        }

        @Override
        public void columnSelectionChanged(ListSelectionEvent lse) {
        }
    }
}

