/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.editors.genealogyeditor.models;

import genj.gedcom.Property;
import genj.gedcom.PropertyRepository;
import genj.gedcom.Repository;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.openide.util.NbBundle;

public class RepositoryCitationsTableModel
extends AbstractTableModel {
    List<PropertyRepository> mRepositoriesList = new ArrayList<PropertyRepository>();
    private final String[] columnsName = new String[]{NbBundle.getMessage(RepositoryCitationsTableModel.class, (String)"RepositoriesTableModel.column.ID.title"), NbBundle.getMessage(RepositoryCitationsTableModel.class, (String)"RepositoriesTableModel.column.name.title"), NbBundle.getMessage(RepositoryCitationsTableModel.class, (String)"RepositoriesTableModel.column.name.shelfNumber")};

    @Override
    public int getRowCount() {
        return this.mRepositoriesList.size();
    }

    @Override
    public int getColumnCount() {
        return this.columnsName.length;
    }

    @Override
    public Object getValueAt(int row, int column) {
        if (row < this.mRepositoriesList.size()) {
            Repository repository = (Repository)this.mRepositoriesList.get(row).getTargetEntity();
            switch (column) {
                case 0: {
                    return repository.getId();
                }
                case 1: {
                    Property name = repository.getProperty("NAME");
                    return name != null ? name.getValue() : "";
                }
                case 2: {
                    Property shelfNumber = this.mRepositoriesList.get(row).getProperty("CALN");
                    return shelfNumber != null ? shelfNumber.getValue() : "";
                }
            }
            return "";
        }
        return "";
    }

    @Override
    public String getColumnName(int col) {
        return this.columnsName[col];
    }

    public String[] getColumnsName() {
        return this.columnsName;
    }

    public void add(PropertyRepository entity) {
        this.mRepositoriesList.add(entity);
        this.fireTableDataChanged();
    }

    public void addAll(List<PropertyRepository> mRepositoriesList) {
        this.mRepositoriesList.addAll(mRepositoriesList);
        this.fireTableDataChanged();
    }

    public PropertyRepository remove(int row) {
        PropertyRepository repositoryCitation = this.mRepositoriesList.remove(row);
        this.fireTableDataChanged();
        return repositoryCitation;
    }

    public void clear() {
        this.mRepositoriesList.clear();
    }

    public PropertyRepository getValueAt(int row) {
        if (row < this.mRepositoriesList.size()) {
            return this.mRepositoriesList.get(row);
        }
        return null;
    }
}

