/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.editors.genealogyeditor.actions;

import ancestris.modules.editors.genealogyeditor.AriesTopComponent;
import ancestris.modules.editors.genealogyeditor.editors.SourceEditor;
import ancestris.view.AncestrisTopComponent;
import genj.gedcom.Context;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.Source;
import genj.gedcom.UnitOfWork;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;
import org.openide.util.Utilities;

public final class GenealogyEditorCreateSourceAction
implements ActionListener {
    private final DataObject context;
    private Source mSource;

    public GenealogyEditorCreateSourceAction(DataObject context) {
        this.context = context;
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        Context gedcomContext = (Context)Utilities.actionsGlobalContext().lookup(Context.class);
        if (gedcomContext != null) {
            Gedcom gedcom = gedcomContext.getGedcom();
            AriesTopComponent atc = AriesTopComponent.findEditorWindow(gedcom);
            if (atc == null) {
                AncestrisTopComponent win = new AriesTopComponent().create(gedcomContext);
                win.open();
                win.requestActive();
            }
            try {
                gedcom.doUnitOfWork(new UnitOfWork(){

                    public void perform(Gedcom gedcom) throws GedcomException {
                        GenealogyEditorCreateSourceAction.this.mSource = (Source)gedcom.createEntity("SOUR");
                    }
                });
                SourceEditor sourceEditor = new SourceEditor(true);
                sourceEditor.setContext(new Context((Entity)this.mSource));
                if (!sourceEditor.showPanel()) {
                    gedcom.undoUnitOfWork(false);
                }
            }
            catch (GedcomException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }
}

