/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.gedcom.searchduplicates;

import ancestris.modules.gedcom.matchers.IndiMatcher;
import ancestris.modules.gedcom.matchers.PotentialMatch;
import ancestris.modules.gedcom.searchduplicates.DuplicateResultCreator;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.Indi;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

public class IndiDuplicatesFinder
implements Runnable {
    private final Gedcom gedcom;
    private final Indi cujus;

    public IndiDuplicatesFinder(Indi indi) {
        this.cujus = indi;
        this.gedcom = indi.getGedcom();
    }

    @Override
    public void run() {
        LinkedList<PotentialMatch<? extends Entity>> matchesLinkedList = new LinkedList<PotentialMatch<? extends Entity>>();
        HashMap<String, Integer> duplicatesHashMap = new HashMap<String, Integer>();
        if (this.gedcom == null) {
            return;
        }
        IndiMatcher matcher = new IndiMatcher();
        ArrayList<Indi> entities = new ArrayList<Indi>();
        for (Object e : this.gedcom.getEntities("INDI")) {
            if (!(e instanceof Indi)) continue;
            entities.add((Indi)e);
        }
        List<PotentialMatch<Indi>> potentialMatches = matcher.getDuplicates(this.cujus, entities);
        if (potentialMatches.isEmpty()) {
            return;
        }
        for (PotentialMatch potentialMatch : potentialMatches) {
            String idRight;
            String idLeft = ((Indi)potentialMatch.getLeft()).getId();
            if (idLeft.compareToIgnoreCase(idRight = ((Indi)potentialMatch.getRight()).getId()) <= 0) continue;
            potentialMatch.swap();
        }
        matchesLinkedList.addAll(potentialMatches);
        duplicatesHashMap.put("INDI", potentialMatches.size());
        Collections.sort(matchesLinkedList, new Comparator<PotentialMatch<? extends Entity>>(){

            @Override
            public int compare(PotentialMatch<? extends Entity> e1, PotentialMatch<? extends Entity> e2) {
                if (e2.getCertainty() - e1.getCertainty() != 0) {
                    return e2.getCertainty() - e1.getCertainty();
                }
                return e1.getLeft().toString(true).toLowerCase().compareTo(e2.getLeft().toString(true).toLowerCase());
            }
        });
        DuplicateResultCreator drc = new DuplicateResultCreator(this.gedcom, matchesLinkedList);
        drc.run();
    }
}

