/*
 * Decompiled with CFR 0.152.
 */
package org.geonames.wikipedia;

public class TextSummaryExtractor {
    public static String extractSummary(String pText, int length) {
        return TextSummaryExtractor.extractSummary(pText, length, true);
    }

    public static String extractSummary(String pText, int length, boolean stopAtParagraph) {
        try {
            return TextSummaryExtractor._extractSummary(pText, length, stopAtParagraph);
        }
        catch (Error e) {
            System.err.println(e.getMessage());
            return null;
        }
    }

    private static String _extractSummary(String pText, int length, boolean stopAtParagraph) {
        int paragraph;
        if (pText == null) {
            return null;
        }
        String textCopy = new String(pText);
        StringBuilder summary = new StringBuilder();
        int idx = 0;
        int cnt = 0;
        while (idx > -1 && (summary.length() < 50 + 2 * length || length == 0) && idx < textCopy.length()) {
            int endHeaderIdx;
            ++cnt;
            char c = textCopy.charAt(idx);
            if (c == '{') {
                int begLabelIdx;
                int endidx = TextSummaryExtractor.skipTemplate(textCopy, idx);
                if (textCopy.toLowerCase().indexOf("{{audio") == idx && (begLabelIdx = textCopy.lastIndexOf("|", endidx)) > -1) {
                    String label = textCopy.substring(begLabelIdx + 1, endidx - 2).trim();
                    summary.append(label);
                }
                if (textCopy.toLowerCase().indexOf("{{formatnum") == idx && (begLabelIdx = textCopy.indexOf(":", idx)) > -1) {
                    int endLabelIdx = endidx - 2;
                    if (textCopy.indexOf("|", begLabelIdx) > -1) {
                        endLabelIdx = textCopy.indexOf("|", begLabelIdx);
                    }
                    String label = textCopy.substring(begLabelIdx + 1, endLabelIdx).trim();
                    summary.append(label);
                }
                idx = endidx;
                continue;
            }
            if (c == '<') {
                if (textCopy.length() > idx + 1 && textCopy.charAt(idx + 1) == '!') {
                    idx = TextSummaryExtractor.skipHTMLComment(textCopy, idx);
                    continue;
                }
                idx = TextSummaryExtractor.skipHTMLElement(textCopy, idx);
                continue;
            }
            if (c == '[') {
                int endOfLink;
                if (textCopy.charAt(idx + 1) == '[') {
                    endOfLink = textCopy.indexOf("]]", idx);
                    int colon = textCopy.indexOf(":", idx);
                    if (colon > -1 && colon < endOfLink) {
                        idx = TextSummaryExtractor.findEndOfLink(textCopy, idx);
                        continue;
                    }
                    int beginAnchor = textCopy.indexOf("|", idx);
                    if (beginAnchor > -1 && beginAnchor < endOfLink) {
                        idx = beginAnchor + 1;
                        continue;
                    }
                    idx += 2;
                    continue;
                }
                endOfLink = textCopy.indexOf("]", idx);
                if (endOfLink > -1) {
                    idx = endOfLink + 1;
                    continue;
                }
            } else if (c == ']') {
                if (idx + 1 < textCopy.length() && textCopy.charAt(idx + 1) == ']') {
                    idx += 2;
                    continue;
                }
            } else if (c == '=' && idx + 1 < textCopy.length() && textCopy.charAt(idx + 1) == '=' && (endHeaderIdx = textCopy.indexOf("==", idx + 2)) > -1) {
                idx = endHeaderIdx + 2;
                continue;
            }
            summary.append(c);
            ++idx;
        }
        String textString = TextSummaryExtractor.removeIndentAtBeginning(summary.toString());
        textString = textString.replaceAll("\\([^\\w]*\\)", "");
        textString = textString.replaceAll("\\([, ]*", "(");
        textString = textString.replaceAll("[, ]*\\)", ")");
        textString = TextSummaryExtractor.removeWhiteSpace(textString.replaceAll("\r", " ").replaceAll("\n", " ").replaceAll("\t", " ")).trim();
        textString = TextSummaryExtractor.removeBold(textString);
        textString = TextSummaryExtractor.removeItalic(textString);
        textString = textString.replaceAll("&nbsp;", " ");
        textString = textString.replaceAll("\\( ", "(");
        textString = textString.replaceAll(" \\)", ")");
        int endOfTextIdx = textString.length();
        if (stopAtParagraph && (paragraph = textString.indexOf("==")) > 10) {
            endOfTextIdx = paragraph;
        }
        if ((endOfTextIdx < 20 || endOfTextIdx > length) && (double)(endOfTextIdx = textString.lastIndexOf(".", length)) < 0.7 * (double)length) {
            endOfTextIdx = textString.lastIndexOf(" ", length);
        }
        if (endOfTextIdx > -1 && endOfTextIdx < textString.length()) {
            textString = textString.substring(0, endOfTextIdx) + " (...)";
        }
        return textString.trim();
    }

    static int skipTemplate(String pText, int pIdx) {
        int idx;
        if (pText.charAt(pIdx) != '{') {
            return pIdx;
        }
        int numOpenings = 1;
        for (idx = pIdx + 1; numOpenings > 0 && pText.length() > idx; ++idx) {
            if (pText.charAt(idx) == '{') {
                ++numOpenings;
                continue;
            }
            if (pText.charAt(idx) != '}') continue;
            --numOpenings;
        }
        if (pIdx > idx) {
            throw new Error("error in skip html comment for " + pText);
        }
        return idx;
    }

    static int skipHTMLElement(String pText, int pIdx) {
        int idx;
        if (pText.charAt(pIdx) != '<') {
            return pIdx;
        }
        int numOpenings = 1;
        for (idx = pIdx + 1; numOpenings > 0 && pText.length() > idx; ++idx) {
            if (pText.charAt(idx) == '<') {
                ++numOpenings;
                continue;
            }
            if (pText.charAt(idx) != '>') continue;
            --numOpenings;
        }
        if (pIdx > idx) {
            throw new Error("error in skip html comment for " + pText);
        }
        return idx;
    }

    static int skipHTMLComment(String pText, int pIdx) {
        if (pText.charAt(pIdx) != '<' && pText.charAt(pIdx + 1) != '!') {
            return pIdx;
        }
        int idx = pIdx;
        while ((idx = pText.indexOf(45, idx)) > -1) {
            if (pText.length() < idx + 2) {
                return pText.length();
            }
            if (pText.charAt(idx) == '-' && pText.charAt(idx + 1) == '-' && pText.charAt(idx + 2) == '>') {
                return idx + 3;
            }
            ++idx;
        }
        if (pIdx > idx) {
            throw new Error("error in skip html comment for " + pText);
        }
        return idx;
    }

    private static String removeIndentAtBeginning(String pText) {
        if ((pText = pText.trim()).startsWith(":")) {
            int italic;
            int lineFeed = pText.indexOf("\n");
            if (lineFeed > -1) {
                pText = pText.substring(lineFeed + 1);
            } else if (pText.startsWith(":''") && (italic = pText.indexOf("''", 3)) > -1) {
                pText = pText.substring(italic + 2);
            }
        }
        return pText;
    }

    private static int findEndOfLink(String pText, int pIdx) {
        int end = pText.indexOf("]]", pIdx);
        if (end == -1) {
            return pIdx;
        }
        int idx = pIdx;
        int openingIdx = pText.indexOf("[[", idx + 2);
        while (openingIdx > -1 && openingIdx < end) {
            idx = end;
            end = pText.indexOf("]]", end + 2);
            openingIdx = pText.indexOf("[[", idx);
        }
        if (end != -1) {
            idx = end;
        }
        if (pIdx > idx) {
            throw new Error("error in skip html comment for " + pText);
        }
        return idx;
    }

    public static String removeWhiteSpace(String pString) {
        StringBuffer buf = new StringBuffer();
        char[] chars = pString.toCharArray();
        int counter = 0;
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] == ' ') {
                if (counter == 0) {
                    buf.append(chars[i]);
                }
                ++counter;
                continue;
            }
            buf.append(chars[i]);
            counter = 0;
        }
        return buf.toString();
    }

    public static String removeBold(String pString) {
        return pString.replaceAll("'''", "");
    }

    public static String removeItalic(String pString) {
        return pString.replaceAll("''", "");
    }
}

