/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.html.json.impl;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.annotation.AnnotationTypeMismatchException;
import java.lang.annotation.IncompleteAnnotationException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Completion;
import javax.annotation.processing.Completions;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.MirroredTypeException;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;
import net.java.html.json.ComputedProperty;
import net.java.html.json.Function;
import net.java.html.json.Model;
import net.java.html.json.ModelOperation;
import net.java.html.json.OnPropertyChange;
import net.java.html.json.OnReceive;
import net.java.html.json.Property;
import org.netbeans.html.json.impl.Transitive;

@SupportedSourceVersion(value=SourceVersion.RELEASE_6)
@SupportedAnnotationTypes(value={"net.java.html.json.Model", "net.java.html.json.ModelOperation", "net.java.html.json.Function", "net.java.html.json.OnReceive", "net.java.html.json.OnPropertyChange", "net.java.html.json.ComputedProperty", "net.java.html.json.Property"})
public final class ModelProcessor
extends AbstractProcessor {
    private static final Logger LOG = Logger.getLogger(ModelProcessor.class.getName());
    private final Map<Element, String> models = new WeakHashMap<Element, String>();
    private final Map<Element, Prprt[]> verify = new WeakHashMap<Element, Prprt[]>();

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        boolean ok = true;
        for (Element element : roundEnv.getElementsAnnotatedWith(Model.class)) {
            if (this.processModel(element)) continue;
            ok = false;
        }
        if (roundEnv.processingOver()) {
            this.models.clear();
            for (Map.Entry entry : this.verify.entrySet()) {
                Prprt[] props;
                Model m;
                TypeElement te = (TypeElement)entry.getKey();
                String fqn = te.getQualifiedName().toString();
                TypeElement finalElem = this.processingEnv.getElementUtils().getTypeElement(fqn);
                if (finalElem == null || (m = finalElem.getAnnotation(Model.class)) == null) continue;
                for (Prprt p : props = Prprt.wrap(this.processingEnv, finalElem, m.properties())) {
                    boolean[] isModel = new boolean[]{false};
                    boolean[] isEnum = new boolean[]{false};
                    boolean[] isPrimitive = new boolean[]{false};
                    String t = this.checkType(p, isModel, isEnum, isPrimitive);
                    if (isEnum[0] || isPrimitive[0] || isModel[0] || "java.lang.String".equals(t)) continue;
                    this.error("The type " + t + " should be defined by @Model annotation", (Element)entry.getKey());
                }
            }
            this.verify.clear();
        }
        return ok;
    }

    private void error(String msg, Element e) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, msg, e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private boolean processModel(Element e) {
        boolean ok = true;
        Model m = e.getAnnotation(Model.class);
        if (m == null) {
            return true;
        }
        String pkg = ModelProcessor.findPkgName(e);
        String className = m.className();
        this.models.put(e, className);
        try {
            StringWriter body = new StringWriter();
            StringBuilder onReceiveType = new StringBuilder();
            ArrayList<GetSet> propsGetSet = new ArrayList<GetSet>();
            ArrayList<Object> functions = new ArrayList<Object>();
            HashMap<String, Collection<String[]>> propsDeps = new HashMap<String, Collection<String[]>>();
            HashMap<String, Collection<String>> functionDeps = new HashMap<String, Collection<String>>();
            Prprt[] props = this.createProps(e, m.properties());
            String builderPrefix = ModelProcessor.findBuilderPrefix(e, m);
            if (!this.generateComputedProperties(className, body, props, e.getEnclosedElements(), propsGetSet, propsDeps)) {
                ok = false;
            }
            if (!this.generateOnChange(e, propsDeps, props, className, functionDeps)) {
                ok = false;
            }
            if (!this.generateProperties(e, builderPrefix, body, className, props, propsGetSet, propsDeps, functionDeps)) {
                ok = false;
            }
            if (!this.generateFunctions(e, body, className, e.getEnclosedElements(), functions)) {
                ok = false;
            }
            int functionsCount = functions.size() / 2;
            for (int i = 0; i < functions.size(); i += 2) {
                for (Prprt prprt : props) {
                    if (!prprt.name().equals(functions.get(i))) continue;
                    this.error("Function cannot have the name of an existing property", e);
                    ok = false;
                }
            }
            if (!this.generateReceive(e, body, className, e.getEnclosedElements(), onReceiveType)) {
                ok = false;
            }
            if (!this.generateOperation(e, body, className, e.getEnclosedElements(), functions)) {
                ok = false;
            }
            JavaFileObject java = this.processingEnv.getFiler().createSourceFile(pkg + '.' + className, e);
            OutputStreamWriter w = new OutputStreamWriter(java.openOutputStream());
            try {
                boolean bl;
                boolean[] isPrimitive;
                boolean[] isEnum;
                int i;
                int i2;
                void var20_40;
                Prprt p;
                void var20_38;
                ((Writer)w).append("package " + pkg + ";\n");
                ((Writer)w).append("import net.java.html.json.*;\n");
                String inPckName = this.inPckName(e, false);
                ((Writer)w).append("/** Generated for {@link ").append(inPckName).append("}*/\n");
                ((Writer)w).append("public final class ").append(className).append(" implements Cloneable {\n");
                ((Writer)w).append("  private static Class<").append(inPckName).append("> modelFor() { return ").append(inPckName).append(".class; }\n");
                ((Writer)w).append("  private static final Html4JavaType TYPE = new Html4JavaType();\n");
                if (m.instance()) {
                    int cCnt = 0;
                    for (Element element : e.getEnclosedElements()) {
                        if (element.getKind() != ElementKind.CONSTRUCTOR) continue;
                        ++cCnt;
                        ExecutableElement ec = (ExecutableElement)element;
                        if (ec.getParameters().size() > 0 || ec.getModifiers().contains((Object)Modifier.PRIVATE)) continue;
                        cCnt = 0;
                        break;
                    }
                    if (cCnt > 0) {
                        ok = false;
                        this.error("Needs non-private default constructor when instance=true", e);
                        ((Writer)w).append("  private final ").append(inPckName).append(" instance = null;\n");
                    } else {
                        ((Writer)w).append("  private final ").append(inPckName).append(" instance = new ").append(inPckName).append("();\n");
                    }
                }
                ((Writer)w).append("  private final org.netbeans.html.json.spi.Proto proto;\n");
                ((Writer)w).append(body.toString());
                ((Writer)w).append("  private ").append(className).append("(net.java.html.BrwsrCtx context) {\n");
                ((Writer)w).append("    this.proto = TYPE.createProto(this, context);\n");
                Prprt[] cCnt = props;
                int n = cCnt.length;
                boolean bl2 = false;
                while (var20_38 < n) {
                    p = cCnt[var20_38];
                    if (p.array()) {
                        String string = this.typeName(p);
                        String[] gs = ModelProcessor.toGetSet(p.name(), string, p.array());
                        w.write("    this.prop_" + p.name() + " = proto.createList(\"" + p.name() + "\"");
                        if (p.mutable()) {
                            if (functionDeps.containsKey(p.name())) {
                                int index = Arrays.asList(functionDeps.keySet().toArray()).indexOf(p.name());
                                w.write(", " + index);
                            } else {
                                w.write(", -1");
                            }
                        } else {
                            w.write(", java.lang.Integer.MIN_VALUE");
                        }
                        Collection dependants = (Collection)propsDeps.get(p.name());
                        if (dependants != null) {
                            for (String[] depProp : dependants) {
                                w.write(", ");
                                ((Writer)w).write(34);
                                w.write(depProp[0]);
                                ((Writer)w).write(34);
                            }
                        }
                        w.write(")");
                        w.write(";\n");
                    }
                    ++var20_38;
                }
                ((Writer)w).append("  };\n");
                ((Writer)w).append("  public ").append(className).append("() {\n");
                ((Writer)w).append("    this(net.java.html.BrwsrCtx.findDefault(").append(className).append(".class));\n");
                cCnt = props;
                n = cCnt.length;
                boolean bl3 = false;
                while (var20_40 < n) {
                    p = cCnt[var20_40];
                    if (!p.array()) {
                        boolean[] blArray = new boolean[]{false};
                        boolean[] isEnum2 = new boolean[]{false};
                        boolean[] isPrimitive2 = new boolean[]{false};
                        String string = this.checkType(p, blArray, isEnum2, isPrimitive2);
                        if (blArray[0]) {
                            w.write("    prop_" + p.name() + " = TYPE; /* uninitialized */\n");
                        }
                    }
                    ++var20_40;
                }
                ((Writer)w).append("  };\n");
                if (props.length > 0 && builderPrefix == null) {
                    String[] third;
                    void var20_42;
                    StringBuilder constructorWithArguments = new StringBuilder();
                    constructorWithArguments.append("  public ").append(className).append("(");
                    Prprt firstArray = null;
                    String string = "";
                    int parameterCount = 0;
                    for (Prprt prprt : props) {
                        if (prprt.array()) {
                            if (firstArray != null) continue;
                            firstArray = prprt;
                            continue;
                        }
                        String tn3 = this.typeName(prprt);
                        constructorWithArguments.append((String)var20_42);
                        constructorWithArguments.append(tn3);
                        String[] third2 = ModelProcessor.toGetSet(prprt.name(), tn3, false);
                        constructorWithArguments.append(" ").append(third2[2]);
                        String string2 = ", ";
                        ++parameterCount;
                    }
                    if (firstArray != null) {
                        boolean[] isModel3 = new boolean[]{false};
                        boolean[] isEnum3 = new boolean[]{false};
                        boolean[] blArray = new boolean[]{false};
                        String string3 = this.checkType(firstArray, isModel3, isEnum3, blArray);
                        constructorWithArguments.append((String)var20_42);
                        constructorWithArguments.append(string3);
                        third = ModelProcessor.toGetSet(firstArray.name(), string3, true);
                        constructorWithArguments.append("... ").append(third[2]);
                        ++parameterCount;
                    }
                    constructorWithArguments.append(") {\n");
                    constructorWithArguments.append("    this(net.java.html.BrwsrCtx.findDefault(").append(className).append(".class));\n");
                    for (Prprt prprt : props) {
                        if (prprt.array()) continue;
                        third = ModelProcessor.toGetSet(prprt.name(), null, false);
                        constructorWithArguments.append("    this.prop_" + prprt.name() + " = " + third[2] + ";\n");
                    }
                    if (firstArray != null) {
                        String[] stringArray = ModelProcessor.toGetSet(firstArray.name(), null, true);
                        constructorWithArguments.append("    proto.initTo(this.prop_" + firstArray.name() + ", " + stringArray[2] + ");\n");
                    }
                    constructorWithArguments.append("  };\n");
                    if (parameterCount < 255) {
                        w.write(constructorWithArguments.toString());
                    }
                }
                ((Writer)w).append("  private static class Html4JavaType extends org.netbeans.html.json.spi.Proto.Type<").append(className).append("> {\n");
                ((Writer)w).append("    private Html4JavaType() {\n      super(").append(className).append(".class, ").append(inPckName).append(".class, " + propsGetSet.size() + ", " + functionsCount + ");\n");
                for (int i22 = 0; i22 < propsGetSet.size(); ++i22) {
                    ((Writer)w).append("      registerProperty(\"").append(((GetSet)propsGetSet.get((int)i22)).name).append("\", ");
                    ((Writer)w).append(i22 + ", " + ((GetSet)propsGetSet.get((int)i22)).readOnly + ", " + ((GetSet)propsGetSet.get((int)i22)).constant + ");\n");
                }
                for (i2 = 0; i2 < functionsCount; ++i2) {
                    ((Writer)w).append("      registerFunction(\"").append((String)functions.get(i2 * 2)).append("\", ");
                    ((Writer)w).append(i2 + ");\n");
                }
                ((Writer)w).append("    }\n");
                ((Writer)w).append("    @Override public void setValue(" + className + " data, int type, Object value) {\n");
                ((Writer)w).append("      switch (type) {\n");
                for (i2 = 0; i2 < propsGetSet.size(); ++i2) {
                    GetSet pgs = (GetSet)propsGetSet.get(i2);
                    if (pgs.readOnly) continue;
                    String string = pgs.setter;
                    String tn4 = pgs.type;
                    String string4 = ModelProcessor.findBoxedType(tn4);
                    if (string4 != null) {
                        tn4 = string4;
                    }
                    ((Writer)w).append("        case " + i2 + ": ");
                    if (pgs.setter != null) {
                        ((Writer)w).append("data.").append(pgs.setter).append("(TYPE.extractValue(" + tn4 + ".class, value)); return;\n");
                        continue;
                    }
                    ((Writer)w).append("TYPE.replaceValue(data.").append(pgs.getter).append("(), " + tn4 + ".class, value); return;\n");
                }
                ((Writer)w).append("      }\n");
                ((Writer)w).append("      throw new UnsupportedOperationException();\n");
                ((Writer)w).append("    }\n");
                ((Writer)w).append("    @Override public Object getValue(" + className + " data, int type) {\n");
                ((Writer)w).append("      switch (type) {\n");
                for (i2 = 0; i2 < propsGetSet.size(); ++i2) {
                    String get = ((GetSet)propsGetSet.get((int)i2)).getter;
                    if (get == null) continue;
                    ((Writer)w).append("        case " + i2 + ": return data." + get + "();\n");
                }
                ((Writer)w).append("      }\n");
                ((Writer)w).append("      throw new UnsupportedOperationException();\n");
                ((Writer)w).append("    }\n");
                ((Writer)w).append("    @Override public void call(" + className + " model, int type, Object data, Object ev) throws Exception {\n");
                ((Writer)w).append("      switch (type) {\n");
                for (i2 = 0; i2 < functions.size(); i2 += 2) {
                    String name = (String)functions.get(i2);
                    Object e2 = functions.get(i2 + 1);
                    if (e2 instanceof ExecutableElement) {
                        ExecutableElement ee = (ExecutableElement)e2;
                        ((Writer)w).append("        case " + i2 / 2 + ":\n");
                        ((Writer)w).append("          ");
                        if (m.instance()) {
                            ((Writer)w).append("model.instance");
                        } else {
                            ((Writer)w).append(((TypeElement)e).getQualifiedName());
                        }
                        ((Writer)w).append(".").append(name).append("(");
                        ((Writer)w).append(this.wrapParams(ee, null, className, "model", "ev", "data"));
                        ((Writer)w).append(");\n");
                        ((Writer)w).append("          return;\n");
                        continue;
                    }
                    String call = (String)e2;
                    ((Writer)w).append("        case " + i2 / 2 + ":\n");
                    ((Writer)w).append("          ").append(call).append("\n");
                    ((Writer)w).append("          return;\n");
                }
                ((Writer)w).append("      }\n");
                ((Writer)w).append("      throw new UnsupportedOperationException();\n");
                ((Writer)w).append("    }\n");
                ((Writer)w).append("    @Override public org.netbeans.html.json.spi.Proto protoFor(Object obj) {\n");
                ((Writer)w).append("      return ((" + className + ")obj).proto;");
                ((Writer)w).append("    }\n");
                ((Writer)w).append("    @Override public void onChange(" + className + " model, int type) {\n");
                ((Writer)w).append("      switch (type) {\n");
                String[] arr = functionDeps.keySet().toArray(new String[0]);
                for (i = 0; i < arr.length; ++i) {
                    Collection collection = (Collection)functionDeps.get(arr[i]);
                    if (collection == null) continue;
                    ((Writer)w).append("      case " + i + ":\n");
                    for (String string : collection) {
                        ((Writer)w).append("      ").append(string).append("\n");
                    }
                    w.write("      return;\n");
                }
                ((Writer)w).append("    }\n");
                ((Writer)w).append("      throw new UnsupportedOperationException();\n");
                ((Writer)w).append("    }\n");
                ((Writer)w).append(onReceiveType);
                ((Writer)w).append("    @Override public " + className + " read(net.java.html.BrwsrCtx c, Object json) { return new " + className + "(c, json); }\n");
                ((Writer)w).append("    @Override public " + className + " cloneTo(" + className + " o, net.java.html.BrwsrCtx c) { return o.clone(c); }\n");
                ((Writer)w).append("  }\n");
                ((Writer)w).append("  private ").append(className).append("(net.java.html.BrwsrCtx c, Object json) {\n");
                ((Writer)w).append("    this(c);\n");
                int values = 0;
                for (i = 0; i < propsGetSet.size(); ++i) {
                    Prprt prprt = ModelProcessor.findPrprt(props, ((GetSet)propsGetSet.get((int)i)).name);
                    if (prprt == null) continue;
                    ++values;
                }
                ((Writer)w).append("    Object[] ret = new Object[" + values + "];\n");
                ((Writer)w).append("    proto.extract(json, new String[] {\n");
                for (i = 0; i < propsGetSet.size(); ++i) {
                    Prprt prprt = ModelProcessor.findPrprt(props, ((GetSet)propsGetSet.get((int)i)).name);
                    if (prprt == null) continue;
                    ((Writer)w).append("      \"").append(((GetSet)propsGetSet.get((int)i)).name).append("\",\n");
                }
                ((Writer)w).append("    }, ret);\n");
                boolean bl4 = false;
                int prop = 0;
                for (i = 0; i < propsGetSet.size(); ++i) {
                    void var20_50;
                    String string = ((GetSet)propsGetSet.get((int)i)).name;
                    Prprt p2 = ModelProcessor.findPrprt(props, string);
                    if (p2 == null || prop >= props.length) continue;
                    boolean[] isModel4 = new boolean[]{false};
                    boolean[] blArray = new boolean[]{false};
                    boolean[] isPrimitive4 = new boolean[]{false};
                    String type = this.checkType(props[prop++], isModel4, blArray, isPrimitive4);
                    if (p2.array()) {
                        ((Writer)w).append("    for (Object e : useAsArray(ret[" + (int)var20_50 + "])) {\n");
                        if (isModel4[0]) {
                            ((Writer)w).append("      this.prop_").append(string).append(".add(proto.read");
                            ((Writer)w).append("(" + type + ".class, e));\n");
                        } else if (blArray[0]) {
                            ((Writer)w).append("        this.prop_").append(string);
                            ((Writer)w).append(".add(e == null ? null : ");
                            ((Writer)w).append(type).append(".valueOf(TYPE.stringValue(e)));\n");
                        } else if (this.isPrimitive(type)) {
                            if (type.equals("char")) {
                                ((Writer)w).append("        this.prop_").append(string).append(".add(TYPE.charValue(e));\n");
                            } else if (type.equals("boolean")) {
                                ((Writer)w).append("        this.prop_").append(string).append(".add(TYPE.boolValue(e));\n");
                            } else {
                                ((Writer)w).append("        this.prop_").append(string).append(".add(TYPE.numberValue(e).");
                                ((Writer)w).append(type).append("Value());\n");
                            }
                        } else {
                            ((Writer)w).append("        this.prop_").append(string).append(".add((");
                            ((Writer)w).append(type).append(")e);\n");
                        }
                        ((Writer)w).append("    }\n");
                    } else if (blArray[0]) {
                        ((Writer)w).append("    try {\n");
                        ((Writer)w).append("    this.prop_").append(string);
                        ((Writer)w).append(" = ret[" + (int)var20_50 + "] == null ? null : ");
                        ((Writer)w).append(type).append(".valueOf(TYPE.stringValue(ret[" + (int)var20_50 + "]));\n");
                        ((Writer)w).append("    } catch (IllegalArgumentException ex) {\n");
                        ((Writer)w).append("      ex.printStackTrace();\n");
                        ((Writer)w).append("    }\n");
                    } else if (this.isPrimitive(type)) {
                        ((Writer)w).append("    this.prop_").append(string);
                        ((Writer)w).append(" = ret[" + (int)var20_50 + "] == null ? ");
                        if ("char".equals(type)) {
                            ((Writer)w).append("0 : (TYPE.charValue(");
                        } else if ("boolean".equals(type)) {
                            ((Writer)w).append("false : (TYPE.boolValue(");
                        } else {
                            ((Writer)w).append("0 : (TYPE.numberValue(");
                        }
                        ((Writer)w).append("ret[" + (int)var20_50 + "])).");
                        ((Writer)w).append(type).append("Value();\n");
                    } else if (isModel4[0]) {
                        ((Writer)w).append("    this.prop_").append(string).append(" = proto.read");
                        ((Writer)w).append("(" + type + ".class, ");
                        ((Writer)w).append("ret[" + (int)var20_50 + "]);\n");
                    } else {
                        ((Writer)w).append("    this.prop_").append(string);
                        ((Writer)w).append(" = (").append(type).append(')');
                        ((Writer)w).append("ret[" + (int)var20_50 + "];\n");
                    }
                    ++var20_50;
                }
                ((Writer)w).append("  }\n");
                ((Writer)w).append("  private static Object[] useAsArray(Object o) {\n");
                ((Writer)w).append("    return o instanceof Object[] ? ((Object[])o) : o == null ? new Object[0] : new Object[] { o };\n");
                ((Writer)w).append("  }\n");
                this.writeToString(props, w);
                this.writeClone(className, props, w);
                String targetId = ModelProcessor.findTargetId(e);
                if (targetId != null) {
                    w.write("  /** Activates this model instance in the current {@link \nnet.java.html.json.Models#bind(java.lang.Object, net.java.html.BrwsrCtx) browser context}. \nIn case of using Knockout technology, this means to \nbind JSON like data in this model instance with Knockout tags in \nthe surrounding HTML page.\n");
                    if (targetId != null) {
                        w.write("This method binds to element '" + targetId + "' on the page\n");
                    }
                    w.write("@return <code>this</code> object\n*/\n");
                    w.write("  public " + className + " applyBindings() {\n");
                    w.write("    proto.applyBindings();\n");
                    w.write("    return this;\n");
                    w.write("  }\n");
                } else {
                    w.write("  private " + className + " applyBindings() {\n");
                    w.write("    throw new IllegalStateException(\"Please specify targetId=\\\"\\\" in your @Model annotation\");\n");
                    w.write("  }\n");
                }
                w.write("  public boolean equals(Object o) {\n");
                w.write("    if (o == this) return true;\n");
                w.write("    if (!(o instanceof " + className + ")) return false;\n");
                w.write("    " + className + " p = (" + className + ")o;\n");
                boolean bl5 = false;
                for (Prprt p3 : props) {
                    boolean[] blArray = new boolean[]{false};
                    isEnum = new boolean[]{false};
                    isPrimitive = new boolean[]{false};
                    this.checkType(p3, blArray, isEnum, isPrimitive);
                    if (blArray[0]) {
                        w.write("    if (!TYPE.isSame(thisToNull(prop_" + p3.name() + "), p.thisToNull(p.prop_" + p3.name() + "))) return false;\n");
                        bl = true;
                        continue;
                    }
                    w.write("    if (!TYPE.isSame(prop_" + p3.name() + ", p.prop_" + p3.name() + ")) return false;\n");
                }
                w.write("    return true;\n");
                w.write("  }\n");
                w.write("  public int hashCode() {\n");
                w.write("    int h = " + className + ".class.getName().hashCode();\n");
                for (Prprt p4 : props) {
                    boolean[] blArray = new boolean[]{false};
                    isEnum = new boolean[]{false};
                    isPrimitive = new boolean[]{false};
                    this.checkType(p4, blArray, isEnum, isPrimitive);
                    if (blArray[0]) {
                        w.write("    h = TYPE.hashPlus(thisToNull(prop_" + p4.name() + "), h);\n");
                        continue;
                    }
                    w.write("    h = TYPE.hashPlus(prop_" + p4.name() + ", h);\n");
                }
                w.write("    return h;\n");
                w.write("  }\n");
                if (bl) {
                    w.write("  private Object thisToNull(Object value) {\n");
                    w.write("    return value == this || value == TYPE ? null : value;\n");
                    w.write("  }\n");
                }
                w.write("}\n");
            }
            finally {
                ((Writer)w).close();
            }
        }
        catch (IOException ex) {
            this.error("Can't create " + className + ".java", e);
            return false;
        }
        return ok;
    }

    private static String findBuilderPrefix(Element e, Model m) {
        if (!m.builder().isEmpty()) {
            return m.builder();
        }
        for (AnnotationMirror annotationMirror : e.getAnnotationMirrors()) {
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationMirror.getElementValues().entrySet()) {
                if (!"builder()".equals(entry.getKey().toString())) continue;
                return "";
            }
        }
        return null;
    }

    private static String builderMethod(String builderPrefix, Prprt p) {
        if (builderPrefix.isEmpty()) {
            return p.name();
        }
        return builderPrefix + Character.toUpperCase(p.name().charAt(0)) + p.name().substring(1);
    }

    private boolean generateProperties(Element where, String builderPrefix, Writer w, String className, Prprt[] properties, List<GetSet> props, Map<String, Collection<String[]>> deps, Map<String, Collection<String>> functionDeps) throws IOException {
        boolean ok = true;
        for (Prprt p : properties) {
            boolean[] isPrimitive;
            boolean[] isEnum;
            String castTo;
            String tn = this.typeName(p);
            String[] gs = ModelProcessor.toGetSet(p.name(), tn, p.array());
            if (p.array()) {
                w.write("  private final java.util.List<" + tn + "> prop_" + p.name() + ";\n");
                castTo = "java.util.List";
                w.write("  public java.util.List<" + tn + "> " + gs[0] + "() {\n");
                w.write("    proto.accessProperty(\"" + p.name() + "\");\n");
                w.write("    return prop_" + p.name() + ";\n");
                w.write("  }\n");
                if (builderPrefix != null) {
                    boolean[] isModel = new boolean[]{false};
                    isEnum = new boolean[]{false};
                    isPrimitive = new boolean[]{false};
                    String ret = this.checkType(p, isModel, isEnum, isPrimitive);
                    w.write("  public " + className + " " + ModelProcessor.builderMethod(builderPrefix, p) + "(" + ret + "... v) {\n");
                    w.write("    proto.accessProperty(\"" + p.name() + "\");\n");
                    w.append("   TYPE.replaceValue(prop_").append(p.name()).append(", " + tn + ".class, v);\n");
                    w.write("    return this;\n");
                    w.write("  }\n");
                }
            } else {
                castTo = tn;
                boolean[] isModel = new boolean[]{false};
                isEnum = new boolean[]{false};
                isPrimitive = new boolean[]{false};
                this.checkType(p, isModel, isEnum, isPrimitive);
                if (isModel[0]) {
                    w.write("  private /*" + tn + "*/Object prop_" + p.name() + ";\n");
                } else {
                    w.write("  private " + tn + " prop_" + p.name() + ";\n");
                }
                w.write("  public " + tn + " " + gs[0] + "() {\n");
                w.write("    proto.accessProperty(\"" + p.name() + "\");\n");
                if (isModel[0]) {
                    w.write("    if (prop_" + p.name() + " == TYPE) prop_" + p.name() + " = net.java.html.json.Models.bind(new " + tn + "(), proto.getContext());\n");
                }
                w.write("    return (" + tn + ")prop_" + p.name() + ";\n");
                w.write("  }\n");
                w.write("  public void " + gs[1] + "(" + tn + " v) {\n");
                if (!p.mutable()) {
                    w.write("    proto.initTo(null, null);\n");
                }
                w.write("    proto.verifyUnlocked();\n");
                w.write("    Object o = prop_" + p.name() + ";\n");
                if (isModel[0]) {
                    w.write("    if (o == v) return;\n");
                    w.write("    prop_" + p.name() + " = v;\n");
                } else {
                    w.write("    if (TYPE.isSame(o , v)) return;\n");
                    w.write("    prop_" + p.name() + " = v;\n");
                }
                w.write("    proto.valueHasMutated(\"" + p.name() + "\", o, v);\n");
                Collection<Object> dependants = deps.get(p.name());
                if (dependants != null) {
                    for (String[] stringArray : dependants) {
                        w.write("    proto.valueHasMutated(\"" + stringArray[0] + "\", null, " + stringArray[1] + "());\n");
                    }
                }
                if ((dependants = functionDeps.get(p.name())) != null) {
                    w.append("    ");
                    w.append(className).append(" model = ").append(className).append(".this;\n");
                    for (String string : dependants) {
                        w.append("  ").append(string);
                    }
                }
                w.write("  }\n");
                if (builderPrefix != null) {
                    w.write("  public " + className + " " + ModelProcessor.builderMethod(builderPrefix, p) + "(" + tn + " v) {\n");
                    w.write("    " + gs[1] + "(v);\n");
                    w.write("    return this;\n");
                    w.write("  }\n");
                }
            }
            for (int i = 0; i < props.size(); ++i) {
                if (!props.get((int)i).name.equals(p.name())) continue;
                this.error("Cannot have the property " + p.name() + " defined twice", where);
                ok = false;
            }
            props.add(new GetSet(p.name(), gs[0], gs[1], tn, gs[3] == null && !p.array(), !p.mutable()));
        }
        return ok;
    }

    /*
     * Could not resolve type clashes
     */
    private boolean generateComputedProperties(String className, Writer w, Prprt[] fixedProps, Collection<? extends Element> arr, Collection<GetSet> props, Map<String, Collection<String[]>> deps) throws IOException {
        boolean ok = true;
        block2: for (Element e : arr) {
            String unknownSingleProperty;
            TypeMirror toCheck;
            if (e.getKind() != ElementKind.METHOD) continue;
            ComputedProperty cp = e.getAnnotation(ComputedProperty.class);
            Transitive tp = e.getAnnotation(Transitive.class);
            if (cp == null) continue;
            if (!e.getModifiers().contains((Object)Modifier.STATIC)) {
                this.error("Method " + e.getSimpleName() + " has to be static when annotated by @ComputedProperty", e);
                ok = false;
                continue;
            }
            ExecutableElement ee = (ExecutableElement)e;
            ExecutableElement write = null;
            if (!cp.write().isEmpty()) {
                write = this.findWrite(ee, (TypeElement)e.getEnclosingElement(), cp.write(), className);
                ok = write != null;
            }
            TypeMirror rt = ee.getReturnType();
            Types tu = this.processingEnv.getTypeUtils();
            TypeMirror ert = tu.erasure(rt);
            String tn = this.fqn(ert, ee);
            boolean array = false;
            if (tn.equals("java.util.List")) {
                array = true;
                toCheck = ((DeclaredType)rt).getTypeArguments().get(0);
            } else {
                toCheck = rt;
            }
            String sn = ee.getSimpleName().toString();
            if (!toCheck.getKind().isPrimitive()) {
                TypeMirror stringType = this.processingEnv.getElementUtils().getTypeElement("java.lang.String").asType();
                TypeMirror enumType = this.processingEnv.getElementUtils().getTypeElement("java.lang.Enum").asType();
                if (!(tu.isSubtype(toCheck, stringType) || tu.isSubtype(tu.erasure(toCheck), tu.erasure(enumType)) || this.isModel(toCheck))) {
                    try {
                        tu.unboxedType(toCheck);
                    }
                    catch (IllegalArgumentException ex) {
                        ok = false;
                        this.error(sn + " cannot return " + toCheck, e);
                    }
                }
            }
            String propertyName = e.getSimpleName().toString();
            for (GetSet prop : props) {
                if (!propertyName.equals(prop.name)) continue;
                this.error("Cannot have the property " + propertyName + " defined twice", e);
                ok = false;
                continue block2;
            }
            String[] gs = ModelProcessor.toGetSet(sn, tn, array);
            w.write("  public " + tn);
            if (array) {
                w.write("<" + toCheck + ">");
            }
            w.write(" " + gs[0] + "() {\n");
            int arg = 0;
            boolean deep = false;
            List<? extends VariableElement> methodParameters = ee.getParameters();
            String string = unknownSingleProperty = methodParameters.size() != 1 ? null : this.verifyPropName(methodParameters.get(0), fixedProps);
            if (unknownSingleProperty == null) {
                for (VariableElement pe : methodParameters) {
                    List<? extends TypeMirror> ptArgs;
                    String dt;
                    TypeMirror pt;
                    String dn = pe.getSimpleName().toString();
                    String unknownPropertyError = this.verifyPropName(pe, fixedProps);
                    if (unknownPropertyError != null) {
                        this.error(unknownPropertyError, e);
                        ok = false;
                    }
                    if (this.isModel(pt = pe.asType())) {
                        deep = true;
                    }
                    if ((dt = this.fqn(pt, ee)).startsWith("java.util.List") && pt instanceof DeclaredType && (ptArgs = ((DeclaredType)pt).getTypeArguments()).size() == 1 && this.isModel(ptArgs.get(0))) {
                        deep = true;
                    }
                    String[] call = ModelProcessor.toGetSet(dn, dt, false);
                    w.write("    " + dt + " arg" + ++arg + " = ");
                    w.write(call[0] + "();\n");
                    Collection<String[]> depends = deps.get(dn);
                    if (depends == null) {
                        depends = new LinkedHashSet<String[]>();
                        deps.put(dn, depends);
                    }
                    depends.add(new String[]{sn, gs[0]});
                }
            } else {
                VariableElement firstProp = methodParameters.get(0);
                TypeMirror type = firstProp.asType();
                CharSequence simpleName = type.getKind() == TypeKind.DECLARED ? ((DeclaredType)type).asElement().getSimpleName() : type.toString();
                if (!simpleName.toString().equals(className)) {
                    this.error("Single parameter needs to be of type " + className + " or " + unknownSingleProperty, e);
                    ok = false;
                    continue;
                }
                w.write("    " + simpleName + " arg" + ++arg + " = this;\n");
            }
            w.write("    try {\n");
            if (tp != null) {
                deep = tp.deep();
            }
            if (deep) {
                w.write("      proto.acquireLock(\"" + sn + "\");\n");
            } else {
                w.write("      proto.acquireLock();\n");
            }
            w.write("      return " + this.fqn(ee.getEnclosingElement().asType(), ee) + '.' + e.getSimpleName() + "(");
            String sep = "";
            for (int i = 1; i <= arg; ++i) {
                w.write(sep);
                w.write("arg" + i);
                sep = ", ";
            }
            w.write(");\n");
            w.write("    } finally {\n");
            w.write("      proto.releaseLock();\n");
            w.write("    }\n");
            w.write("  }\n");
            if (write == null) {
                props.add(new GetSet(propertyName, gs[0], null, tn, true, false));
                continue;
            }
            w.write("  public void " + gs[4] + "(" + write.getParameters().get(1).asType());
            w.write(" value) {\n");
            w.write("    " + this.fqn(ee.getEnclosingElement().asType(), ee) + '.' + write.getSimpleName() + "(this, value);\n");
            w.write("  }\n");
            props.add(new GetSet(propertyName, gs[0], gs[4], tn, false, false));
        }
        return ok;
    }

    private static String[] toGetSet(String name, String type, boolean array) {
        String pref;
        String n = Character.toUpperCase(name.charAt(0)) + name.substring(1);
        boolean clazz = "class".equals(name);
        String string = pref = clazz ? "access" : "get";
        if ("boolean".equals(type) && !array) {
            pref = "is";
        }
        if (array) {
            return new String[]{pref + n, null, "a" + n, null, "set" + n};
        }
        return new String[]{pref + n, "set" + n, "a" + n, "", "set" + n};
    }

    private String typeName(Prprt p) {
        String bt;
        boolean[] isModel = new boolean[]{false};
        boolean[] isEnum = new boolean[]{false};
        boolean[] isPrimitive = new boolean[]{false};
        String ret = this.checkType(p, isModel, isEnum, isPrimitive);
        if (p.array() && (bt = ModelProcessor.findBoxedType(ret)) != null) {
            return bt;
        }
        return ret;
    }

    private static String findBoxedType(String ret) {
        if (ret.equals("boolean")) {
            return Boolean.class.getName();
        }
        if (ret.equals("byte")) {
            return Byte.class.getName();
        }
        if (ret.equals("short")) {
            return Short.class.getName();
        }
        if (ret.equals("char")) {
            return Character.class.getName();
        }
        if (ret.equals("int")) {
            return Integer.class.getName();
        }
        if (ret.equals("long")) {
            return Long.class.getName();
        }
        if (ret.equals("float")) {
            return Float.class.getName();
        }
        if (ret.equals("double")) {
            return Double.class.getName();
        }
        return null;
    }

    private String verifyPropName(Element e, Prprt[] existingProps) {
        String propName = e.getSimpleName().toString();
        StringBuilder sb = new StringBuilder();
        String sep = "";
        for (Prprt Prprt2 : existingProps) {
            if (Prprt2.name().equals(propName)) {
                return null;
            }
            sb.append(sep);
            sb.append('\"');
            sb.append(Prprt2.name());
            sb.append('\"');
            sep = ", ";
        }
        return propName + " has to be one of known properties: " + sb;
    }

    private static String findPkgName(Element e) {
        while (e.getKind() != ElementKind.PACKAGE) {
            e = e.getEnclosingElement();
        }
        return ((PackageElement)e).getQualifiedName().toString();
    }

    private boolean generateFunctions(Element clazz, StringWriter body, String className, List<? extends Element> enclosedElements, List<Object> functions) {
        boolean instance = clazz.getAnnotation(Model.class).instance();
        for (Element element : enclosedElements) {
            ExecutableElement e;
            Function onF;
            if (element.getKind() != ElementKind.METHOD || (onF = (e = (ExecutableElement)element).getAnnotation(Function.class)) == null) continue;
            if (!instance && !e.getModifiers().contains((Object)Modifier.STATIC)) {
                this.error("@OnFunction method needs to be static", e);
                return false;
            }
            if (e.getModifiers().contains((Object)Modifier.PRIVATE)) {
                this.error("@OnFunction method cannot be private", e);
                return false;
            }
            if (e.getReturnType().getKind() != TypeKind.VOID) {
                this.error("@OnFunction method should return void", e);
                return false;
            }
            String n = e.getSimpleName().toString();
            functions.add(n);
            functions.add(e);
        }
        return true;
    }

    private boolean generateOnChange(Element clazz, Map<String, Collection<String[]>> propDeps, Prprt[] properties, String className, Map<String, Collection<String>> functionDeps) {
        boolean instance = clazz.getAnnotation(Model.class).instance();
        for (Element element : clazz.getEnclosedElements()) {
            ExecutableElement e;
            OnPropertyChange onPC;
            if (element.getKind() != ElementKind.METHOD || (onPC = (e = (ExecutableElement)element).getAnnotation(OnPropertyChange.class)) == null) continue;
            for (String pn : onPC.value()) {
                if (ModelProcessor.findPrprt(properties, pn) != null || !ModelProcessor.findDerivedFrom(propDeps, pn).isEmpty()) continue;
                this.error("No Prprt named '" + pn + "' in the model", clazz);
                return false;
            }
            if (!instance && !e.getModifiers().contains((Object)Modifier.STATIC)) {
                this.error("@OnPrprtChange method needs to be static", e);
                return false;
            }
            if (e.getModifiers().contains((Object)Modifier.PRIVATE)) {
                this.error("@OnPrprtChange method cannot be private", e);
                return false;
            }
            if (e.getReturnType().getKind() != TypeKind.VOID) {
                this.error("@OnPrprtChange method should return void", e);
                return false;
            }
            String n = e.getSimpleName().toString();
            for (String pn : onPC.value()) {
                StringBuilder call = new StringBuilder();
                call.append("  ").append(this.inPckName(clazz, instance)).append(".").append(n).append("(");
                call.append(this.wrapPropName(e, className, "name", pn));
                call.append(");\n");
                Collection<String> change = functionDeps.get(pn);
                if (change == null) {
                    change = new ArrayList<String>();
                    functionDeps.put(pn, change);
                }
                change.add(call.toString());
                for (String dpn : ModelProcessor.findDerivedFrom(propDeps, pn)) {
                    change = functionDeps.get(dpn);
                    if (change == null) {
                        change = new ArrayList<String>();
                        functionDeps.put(dpn, change);
                    }
                    change.add(call.toString());
                }
            }
        }
        return true;
    }

    private boolean generateOperation(Element clazz, StringWriter body, String className, List<? extends Element> enclosedElements, List<Object> functions) {
        Types tu = this.processingEnv.getTypeUtils();
        boolean instance = clazz.getAnnotation(Model.class).instance();
        for (Element element : enclosedElements) {
            ExecutableElement e;
            ModelOperation mO;
            if (element.getKind() != ElementKind.METHOD || (mO = (e = (ExecutableElement)element).getAnnotation(ModelOperation.class)) == null) continue;
            if (!instance && !e.getModifiers().contains((Object)Modifier.STATIC)) {
                this.error("@ModelOperation method needs to be static", e);
                return false;
            }
            if (e.getModifiers().contains((Object)Modifier.PRIVATE)) {
                this.error("@ModelOperation method cannot be private", e);
                return false;
            }
            if (e.getReturnType().getKind() != TypeKind.VOID) {
                this.error("@ModelOperation method should return void", e);
                return false;
            }
            ArrayList<String> args = new ArrayList<String>();
            body.append("  /** @see " + clazz.getSimpleName() + "#" + element.getSimpleName() + " */\n");
            body.append("  public void ").append(element.getSimpleName()).append("(");
            String sep = "";
            boolean checkFirst = true;
            for (VariableElement variableElement : e.getParameters()) {
                TypeMirror type = variableElement.asType();
                CharSequence simpleName = type.getKind() == TypeKind.DECLARED ? ((DeclaredType)type).asElement().getSimpleName() : type.toString();
                if (checkFirst && simpleName.toString().equals(className)) {
                    checkFirst = false;
                    continue;
                }
                if (checkFirst) {
                    this.error("First parameter of @ModelOperation method must be " + className, element);
                    return false;
                }
                if (variableElement.asType().getKind() == TypeKind.ARRAY) {
                    args.add("(Object) " + variableElement.getSimpleName().toString());
                } else {
                    args.add(variableElement.getSimpleName().toString());
                }
                body.append(sep).append("final ");
                body.append(variableElement.asType().toString()).append(" ");
                body.append(variableElement.toString());
                sep = ", ";
            }
            body.append(") {\n");
            int idx = functions.size() / 2;
            functions.add(element.getSimpleName().toString());
            body.append("    proto.runInBrowser(" + idx);
            for (String s : args) {
                body.append(", ").append(s);
            }
            body.append(");\n");
            body.append("  }\n");
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("{ Object[] arr = (Object[])data; ");
            stringBuilder.append(this.inPckName(clazz, true)).append(".").append(element.getSimpleName()).append("(");
            int i = 0;
            for (VariableElement variableElement : e.getParameters()) {
                if (i++ == 0) {
                    stringBuilder.append("model");
                    continue;
                }
                String type = variableElement.asType().toString();
                String boxedType = ModelProcessor.findBoxedType(type);
                if (boxedType != null) {
                    type = boxedType;
                }
                stringBuilder.append(", ").append("(").append(type).append(")arr[").append(i - 2).append("]");
            }
            stringBuilder.append("); }");
            functions.add(stringBuilder.toString());
        }
        return true;
    }

    private boolean generateReceive(Element clazz, StringWriter body, String className, List<? extends Element> enclosedElements, StringBuilder inType) {
        boolean ret = this.generateReceiveImpl(clazz, body, className, enclosedElements, inType);
        if (!ret) {
            inType.setLength(0);
        }
        return ret;
    }

    private boolean generateReceiveImpl(Element clazz, StringWriter body, String className, List<? extends Element> enclosedElements, StringBuilder inType) {
        inType.append("  @Override public void onMessage(").append(className).append(" model, int index, int type, Object data, Object[] params) {\n");
        inType.append("    switch (index) {\n");
        int index = 0;
        boolean ok = true;
        boolean instance = clazz.getAnnotation(Model.class).instance();
        for (Element element : enclosedElements) {
            boolean isWebSocket;
            ExecutableElement e;
            OnReceive onR;
            if (element.getKind() != ElementKind.METHOD || (onR = (e = (ExecutableElement)element).getAnnotation(OnReceive.class)) == null) continue;
            if (!instance && !e.getModifiers().contains((Object)Modifier.STATIC)) {
                this.error("@OnReceive method needs to be static", e);
                return false;
            }
            if (e.getModifiers().contains((Object)Modifier.PRIVATE)) {
                this.error("@OnReceive method cannot be private", e);
                return false;
            }
            if (e.getReturnType().getKind() != TypeKind.VOID) {
                this.error("@OnReceive method should return void", e);
                return false;
            }
            if (!onR.jsonp().isEmpty() && !"GET".equals(onR.method())) {
                this.error("JSONP works only with GET transport method", e);
            }
            String dataMirror = this.findDataSpecified(e, onR);
            if ("PUT".equals(onR.method()) && dataMirror == null) {
                this.error("PUT method needs to specify a data() class", e);
                return false;
            }
            if ("POST".equals(onR.method()) && dataMirror == null) {
                this.error("POST method needs to specify a data() class", e);
                return false;
            }
            if (e.getParameters().size() < 2) {
                this.error("@OnReceive method needs at least two parameters", e);
            }
            if ((isWebSocket = "WebSocket".equals(onR.method())) && dataMirror == null) {
                this.error("WebSocket method needs to specify a data() class", e);
            }
            int expectsList = 0;
            ArrayList<String> args = new ArrayList<String>();
            ArrayList<String> params = new ArrayList<String>();
            TypeMirror type = e.getParameters().get(0).asType();
            CharSequence simpleName = type.getKind() == TypeKind.DECLARED ? ((DeclaredType)type).asElement().getSimpleName() : type.toString();
            if (!simpleName.toString().equals(className)) {
                this.error("First parameter needs to be " + className, e);
                return false;
            }
            args.add("model");
            Types tu = this.processingEnv.getTypeUtils();
            TypeMirror type2 = e.getParameters().get(1).asType();
            TypeMirror modelType = null;
            TypeMirror ert = tu.erasure(type2);
            if (this.isModel(type2)) {
                modelType = type2;
            } else if (type2.getKind() == TypeKind.ARRAY) {
                modelType = ((ArrayType)type2).getComponentType();
                expectsList = 1;
            } else if ("java.util.List".equals(this.fqn(ert, e))) {
                List<? extends TypeMirror> typeArgs = ((DeclaredType)type2).getTypeArguments();
                if (typeArgs.size() == 1) {
                    modelType = typeArgs.get(0);
                    expectsList = 2;
                }
            } else if (type2.toString().equals("java.lang.String")) {
                modelType = type2;
            }
            if (modelType == null) {
                this.error("Second arguments needs to be a model, String or array or List of models", e);
                return false;
            }
            String modelClass = modelType.toString();
            if (expectsList == 1) {
                args.add("arr");
            } else if (expectsList == 2) {
                args.add("net.java.html.json.Models.asList(arr)");
            } else {
                args.add("arr[0]");
            }
            String n = e.getSimpleName().toString();
            String c = this.inPckName(clazz, false);
            if (isWebSocket) {
                body.append("  /** Performs WebSocket communication and then calls {@link ");
                body.append(c).append("#").append(n).append("}.\n");
                body.append("  * Call with <code>null</code> data parameter\n");
                body.append("  * to open the connection (even if not required). Call with non-null data to\n");
                body.append("  * send messages to server. Call again with <code>null</code> data to close the socket.\n");
                body.append("  */\n");
                if (onR.headers().length > 0) {
                    this.error("WebSocket spec does not support headers", e);
                }
            } else {
                body.append("  /** Performs network communication and then calls {@link ");
                body.append(c).append("#").append(n).append("}.\n");
                body.append("  */\n");
            }
            body.append("  public void ").append(n).append("(");
            StringBuilder urlBefore = new StringBuilder();
            StringBuilder urlAfter = new StringBuilder();
            StringBuilder headers = new StringBuilder();
            String jsonpVarName = null;
            String sep = "";
            boolean skipJSONP = onR.jsonp().isEmpty();
            LinkedHashSet<String> receiveParams = new LinkedHashSet<String>();
            this.findParamNames(receiveParams, e, onR.url(), onR.jsonp(), urlBefore, urlAfter);
            for (String headerLine : onR.headers()) {
                if (headerLine.contains("\r") || headerLine.contains("\n")) {
                    this.error("Header line cannot contain line separator", e);
                }
                this.findParamNames(receiveParams, e, headerLine, null, headers);
                headers.append("+ \"\\r\\n\" +\n");
            }
            if (headers.length() > 0) {
                headers.append("\"\"");
            }
            for (String p : receiveParams) {
                if (!skipJSONP && p.equals(onR.jsonp())) {
                    skipJSONP = true;
                    jsonpVarName = p;
                    continue;
                }
                body.append(sep);
                body.append("String ").append(p);
                sep = ", ";
            }
            if (!skipJSONP) {
                this.error("Name of jsonp attribute ('" + onR.jsonp() + "') is not used in url attribute '" + onR.url() + "'", e);
            }
            if (dataMirror != null) {
                body.append(sep).append(dataMirror.toString()).append(" data");
            }
            for (int i = 2; i < e.getParameters().size(); ++i) {
                if (isWebSocket) {
                    this.error("@OnReceive(method=\"WebSocket\") can only have two arguments", e);
                    ok = false;
                }
                VariableElement ve = e.getParameters().get(i);
                body.append(sep).append(ve.asType().toString()).append(" ").append(ve.getSimpleName());
                String tp = ve.asType().toString();
                String btn = ModelProcessor.findBoxedType(tp);
                if (btn == null) {
                    btn = tp;
                }
                args.add("(" + btn + ")params[" + (i - 2) + "]");
                params.add(ve.getSimpleName().toString());
                sep = ", ";
            }
            body.append(") {\n");
            boolean webSocket = onR.method().equals("WebSocket");
            if (webSocket) {
                if (this.generateWSReceiveBody(index++, body, inType, onR, e, clazz, className, expectsList != 0, modelClass, n, args, params, urlBefore, jsonpVarName, urlAfter, dataMirror, headers)) {
                    return false;
                }
                body.append("  }\n");
                body.append("  private Object ws_" + e.getSimpleName() + ";\n");
                continue;
            }
            if (this.generateJSONReceiveBody(index++, body, inType, onR, e, clazz, className, expectsList != 0, modelClass, n, args, params, urlBefore, jsonpVarName, urlAfter, dataMirror, headers)) {
                ok = false;
            }
            body.append("  }\n");
        }
        inType.append("    }\n");
        inType.append("    throw new UnsupportedOperationException(\"index: \" + index + \" type: \" + type);\n");
        inType.append("  }\n");
        return ok;
    }

    private boolean generateJSONReceiveBody(int index, StringWriter method, StringBuilder body, OnReceive onR, ExecutableElement e, Element clazz, String className, boolean expectsList, String modelClass, String n, List<String> args, List<String> params, StringBuilder urlBefore, String jsonpVarName, StringBuilder urlAfter, String dataMirror, StringBuilder headers) {
        boolean error = false;
        body.append("    case " + index + ": {\n      if (type == 2) { /* on error */\n        Exception ex = (Exception)data;\n");
        if (onR.onError().isEmpty()) {
            body.append("        ex.printStackTrace();\n");
        } else {
            int errorParamsLength = this.findOnError(e, (TypeElement)clazz, onR.onError(), className);
            error = errorParamsLength < 0;
            body.append("        ").append(clazz.getSimpleName()).append(".").append(onR.onError()).append("(");
            body.append("model, ex");
            for (int i = 2; i < errorParamsLength; ++i) {
                String arg = args.get(i);
                body.append(", ");
                if (arg.startsWith("arr") || arg.startsWith("java.util.Array")) {
                    body.append("null");
                    continue;
                }
                body.append(arg);
            }
            body.append(");\n");
        }
        body.append("        return;\n      } else if (type == 1) {\n        Object[] ev = (Object[])data;\n");
        if (expectsList) {
            body.append("        " + modelClass + "[] arr = new " + modelClass + "[ev.length];\n");
        } else {
            body.append("        " + modelClass + "[] arr = { null };\n");
        }
        body.append("        TYPE.copyJSON(model.proto.getContext(), ev, " + modelClass + ".class, arr);\n");
        body.append("        ").append(clazz.getSimpleName()).append(".").append(n).append("(");
        String sep = "";
        for (String arg : args) {
            body.append(sep);
            body.append(arg);
            sep = ", ";
        }
        body.append(");\n");
        body.append("        return;\n      }\n    }\n");
        method.append("    proto.loadJSONWithHeaders(" + index + ",\n        ");
        method.append(headers.length() == 0 ? "null" : headers).append(",\n        ");
        method.append(urlBefore).append(", ");
        if (jsonpVarName != null) {
            method.append(urlAfter);
        } else {
            method.append("null");
        }
        if (!"GET".equals(onR.method()) || dataMirror != null) {
            method.append(", \"").append(onR.method()).append('\"');
            if (dataMirror != null) {
                method.append(", data");
            } else {
                method.append(", null");
            }
        } else {
            method.append(", null, null");
        }
        for (String a : params) {
            method.append(", ").append(a);
        }
        method.append(");\n");
        return error;
    }

    private boolean generateWSReceiveBody(int index, StringWriter method, StringBuilder body, OnReceive onR, ExecutableElement e, Element clazz, String className, boolean expectsList, String modelClass, String n, List<String> args, List<String> params, StringBuilder urlBefore, String jsonpVarName, StringBuilder urlAfter, String dataMirror, StringBuilder headers) {
        body.append("    case " + index + ": {\n      if (type == 0) { /* on open */\n        ").append(this.inPckName(clazz, true)).append(".").append(n).append("(");
        String sep = "";
        for (String arg : args) {
            body.append(sep);
            if (arg.startsWith("arr") || arg.startsWith("net.java.html.json.Models.asList")) {
                body.append("null");
            } else {
                body.append(arg);
            }
            sep = ", ";
        }
        body.append(");\n");
        body.append("        return;\n      } else if (type == 2) { /* on error */\n        Exception value = (Exception)data;\n");
        if (onR.onError().isEmpty()) {
            body.append("        value.printStackTrace();\n");
        } else {
            int errorParamsLength = this.findOnError(e, (TypeElement)clazz, onR.onError(), className);
            if (errorParamsLength < 0) {
                return true;
            }
            body.append("        ").append(this.inPckName(clazz, true)).append(".").append(onR.onError()).append("(");
            body.append("model, value");
            for (int i = 2; i < errorParamsLength; ++i) {
                String arg;
                arg = args.get(i);
                body.append(", ");
                if (arg.startsWith("arr") || arg.startsWith("java.util.Array")) {
                    body.append("null");
                    continue;
                }
                body.append(arg);
            }
            body.append(");\n");
        }
        body.append("        return;\n      } else if (type == 1) {\n        Object[] ev = (Object[])data;\n");
        if (expectsList) {
            body.append("        " + modelClass + "[] arr = new " + modelClass + "[ev.length];\n");
        } else {
            body.append("        " + modelClass + "[] arr = { null };\n");
        }
        body.append("        TYPE.copyJSON(model.proto.getContext(), ev, " + modelClass + ".class, arr);\n");
        body.append("        ").append(this.inPckName(clazz, true)).append(".").append(n).append("(");
        sep = "";
        for (String arg : args) {
            body.append(sep);
            body.append(arg);
            sep = ", ";
        }
        body.append(");\n");
        body.append("        return;\n      }");
        if (!onR.onError().isEmpty()) {
            body.append(" else if (type == 3) { /* on close */\n");
            body.append("        ").append(this.inPckName(clazz, true)).append(".").append(onR.onError()).append("(");
            body.append("model, null);\n");
            body.append("        return;      }");
        }
        body.append("\n");
        body.append("    }\n");
        method.append("    if (this.ws_").append(e.getSimpleName()).append(" == null) {\n");
        method.append("      this.ws_").append(e.getSimpleName());
        method.append("= proto.wsOpen(" + index + ", ");
        method.append(urlBefore).append(", data);\n");
        method.append("    } else {\n");
        method.append("      proto.wsSend(this.ws_").append(e.getSimpleName()).append(", ").append(urlBefore).append(", data");
        for (String a : params) {
            method.append(", ").append(a);
        }
        method.append(");\n");
        method.append("    }\n");
        return false;
    }

    private CharSequence wrapParams(ExecutableElement ee, String id, String className, String classRef, String evName, String dataName) {
        TypeMirror stringType = this.processingEnv.getElementUtils().getTypeElement("java.lang.String").asType();
        StringBuilder params = new StringBuilder();
        boolean first = true;
        for (VariableElement variableElement : ee.getParameters()) {
            if (!first) {
                params.append(", ");
            }
            first = false;
            String toCall = null;
            String toFinish = null;
            boolean addNull = true;
            if (variableElement.asType() == stringType) {
                if (variableElement.getSimpleName().contentEquals("id")) {
                    params.append('\"').append(id).append('\"');
                    continue;
                }
                toCall = classRef + ".proto.toString(";
            }
            if (variableElement.asType().getKind() == TypeKind.DOUBLE) {
                toCall = classRef + ".proto.toNumber(";
                toFinish = ".doubleValue()";
            }
            if (variableElement.asType().getKind() == TypeKind.FLOAT) {
                toCall = classRef + ".proto.toNumber(";
                toFinish = ".floatValue()";
            }
            if (variableElement.asType().getKind() == TypeKind.INT) {
                toCall = classRef + ".proto.toNumber(";
                toFinish = ".intValue()";
            }
            if (variableElement.asType().getKind() == TypeKind.BYTE) {
                toCall = classRef + ".proto.toNumber(";
                toFinish = ".byteValue()";
            }
            if (variableElement.asType().getKind() == TypeKind.SHORT) {
                toCall = classRef + ".proto.toNumber(";
                toFinish = ".shortValue()";
            }
            if (variableElement.asType().getKind() == TypeKind.LONG) {
                toCall = classRef + ".proto.toNumber(";
                toFinish = ".longValue()";
            }
            if (variableElement.asType().getKind() == TypeKind.BOOLEAN) {
                toCall = "\"true\".equals(" + classRef + ".proto.toString(";
                toFinish = ")";
            }
            if (variableElement.asType().getKind() == TypeKind.CHAR) {
                toCall = "(char)" + classRef + ".proto.toNumber(";
                toFinish = ".intValue()";
            }
            if (dataName != null && variableElement.getSimpleName().contentEquals(dataName) && this.isModel(variableElement.asType())) {
                toCall = classRef + ".proto.toModel(" + variableElement.asType() + ".class, ";
                addNull = false;
            }
            if (toCall != null) {
                params.append(toCall);
                if (dataName != null && variableElement.getSimpleName().contentEquals(dataName)) {
                    params.append(dataName);
                    if (addNull) {
                        params.append(", null");
                    }
                } else {
                    if (evName == null) {
                        StringBuilder sb = new StringBuilder();
                        sb.append("Unexpected string parameter name.");
                        if (dataName != null) {
                            sb.append(" Try \"").append(dataName).append("\"");
                        }
                        this.error(sb.toString(), ee);
                    }
                    params.append(evName);
                    params.append(", \"");
                    params.append(variableElement.getSimpleName().toString());
                    params.append("\"");
                }
                params.append(")");
                if (toFinish == null) continue;
                params.append(toFinish);
                continue;
            }
            String rn = this.fqn(variableElement.asType(), ee);
            int last = rn.lastIndexOf(46);
            if (last >= 0) {
                rn = rn.substring(last + 1);
            }
            if (rn.equals(className)) {
                params.append(classRef);
                continue;
            }
            StringBuilder err = new StringBuilder();
            err.append("Argument ").append(variableElement.getSimpleName()).append(" is not valid. The annotated method can only accept ").append(className).append(" argument");
            if (dataName != null) {
                err.append(" or argument named '").append(dataName).append("'");
            }
            err.append(".");
            this.error(err.toString(), ee);
        }
        return params;
    }

    private CharSequence wrapPropName(ExecutableElement ee, String className, String propName, String propValue) {
        TypeMirror stringType = this.processingEnv.getElementUtils().getTypeElement("java.lang.String").asType();
        StringBuilder params = new StringBuilder();
        boolean first = true;
        for (VariableElement variableElement : ee.getParameters()) {
            if (!first) {
                params.append(", ");
            }
            first = false;
            if (variableElement.asType() == stringType) {
                if (propName != null && variableElement.getSimpleName().contentEquals(propName)) {
                    params.append('\"').append(propValue).append('\"');
                    continue;
                }
                this.error("Unexpected string parameter name. Try \"" + propName + "\".", ee);
                continue;
            }
            String rn = this.fqn(variableElement.asType(), ee);
            int last = rn.lastIndexOf(46);
            if (last >= 0) {
                rn = rn.substring(last + 1);
            }
            if (rn.equals(className)) {
                params.append("model");
                continue;
            }
            this.error("@OnPrprtChange method can only accept String or " + className + " arguments", ee);
        }
        return params;
    }

    private boolean isModel(TypeMirror tm) {
        if (tm.getKind() == TypeKind.ERROR) {
            return true;
        }
        Element e = this.processingEnv.getTypeUtils().asElement(tm);
        if (e == null) {
            return false;
        }
        for (Element element : e.getEnclosedElements()) {
            ExecutableElement ee;
            if (element.getKind() != ElementKind.METHOD || !(ee = (ExecutableElement)element).getParameters().isEmpty() || !ee.getSimpleName().contentEquals("modelFor")) continue;
            return true;
        }
        return this.models.values().contains(e.getSimpleName().toString());
    }

    private void writeToString(Prprt[] props, Writer w) throws IOException {
        w.write("  public String toString() {\n");
        w.write("    StringBuilder sb = new StringBuilder();\n");
        w.write("    sb.append('{');\n");
        String sep = "";
        for (Prprt p : props) {
            w.write(sep);
            w.append("    sb.append('\"').append(\"" + p.name() + "\")");
            w.append(".append('\"').append(\":\");\n");
            String tn = this.typeName(p);
            String[] gs = ModelProcessor.toGetSet(p.name(), tn, p.array());
            boolean[] isModel = new boolean[]{false};
            boolean[] isEnum = new boolean[]{false};
            boolean[] isPrimitive = new boolean[]{false};
            this.checkType(p, isModel, isEnum, isPrimitive);
            if (isModel[0]) {
                w.append("    sb.append(TYPE.toJSON(thisToNull(this.prop_");
                w.append(p.name()).append(")));\n");
            } else {
                w.append("    sb.append(TYPE.toJSON(");
                w.append(gs[0]).append("()));\n");
            }
            sep = "    sb.append(',');\n";
        }
        w.write("    sb.append('}');\n");
        w.write("    return sb.toString();\n");
        w.write("  }\n");
    }

    private void writeClone(String className, Prprt[] props, Writer w) throws IOException {
        w.write("  public " + className + " clone() {\n");
        w.write("    return clone(proto.getContext());\n");
        w.write("  }\n");
        w.write("  private " + className + " clone(net.java.html.BrwsrCtx ctx) {\n");
        w.write("    " + className + " ret = new " + className + "(ctx);\n");
        for (Prprt p : props) {
            String tn = this.typeName(p);
            String[] gs = ModelProcessor.toGetSet(p.name(), tn, p.array());
            if (!p.array()) {
                boolean[] isModel = new boolean[]{false};
                boolean[] isEnum = new boolean[]{false};
                boolean[] isPrimitive = new boolean[]{false};
                this.checkType(p, isModel, isEnum, isPrimitive);
                if (!isModel[0]) {
                    w.write("    ret.prop_" + p.name() + " = " + gs[0] + "();\n");
                    continue;
                }
                w.write("    ret.prop_" + p.name() + " =  prop_" + p.name() + " == null ? null : prop_" + p.name() + " == TYPE ? TYPE : net.java.html.json.Models.bind(" + gs[0] + "(), ctx);\n");
                continue;
            }
            w.write("    proto.cloneList(ret." + gs[0] + "(), ctx, prop_" + p.name() + ");\n");
        }
        w.write("    return ret;\n");
        w.write("  }\n");
    }

    private String inPckName(Element e, boolean preferInstance) {
        if (preferInstance && e.getAnnotation(Model.class).instance()) {
            return "model.instance";
        }
        StringBuilder sb = new StringBuilder();
        while (e.getKind() != ElementKind.PACKAGE) {
            if (sb.length() == 0) {
                sb.append(e.getSimpleName());
            } else {
                sb.insert(0, '.');
                sb.insert(0, e.getSimpleName());
            }
            e = e.getEnclosingElement();
        }
        return sb.toString();
    }

    private String fqn(TypeMirror pt, Element relative) {
        if (pt.getKind() == TypeKind.ERROR) {
            Elements eu = this.processingEnv.getElementUtils();
            PackageElement pckg = eu.getPackageOf(relative);
            return pckg.getQualifiedName() + "." + pt.toString();
        }
        return pt.toString();
    }

    private String checkType(Prprt p, boolean[] isModel, boolean[] isEnum, boolean[] isPrimitive) {
        String ret;
        TypeMirror tm;
        try {
            String ret2 = p.typeName(this.processingEnv);
            TypeElement e = this.processingEnv.getElementUtils().getTypeElement(ret2);
            if (e == null) {
                isModel[0] = true;
                isEnum[0] = false;
                isPrimitive[0] = false;
                return ret2;
            }
            tm = e.asType();
        }
        catch (MirroredTypeException ex) {
            tm = ex.getTypeMirror();
        }
        tm = this.processingEnv.getTypeUtils().erasure(tm);
        isPrimitive[0] = tm.getKind().isPrimitive();
        if (isPrimitive[0]) {
            isEnum[0] = false;
            isModel[0] = false;
            return tm.toString();
        }
        Element e = this.processingEnv.getTypeUtils().asElement(tm);
        if (e.getKind() == ElementKind.CLASS && tm.getKind() == TypeKind.ERROR) {
            isModel[0] = true;
            isEnum[0] = false;
            return e.getSimpleName().toString();
        }
        TypeMirror enm = this.processingEnv.getElementUtils().getTypeElement("java.lang.Enum").asType();
        enm = this.processingEnv.getTypeUtils().erasure(enm);
        isEnum[0] = this.processingEnv.getTypeUtils().isSubtype(tm, enm);
        if (!isEnum[0]) {
            Model m;
            Model model = m = e == null ? null : e.getAnnotation(Model.class);
            if (m != null) {
                ret = ModelProcessor.findPkgName(e) + '.' + m.className();
                isModel[0] = true;
                this.models.put(e, m.className());
            } else if (ModelProcessor.findModelForMthd(e)) {
                ret = ((TypeElement)e).getQualifiedName().toString();
                isModel[0] = true;
            } else {
                ret = tm.toString();
            }
        } else {
            ret = tm.toString();
        }
        return ret;
    }

    private static boolean findModelForMthd(Element clazz) {
        if (clazz == null) {
            return false;
        }
        for (Element element : clazz.getEnclosedElements()) {
            ExecutableElement ee;
            if (element.getKind() != ElementKind.METHOD || !(ee = (ExecutableElement)element).getSimpleName().contentEquals("modelFor") || !ee.getParameters().isEmpty()) continue;
            return true;
        }
        return false;
    }

    private void findParamNames(Set<String> params, Element e, String url, String jsonParam, StringBuilder ... both) {
        int wasJSON = 0;
        int pos = 0;
        while (true) {
            int next;
            if ((next = url.indexOf(123, pos)) == -1) {
                both[wasJSON].append('\"').append(url.substring(pos).replace("\"", "\\\"")).append('\"');
                return;
            }
            int close = url.indexOf(125, next);
            if (close == -1) {
                this.error("Unbalanced '{' and '}' in " + url, e);
                return;
            }
            String paramName = url.substring(next + 1, close);
            params.add(paramName);
            if (paramName.equals(jsonParam) && !jsonParam.isEmpty()) {
                both[wasJSON].append('\"').append(url.substring(pos, next).replace("\"", "\\\"")).append('\"');
                wasJSON = 1;
            } else {
                both[wasJSON].append('\"').append(url.substring(pos, next).replace("\"", "\\\"")).append("\" + ").append(paramName).append(" + ");
            }
            pos = close + 1;
        }
    }

    private static Prprt findPrprt(Prprt[] properties, String propName) {
        for (Prprt p : properties) {
            if (!propName.equals(p.name())) continue;
            return p;
        }
        return null;
    }

    private boolean isPrimitive(String type) {
        return "int".equals(type) || "double".equals(type) || "long".equals(type) || "short".equals(type) || "byte".equals(type) || "char".equals(type) || "boolean".equals(type) || "float".equals(type);
    }

    private static Collection<String> findDerivedFrom(Map<String, Collection<String[]>> propsDeps, String derivedProp) {
        HashSet<String> names = new HashSet<String>();
        block0: for (Map.Entry<String, Collection<String[]>> e : propsDeps.entrySet()) {
            for (String[] pair : e.getValue()) {
                if (!pair[0].equals(derivedProp)) continue;
                names.add(e.getKey());
                continue block0;
            }
        }
        return names;
    }

    private Prprt[] createProps(Element e, Property[] arr) {
        Prprt[] ret = Prprt.wrap(this.processingEnv, e, arr);
        Prprt[] prev = this.verify.put(e, ret);
        if (prev != null) {
            this.error("Two sets of properties for ", e);
        }
        return ret;
    }

    /*
     * WARNING - void declaration
     */
    private String findDataSpecified(ExecutableElement e, OnReceive onR) {
        try {
            return onR.data().getName();
        }
        catch (MirroredTypeException ex) {
            void var5_12;
            TypeMirror tm = ex.getTypeMirror();
            Element te = this.processingEnv.getTypeUtils().asElement(tm);
            if (te.getKind() == ElementKind.CLASS && tm.getKind() == TypeKind.ERROR) {
                String string = te.getSimpleName().toString();
            } else {
                String string = tm.toString();
            }
            return "java.lang.Object".equals(var5_12) ? null : var5_12;
        }
        catch (Exception ex) {
            AnnotationMirror found = null;
            for (AnnotationMirror annotationMirror : e.getAnnotationMirrors()) {
                if (!annotationMirror.getAnnotationType().toString().equals(OnReceive.class.getName())) continue;
                found = annotationMirror;
            }
            if (found == null) {
                return null;
            }
            for (Map.Entry entry : found.getElementValues().entrySet()) {
                ExecutableElement ee = (ExecutableElement)entry.getKey();
                AnnotationValue av = (AnnotationValue)entry.getValue();
                if (!ee.getSimpleName().contentEquals("data")) continue;
                List<? extends Object> values = ModelProcessor.getAnnoValues(this.processingEnv, e, found);
                for (Object object : values) {
                    String sv = object.toString();
                    if (!sv.startsWith("data = ") || !sv.endsWith(".class")) continue;
                    return sv.substring(7, sv.length() - 6);
                }
                return "error";
            }
            return null;
        }
    }

    static List<? extends Object> getAnnoValues(ProcessingEnvironment pe, Element e, AnnotationMirror am) {
        try {
            Class<?> trees = Class.forName("com.sun.tools.javac.api.JavacTrees");
            Method m = trees.getMethod("instance", ProcessingEnvironment.class);
            Object instance = m.invoke(null, pe);
            m = instance.getClass().getMethod("getPath", Element.class, AnnotationMirror.class);
            Object path = m.invoke(instance, e, am);
            m = path.getClass().getMethod("getLeaf", new Class[0]);
            Object leaf = m.invoke(path, new Object[0]);
            m = leaf.getClass().getMethod("getArguments", new Class[0]);
            return (List)m.invoke(leaf, new Object[0]);
        }
        catch (Exception ex) {
            return Collections.emptyList();
        }
    }

    private static String findTargetId(Element e) {
        for (AnnotationMirror annotationMirror : e.getAnnotationMirrors()) {
            if (!annotationMirror.getAnnotationType().toString().equals(Model.class.getName())) continue;
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entrySet : annotationMirror.getElementValues().entrySet()) {
                ExecutableElement key = entrySet.getKey();
                AnnotationValue value = entrySet.getValue();
                if (!"targetId()".equals(key.toString())) continue;
                return value.toString();
            }
        }
        return null;
    }

    @Override
    public Iterable<? extends Completion> getCompletions(Element element, AnnotationMirror annotation, ExecutableElement member, String userText) {
        Level l = Level.FINE;
        LOG.log(l, " element: {0}", element);
        LOG.log(l, " annotation: {0}", annotation);
        LOG.log(l, " member: {0}", member);
        LOG.log(l, " userText: {0}", userText);
        LOG.log(l, "str: {0}", annotation.getAnnotationType().toString());
        if (annotation.getAnnotationType().toString().equals(OnReceive.class.getName()) && member.getSimpleName().contentEquals("method")) {
            return Arrays.asList(ModelProcessor.methodOf("GET"), ModelProcessor.methodOf("POST"), ModelProcessor.methodOf("PUT"), ModelProcessor.methodOf("DELETE"), ModelProcessor.methodOf("HEAD"), ModelProcessor.methodOf("WebSocket"));
        }
        return super.getCompletions(element, annotation, member, userText);
    }

    private static final Completion methodOf(String method) {
        ResourceBundle rb = ResourceBundle.getBundle("org.netbeans.html.json.impl.Bundle");
        return Completions.of('\"' + method + '\"', rb.getString("MSG_Completion_" + method));
    }

    private int findOnError(ExecutableElement errElem, TypeElement te, String name, String className) {
        String err = null;
        for (Element element : te.getEnclosedElements()) {
            if (element.getKind() != ElementKind.METHOD || !element.getSimpleName().contentEquals(name)) continue;
            if (!element.getModifiers().contains((Object)Modifier.STATIC)) {
                errElem = (ExecutableElement)element;
                err = "Would have to be static";
                continue;
            }
            ExecutableElement ee = (ExecutableElement)element;
            TypeMirror excType = this.processingEnv.getElementUtils().getTypeElement(Exception.class.getName()).asType();
            List<? extends VariableElement> params = ee.getParameters();
            boolean error = false;
            if (params.size() < 2 || params.size() > errElem.getParameters().size()) {
                error = true;
            } else {
                String firstType = params.get(0).asType().toString();
                int lastDot = firstType.lastIndexOf(46);
                if (lastDot != -1) {
                    firstType = firstType.substring(lastDot + 1);
                }
                if (!firstType.equals(className)) {
                    error = true;
                }
                if (!this.processingEnv.getTypeUtils().isAssignable(excType, params.get(1).asType())) {
                    error = true;
                }
                for (int i = 2; i < params.size(); ++i) {
                    VariableElement expectedParam = errElem.getParameters().get(i);
                    if (this.processingEnv.getTypeUtils().isSameType(params.get(i).asType(), errElem.getParameters().get(i).asType())) continue;
                    error = true;
                    err = "Parameter #" + (i + 1) + " should be of type " + expectedParam;
                }
            }
            if (error) {
                errElem = (ExecutableElement)element;
                if (err != null) continue;
                err = "Error method first argument needs to be " + className + " and second Exception";
                continue;
            }
            return params.size();
        }
        if (err == null) {
            err = "Cannot find " + name + "(" + className + ", Exception) method in this class";
        }
        this.error(err, errElem);
        return -1;
    }

    private ExecutableElement findWrite(ExecutableElement computedPropElem, TypeElement te, String name, String className) {
        String err = null;
        for (Element element : te.getEnclosedElements()) {
            if (element.getKind() != ElementKind.METHOD || !element.getSimpleName().contentEquals(name) || element.equals(computedPropElem)) continue;
            if (!element.getModifiers().contains((Object)Modifier.STATIC)) {
                computedPropElem = (ExecutableElement)element;
                err = "Would have to be static";
                continue;
            }
            ExecutableElement ee = (ExecutableElement)element;
            if (ee.getReturnType().getKind() != TypeKind.VOID) {
                computedPropElem = (ExecutableElement)element;
                err = "Write method has to return void";
                continue;
            }
            TypeMirror retType = computedPropElem.getReturnType();
            List<? extends VariableElement> params = ee.getParameters();
            boolean error = false;
            if (params.size() != 2) {
                error = true;
            } else {
                String firstType = params.get(0).asType().toString();
                int lastDot = firstType.lastIndexOf(46);
                if (lastDot != -1) {
                    firstType = firstType.substring(lastDot + 1);
                }
                if (!firstType.equals(className)) {
                    error = true;
                }
                if (!this.processingEnv.getTypeUtils().isAssignable(retType, params.get(1).asType())) {
                    error = true;
                }
            }
            if (error) {
                computedPropElem = (ExecutableElement)element;
                err = "Write method first argument needs to be " + className + " and second " + retType + " or Object";
                continue;
            }
            return ee;
        }
        if (err == null) {
            err = "Cannot find " + name + "(" + className + ", value) method in this class";
        }
        this.error(err, computedPropElem);
        return null;
    }

    private static final class GetSet {
        final String name;
        final String getter;
        final String setter;
        final String type;
        final boolean readOnly;
        final boolean constant;

        GetSet(String name, String getter, String setter, String type, boolean readOnly, boolean constant) {
            this.name = name;
            this.getter = getter;
            this.setter = setter;
            this.type = type;
            this.readOnly = readOnly;
            this.constant = constant;
        }
    }

    private static class Prprt {
        private final Element e;
        private final AnnotationMirror tm;
        private final Property p;

        public Prprt(Element e, AnnotationMirror tm, Property p) {
            this.e = e;
            this.tm = tm;
            this.p = p;
        }

        String name() {
            return this.p.name();
        }

        boolean array() {
            return this.p.array();
        }

        boolean mutable() {
            return this.p.mutable();
        }

        String typeName(ProcessingEnvironment env) {
            RuntimeException ex;
            try {
                return this.p.type().getName();
            }
            catch (IncompleteAnnotationException e) {
                ex = e;
            }
            catch (AnnotationTypeMismatchException e) {
                ex = e;
            }
            for (Object object : ModelProcessor.getAnnoValues(env, this.e, this.tm)) {
                String s = object.toString().replace(" ", "");
                if (!s.startsWith("type=") || !s.endsWith(".class")) continue;
                return s.substring(5, s.length() - 6);
            }
            throw ex;
        }

        /*
         * WARNING - void declaration
         */
        static Prprt[] wrap(ProcessingEnvironment pe, Element e, Property[] arr) {
            void var6_8;
            if (arr.length == 0) {
                return new Prprt[0];
            }
            if (!e.getKind().isClass()) {
                throw new IllegalStateException("" + (Object)((Object)e.getKind()));
            }
            TypeElement te = (TypeElement)e;
            List val = null;
            block0: for (AnnotationMirror annotationMirror : te.getAnnotationMirrors()) {
                for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationMirror.getElementValues().entrySet()) {
                    if (!entry.getKey().getSimpleName().contentEquals("properties")) continue;
                    val = (List)entry.getValue().getValue();
                    continue block0;
                }
            }
            if (val == null || val.size() != arr.length) {
                pe.getMessager().printMessage(Diagnostic.Kind.ERROR, "" + val, e);
                return new Prprt[0];
            }
            Prprt[] ret = new Prprt[arr.length];
            boolean bl = false;
            while (var6_8 < ret.length) {
                AnnotationMirror am = (AnnotationMirror)((AnnotationValue)val.get((int)var6_8)).getValue();
                ret[var6_8] = new Prprt(e, am, arr[var6_8]);
                ++var6_8;
            }
            return ret;
        }
    }
}

