/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.geo;

import genj.gedcom.PropertyPlace;
import java.awt.Dimension;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class PlaceDisplayFormatPanel
extends JPanel {
    String displayFormat = "";
    PropertyPlace place = null;
    private JLabel displayLabel;
    private JTextField displayText;
    private JLabel explanationLabel;
    private JLabel placeFormatLabel;
    private JLabel resultDescLabel;
    private JLabel resultLabel;

    public PlaceDisplayFormatPanel(PropertyPlace place) {
        this.place = place;
        this.displayFormat = place.getGedcom().getPlaceDisplayFormat();
        if (this.displayFormat == null) {
            this.displayFormat = place.getGedcom().getPlaceDisplayFormatStartingWithCity();
        } else if (place.format(null).equals(place.getFirstAvailableJurisdiction())) {
            this.displayFormat = "0";
        }
        this.initComponents();
        this.placeFormatLabel.setText(this.getPlaceFormatText());
        this.displayText.setText(this.displayFormat);
        this.updateResult();
        this.displayText.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                PlaceDisplayFormatPanel.this.updateResult();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                PlaceDisplayFormatPanel.this.updateResult();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                PlaceDisplayFormatPanel.this.updateResult();
            }
        });
    }

    private void updateResult() {
        this.displayFormat = this.displayText.getText();
        String str = this.place.format(this.displayFormat);
        str = str.replaceAll("\\(\\)", "");
        str = str.replaceAll("\\[\\]", "");
        str = str.replaceAll("\\{\\}", "");
        this.resultLabel.setText("<html>" + str + "</html>");
    }

    private void initComponents() {
        this.explanationLabel = new JLabel();
        this.placeFormatLabel = new JLabel();
        this.displayLabel = new JLabel();
        this.displayText = new JTextField();
        this.resultDescLabel = new JLabel();
        this.resultLabel = new JLabel();
        this.setPreferredSize(new Dimension(650, 200));
        Mnemonics.setLocalizedText((JLabel)this.explanationLabel, (String)NbBundle.getMessage(PlaceDisplayFormatPanel.class, (String)"PlaceDisplayFormatPanel.explanationLabel.text"));
        this.explanationLabel.setPreferredSize(new Dimension(550, 30));
        Mnemonics.setLocalizedText((JLabel)this.placeFormatLabel, (String)NbBundle.getMessage(PlaceDisplayFormatPanel.class, (String)"PlaceDisplayFormatPanel.placeFormatLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.displayLabel, (String)NbBundle.getMessage(PlaceDisplayFormatPanel.class, (String)"PlaceDisplayFormatPanel.displayLabel.text"));
        this.displayText.setText(NbBundle.getMessage(PlaceDisplayFormatPanel.class, (String)"PlaceDisplayFormatPanel.displayText.text"));
        Mnemonics.setLocalizedText((JLabel)this.resultDescLabel, (String)NbBundle.getMessage(PlaceDisplayFormatPanel.class, (String)"PlaceDisplayFormatPanel.resultDescLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.resultLabel, (String)NbBundle.getMessage(PlaceDisplayFormatPanel.class, (String)"PlaceDisplayFormatPanel.resultLabel.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(12, 12, 12).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.explanationLabel, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.displayLabel).addComponent(this.resultDescLabel)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.resultLabel, -1, 525, Short.MAX_VALUE).addComponent(this.displayText))).addComponent(this.placeFormatLabel, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(12, 12, 12).addComponent(this.explanationLabel, -1, 45, Short.MAX_VALUE).addGap(18, 18, 18).addComponent(this.placeFormatLabel).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.displayLabel).addComponent(this.displayText, -2, -1, -2)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.resultLabel, -1, 44, Short.MAX_VALUE).addComponent(this.resultDescLabel)).addContainerGap()));
    }

    public String getDisplayFormat() {
        return this.displayFormat;
    }

    private String getPlaceFormatText() {
        String[] jurisdictions = PropertyPlace.getFormat((String)this.place.getGedcom().getPlaceFormat());
        String ret = "";
        for (int i = 0; i < jurisdictions.length; ++i) {
            ret = ret + i + " (" + jurisdictions[i] + ")";
            if (i >= jurisdictions.length - 1) continue;
            ret = ret + ", ";
        }
        return ret;
    }
}

