/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.geo;

import ancestris.modules.geo.GeoNodeObject;
import ancestris.modules.geo.GeoPlacesList;
import ancestris.modules.place.geonames.GeonamesResearcher;
import genj.gedcom.Gedcom;
import genj.gedcom.PropertyPlace;
import java.text.Collator;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.JOptionPane;
import org.netbeans.api.progress.ProgressHandle;
import org.openide.awt.StatusDisplayer;
import org.openide.util.Cancellable;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.TaskListener;
import org.openide.windows.WindowManager;

class GeoInternetSearch {
    private static boolean isBusy = false;
    private static Set<Gedcom> gedcomSearchingList = new HashSet<Gedcom>();
    private static RequestProcessor RP = null;
    private GeoPlacesList gplOwner;
    private List<PropertyPlace> placesProps;
    private GeoNodeObject[] result;
    private RequestProcessor.Task theTask = null;
    private GeonamesResearcher geonamesResearcher = null;
    public Comparator<String> sortString = new Comparator<String>(){

        @Override
        public int compare(String o1, String o2) {
            if (o1 == null) {
                return 1;
            }
            if (o2 == null) {
                return -1;
            }
            Collator myCollator = Collator.getInstance();
            myCollator.setStrength(2);
            myCollator.setDecomposition(1);
            return myCollator.compare(o1, o2);
        }
    };

    public GeoInternetSearch(GeoPlacesList gplOwner, List<PropertyPlace> placesProps) {
        this.gplOwner = gplOwner;
        this.placesProps = placesProps;
        this.geonamesResearcher = new GeonamesResearcher();
    }

    public synchronized void executeSearch(Gedcom gedcom, final int internetSearchType) {
        if (isBusy && gedcomSearchingList.contains(gedcom)) {
            return;
        }
        isBusy = true;
        gedcomSearchingList.add(gedcom);
        final TreeMap listOfCities = new TreeMap(this.sortString);
        String paramMsg = NbBundle.getMessage(GeoInternetSearch.class, (String)(internetSearchType == 2 ? "TXT_SearchPlacesWeb" : "TXT_SearchPlacesLocal"));
        String processMsg = NbBundle.getMessage(GeoInternetSearch.class, (String)"TXT_SearchPlaces", (Object)this.placesProps.size(), (Object)paramMsg);
        final ProgressHandle ph = ProgressHandle.createHandle((String)processMsg, (Cancellable)new Cancellable(){

            public boolean cancel() {
                return GeoInternetSearch.this.handleCancel();
            }
        });
        Runnable runnable = new Runnable(){
            private final int NUM;
            {
                this.NUM = GeoInternetSearch.this.placesProps.size();
            }

            @Override
            public synchronized void run() {
                try {
                    StatusDisplayer.getDefault().setStatusText("");
                    listOfCities.clear();
                    ph.start();
                    ph.switchToDeterminate(this.NUM);
                    int i = 0;
                    for (PropertyPlace propertyPlace : GeoInternetSearch.this.placesProps) {
                        ++i;
                        String key = GeoInternetSearch.this.gplOwner.getPlaceKey(propertyPlace);
                        GeoNodeObject obj = (GeoNodeObject)listOfCities.get(key);
                        if (obj == null) {
                            GeoNodeObject newObj = new GeoNodeObject(GeoInternetSearch.this.geonamesResearcher, GeoInternetSearch.this.gplOwner, propertyPlace, internetSearchType);
                            if (newObj.isInError) {
                                WindowManager.getDefault().invokeWhenUIReady(new Runnable(){

                                    @Override
                                    public void run() {
                                        String msg = NbBundle.getMessage(GeoInternetSearch.class, (String)"ERROR_cannotFindPlace");
                                        JOptionPane.showMessageDialog(WindowManager.getDefault().getMainWindow(), msg, NbBundle.getMessage(GeoInternetSearch.class, (String)"ERROR_Title"), 0);
                                        StatusDisplayer.getDefault().setStatusText(msg, 10000);
                                    }
                                });
                                break;
                            }
                            listOfCities.put(key, newObj);
                        } else {
                            obj.addEvent(propertyPlace.getParent(), propertyPlace);
                        }
                        ph.progress(i);
                        if (!Thread.currentThread().isInterrupted()) continue;
                        throw new InterruptedException("");
                    }
                }
                catch (InterruptedException ex) {
                    isBusy = false;
                    String msg = NbBundle.getMessage(GeoInternetSearch.class, (String)"TXT_SearchCancelled");
                    System.out.println(msg);
                    StatusDisplayer.getDefault().setStatusText(msg, 10000);
                    return;
                }
            }
        };
        if (RP == null) {
            RP = new RequestProcessor("GeoInternetSearch", 1, true);
        }
        this.theTask = RP.create(runnable);
        this.theTask.addTaskListener(new TaskListener(){

            public void taskFinished(Task task) {
                ph.finish();
                Collection ret = listOfCities.values();
                GeoInternetSearch.access$502(GeoInternetSearch.this, ret.toArray(new GeoNodeObject[ret.size()]));
                if (GeoInternetSearch.this.result.length > 0) {
                    GeoInternetSearch.this.gplOwner.setPlaces(GeoInternetSearch.this.result);
                    gedcomSearchingList.remove(((PropertyPlace)GeoInternetSearch.this.placesProps.get(0)).getGedcom());
                }
                isBusy = false;
                GeoInternetSearch.this.callback();
            }
        });
        this.theTask.schedule(0);
    }

    private boolean handleCancel() {
        if (null == this.theTask) {
            return false;
        }
        return this.theTask.cancel();
    }

    public void callback() {
    }

    static /* synthetic */ GeoNodeObject[] access$502(GeoInternetSearch x0, GeoNodeObject[] x1) {
        x0.result = x1;
        return x1;
    }
}

