/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.ui.layout.springbox;

import java.util.Iterator;
import org.graphstream.ui.layout.springbox.NodeParticle;
import org.miv.pherd.ntree.BarycenterCellData;
import org.miv.pherd.ntree.Cell;
import org.miv.pherd.ntree.CellData;
import org.miv.pherd.ntree.NTreeListener;

public class GraphCellData
extends BarycenterCellData {
    public double degree;

    public double getDegree() {
        return this.degree;
    }

    public CellData newCellData() {
        return new GraphCellData();
    }

    public void recompute() {
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        double n = 0.0;
        this.weight = 0.0;
        this.degree = 0.0;
        if (this.cell.isLeaf()) {
            Iterator particles = this.cell.getParticles();
            while (particles.hasNext()) {
                NodeParticle particle = (NodeParticle)((Object)particles.next());
                x += particle.getPosition().x;
                y += particle.getPosition().y;
                z += particle.getPosition().z;
                this.weight += particle.getWeight();
                this.degree += (double)particle.getEdges().size();
                n += 1.0;
            }
            if (n > 0.0) {
                x /= n;
                y /= n;
                z /= n;
            }
            this.center.set(x, y, z);
        } else {
            double subcnt = this.cell.getSpace().getDivisions();
            double totpop = this.cell.getPopulation();
            int verif = 0;
            if (totpop > 0.0) {
                int i = 0;
                while ((double)i < subcnt) {
                    Cell subcell = this.cell.getSub(i);
                    GraphCellData data = (GraphCellData)subcell.getData();
                    double pop = subcell.getPopulation();
                    verif = (int)((double)verif + pop);
                    x += data.center.x * pop;
                    y += data.center.y * pop;
                    z += data.center.z * pop;
                    this.weight += data.weight;
                    this.degree += data.degree;
                    ++i;
                }
                assert ((double)verif == totpop) : "Discrepancy in population counts ?";
                x /= totpop;
                y /= totpop;
                z /= totpop;
            }
            this.center.set(x, y, z);
        }
        for (NTreeListener listener : this.cell.getTree().getListeners()) {
            listener.cellData((Object)this.cell.getId(), "barycenter", (Object)this);
        }
    }
}

