/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.stream.file.gexf;

import javax.xml.stream.XMLStreamException;
import org.graphstream.stream.file.gexf.GEXF;
import org.graphstream.stream.file.gexf.GEXFAttValues;
import org.graphstream.stream.file.gexf.GEXFElement;
import org.graphstream.stream.file.gexf.GEXFSpells;
import org.graphstream.stream.file.gexf.SmartXMLWriter;

public class GEXFNode
implements GEXFElement {
    GEXF root;
    String id;
    String label;
    GEXFAttValues attvalues;
    GEXFSpells spells;
    float x;
    float y;
    float z;
    boolean position;

    public GEXFNode(GEXF root, String id) {
        this.root = root;
        this.id = id;
        this.label = id;
        this.spells = new GEXFSpells(root);
        this.attvalues = new GEXFAttValues(root);
        this.position = false;
    }

    @Override
    public void export(SmartXMLWriter stream) throws XMLStreamException {
        stream.startElement("node");
        stream.stream.writeAttribute("id", this.id);
        stream.stream.writeAttribute("label", this.label);
        if (this.position && this.root.isExtensionEnable(GEXFElement.Extension.VIZ)) {
            stream.startElement("viz:position");
            stream.stream.writeAttribute("x", Float.toString(this.x));
            stream.stream.writeAttribute("y", Float.toString(this.y));
            stream.stream.writeAttribute("z", Float.toString(this.z));
            stream.endElement();
        }
        this.attvalues.export(stream);
        if (this.root.isExtensionEnable(GEXFElement.Extension.DYNAMICS)) {
            this.spells.export(stream);
        }
        stream.endElement();
    }
}

