/*
 * Decompiled with CFR 0.152.
 */
package genj.edit.beans;

import genj.common.AbstractPropertyTableModel;
import genj.common.PropertyTableModel;
import genj.common.PropertyTableWidget;
import genj.edit.beans.PropertyBean;
import genj.gedcom.Fam;
import genj.gedcom.Gedcom;
import genj.gedcom.Grammar;
import genj.gedcom.Indi;
import genj.gedcom.MetaProperty;
import genj.gedcom.Property;
import genj.gedcom.PropertyChild;
import genj.gedcom.PropertyHusband;
import genj.gedcom.PropertyWife;
import genj.gedcom.PropertyXRef;
import genj.gedcom.TagPath;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;

public class RelationshipsBean
extends PropertyBean {
    public static Icon IMG = Grammar.V55.getMeta(new TagPath("FAM")).getImage().getOverLayed(MetaProperty.IMG_LINK);
    private PropertyTableWidget table;
    private Map<Property, String> relationships = new HashMap<Property, String>();

    public RelationshipsBean() {
        this.table = new PropertyTableWidget();
        this.table.setVisibleRowCount(2);
        this.setLayout(new BorderLayout());
        this.add("Center", (Component)this.table);
    }

    @Override
    public void removeNotify() {
        REGISTRY.put("relcols", this.table.getColumnLayout());
        super.removeNotify();
    }

    @Override
    protected void commitImpl(Property property) {
    }

    @Override
    protected void setPropertyImpl(Property prop) {
        this.relationships.clear();
        Model model = null;
        if (prop instanceof Indi) {
            model = this.getModel((Indi)prop);
        }
        if (prop instanceof Fam) {
            model = this.getModel((Fam)prop);
        }
        this.table.setModel((PropertyTableModel)model);
        this.table.setColumnLayout(REGISTRY.get("relcols", ""));
    }

    private Model getModel(Fam fam) {
        Property wife;
        TagPath[] columns = new TagPath[]{new TagPath(".", RESOURCES.getString("relationship")), new TagPath("*:..", Gedcom.getName((String)"INDI")), new TagPath("*:..:NAME"), new TagPath("*:..:BIRT:DATE")};
        ArrayList<Property> rows = new ArrayList<Property>();
        Property husband = fam.getProperty("HUSB");
        if (husband instanceof PropertyXRef && husband.isValid()) {
            this.relationships.put(husband, PropertyHusband.LABEL_FATHER);
            rows.add(husband);
        }
        if ((wife = fam.getProperty("WIFE")) instanceof PropertyWife && wife.isValid()) {
            this.relationships.put(wife, PropertyWife.LABEL_MOTHER);
            rows.add(wife);
        }
        for (Property child : fam.getProperties("CHIL")) {
            if (!(child instanceof PropertyXRef) || !child.isValid()) continue;
            this.relationships.put(child, child.getPropertyName());
            rows.add(child);
        }
        return new Model(fam.getGedcom(), columns, rows);
    }

    private Model getModel(Indi indi) {
        TagPath[] columns = new TagPath[]{new TagPath(".", RESOURCES.getString("relationship")), new TagPath("*:..", Gedcom.getName((String)"INDI")), new TagPath("*:..:NAME"), new TagPath("*:..:BIRT:DATE"), new TagPath("..", Gedcom.getName((String)"FAM")), new TagPath("..:MARR:DATE")};
        ArrayList<Property> rows = new ArrayList<Property>();
        Fam parental = indi.getFamilyWhereBiologicalChild();
        if (parental != null) {
            Property wife;
            Property husband = parental.getProperty("HUSB");
            if (husband instanceof PropertyXRef && husband.isValid()) {
                this.relationships.put(husband, PropertyHusband.LABEL_FATHER);
                rows.add(husband);
            }
            if ((wife = parental.getProperty("WIFE")) instanceof PropertyWife && wife.isValid()) {
                this.relationships.put(wife, PropertyWife.LABEL_MOTHER);
                rows.add(wife);
            }
        }
        for (Fam spousal : indi.getFamiliesWhereSpouse()) {
            Property spouse = spousal.getProperty("HUSB");
            if (spouse instanceof PropertyXRef && spouse.isValid() && ((PropertyXRef)spouse).getTargetEntity() != indi) {
                this.relationships.put(spouse, spouse.getPropertyName());
                rows.add(spouse);
            } else {
                spouse = spousal.getProperty("WIFE");
                if (spouse instanceof PropertyXRef && spouse.isValid() && ((PropertyXRef)spouse).getTargetEntity() != indi) {
                    this.relationships.put(spouse, spouse.getPropertyName());
                    rows.add(spouse);
                }
            }
            for (PropertyChild child : spousal.getProperties(PropertyChild.class)) {
                if (!child.isValid()) continue;
                this.relationships.put((Property)child, child.getPropertyName());
                rows.add((Property)child);
            }
        }
        return new Model(indi.getGedcom(), columns, rows);
    }

    private class Model
    extends AbstractPropertyTableModel {
        private TagPath[] columns;
        private List<Property> rows;

        public Model(Gedcom gedcom, TagPath[] columns, List<Property> rows) {
            super(gedcom);
            this.columns = columns;
            this.rows = rows;
        }

        public int getNumCols() {
            return this.columns.length;
        }

        public int getNumRows() {
            return this.rows.size();
        }

        public TagPath getColPath(int col) {
            return this.columns[col];
        }

        public Property getRowRoot(int row) {
            return this.rows.get(row);
        }

        public String getCellValue(Property property, int row, int col) {
            String relationship = (String)RelationshipsBean.this.relationships.get(property);
            return relationship != null ? relationship : super.getCellValue(property, row, col);
        }
    }
}

