/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.algorithm.measure;

import org.graphstream.algorithm.Algorithm;
import org.graphstream.algorithm.NotInitializedException;
import org.graphstream.algorithm.util.Parameter;
import org.graphstream.algorithm.util.Result;
import org.graphstream.graph.Graph;

public abstract class AbstractCentrality
implements Algorithm {
    protected String centralityAttribute;
    protected NormalizationMode normalize;
    protected double[] data;
    protected Graph graph;

    protected AbstractCentrality(String attribute, NormalizationMode normalize) {
        this.centralityAttribute = attribute;
        this.normalize = normalize;
    }

    @Override
    public void init(Graph graph) {
        if (graph == null) {
            throw new NullPointerException();
        }
        this.graph = graph;
    }

    @Override
    public void compute() {
        if (this.graph == null) {
            throw new NotInitializedException(this);
        }
        int count = this.graph.getNodeCount();
        if (this.data == null || this.data.length != count) {
            this.data = new double[count];
        }
        this.computeCentrality();
        this.copyValuesTo(this.centralityAttribute, this.normalize);
    }

    public void copyValuesTo(String attribute) {
        this.copyValuesTo(attribute, NormalizationMode.NONE);
    }

    public void copyValuesTo(String attribute, NormalizationMode normalize) {
        int count = this.graph.getNodeCount();
        switch (normalize) {
            case SUM_IS_1: {
                int idx;
                double s = 0.0;
                for (idx = 0; idx < count; ++idx) {
                    s += this.data[idx];
                }
                for (idx = 0; idx < count; ++idx) {
                    this.graph.getNode(idx).setAttribute(attribute, new Object[]{this.data[idx] / s});
                }
                break;
            }
            case MAX_1_MIN_0: {
                int idx;
                double max;
                double min = max = this.data[0];
                for (idx = 1; idx < count; ++idx) {
                    max = max < this.data[idx] ? this.data[idx] : max;
                    min = min > this.data[idx] ? this.data[idx] : min;
                }
                for (idx = 0; idx < count; ++idx) {
                    this.graph.getNode(idx).setAttribute(attribute, new Object[]{(this.data[idx] - min) / (max - min)});
                }
                break;
            }
            case NONE: {
                for (int idx = 0; idx < count; ++idx) {
                    this.graph.getNode(idx).setAttribute(attribute, new Object[]{this.data[idx]});
                }
                break;
            }
        }
    }

    public String getCentralityAttribute() {
        return this.centralityAttribute;
    }

    @Parameter
    public void setCentralityAttribute(String centralityAttribute) {
        this.centralityAttribute = centralityAttribute;
    }

    public NormalizationMode getNormalizationMode() {
        return this.normalize;
    }

    public void setNormalizationMode(NormalizationMode normalize) {
        this.normalize = normalize;
    }

    protected abstract void computeCentrality();

    @Result
    public String defaultMessage() {
        return "Result stored in \"" + this.centralityAttribute + "\" attribute";
    }

    public static enum NormalizationMode {
        NONE,
        SUM_IS_1,
        MAX_1_MIN_0;

    }
}

