/*
 * Decompiled with CFR 0.152.
 */
package ancestris.app;

import ancestris.core.CoreOptions;
import ancestris.gedcom.GedcomDirectory;
import genj.gedcom.Context;
import genj.util.Registry;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Logger;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.util.Lookup;

public abstract class StartupFiles {
    static final Logger LOG = Logger.getLogger("ancestris.app");
    static final Registry REGISTRY = Registry.get(StartupFiles.class);
    private static final String KEY = "startup.files";
    public static final String PROP_STARTUP_FILE_INFO = "StartupFiletInformation";
    protected PropertyChangeSupport pch;
    private List<FileObject> commandLineFiles = new ArrayList<FileObject>(2);
    private static StartupFiles defaultInstance;

    public List<FileObject> getCommandLineFiles() {
        return this.commandLineFiles;
    }

    public void setCommandLineFiles(List<File> commandLineFiles) {
        for (File file : commandLineFiles) {
            LOG.fine("set command files: " + file.getAbsolutePath());
            try {
                this.commandLineFiles.add(URLMapper.findFileObject((URL)file.toURI().toURL()));
            }
            catch (MalformedURLException ex) {
                LOG.warning(ex.getMessage());
            }
        }
    }

    public abstract void add(FileObject var1);

    public abstract List<FileObject> getAll();

    public abstract void removeAll();

    public void addOpenedGedcoms() {
        this.removeAll();
        for (Context context : GedcomDirectory.getDefault().getContexts()) {
            try {
                this.add(GedcomDirectory.getDefault().getDataObject(context).getPrimaryFile());
            }
            catch (GedcomDirectory.ContextNotFoundException contextNotFoundException) {}
        }
    }

    public StartupFiles() {
        this.pch = new PropertyChangeSupport(this);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pch.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pch.removePropertyChangeListener(listener);
    }

    public static StartupFiles getDefault() {
        StartupFiles instance = (StartupFiles)Lookup.getDefault().lookup(StartupFiles.class);
        return instance != null ? instance : StartupFiles.getDefaultInstance();
    }

    private static synchronized StartupFiles getDefaultInstance() {
        if (defaultInstance == null) {
            defaultInstance = new DefaultStartupFilesImpl();
        }
        return defaultInstance;
    }

    private static class DefaultStartupFilesImpl
    extends StartupFiles {
        private DefaultStartupFilesImpl() {
        }

        @Override
        public void add(FileObject gedcomFile) {
            String url = gedcomFile.toURL().toString();
            List history = REGISTRY.get(StartupFiles.KEY, new ArrayList());
            history.remove(url);
            history.add(0, url);
            REGISTRY.put(StartupFiles.KEY, (Collection)history);
            this.pch.firePropertyChange(new PropertyChangeEvent(StartupFiles.class, StartupFiles.PROP_STARTUP_FILE_INFO, null, null));
        }

        @Override
        public List<FileObject> getAll() {
            List list = REGISTRY.get(StartupFiles.KEY, new ArrayList());
            ArrayList<FileObject> result = new ArrayList<FileObject>(5);
            if (!CoreOptions.getInstance().getOpenNothingAtStartup()) {
                FileObject defaultGedcom;
                URL defaultURL;
                for (String file : list) {
                    try {
                        result.add(URLMapper.findFileObject((URL)new URL(file)));
                    }
                    catch (MalformedURLException malformedURLException) {}
                }
                if ((result == null || result.isEmpty() || CoreOptions.getInstance().getAlwaysOpenDefault()) && (defaultURL = CoreOptions.getInstance().getDefaultGedcom()) != null && (defaultGedcom = URLMapper.findFileObject((URL)defaultURL)) != null && !result.contains(defaultGedcom)) {
                    result.add(defaultGedcom);
                }
            }
            return result;
        }

        @Override
        public void removeAll() {
            REGISTRY.put(StartupFiles.KEY, (Collection)null);
        }
    }
}

